#!/usr/local/bin/perl
# 
# oracle_e1_scf_sa_discover.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Discovery script for EnterpriseOne (Former JDEdwards) Server Configuration Framework/Standalone Agents ('scf_sa') data.
#
#    NOTES
#      This script relies on a xml dump file produced by the standalone agent.
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 10/25/06 - Creation

($emdRoot,$hostName,$crsHome) = @ARGV;

use File::Spec;
use File::Copy;
use ias::simpleXPath;
use Config;
use constant LIVELINK_HOME => $ENV{CCR_HOME};
require "$emdRoot/sysman/admin/scripts/emd_common.pl";
require "$emdRoot/sysman/admin/discover/utl/e1_util.pl";


EMD_PERL_DEBUG("oracle_e1_scf_sa_discover START");

        #Looking for dumpfile in ccr directory because we need the dumpfile created before CCR installs and therefore state will not exist yet.
        #my $dumpFileLocation = File::Spec->catdir($emdRoot, "state");
        my $dumpFileLocation = $emdRoot;
        
        my @files = getE1CCRDumpFiles($dumpFileLocation, "scf_sa");
        foreach my $file (@files)
        {
            my $standAloneAgent = 0;
            my $fileNamePath = File::Spec->catdir($dumpFileLocation, $file);
            
            if( -f $fileNamePath)
            {
                # scf_sa dump file found.
                my @topLevelComponents = simpleXPathQuery($fileNamePath, "oracle_e1/scf_sa");
                for my $topLevelComponent (@topLevelComponents)
                {
                
                    #add all of the managed instances, for this standalone agent, as targets.                  
                    my @agents =  simpleXPathQuery($fileNamePath, "oracle_e1/scf_sa/agents/agent/agentattributes/agentattribute");
                    for my $agent (@agents)
                    {                   
                        my $Agentlocation = $$agent{'AIINLOC'};
                    
                        #add the standalone agent as a target once.  There will be one if there are any E1 instances.

                        EMD_PERL_DEBUG("oracle_e1_scf_sa target found");
                        print  "<Target TYPE=\"oracle_e1_scf_sa\" NAME=\"$Agentlocation\" >\n";
                        print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                        print  "</Target>\n";
                        #one agent per OCM install.  Instances are in seperate dump files.  Leave discovery.
                        $standAloneAgent = 1;
                        last;
                        
                    }# end for loop - agents

                if($standAloneAgent == 0)
                {
                    #add all of the managed instances, for this standalone agent, as targets.                  
                    my @managedinstances =  simpleXPathQuery($fileNamePath, "oracle_e1/scf_sa/agents/agent/managedinstances/managedinstance");
                    for my $managedinstance (@managedinstances)
                    {
                        my $location = $$managedinstance{'MIINLOC'};
                        my $instance = $$managedinstance{'MIINSTNM'};
                        my $targetType = $$managedinstance{'MITRGTYP'};
                        
                        $location=~ s/^\s*(.*?)\s*$/$1/;
                        $targetType=~ s/^\s*(.*?)\s*$/$1/;
                        $instance=~ s/^\s*(.*?)\s*$/$1/;
                        
                        
                        
                        if ($targetType eq "webserver")
                        {

                            print  "<Target TYPE=\"oracle_e1_scf_sa_webserver\" NAME=\"$location\;$targetType\;$instance\" >\n";
                            print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                            print  "</Target>\n";
                        
                        }
                        elsif($targetType eq "entserver")
                        {
                        
                            print  "<Target TYPE=\"oracle_e1_scf_sa_entserver\" NAME=\"$location\;$targetType\;$instance\" >\n";
                            print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                            print  "</Target>\n";
                        
                        }
                        elsif($targetType eq "pimsync")
                        {
                        
                            print  "<Target TYPE=\"oracle_e1_scf_sa_pimsynch\" NAME=\"$location\;$targetType\;$instance\" >\n";
                            print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                            print  "</Target>\n";
                        
                        }
                        elsif($targetType eq "rteserver")
                        {
                        
                            print  "<Target TYPE=\"oracle_e1_scf_sa_rteserver\" NAME=\"$location\;$targetType\;$instance\" >\n";
                            print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                            print  "</Target>\n";
                        
                        }
                        elsif($targetType eq "collabportal")
                        {
                        
                            print  "<Target TYPE=\"oracle_e1_scf_sa_collabportal\" NAME=\"$location\;$targetType\;$instance\" >\n";
                            print  "  <Property NAME=\"E1DumpFile\" VALUE=\"$fileNamePath\" />\n";
                            print  "</Target>\n";
                        
                        }
                        
                        
                        
                    }# end for loop - managedinstances
                  } # if $standAloneAgent 
                }
            }
        }
    


EMD_PERL_DEBUG("oracle_e1_scf_sa_discover END");



