#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_emd_discover.pl /main/10 2011/06/10 02:36:49 tsubrama Exp $
#
# oracle_emd_discover.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_emd_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tsubrama    06/08/11 - getting 12G Agent version
#    tsubrama    05/30/11 - don't discover agent if it is 12G or later
#    rstorrie    06/22/10 - Addd call to get agent version for version_value
#    rstorrie    03/09/10 - Bug 8984993 add the OracleHome of the agent to the
#                           properties for use in callEmctl
#    rstorrie    10/02/09 - Provide workaround for issue with
#                           emctl.bat Currently the getemhome call is failing on
#                           windows the workaround is to call emctl.pl directly
#    jsutton     11/21/07 - Fix issue with existing targets.xml extraction
#    rstorrie    06/07/06 - Fix sytnax error 
#    rstorrie    06/06/06 - Fix for NT discovery 
#    rstorrie    11/22/05 - New script for discovering Agent install 
#    rstorrie    11/22/05 - New script for discovering Agent install 
#    rstorrie    11/22/05 - Creation
# 
use strict;
use Config;
use File::Spec;
use ias::simpleXPath;

require "$ENV{CCR_HOME}/sysman/admin/scripts/emd_common.pl";

# Get the CONSOLE_CFG property from emctl, if emctl does not exist exit
my $emctl_file = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "bin", "emctl" );
my $emctl_perl = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "bin", "emctl.pl");

# If we are on windows then get emctl.bat rather than emctl
my $OSNAME = $Config{'osname'};
my $IsWin32 = ($OSNAME eq 'MSWin32');
my $hsoe = "";

if($IsWin32)
{
   $emctl_file = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "bin", "emctl.bat" );
   open (EMCTLFILE, $emctl_file) or exit;   
   my $line; 
   
   while ($line = <EMCTLFILE>)
   {
      chomp $line;           
      if ( $line =~ /^\s*set HOST_SID_OFFSET_ENABLED\s*=\s*(.*?)$/) 
      {
 	  $hsoe = $1;
      }
   }
   close EMCTLFILE;
}

my $agent_only_install=0;
if (-f $emctl_file)
{
    open (EMCTLFILE, $emctl_file) or exit;
    # Check if CONSOLE_CFG is set to agent
    my @emctlData=<EMCTLFILE>;
    close EMCTLFILE;
    foreach (@emctlData)
    {
        if ((/^\s*CONSOLE_CFG\s*=\s*agent\s*$/) || (/^\s*set CONSOLE_CFG\s*=\s*agent\s*$/))
        {
            $agent_only_install=1;
            last;
        }
    }
}

# If we didnt find CONSOLE_CFG set to agent then exit
# Currently this script is designed for grid control agents
if ( $agent_only_install == 0 )
{
    exit;
}

# Use the emctl command to get the true home of the agent
# This may not be ORACLE_HOME for dbconsole or RAC installs
# Also retrieve the version while we are at it
my @getemhome_output;
my @agentVersion;

# Use the emctl command to get the true home of the agent
# This may not be ORACLE_HOME for dbconsole or RAC installs
# On Windows this was found not to be possible
# Therefore a direct call is made to emctl.pl to get the home

if($IsWin32)
{      
	$ENV{EMDROOT}="$ENV{LL_ORACLE_HOME}";
	$ENV{CONSOLE_CFG}="agent";
	$ENV{PERL5LIB}="$ENV{PERL5LIB};$ENV{LL_ORACLE_HOME}/bin";
	$ENV{ORACLE_HOME}="$ENV{LL_ORACLE_HOME}";
	$ENV{JAVA_HOME}="$ENV{LL_ORACLE_HOME}/jdk";
	$ENV{HOST_OFFSET_ENABLED}=$hsoe;	
	@getemhome_output= `$^X $emctl_perl getemhome`;
        @agentVersion = `$^X $emctl_perl getversion`;
}
else
{
	@getemhome_output= `$emctl_file getemhome`;
        @agentVersion = `$emctl_file getversion`;
}

my $emhome_rec;
my $agentHome;
foreach $emhome_rec (@getemhome_output)
{
    chomp $emhome_rec;
    if ( $emhome_rec =~ /^EMHOME\s*=\s*(.*)$/ )
    {
        $agentHome=$1;
        last;
    }
}

my $versionString;
my $version='';
foreach $versionString (@agentVersion)
{
    chomp ($versionString);
    if ($versionString =~ /Agent Version ([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/)
    {
        $version = $1;
        last;
    }
    elsif ($versionString =~ /Agent ([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/)  # to get version of 12GC Agent
    {
        $version = $1;
        last;
    }
}

# get if agent is pre12G or later.
my $isPre12GAgent = isPre12gcTarget($version);


# Retrieve the name of of the agent from its targets.xml if it is pre12GC Agent
# This will guarantee to us that we are using the same name as grid control
# Write this and the true agent home to ccr targets.xml
my $targetsFile = File::Spec->catfile($agentHome, "sysman", "emd", "targets.xml");
if ((-f $targetsFile) && ($isPre12GAgent eq 'Yes'))
{
    open (FILE, "<$targetsFile") or exit;
    close FILE;

    my @agentTarget = simpleXPathQuery($targetsFile, 'Targets/Target[@TYPE="oracle_emd"]');
    foreach my $refTargetRec (@agentTarget)
    {
        printf ("<Target TYPE=\"oracle_emd\" NAME=\"%s\">\n", $refTargetRec->{'NAME'});
        if (defined $version && $version ne "")
        {
            print  ("    <Property NAME=\"version_value\" VALUE=\"$version\"/>\n");
        }
        print  ("    <Property NAME=\"OracleHome\" VALUE=\"$ENV{LL_ORACLE_HOME}\"/>\n");
        print  ("    <Property NAME=\"AgentConfigRoot\" VALUE=\"$agentHome\"/>\n");
        print  ("</Target>\n");
    }
}
