#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_emrep_discover.pl /main/14 2012/11/06 13:57:28 fmorshed Exp $
#
# oracle_emrep_discover.pl
# 
# Copyright (c) 2006, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_emrep_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    11/05/12 - Call getStateDirs instead of figuring it out.  In presence
#                           of designated collector the algorithm is more complicated.
#    tsubrama    05/30/11 - don't discover emrep and emsystem if it is 12G or
#                           later
#    jsutton     02/25/11 - fix empty string check
#    aghanti     10/14/10 - Bug 9033775 - Do not discover targets from
#                           .ll*/.ccr/.emrep file if it does not have end
#                           marker
#    rstorrie    06/22/10 - Make a call to getEMVersionFromEMll
#    rstorrie    06/12/09 - Add hostname to the emrep target properties
#    aghanti     05/24/09 - Add CCR_DB_NLS_CHARACTERSET as property in
#                           targets.xml file
#    nmittal     12/17/08 - bug 7419071: checking for files in oh/state along
#                           with ccrConfigHome/ccr
#    rstorrie    11/27/08 - Fix for bug 6774878 - change $file to $fullFilePath
#    pparida     10/17/07 - XbranchMerge pparida_bug-6492554 from
#                           st_emll_10.2.7
#    pparida     10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                           state and config dirs.
#    jsutton     06/26/07 - Check if emrep is on a RAC db
#    ndutko      02/07/07 - XbranchMerge ndutko_bug-5871087 from st_emll_10.2.5
#    ndutko      02/07/07 - Do not discover the emSystemm target
#    rstorrie    09/18/06 - Addition of hostname to emsystem property
#    rstorrie    08/24/06 - Addition of emsystem
#    rstorrie    08/14/06 - Grid control repository discovery script
#    rstorrie    08/14/06 - Creation
# 

use Config;
use Cwd;
use File::Copy;
use File::Spec;
my ($emdRoot,$hostName) = @ARGV;
$ENV{EMDROOT} = $emdRoot;

require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/scripts/ccr/ccr_common.pl";
require "$emdRoot/sysman/admin/scripts/emd_common.pl";

#Discovery LOG CATEGORY
$LOG_CATEGORY = "GCREP_DISCOVERY: ";

my $elapsedSec = time();
EMD_PERL_INFO("$LOG_CATEGORY ***** Start of Grid Control Repository Discovery***");

my $OCMOracleHome;
if (defined $ENV{LL_ORACLE_HOME} && -d  $ENV{LL_ORACLE_HOME})
{
  $OCMOracleHome = $ENV{LL_ORACLE_HOME};
  #move the .emrep files from state to temp directory
  my @configDirs = getStateDirs($emdRoot,$hostName);
  foreach $configDir (@configDirs)
  {
    opendir(DIR,$configDir);
    my @files = grep {/\.emrep$/ }  readdir(DIR);
    foreach my $file (@files)
    {
      my $fullFilePath = File::Spec->catdir($configDir,$file);
      EMD_PERL_INFO("$LOG_CATEGORY Days past since last modification on $fullFilePath=". (-M $fullFilePath));
      if( -M $fullFilePath >= 30)
      {
        unlink($fullFilePath);
        EMD_PERL_INFO("$LOG_CATEGORY Deleted 30 day old file=$fullFilePath");
        next;
      }
      #
      # Check if the file has been completely written out (has an end marker)
      # If it is incomplete, print a warning and ignore the file
      #
      next if (llFileIsComplete($fullFilePath) ne "true");

      EMD_PERL_INFO("$LOG_CATEGORY Handle $file");
      if ( $file =~ /(.*).emrep$/)
      {
        my $filename = $1;
        my $EMVersion = getEMVersionFromEMll($fullFilePath);

        # get if emrep is pre12GC or later.
        my $isPre12gEmrep = isPre12gcTarget($EMVersion);

        if( ($filename =~ /(.*)db$/) && ($isPre12gEmrep eq "Yes"))
        {
          my $dbname = $1;
          print "<Target TYPE=\"oracle_emrep\" NAME=\"$1_emrep\" >\n";
          my $timestamp = getCollectionTimestamp($fullFilePath);
          if (defined $timestamp && $timestamp ne "")
          {
            print "    <Property NAME=\"CCR_COLLECTION_TIMESTAMP_OVERRIDE\" VALUE=\"$timestamp\" />\n";
          }
          my $EMVersion = getEMVersionFromEMll($fullFilePath);
          if (defined $EMVersion && $EMVersion ne "")
          {
            print "<Property NAME=\"version_value\" VALUE=\"$EMVersion\"/>\n";
          }

          my $dbcharset = getConfigProperty($fullFilePath, "NLS_CHARACTERSET");
          if (defined $dbcharset && $dbcharset ne "") {
              print "<Property NAME=\"CCR_DB_NLS_CHARACTERSET\" VALUE=\"".$dbcharset."\"/>\n";
          }

          print "    <Property NAME=\"ConfigFile\" VALUE=\"". $fullFilePath. "\"/> \n";
          print"     <Property NAME=\"HostName\" VALUE=\"". $hostName. "\"/> \n";
          # open file, scan for "OCM_CROSS_HOST=YES"
          # if found, add the property
          my $ocmCrossHost = "FALSE";
          my $ocmCrossHostFound = 0;
          if (open(CONFIG_FILE_READER, "$fullFilePath"))
          {
            while (<CONFIG_FILE_READER>)
            {
              if (/OCM_CROSS_HOST/)
              {
                (undef,$ocmCrossHost) = split(/=/, $_);
                chomp($ocmCrossHost);
                $ocmCrossHostFound = 1;
                last;
              }
            }
            close(CONFIG_FILE_READER);
            print "    <Property NAME=\"OCM_CROSS_HOST\" VALUE=\"".$ocmCrossHost."\"/>\n";
          }
          print "</Target>\n";

          # if the entry was found, create an oracle_emsystem target
          if ($ocmCrossHostFound == 1)
          {
            # formulate a target of type oracle_emsystem
            print "<Target TYPE=\"oracle_emsystem\" NAME=\"$1_EM\">\n";
            if (defined $EMVersion && $EMVersion ne "")
            {
              print "<Property NAME=\"version_value\" VALUE=\"$EMVersion\"/>\n";
            }
            print "    <Property NAME=\"ConfigFile\" VALUE=\"". $fullFilePath. "\"/> \n";
            print"     <Property NAME=\"HostName\" VALUE=\"". $hostName. "\"/> \n";
            print "    <Property NAME=\"OCM_CROSS_HOST\" VALUE=\"".$ocmCrossHost."\"/>\n";
            print "</Target>\n";
          }
          next;
        }
      }
    }
    closedir (DIR);
  }
}

#Returns the timestamp from the config file
#if there is no error and the value is not empty, return the value
#otherwise, returned undefined value.
sub getCollectionTimestamp
{
  my ($configFile) = @_;
  my ($err,$value) = getConfigProperty($configFile,"TIMESTAMP");

  EMD_PERL_DEBUG("$LOG_CATEGORY in getCollectionTimestamp for $configFile=$err,$value");
  #if there is no error and the value is not empty, return the value
  if ($err eq "" && trim($value) ne "")
  {
    return trim($value);
  }
  return '';
}

