#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_epm_discover.pl /main/2 2009/08/10 12:05:42 rbalan Exp $
#
# oracle_epm_discover.pl
# 
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_epm_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nunni       07/01/09 - discovery script for epm products
#    nunni       07/01/09 - Creation
# 

use strict;

my ( $emdRoot, $hostName, $crsHome ) = @ARGV;

require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/discover/utl/thirdPartyCommon.pl";

use File::Spec;
use File::Basename;

EMD_PERL_DEBUG("EPM DISCOVERY START");

# OS specific checks
my $isWin   = 0;

my $filesep = "/";
my $pathsep = ":";
my $javaexe = "java";
my $reqdversion = "11.1.2.0";

if ( get_osType() eq 'WIN' )
{	
	$pathsep = ";";
	$javaexe = "java.exe"
}
elsif ( get_osType() eq 'MAC OS X' || get_osType() == -1 )
{
# Unsupported OS for EPM, exit        
	exit;
}

# Get Oracle home, Oracle config home and ccr java home from env
my $epminstance = $ENV{ORACLE_CONFIG_HOME};
my $epmoraclehome = $ENV{LL_ORACLE_HOME};
my $ccrjavahome = $ENV{CCR_JAVA_HOME};

#Ensure unix paths for collection scripts to work
$epmoraclehome = unixPath($epmoraclehome);
$epminstance = unixPath($epminstance);
$ccrjavahome = unixPath($ccrjavahome);

if (  !defined $epmoraclehome || $epmoraclehome eq "" )
{		
	EMD_PERL_DEBUG("Unable to get LL_ORACLE_HOME");
	exit;
}

if( !defined $epminstance || $epminstance eq "" )
{
	EMD_PERL_DEBUG("Unable to get ORACLE_CONFIG_HOME");
	exit;
}

# Check if ORACLE_CONFIG_HOME is a valid EPM instance
my $instcheckfile = join($filesep, $epminstance, "config", "foundation", $reqdversion, "epm.xml");
#print ($instcheckfolder ,"\n");
if (-f $instcheckfile)
{
	EMD_PERL_DEBUG("$epminstance is a valid epm instance");
	#print("$epminstance is a valid epm instance\n");
}
else
{
	EMD_PERL_DEBUG("$epminstance is not a valid epm instance");
	#print("$epminstance is not a valid epm instance\n");
	exit;
}

# Get epm_ocm_jar path        
my $epm_ocm_jarPath = join ($filesep,$emdRoot,"sysman","admin","lib","epm_ocm.jar");
if ( ! -f $epm_ocm_jarPath)
{
	$epm_ocm_jarPath = join($filesep,$epmoraclehome,"common","jlib",$reqdversion,"epm_ocm.jar")
}
if ( ! -f $epm_ocm_jarPath){
	EMD_PERL_DEBUG("Unable to locate epm_ocm.jar");
	exit;
}
$epm_ocm_jarPath = unixPath($epm_ocm_jarPath);

# Get Middleware home relative to LL_ORACLE_HOME
my $mwhome;
# EPM's Oracle Home should be below Middleware home
$mwhome = join ($filesep,$ENV{LL_ORACLE_HOME},".." );

$mwhome = unixPath($mwhome);
if( ! -d $mwhome)
{
	EMD_PERL_DEBUG("Unable to get MW_HOME");
	exit;
}

# Get valid java 1.6 executable
# Check CCR_JAVA_HOME first
my $jrebinfldr;		
my $java6;
$jrebinfldr=join ($filesep,$ccrjavahome,"bin");
$java6 = getValidJava6($jrebinfldr);

# Exit if java 1.6 not found 
if( $java6 == -1 )
{
	EMD_PERL_DEBUG("Unable to get a valid java 1.6 installation");
	exit;
}

#print "Got java ", $java6 ,"\n";

# Get version of installed EPM foundation
my $path = join ($filesep,$epmoraclehome,"common", "config");
$path=unixPath($path);
opendir(DIR,$path);
my @files = readdir(DIR);
closedir(DIR);
my $fldrname;
my $combined;
my @version;
my $currlargest = 0 ;
my $currversionfldr;
my $currversion;
foreach(@files){

	$fldrname =  $_ ;
	if( $fldrname ne "." && $fldrname ne ".." ) {
		$currversionfldr = join("/",$path,$fldrname);
		if( -d $currversionfldr ) {
			$combined="";
  			EMD_PERL_DEBUG("version folder found ", $fldrname );
			@version = split('\.',$fldrname);
  			foreach(@version) {
				$combined = $combined . $_;
			}
			#change to number
			$combined = $combined + 0;			
			if ($currlargest < $combined){
				$currlargest = $combined;
				$currversion = $fldrname;
			}
		}
	}
}
#print $currversion , "\n";
my @cparr;   
EMD_PERL_DEBUG("epm_home = $epmoraclehome");
EMD_PERL_DEBUG("epm_instance = $epminstance");

# Check version and set classpath accordingly
if($currversion eq $reqdversion)
{
    @cparr = ( 
    		join($filesep, $epmoraclehome, "common", "jlib", $reqdversion, "epm_j2se.jar"),
          	$epm_ocm_jarPath
          	);
          	
}
else
{
# Only 11.1.2.0 supported now
	exit;
}

my $classpath = unixPath(join ($pathsep, @cparr));         
my $targetLine;
my $command;

$command = "$java6 -classpath $classpath -DEPM_ORACLE_HOME=$epmoraclehome -DMW_HOME=$mwhome -DORACLE_INSTANCE=$epminstance -DEPM_ORACLE_INSTANCE=$epminstance -DEPM_VERSION=$currversion -DEPM_OCM_JAR=$epm_ocm_jarPath -DEPM_JAVA=$java6 oracle.ocm.epm.discovery.EPMDiscover $epminstance" ;
#print $command,"\n";
EMD_PERL_DEBUG("Java Path = $java6"); 
EMD_PERL_DEBUG("Classpath = $classpath"); 
EMD_PERL_DEBUG("Command = $command");

my @command_res;
chomp(@command_res = qx!$command!);
if ($? > 0 )
{
	#print "failed", "\n";
   EMD_PERL_DEBUG("The following command failed : $command. Error Code : $?");
}
else
{
   foreach $targetLine (@command_res)
   {
       print($targetLine,"\n");    
   }
}

EMD_PERL_DEBUG("EPM DISCOVERY END");

###########################################    

sub unixPath
{
    (my $path = shift) =~ tr!\\!/!;
    return $path;
}

sub getValidJava6 
{
	my $jrebinfldr = $_[0];
	my $java;
	my @jversion;
	my @version;
	my $major;
	my $maintenance;
	my @min ;
	my $minor ;
	my $reqdMajor = 1;
	my $reqdMaint = 6;
	$java = join($filesep, $jrebinfldr,$javaexe);
#	print "Checking " ,$jrebinfldr, "\n";
	if( -d $jrebinfldr && -f $java) {		
#		print ("java " , $java, "\n");
		EMD_PERL_DEBUG( "checking ", $java );
 		@jversion=`$java -version 2>&1`;
 		@version = split('"', $jversion[0]);
		@version = split('\.', $version[1]);
		$major=$version[0];
		$maintenance=$version[1];
		@min = split('_', $version[2]);
		$minor = $min[0];
		EMD_PERL_DEBUG( "Java version found " . $major . " "  . $maintenance . " " . $minor . " " .$min[1] );
		if( $major>=$reqdMajor && $maintenance>=$reqdMaint ) {
			return $java;
		}		
	}
	return -1;
}
