#!/usr/local/bin/perl
# 
# oracle_forms.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_forms.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hebansal   05/28/12 - XbranchMerge sbalacha_fixversion from st_emll_10.3.5
#    sbalacha   05/19/11 - Populate the version from Version.java
#    sbalacha   03/02/11 - #(10632882) forms ocm discovery file
#    sbalacha   02/14/11 - Creation
# 

use strict;
use Config;
use File::Spec;
use ias::simpleXPath;
use ias::propertiesFileParser;
use ias::asecm;

my ($emdRoot,$hostName) = @ARGV;

my @properties;
my @targetLines;
my $host;
#Get OS to check whether windows or not
my $os = $^O;
my $oracleHomeValue;
my %farms=();
my $farmName;
my $version;
my $domainName;
my $flag = "false";
my $isWin = "false";
my $domainFile;
my $topologyFile;
my $adminServerHost = $hostName;


#If OS is Windows set flag isWin to true
if(($os =~ "Win") || ($os =~ "MSWin32"))
{
    EMD_PERL_DEBUG("OS is Windows");
    $isWin = "true";
}
my $middlewareHome = $ENV{'BEA_HOME'};
if (!defined($middlewareHome))
{
    EMD_PERL_DEBUG("No BEA_HOME defined, aborting middleware discovery");
    exit;
}
$domainFile = File::Spec->catfile("$middlewareHome","utils","ccr","domainlocation.properties");

#Lookup in domainLocation file and search topology file for every domain.
if(-e $domainFile && defined($domainFile))
{
    my %domainLocations = parsePropertiesFile($domainFile);
    my @domainHomes;
    for my $domainHost (keys %domainLocations)
    {
        my $domainHost1 = lc($domainHost);
	 push(@domainHomes, split(',', $domainLocations{$domainHost})) if (lc($hostName) eq $domainHost1 || lc($hostName) =~ /^$domainHost1\..+/);
	}
	for my $domainHome (@domainHomes)
	{
            #For each domain, derive the forms target name from config.xml
            # Make sure the domain config file exists
            my $configFileName = "$domainHome/config/config.xml";
            if (!-e $configFileName)
            {
                EMD_PERL_DEBUG("No config.xml in domain home: $domainHome; skipping");
                next;
            }
            my $configFile = ias::simpleXPath::parseFile($configFileName);
            my $domainName = (ias::simpleXPath::queryForText($configFile,
                              'domain/name'))[0];
            EMD_PERL_DEBUG("Domain name = $domainName");

	    $topologyFile = File::Spec->catfile("$domainHome","opmn","topology.xml");
	    if(-e $topologyFile)
	    { 
     		#Parse topology file
		parseTopologyFile($topologyFile, $domainName);
                EMD_PERL_DEBUG(@targetLines);
	    }
	}
}
else
{
	EMD_PERL_DEBUG("oracle_forms.pl: domainLocaitons.properties file does not exist. Cannot discover Forms");
	exit;
}

print(@targetLines);

sub parseTopologyFile
{
	my $tpFile = $_[0];
        my $domainName = $_[1];
        my $targetName = "/Farm_$domainName";
#        print "targetNam eis ", $targetName;
#	%farms="";
	EMD_PERL_DEBUG("Gets here: $tpFile");
	my $configTopo = ias::simpleXPath::parseFile("$tpFile");
        #get list of instances
	my @tpNodes = ias::simpleXPath::queryForNodes($configTopo, 'topology/ias-instance');
	my $tpHash = scalar(@tpNodes);
	for (my $count1=0; $count1 < $tpHash ; $count1++) 
	{
	    my $instanceHost = ias::simpleXPath::getAttribute($tpNodes[$count1], "host");
	    if($instanceHost eq $hostName)
	    {
	        my $instanceHome = ias::simpleXPath::getAttribute($tpNodes[$count1], "instance-home");
                my $instId = ias::simpleXPath::getAttribute($tpNodes[$count1], "id");
                #If OS is Windows then convert Instance Location in lower case.
                if($isWin eq "true")
                {
                    $instanceHome = lc($instanceHome);
                }
                # we will have to create a target.xml xml snippet for 
                # oracle_forms target
                # only one forms component per as instance
                my @components = ias::simpleXPath::queryForNodes($configTopo, 'topology/ias-instance[@id="'.$instId.'"]/ias-component');
	        my $compHash = scalar(@components);
                for (my $count1=0; $count1 < $compHash ; $count1++) 
                {
                    my $id = ias::simpleXPath::getAttribute($components[$count1], "id");
                    my $comptype = ias::simpleXPath::getAttribute($components[$count1], "type");
                    if ( $comptype eq 'FormsComponent' )
                    { 
                        my @propNodes = ias::simpleXPath::queryForNodes($configTopo, 'topology/ias-instance[@id="'.$instId.'"]/ias-component[@id="'.$id.'"][@type="'.$comptype.'"]/em-properties/property');
                        my $pHash=scalar(@propNodes);
                        my $oraclehome; 
                        my $instname; 
                        my $targettype;
                        my $version;
                        for(my $cnt = 0; $cnt < $pHash; $cnt++)
                        {
                            my $name =  ias::simpleXPath::getAttribute($propNodes[$cnt], "name");
                            my $value =  ias::simpleXPath::getAttribute($propNodes[$cnt], "value");
                            if ( $name eq 'OracleHome' )
                            {
                                $oraclehome = $value;
                            }
                            elsif ( $name eq 'instName')
                            {
                                $instname = $value;
                            }
                            elsif ( $name eq 'EMTargetType' )
                            {
                                $targettype = $value;
                            }
                            elsif ( $name eq 'version' )
                            {
                                $version = $value;
                            }
                        }
# make a temperory change to the verion obtained. we need to remove this after
# we fix the version in topology.xml for forms target
# Get the version from the Version.java from frmall.jar
my $full_version = getVersion($oraclehome, $isWin);
$version=$full_version;
                        if ( $instId eq $instname )
                        {
                            # create a forms targets.xml snippet
                            my $displayName = "forms";
                            my $targetname1 = "$targetName/$instname/forms";
                            EMD_PERL_DEBUG("Target Name: $targetname1");
                            push(@targetLines, "<Target TYPE=\"$targettype\" NAME=\"$targetname1\" DISPLAY_NAME=\"$displayName\" ON_HOST=\"".$hostName."\">\n");
                            push(@targetLines, "\t<Property NAME=\"OracleHome\" VALUE=\"$oraclehome\"/>\n");
                            push(@targetLines, "\t<Property NAME=\"OcmProxyOracleHome\" VALUE=\"$oraclehome\"/>\n");
                            push(@targetLines, "\t<Property NAME=\"version\" VALUE=\"$version\"/>\n");
                            push(@targetLines, "\t<Property NAME=\"version_value\" VALUE=\"$version\"/>\n");
                            push(@targetLines, "\t<Property NAME=\"instName\" VALUE=\"$instname\"/>\n");
                            push(@targetLines, "\t<Property NAME=\"domainTarget\" VALUE=\"/Farm_$domainName/$domainName\"/>\n");
#                            push(@targetLines, "\t<Property NAME=\"hostNameAndOH\" VALUE=\"$hostName|$oraclehome\"/>\n");
                            push(@targetLines, "\t<Property NAME=\"adminServerHost\" VALUE=\"$adminServerHost\"/>\n");
                            push(@targetLines,"</Target>\n");
                        }
                    }
                }
            }
        }
}

sub getVersion()
{
my $oracle_home = $_[0];
my $isWin = $_[1];
my $java_home = $ENV{'CCR_JAVA_HOME'};
my $ccr_home = $ENV{'CCR_HOME'};
$oracle_home=~s/\\/\//g if ($oracle_home=~/^.:\\/);
$ccr_home=~s/\\/\//g if ($ccr_home=~/^.:\\/);
$java_home=~s/\\/\//g if ($java_home=~/^.:\\/);
my $classpath;
if ( $isWin eq "true")
{
#Windows OS
$classpath="$oracle_home/forms/java/frmall.jar;$ccr_home/sysman/admin/lib/formsver.jar";
#print "classpath is $classpath";
}
else
{
#Not windows OS
 $classpath="$oracle_home/forms/java/frmall.jar:$ccr_home/sysman/admin/lib/formsver.jar";
#print "classpath is $classpath";
}
if ( length($java_home) == 0 )
{
    EMD_PERL_DEBUG("The JAVA_HOME environment variable is not defined \n");
    exit 0;
}
if ( length($oracle_home) == 0 )
{
    EMD_PERL_DEBUG("oracle home is not defined \n");
    exit 0;
}
if ( length($ccr_home) == 0 )
{
    EMD_PERL_DEBUG("ccr home is not defined \n");
    exit 0;
}
my $command = "$java_home/bin/java -cp $classpath formsVersion";
#print "Command is $command";
my $res = `$command`;
chop($res);
return $res;
}
