#!/usr/local/bin/perl
# 
# $Header: oracle_ias_farm.pl 10-dec-2007.07:50:23 jsutton Exp $
#
# oracle_ias_farm.pl
# 
# Copyright (c) 2006, 2007, Oracle. All rights reserved.  
#
#    NAME
#      oracle_ias_farm.pl - Discovery script for iAS farms and clusters
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     12/10/07 - Use ORACLE_CONFIG_HOME vs. LL_ORACLE_HOME, as
#                           appropriate
#    jsutton     06/26/07 - Add OCM_CROSS_HOST instance property
#    pparida     06/09/06 - Creation (Bug 5293161: Add support for farms and clusters)
#


($emdRoot,$hostName,$crsHome) = @ARGV;
my $oracleHome = $ENV{LL_ORACLE_HOME};

if (defined($ENV{ORACLE_CONFIG_HOME}))
{
  $oracleHome = $ENV{ORACLE_CONFIG_HOME};
}

chomp($oracleHome);

require "$emdRoot/sysman/admin/scripts/ias/IAS_getFarmInfo.pl";

if(-e $oracleHome . "/config/ias.properties")
{
  my ($iasVersion, $farmName, $clusterName) = getIASFarmInfo($oracleHome);
  if($farmName ne "")
  {
    printTargetXML("oracle_ias_farm", $farmName, $iasVersion, $oracleHome)
  }
  if($clusterName ne "")
  {
    printTargetXML("oracle_ias_cluster", $clusterName, $iasVersion, $oracleHome)
  }
}


sub printTargetXML
{
  my ($targetType, $targetName, $targetVersion, $oh) = @_;
  print "<Target TYPE=\"$targetType\" NAME=\"$targetName\">\n";
  print "   <Property NAME=\"version\" VALUE=\"$targetVersion\"/>\n";
  print "   <Property NAME=\"OracleHome\" VALUE=\"$oh\"/>\n";
  print "   <Property NAME=\"OCM_CROSS_HOST\" VALUE=\"TRUE\"/>\n";
  print "</Target>\n";
  return;
}



