#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_idm.pl /main/8 2012/01/12 21:00:38 proxy Exp $
#
# oracle_idm.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_idm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       03/24/11 - fix_proxy_oracle_home and remove iam instance discovery
#    proxy       02/23/11 - fix_bug_9888486
#    proxy       09/08/10 - fix_bug_10086267
#    proxy       08/16/10 - fix_bug_10020496
#    proxy       08/03/10 - XbranchMerge proxy_ocmbug1 from main
#    proxy       08/02/10 - XbranchMerge proxy_idmocm20 from main
#    proxy       07/26/10 - Fix for bugs 9925972 and 9926308
#    proxy       04/15/10 - Creation
# 

use strict;
use Config;
use File::Spec;
use ias::simpleXPath;
use ias::propertiesFileParser;
use ias::asecm;
use Sys::Hostname;
use Socket;

my ($emdRoot,$hostName) = @ARGV;

my @properties;
my @targetLines;
my $host;
#Get OS to check whether windows or not
my $os = $^O;
my $oracleHomeValue;
my $oracleHomeFlag = "true";
my $farmName;
my $version;
my $machineName;
my $machinePort;
my $domainName;
my $isWin = "false";
my $domainFile;
my $topologyFile;

#Getting the IP address of the host in order to compare it with the hosts in domainlocation.properties file
my($hostIP) = inet_ntoa( (gethostbyname($hostName))[4] );

#If OS is Windows set flag isWin to true
if(($os =~ "Win") || ($os =~ "MSWin32"))
{
    EMD_PERL_DEBUG("OS is Windows");
    $isWin = "true";
}

#The following flag is to keep track of shared Oracle Home, where oracle home is same while oracle config home is different for each instance.
my $sharedHomeFlag = "false";
my $emagentString = File::Spec->catfile("EMAGENT","EMAGENT","sysman","emd","targets.xml");

#To check whether it is a shared home configuration or not (bug 9925972)
#Pick up LL_ORACLE_HOME and ORACLE_CONFIG_HOME from the environment and compare. If both are defined and not same, then it is shared home configuration
#and the flag will be set to true
my $oracleHome = $ENV{'LL_ORACLE_HOME'};
my $configHome = $ENV{'ORACLE_CONFIG_HOME'};

#If OS is Windows then convert Oracle home and config home in lower case.
#This is fix for bug 10020496
if($isWin eq "true")
{
    $oracleHome = lc($oracleHome);
    $configHome = lc($configHome);
}

if(defined $configHome && defined $oracleHome)
{
	if($oracleHome ne $configHome)
	{
		$sharedHomeFlag = "true";
	}
}


my $middlewareHome = $ENV{'BEA_HOME'};
if (!defined($middlewareHome))
{
	EMD_PERL_DEBUG("No BEA_HOME defined, aborting middleware discovery");
}
else
{
	$domainFile = File::Spec->catfile("$middlewareHome","utils","ccr","domainlocation.properties");
}

#Lookup in domainLocation file and search topology file for every domain.
if(-e $domainFile && defined($domainFile))
{
	my %domainLocations = parsePropertiesFile($domainFile);
	my @domainHomes;
	for my $domainHost (keys %domainLocations)
	{
		my $domainHost1 = lc($domainHost);
		#get IP address and compare it to localhosts' ip address and if found equal then split domainHomes and store
		my($domainHostIP) = inet_ntoa( (gethostbyname($domainHost1))[4] );
		push(@domainHomes, split(',', $domainLocations{$domainHost})) if ($hostIP eq $domainHostIP);
	}
	for my $domainHome (@domainHomes)
	{
		$topologyFile = File::Spec->catfile("$domainHome","opmn","topology.xml");
		if(-e $topologyFile)
		{
			#Parse topology file
			parseTopologyFile($topologyFile);
		}
	}
}
elsif(defined($ENV{'ORACLE_INSTANCE'}))
{
	#else look up if ORACLE_INSTANCE is defined. In case of multiple instance homes, they will be separated by colon. Get each instance home and then parse the targets.xml for each of them.
	my $oracleInstance = $ENV{'ORACLE_INSTANCE'};
	EMD_PERL_DEBUG("oracle_idm.pl: OracleInstance is $oracleInstance");
	my $char = ':';
	my $pos1 = 0;
   	my @oracleInstances;
	my $result;
	while(($result = index($oracleInstance, $char, $pos1)) != -1)
	{
		my $len = $result - $pos1;
		my $instance = substr($oracleInstance, $pos1, $len);
		push(@oracleInstances, $instance);
		$pos1=$result + 1;
	}

	push(@oracleInstances, substr($oracleInstance, $pos1));
	my $instanceLocn;
	foreach $instanceLocn (@oracleInstances) 
	{
        #If OS is Windows then convert Instance Location in lower case.
        #This is fix for bug 10020496
        if($isWin eq "true")
        {
            $instanceLocn = lc($instanceLocn);
        }
 
		#if shared home flag is true then check if the instance home location is same as oracle config home or not. If instance location is same as config home, then go ahead with parsing targets.xml
		#if shared home flag is false then no need of checking, simply go ahead with targets.xml parsing.
		#if it is same then go ahead with parsing the targets.xml otherwise do nothing.
		if(($sharedHomeFlag eq "true" && $instanceLocn eq $configHome) || ($sharedHomeFlag eq "false"))
		{
			my $targetsFile = File::Spec->catfile("$instanceLocn","$emagentString");
			if (!-e $targetsFile) 
			{
                EMD_PERL_DEBUG("oracle_idm.pl: Can't find the file...: $targetsFile");
			}
			else
			{
				parseTargetXml($targetsFile);
			}
		}
	}
}
else
{
	EMD_PERL_DEBUG("No IDM Instance found");
	exit;
}

print(@targetLines);

sub parseTopologyFile
{
	my $tpFile = $_[0];
	EMD_PERL_DEBUG("Gets here: $tpFile");
	my $configTopo = ias::simpleXPath::parseFile("$tpFile");
#	get list of instances
	my @tpNodes = ias::simpleXPath::queryForNodes($configTopo, 'topology/ias-instance');
	my $tpHash = scalar(@tpNodes);
	for (my $count1=0; $count1 < $tpHash ; $count1++) 
	{
		my $instanceHost = ias::simpleXPath::getAttribute($tpNodes[$count1], "host");
		my ($instanceHostIP) = inet_ntoa( (gethostbyname($instanceHost))[4] );
		#compare ip addresses 
		if($instanceHostIP eq $hostIP)
		{
			my $instanceHome = ias::simpleXPath::getAttribute($tpNodes[$count1], "instance-home");
            #If OS is Windows then convert Instance Location in lower case.
            #This is fix for bug 10020496
            if($isWin eq "true")
            {
                $instanceHome = lc($instanceHome);
            }
			#if shared home flag is true then check if the instance home location is same as oracle config home or not. If instance location is same as config home, then go ahead with parsing targets.xml
			#if shared home flag is false then no need of checking, simply go ahead with targets.xml parsing.
			#if it is same then go ahead with parsing the targets.xml otherwise do nothing.
			if(($sharedHomeFlag eq "true" && $instanceHome eq $configHome) || ($sharedHomeFlag eq "false"))
			{
				my $targetFile = File::Spec->catfile("$instanceHome","$emagentString");
				if (!-e $targetFile) 
				{
					EMD_PERL_DEBUG("oracle_idm.pl: Can't find the file...: $targetFile");
				}
				else
				{
					parseTargetXml($targetFile);
				}
			}
		}
	}
}

sub parseTargetXml
{
	my $fileName = $_[0];
	EMD_PERL_DEBUG("Gets here: $fileName");
	my $configFile = ias::simpleXPath::parseFile("$fileName");



	my @nodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target');
	my $hashSize=scalar(@nodes);
	for (my $count = 0; $count < $hashSize; $count++) 
	{
		my $type = ias::simpleXPath::getAttribute($nodes[$count], "TYPE");
		EMD_PERL_DEBUG("Target Type: $type");

		my $property;
		#For DIP
		if($type eq "oracle_eps_server" || $type eq "oracle_federation" || $type eq "oracle_ovd" || $type eq "oracle_ldap")
		{
			#flag to check whether the OH from where ccr discovery is happening is same as OH for the product.
			$oracleHomeFlag = "true";
			my $targetName = ias::simpleXPath::getAttribute($nodes[$count], "NAME");
			
			my @ohNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property[@NAME="OracleHome"]');
			$oracleHomeValue = ias::simpleXPath::getAttribute($ohNodes[0], "VALUE");

			if($oracleHomeValue ne $oracleHome)
			{
				$oracleHomeFlag = "false";
			}

			EMD_PERL_DEBUG("Target Name: $targetName");
			#discover with or without OcmProxyOracleHome based on from which OH discovery is happening.
			if(length($oracleHomeValue)>0)
			{
				printTargets($fileName,$targetName,$oracleHomeFlag);
			}
		}
	}
}

sub printTargets
{
	my $fileName = $_[0];
	EMD_PERL_DEBUG("Gets here: $fileName");
	my $configFile = ias::simpleXPath::parseFile("$fileName");

	#String tokens to be used in regular expressions for identifying AppName from AppObjectName for DIP and OIF
	my $str1 = "com.bea:Name=";
	my $str2 = ",Location=";
	my $str3 = ",Type=AppDeployment";

	my $targetName = $_[1];
	my $oracleHomeFlag = $_[2];

	my @nodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]');
	my $hashSize=scalar(@nodes);
	for (my $count = 0; $count < $hashSize; $count++) 
	{
		my $type = ias::simpleXPath::getAttribute($nodes[$count], "TYPE");
		my $displayName = ias::simpleXPath::getAttribute($nodes[$count], "DISPLAY_NAME");

		EMD_PERL_DEBUG("Target Type: $type");

		my $property;
		#For DIP
		if($type eq "oracle_eps_server")
		{
			if($oracleHomeFlag eq "true")
			{
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\">\n");
			}
			else{
				my @ohNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property[@NAME="OracleHome"]');
				$oracleHomeValue = ias::simpleXPath::getAttribute($ohNodes[0], "VALUE");

				#push proxy oracle home value, if the oracle home of product is different from that of where ccr is configured
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\" ON_HOST=\"$hostName\">\n");
				push(@targetLines, "\t<Property NAME=\"OcmProxyOracleHome\" VALUE=\"$oracleHomeValue\"/>\n");
			}
			@properties = ("DomainHome","DOMAIN_HOME","version","MachineName","Port","ServerNames","appObjectName");
			my @propNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property');

			my $pHash=scalar(@propNodes);

			for(my $cnt = 0; $cnt < $pHash; $cnt++)
			{
				my $pName = ias::simpleXPath::getAttribute($propNodes[$cnt], "NAME");
				if($pName eq "version")
				{
					$version = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "MachineName")
				{
					$machineName = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "Port")
				{
					$machinePort = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				foreach $property (@properties) 
				{
					if ($pName eq $property) 
					{
						my $pValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
						if($pName eq "DomainHome")
						{
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"DOMAIN_HOME\" VALUE=\"$pValue\"/>\n");
							push(@targetLines, "\t<Property NAME=\"domainHome\" VALUE=\"$pValue\"/>\n");
						}
						elsif($pName eq "version")
						{
							#if the property name is "version" then add "version_value" as well in order to introduce normalized target version for the target
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
							push(@targetLines, "\t<Property NAME=\"version_value\" VALUE=\"$pValue\"/>\n");
						}
						elsif($pName eq "appObjectName")
						{
							#Extract the appName from appObjectName
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							$pValue =~ /^$str1(.*?)$str2(.*?)$str3$/;
							my $appName = $1;
							push(@targetLines, "\t<Property NAME=\"appName\" VALUE=\"$appName\"/>\n");
						}
						else{
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
						}
					}
				}		
			}
			my @assocNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@TYPE="'.$type.'"]/AssocTargetInstance');
			my $aHash = scalar(@assocNodes);

			for(my $cnt = 0; $cnt < $aHash; $cnt++)
			{
				my $assocName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOCIATION_NAME");
				my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
				my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
				EMD_PERL_DEBUG("ANAME = $assocName, ATT = $assocTargetType, ATN = $assocTargetName");
				push(@targetLines, "\t<AssocTargetInstance ASSOCIATION_NAME=\"$assocName\" ASSOC_TARGET_TYPE=\"$assocTargetType\" ASSOC_TARGET_NAME=\"$assocTargetName\"/>\n");
			}
			push(@targetLines,"</Target>\n");
		}

		#For OIF
		if($type eq "oracle_federation")
		{
			if($oracleHomeFlag eq "true")
			{
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\">\n");
			}
			else{
				my @ohNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property[@NAME="OracleHome"]');
				$oracleHomeValue = ias::simpleXPath::getAttribute($ohNodes[0], "VALUE");

				#push proxy oracle home value, if the oracle home of product is different from that of where ccr is configured
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\" ON_HOST=\"$hostName\">\n");
				push(@targetLines, "\t<Property NAME=\"OcmProxyOracleHome\" VALUE=\"$oracleHomeValue\"/>\n");
			}
			@properties = ("DomainHome","DOMAIN_HOME","version","MachineName","Port","ServerNames","appObjectName");

			my @propNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property');
			my $pHash=scalar(@propNodes);

			for(my $cnt = 0; $cnt < $pHash; $cnt++)
			{
				my $pName = ias::simpleXPath::getAttribute($propNodes[$cnt], "NAME");
				if($pName eq "OracleHome")
				{
					$oracleHomeValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
					if($oracleHomeValue ne $oracleHome)
					{
						$oracleHomeFlag = "false";
					}
				}
				if($pName eq "version")
				{
					$version = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "MachineName")
				{
					$machineName = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "Port")
				{
					$machinePort = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				foreach $property (@properties) 
				{
					if ($pName eq $property) 
					{
						my $pValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
						if($pName eq "DomainHome")
						{
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"DOMAIN_HOME\" VALUE=\"$pValue\"/>\n");
							push(@targetLines, "\t<Property NAME=\"domainHome\" VALUE=\"$pValue\"/>\n");
						}
						elsif($pName eq "version")
						{
							#if the property name is "version" then add "version_value" as well in order to introduce normalized target version for the target
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
							push(@targetLines, "\t<Property NAME=\"version_value\" VALUE=\"$pValue\"/>\n");
						}
						elsif($pName eq "appObjectName")
						{
							#Extract the appName from appObjectName
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							$pValue =~ /^$str1(.*?)$str2(.*?)$str3$/;
							my $appName = $1;
							push(@targetLines, "\t<Property NAME=\"appName\" VALUE=\"$appName\"/>\n");
						}
						else{
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
						}
					}
				}		
			}
			my @assocNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@TYPE="'.$type.'"]/AssocTargetInstance');
			my $aHash = scalar(@assocNodes);

			for(my $cnt = 0; $cnt < $aHash; $cnt++)
			{
				my $assocName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOCIATION_NAME");
				my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
				my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
				EMD_PERL_DEBUG("ANAME = $assocName, ATT = $assocTargetType, ATN = $assocTargetName");
				push(@targetLines, "\t<AssocTargetInstance ASSOCIATION_NAME=\"$assocName\" ASSOC_TARGET_TYPE=\"$assocTargetType\" ASSOC_TARGET_NAME=\"$assocTargetName\"/>\n");
			}
			push(@targetLines,"</Target>\n");
		}

		#For OVD
		if($type eq "oracle_ovd"){
			if($oracleHomeFlag eq "true")
			{
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\">\n");
			}
			else{
				my @ohNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property[@NAME="OracleHome"]');
				$oracleHomeValue = ias::simpleXPath::getAttribute($ohNodes[0], "VALUE");

				#push proxy oracle home value, if the oracle home of product is different from that of where ccr is configured
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\" ON_HOST=\"$hostName\">\n");
				push(@targetLines, "\t<Property NAME=\"OcmProxyOracleHome\" VALUE=\"$oracleHomeValue\"/>\n");
			}
			@properties = ("OracleInstance","version","MachineName","Port");

			my @propNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property');
			my $pHash=scalar(@propNodes);

			for(my $cnt = 0; $cnt < $pHash; $cnt++)
			{
				my $pName = ias::simpleXPath::getAttribute($propNodes[$cnt], "NAME");
				if($pName eq "OracleHome")
				{
					$oracleHomeValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
					if($oracleHomeValue ne $oracleHome)
					{
						$oracleHomeFlag = "false";
					}
				}
				if($pName eq "version")
				{
					$version = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "MachineName")
				{
					$machineName = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "Port")
				{
					$machinePort = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				foreach $property (@properties) 
				{
					if ($pName eq $property) 
					{
						my $pValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
						if($pName eq "version")
						{
							#if the property name is "version" then add "version_value" as well in order to introduce normalized target version for the target
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
							push(@targetLines, "\t<Property NAME=\"version_value\" VALUE=\"$pValue\"/>\n");
						}
						else{
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
						}
					}
				}		
			}
			my @assocNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@TYPE="'.$type.'"]/AssocTargetInstance');
			my $aHash = scalar(@assocNodes);

			for(my $cnt = 0; $cnt < $aHash; $cnt++)
			{
				my $assocName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOCIATION_NAME");
				my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
				my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
				EMD_PERL_DEBUG("ANAME = $assocName, ATT = $assocTargetType, ATN = $assocTargetName");
				push(@targetLines, "\t<AssocTargetInstance ASSOCIATION_NAME=\"$assocName\" ASSOC_TARGET_TYPE=\"$assocTargetType\" ASSOC_TARGET_NAME=\"$assocTargetName\"/>\n");
			}

			push(@targetLines,"</Target>\n");
		}

		#For OID
		if($type eq "oracle_ldap"){
			if($oracleHomeFlag eq "true")
			{
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\">\n");
			}
			else{
				my @ohNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property[@NAME="OracleHome"]');
				$oracleHomeValue = ias::simpleXPath::getAttribute($ohNodes[0], "VALUE");

				#push proxy oracle home value, if the oracle home of product is different from that of where ccr is configured
				push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\" ON_HOST=\"$hostName\">\n");
				push(@targetLines, "\t<Property NAME=\"OcmProxyOracleHome\" VALUE=\"$oracleHomeValue\"/>\n");
			}
			@properties = ("OracleInstance","version","ConnectDescriptor","MachineName","Port");

			my @propNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property');
			my $pHash=scalar(@propNodes);

			for(my $cnt = 0; $cnt < $pHash; $cnt++)
			{
				my $pName = ias::simpleXPath::getAttribute($propNodes[$cnt], "NAME");
				if($pName eq "OracleHome")
				{
					$oracleHomeValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
					if($oracleHomeValue ne $oracleHome)
					{
						$oracleHomeFlag = "false";
					}
				}
				if($pName eq "version")
				{
					$version = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "MachineName")
				{
					$machineName = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				if($pName eq "Port")
				{
					$machinePort = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
				}
				foreach $property (@properties) 
				{
					if ($pName eq $property) 
					{
						my $pValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
						my $pValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
						if($pName eq "version")
						{
							#if the property name is "version" then add "version_value" as well in order to introduce normalized target version for the target
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
							push(@targetLines, "\t<Property NAME=\"version_value\" VALUE=\"$pValue\"/>\n");
						}
						else{
							EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
							push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
						}
					}
				}		
			}
			my @assocNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@TYPE="'.$type.'"]/AssocTargetInstance');
			my $aHash = scalar(@assocNodes);

			for(my $cnt = 0; $cnt < $aHash; $cnt++)
			{
				my $assocName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOCIATION_NAME");
				my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
				my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
				EMD_PERL_DEBUG("ANAME = $assocName, ATT = $assocTargetType, ATN = $assocTargetName");
				push(@targetLines, "\t<AssocTargetInstance ASSOCIATION_NAME=\"$assocName\" ASSOC_TARGET_TYPE=\"$assocTargetType\" ASSOC_TARGET_NAME=\"$assocTargetName\"/>\n");
			}
			push(@targetLines,"</Target>\n");
		}
	}
}