#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_livelink.pl /main/6 2010/06/10 06:01:31 ckalivar Exp $
#
# oracle_livelink.pl
# 
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      discovers the livelink target
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       ckalivar 05/31/10 - ER 8239565: populate version_value property
#       ndutko   02/06/06 - Product name change 
#       ndutko   12/13/05 - Change of product name to Oracle Direct Connect 
#       ndutko   10/06/05 - CCR Cutover 
#       ndutko   08/03/05 - ndutko_code_checkin
#    ndutko      08-jun-2005 - Creation
# 

($emdRoot,$hostName,$crsHome) = @ARGV;
require "$emdRoot/sysman/admin/scripts/semd_common.pl";


use File::Spec;
use Config;
use File::Temp qw/tempdir/;

use constant LIVELINK_HOME => $ENV{CCR_HOME};
use constant NIL            => '';
use constant LIVELINK_INVENTORY => File::Spec->catdir(LIVELINK_HOME, "inventory");

#Discovery LOG CATEGORY
$LOG_CATEGORY = "LIVELINK_DISCOVERY: ";

my $jarFNM = "jar";
my $ocmJarUtilFNM = "ocmJarUtil";
if ($Config{'osname'} eq "MSWin32")
{
    $jarFNM = $jarFNM . ".exe";
    $ocmJarUtilFNM = $ocmJarUtilFNM .".bat";
}
my $javaHomeJar = File::Spec->catdir($ENV{CCR_JAVA_HOME},"bin",$jarFNM);
my $oracleHomeJar = File::Spec->catdir(
                       dirname(LIVELINK_HOME),
                       "jdk", "bin", $jarFNM);
my $ocmJarUtil = File::Spec->catdir(LIVELINK_HOME,"bin",$ocmJarUtilFNM);
my $JAR;
if ( -f $javaHomeJar )
{
    $JAR = $javaHomeJar;
}
elsif ( -f $oracleHomeJar )
{
    $JAR = $oracleHomeJar;
}
elsif ( -f $ocmJarUtil )
{
    $JAR = $ocmJarUtil;
}


print  "<Target NAME=\"Oracle Configuration Manager\" TYPE=\"oracle_livelink\">\n";
printf "    <Property NAME=\"livelink_home\" VALUE=\"%s\"/>\n",
			LIVELINK_HOME;
if (my $version =getCoreVersion() )
{
print "    <Property NAME=\"version_value\" VALUE=\"$version\"/>\n";
}
print  "</Target>\n";



sub getCoreVersion()
{
    if(!opendir INVENTORY, LIVELINK_INVENTORY )
   {
     EMD_PERL_ERROR( "$LOG_CATEGORY Unable to open LiveLink deployment directory");
     return;
   }
    
    my @package = grep {/^core\.jar$/ }  readdir(INVENTORY);
    my $fullSpec = File::Spec->catfile(LIVELINK_INVENTORY, $package[0]);
    closedir INVENTORY;
    my $packageFNM = $fullSpec;
    if ($Config{'osname'} eq "MSWin32")
    {
        $packageFNM = Win32::GetShortPathName($packageFNM);
    }

    # create a temporary directory to unpack the MANIFEST into
    my $curdir=File::Spec->rel2abs(File::Spec->curdir());
    my $tmpdir=tempdir();
    chdir($tmpdir);
    system("$JAR xf $packageFNM META-INF/MANIFEST.MF");

    if (!open MANIFEST,"<".File::Spec->catfile(".", "META-INF", "MANIFEST.MF"))
    {
        EMD_PERL_ERROR( "$LOG_CATEGORY Unable to open manifest, $!\n");
        return;
    }

    my $line;
    my $value = '';
    while($line = <MANIFEST>)
    {
        chomp $line;
        ($value) = ($line =~ /^package-version\s*:\s*([\w. :\/\-]*)/);
        if ($value ne '')
        {
           last;
        }
    }

    close MANIFEST;
    # Reset the working directory to whence we started.
    chdir ($curdir);
    # remove the temporary directory.
    unlink File::Spec->catfile($tmpdir, "META-INF", "MANIFEST.MF");
    rmdir File::Spec->catdir($tmpdir, "META-INF");
    rmdir $tmpdir;

    return  $value;

}

