#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_oms_discover.pl /main/7 2011/07/20 05:20:48 tsubrama Exp $
#
# oracle_oms_discover.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_oms_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tsubrama    07/18/11 - fix for bug#12767808
#    tsubrama    05/30/11 - don't discover oms if it is 12G or later
#    rstorrie    06/25/10 - Addition of version_value to discvoery
#    nmittal     11/13/09 - XbranchMerge nmittal_bug-9118047 from
#                           st_emll_10.3.2
#    nmittal     11/13/09 - fixing oms discovery in SH for wls stack.
#    nmittal     10/02/09 - XbranchMerge nmittal_bug-8629030 from
#                           st_emll_10.3.2
#    nmittal     09/17/09 - adding discovery for 11.1+ OMS with WLS stack
#    rstorrie    12/08/05 - Move oracle_home into for loop 
#    rstorrie    12/08/05 - Add oracle_home part to target definition 
#    rstorrie    12/01/05 - Discovery script for grid control OMS 
#    rstorrie    12/01/05 - Discovery script for grid control OMS 
#    rstorrie    12/01/05 - Creation
# 
use strict;
use File::Spec;
use ias::simpleXPath;

my ($emdRoot,$hostName,$crsHome) = @ARGV;
require "$emdRoot/sysman/admin/scripts/emd_common.pl";

#Discovery for pre-11g OMS
discoveryInOC4JStack();

#Discovery for 11.1+ OMS
discoveryInWLSStack();

sub discoveryInWLSStack
{
   my $instance_home = $ENV{ORACLE_CONFIG_HOME};

   if ( defined $instance_home && $instance_home ne "" )
   {
      my $oms_properties_file_for_ocm = File::Spec->catfile( $instance_home, "sysman", "ocm", "emoms.properties" );
      my $oms_version_file = File::Spec->catfile( $instance_home, "sysman", "ocm", "emVersion.properties" );
      if(-f $oms_properties_file_for_ocm && -f $oms_version_file ) 
      {
         my $file_opened = "true";
         open (FILE, "<$oms_properties_file_for_ocm") or ($file_opened="false");
         if($file_opened eq "true")
         {
            #Discover target only if we can read the file
            my $omsName = "OMS_NAME";
            my $line;
            my $omsVersion = '';
            #Scan through the file assigning the various parameters to get the values
            while ($line = <FILE>)
            { 
               chomp $line;
               next if ($line =~ /^\s*#/);
               if ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
               {
                  my $value = $2;
                  my $parameter = $1;
                  if($parameter eq "oracle.sysman.emSDK.svlt.ConsoleServerName")
                  {
                     #replace any \: with : 
                     $value =~ s/\\:/:/g;
                     $omsName = $value;
                  }
               }
            }
            close FILE;
            open (FILE, "<$oms_version_file") or ($file_opened="false");
            if($file_opened eq "true")
            {
               while ($line = <FILE>)
               {
                  chomp $line;
                  next if ($line =~ /^\s*#/);
                  if  ( $line =~ /^\s*(.*?)\s*=\s*(.*?)$/)
                  {
                     my $value = $2;
                     my $parameter= $1;
                     if ($parameter eq "coreVersion")
                     {
                        $omsVersion = $value; 
                     }
                  }
               }
            } #end the if opened file
            else
            {
               EMD_PERL_DEBUG("Unable to open $! \n",$oms_version_file);
            }
            #InstanceHome is set in WLS stack, also WLS_STACK=TRUE is added
             # get if OMS is 11.2 (12gc) or later.
            my $isPre12gOMS = isPre12gcOMS($omsVersion);

            # Add OMS target if it is pre12GC.
            if ( $isPre12gOMS eq 'Yes')
            {
                  printf ("<Target TYPE=\"oracle_oms\" NAME=\"%s\">\n", $omsName);
                  if (defined $omsVersion && $omsVersion ne "")
                  {
                     print ("     <Property NAME=\"version_value\" VALUE=\"$omsVersion\"/>\n");
                  }
                  print ("     <Property NAME=\"OracleHome\" VALUE=\"$ENV{LL_ORACLE_HOME}\"/>\n");
                  print ("     <Property NAME=\"InstanceHome\" VALUE=\"$instance_home\"/>\n");
                  print ("     <Property NAME=\"WLS_STACK\" VALUE=\"TRUE\"/>\n");
                  print "</Target>\n";
            }
         }
         else
         {
            EMD_PERL_DEBUG("Unable to open $! \n",$oms_properties_file_for_ocm); 
         }
      }
   }
}

sub discoveryInOC4JStack
{
   my $oc4j_em_file = File::Spec->catdir( $ENV{LL_ORACLE_HOME}, "j2ee", "OC4J_EM" );
   # Setup a filename to get the oms version
   # then parse this using simpleXPathQuery
   my $oms_version_file = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "j2ee", "OC4J_EM","applications","em","em","WEB-INF","config","emVersion.xml");
   my $oms_properties_file = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "sysman", "config", "emoms.properties" );
   my $opmn_file = File::Spec->catfile( $ENV{LL_ORACLE_HOME}, "opmn", "conf", "opmn.xml" );
   my $omsCoreVersion = '';

   if (-f $oms_version_file)
   {
      my $file_opened = "true";
      open (FILE, "<$oms_version_file") or ($file_opened="false");
      if($file_opened eq "true")
      {
         close FILE;
         my @omsVersion = simpleXPathQuery($oms_version_file,'Product');
         foreach my $refOmsVersion (@omsVersion)
         {
             $omsCoreVersion = $refOmsVersion->{'coreVersion'};
         }
      }
      else
      {
         EMD_PERL_DEBUG("Unable to open $! \n",$oms_version_file);
      }
   }

   if (-d $oc4j_em_file && -e $oms_properties_file && -e $opmn_file)
   {
      #Ensure we can read the opmn configuration file
      my $file_opened = "true";
      open (FILE, "<$opmn_file") or ($file_opened="false");
      if($file_opened eq "true")
      {
         close FILE;
         #using XPathQuery navigate the xml tree to get the ias-instance name
         #This is then used for the name of the target
         my @omsTarget = simpleXPathQuery($opmn_file, 'opmn/process-manager/ias-instance');
   
         foreach my $refTargetRec (@omsTarget)
         {
            printf ("<Target TYPE=\"oracle_oms\" NAME=\"%s\">\n", $refTargetRec->{'id'});
            if (defined $omsCoreVersion && $omsCoreVersion ne "")
            {
                print ("     <Property NAME=\"version_value\" VALUE=\"$omsCoreVersion\"/>\n");
            }
            print ("     <Property NAME=\"OracleHome\" VALUE=\"$ENV{LL_ORACLE_HOME}\"/>\n");
            print ("     <Property NAME=\"WLS_STACK\" VALUE=\"FALSE\"/>\n");
            print "</Target>\n";
         }
      }
      else
      {
         EMD_PERL_DEBUG("Unable to open $! \n",$opmn_file); 
      }
   }  
}

# get the OMS is pre-12GC or not by passing the OMS Version.
sub isPre12gcOMS
{
  my ($tgt_version) = @_;

  my $first_dot_index = index($tgt_version,".");
  my $second_dot_index;
  my $tgt_max_version;
  my $tgt_min_version = 0;


  my $isPre12G_Target = 'No';

  if ($first_dot_index > -1)
  {
      $tgt_max_version = substr($tgt_version,0,$first_dot_index);

      $second_dot_index = index($tgt_version,".",($first_dot_index+1));
      if($second_dot_index > -1)
      {
        $tgt_min_version = substr($tgt_version, ($first_dot_index+1), $second_dot_index-($first_dot_index+1));
      }

      if($tgt_max_version <= 11 and $tgt_min_version<=1)
      {
         $isPre12G_Target = 'Yes';
      }
      elsif($tgt_max_version <= 10)
      {
         $isPre12G_Target = 'Yes';
      }
  }
  return $isPre12G_Target;
}

