#!/usr/local/bin/perl
# 
# oracle_psft_appsrv_discover.pl
# 
# Copyright (c) 2002, 2007, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       pparida  10/17/07 - XbranchMerge pparida_bug-6492554 from
#                           st_emll_10.2.7
#       pparida  10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                           state and config dirs.
#       ndutko   02/12/06 - PSFT target discovery - initial checkin for 
#                           MTAMURA 
#       ndutko   02/12/06 - PSFT target discovery - initial checkin for 
#                           MTAMURA 
# 

($emdRoot,$hostName,$crsHome) = @ARGV;
use File::Spec;
use ias::simpleXPath;
use psft::ccr;
use Digest::MD5 qw(md5 md5_hex md5_base64);

use constant LIVELINK_HOME => $ENV{CCR_HOME};

my $ccrRootState = "$emdRoot/state";
my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";
my @files = getCCRDumpFiles($ccrRootState, $ccrHomeState, 'appserver');
foreach my $file (@files)
{
    my $registryFile = "$ccrHomeState/temp/".$file;

    if( -f $registryFile)
    {
        # appserver.psft file found.
    	my @topLevelComponents = simpleXPathQuery($registryFile, "components/appserv");
    	for my $topLevelComponent (@topLevelComponents)
    	{
    	    # found a domain.
    		my $domain = $$topLevelComponent{'domain'};
    		my $configpath = $$topLevelComponent{'configpath'};
            if( length($domain."_".$configpath) > 256)
            {
                $configpath = uc md5_base64($configpath);
            }
            print  "<Target NAME=\"$domain\_$configpath\" TYPE=\"oracle_psft_appsrv\">\n";
      		print  "  <Property NAME=\"PSFTFile\" VALUE=\"$file\" />\n";
            print  "</Target>\n";
    	} # end for - domain
    } # end for - file
}
