#!/usr/local/bin/perl
# 
# oracle_psft_database_discover.pl
# 
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       nmittal  05/26/10 - XbranchMerge nmittal_bug-9646495 from
#                           st_emll_10.3.3
#       nmittal  04/23/10 - XbranchMerge nmittal_bug-9646490 from
#                           st_emll_10.3.3
#       nmittal  04/23/10 - 9646490
#       nmittal  02/16/10 - 9323287
#       nmittal  02/06/10 - 9323287 - PEOPLESOFT METRIC COLLECTION ENHANCEMENT
#       pparida  10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                           state and config dirs.
#       ndutko   02/12/06 - PSFT target discovery - initial checkin for 
#                           MTAMURA 
#       ndutko   02/12/06 - PSFT target discovery - initial checkin for 
#                           MTAMURA 
# 

($emdRoot,$hostName,$crsHome) = @ARGV;
use File::Spec;
use ias::simpleXPath;
use psft::ccr;

use constant LIVELINK_HOME => $ENV{CCR_HOME};

my $ccrRootState = "$emdRoot/state";
my $ccrHomeState = $ENV{CCR_CONFIG_HOME} . "/state";
my @files = getCCRDumpFiles($ccrRootState, $ccrHomeState, 'database');
foreach my $file (@files)
{
    my $registryFile = "$ccrHomeState/temp/".$file;

    if( -f $registryFile)
    {   # database.psft file found.
        my @topLevelComponents = simpleXPathQuery($registryFile, 'components/app');
        for my $topLevelComponent (@topLevelComponents)
        {   # found a guid.
            my $guid = $$topLevelComponent{'guid'};
            my @subComponents = simpleXPathQuery($registryFile, 'components/app[@guid="'.$guid.'"]/database_info/database');
            if(defined @subComponents)
            {   # the specified configuration setting was found.
                my $keyval;
                my $valval;
                my $dbname;
		my $dbhost = "";
        
                for (my $i = 0; $i < @subComponents; $i++)
                {   # looping through all the properties of the configuration setting.
                    my $hashref = $subComponents[$i];
                    my %hash = %$hashref;
                    while ( my ($key, $value) = each %hash) {
                        $keyval = $key;
                        $valval = $value;
                        if ($keyval eq 'dbname')
                        {
                            $dbname = $valval;
                        }
						elsif ($keyval eq 'dbhostname')
						{
						  $dbhost = $valval;
						}	
                    }
                } # end for - configuration settings
				if ($dbhost eq ''){
					print  "<Target NAME=\"${dbname}_$guid\" TYPE=\"oracle_psft_database\">\n";
					print  "  <Property NAME=\"PSFTFile\" VALUE=\"$file\" />\n";
					print  "</Target>\n";
				}
				else{
					print  "<Target NAME=\"${dbname}_$guid\" TYPE=\"oracle_psft_database\" ON_HOST=\"${dbhost}\">\n";
					print  "  <Property NAME=\"OcmProxyOracleHome\" VALUE=\"NA\"/> \n";
					print  "  <Property NAME=\"PSFTFile\" VALUE=\"$file\" />\n";
					print  "</Target>\n";
			   }
			 } # end if - configuration settings found
        } # end for - domain
    }
}
