#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_repserv.pl /main/1 2011/03/20 22:22:43 rrpai Exp $
#
# oracle_repserv.pl
# 
# Copyright (c) 2010, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_repserv.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rrpai       02/23/11 - Creation
# 

use strict;
use Config;
use File::Spec;
use ias::simpleXPath;
use ias::propertiesFileParser;
use ias::asecm;

my ($emdRoot,$hostName) = @ARGV;

my @properties;
my @targetLines;
my $host;
#Get OS to check whether windows or not
my $os = $^O;
my $oracleHomeValue;
my %farms=();
my $farmName;
my $version;
my $machineName;
my $machinePort;
my $domainName;
my $flag = "false";
my $isWin = "false";
my $domainFile;
my $topologyFile;


#If OS is Windows set flag isWin to true
if(($os =~ "Win") || ($os =~ "MSWin32"))
{
    EMD_PERL_DEBUG("OS is Windows");
    $isWin = "true";
}

#The following flag is to keep track of shared Oracle Home, where oracle home is same while oracle config home is different for each instance.
my $sharedHomeFlag = "false";

#To check whether it is a shared home configuration or not (bug 9925972)
#Pick up LL_ORACLE_HOME and ORACLE_CONFIG_HOME from the environment and compare. If both are defined and not same, then it is shared home configuration
#and the flag will be set to true
my $oracleHome = $ENV{'LL_ORACLE_HOME'};
my $configHome = $ENV{'ORACLE_CONFIG_HOME'};

#If OS is Windows then convert Oracle home and config home in lower case.
#This is fix for bug 10020496
if($isWin eq "true")
{
    $oracleHome = lc($oracleHome);
    $configHome = lc($configHome);
}

if(defined $configHome && defined $oracleHome)
{
  if($oracleHome ne $configHome)
  {
    $sharedHomeFlag = "true";
  }
}


my $middlewareHome = $ENV{'BEA_HOME'};
if (!defined($middlewareHome))
{
  EMD_PERL_DEBUG("No BEA_HOME defined, aborting middleware discovery");
}
else
{
  $domainFile = File::Spec->catfile("$middlewareHome","utils","ccr","domainlocation.properties");
}

#Lookup in domainLocation file and search topology file for every domain.
if(-e $domainFile && defined($domainFile))
{
  my %domainLocations = parsePropertiesFile($domainFile);
  my @domainHomes;
  for my $domainHost (keys %domainLocations)
  {
    my $domainHost1 = lc($domainHost);
    push(@domainHomes, split(',', $domainLocations{$domainHost})) if (lc($hostName) eq $domainHost1 || lc($hostName) =~ /^$domainHost1\..+/);
  }
  for my $domainHome (@domainHomes)
  {
    $topologyFile = File::Spec->catfile("$domainHome","opmn","topology.xml");
    if(-e $topologyFile)
    {
      #Parse topology file
      parseTopologyFile($topologyFile);
    }
  }
}
elsif(defined($ENV{'ORACLE_INSTANCE'}))
{
  #else look up if ORACLE_INSTANCE is defined. In case of multiple instance homes, they will be separated by colon. Get each instance home and then parse the targets.xml for each of them.
  my $oracleInstance = $ENV{'ORACLE_INSTANCE'};
  EMD_PERL_DEBUG("oracle_repserv.pl: OracleInstance is $oracleInstance");
  my $char = ':';
  my $pos1 = 0;
     my @oracleInstances;
  my $result;
  while(($result = index($oracleInstance, $char, $pos1)) != -1)
  {
    my $len = $result - $pos1;
    my $instance = substr($oracleInstance, $pos1, $len);
    push(@oracleInstances, $instance);
    $pos1=$result + 1;
  }

  push(@oracleInstances, substr($oracleInstance, $pos1));
  my $instanceLocn;
  foreach $instanceLocn (@oracleInstances) 
  {
        #If OS is Windows then convert Instance Location in lower case.
        #This is fix for bug 10020496
        if($isWin eq "true")
        {
            $instanceLocn = lc($instanceLocn);
        }
 
    #if shared home flag is true then check if the instance home location is same as oracle config home or not. If instance location is same as config home, then go ahead with parsing targets.xml
    #if shared home flag is false then no need of checking, simply go ahead with targets.xml parsing.
    #if it is same then go ahead with parsing the targets.xml otherwise do nothing.
    if(($sharedHomeFlag eq "true" && $instanceLocn eq $configHome) || ($sharedHomeFlag eq "false"))
    {
      my $agentDir = getEmAgentDir($instanceLocn);
      my $targetsFile = File::Spec->catfile("$agentDir", "sysman","emd","targets.xml");

      if (!-e $targetsFile) 
      {
                EMD_PERL_DEBUG("oracle_repserv.pl: Can't find the file...: $targetsFile");
      }
      else
      {
        parseTargetXml($targetsFile);
        $flag = "true";
      }
    }
  }
}
else
{
  EMD_PERL_DEBUG("No Reports Server Instance found");
  exit;
}

print(@targetLines);


sub parseTopologyFile
{
  my $tpFile = $_[0];
  %farms="";
  EMD_PERL_DEBUG("Gets here: $tpFile");
  my $configTopo = ias::simpleXPath::parseFile("$tpFile");
#  get list of instances
  my @tpNodes = ias::simpleXPath::queryForNodes($configTopo, 'topology/ias-instance');
  my $tpHash = scalar(@tpNodes);
  for (my $count1=0; $count1 < $tpHash ; $count1++) 
  {
    my $instanceHost = ias::simpleXPath::getAttribute($tpNodes[$count1], "host");
    if($instanceHost eq $hostName)
    {
      my $instanceHome = ias::simpleXPath::getAttribute($tpNodes[$count1], "instance-home");
            #If OS is Windows then convert Instance Location in lower case.
            #This is fix for bug 10020496
            if($isWin eq "true")
            {
                $instanceHome = lc($instanceHome);
            }
      #if shared home flag is true then check if the instance home location is same as oracle config home or not. If instance location is same as config home, then go ahead with parsing targets.xml
      #if shared home flag is false then no need of checking, simply go ahead with targets.xml parsing.
      #if it is same then go ahead with parsing the targets.xml otherwise do nothing.
      if(($sharedHomeFlag eq "true" && $instanceHome eq $configHome) || ($sharedHomeFlag eq "false"))
      {
        my $agentDir = getEmAgentDir($instanceHome);
        my $targetFile = File::Spec->catfile("$agentDir", "sysman","emd","targets.xml");
      
        if (!-e $targetFile) 
        {
          EMD_PERL_DEBUG("oracle_repserv.pl: Can't find the file...: $targetFile");
        }
        else
        {
          parseTargetXml($targetFile);
          $flag = "true";
        }
      }
    }
  }
}

sub parseTargetXml
{
  my $fileName = $_[0];
  EMD_PERL_DEBUG("Gets here: $fileName");
  my $configFile = ias::simpleXPath::parseFile("$fileName");

  # directly querying for reports server as we have only one type
  my @nodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@TYPE="oracle_repserv"]');
  my $hashSize=scalar(@nodes);
  for (my $count = 0; $count < $hashSize; $count++) 
  {
    my $type = ias::simpleXPath::getAttribute($nodes[$count], "TYPE");
    EMD_PERL_DEBUG("Target Type: $type");

    my $property;
    #For reports server
    if($type eq "oracle_repserv")
    {
      my $targetName = ias::simpleXPath::getAttribute($nodes[$count], "NAME");
      my $displayName = ias::simpleXPath::getAttribute($nodes[$count], "DISPLAY_NAME");
      EMD_PERL_DEBUG("Target Name: $targetName");
      push(@targetLines, "<Target TYPE=\"$type\" NAME=\"$targetName\" DISPLAY_NAME=\"$displayName\" ON_HOST=\"$hostName\">\n");
      @properties = ("OracleInstance","version","OracleHome","DomainHome", "MachineName");

      #Unlike idm, querying based on NAME as we want properties for this node.
       my @propNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/Property');
      my $pHash=scalar(@propNodes);

      for(my $cnt = 0; $cnt < $pHash; $cnt++)
      {
        my $pName = ias::simpleXPath::getAttribute($propNodes[$cnt], "NAME");
        foreach $property (@properties) 
        {
          if ($pName eq $property) 
          {
            my $pValue = ias::simpleXPath::getAttribute($propNodes[$cnt], "VALUE");
            if($pName eq "version")
            {
              #if the property name is "version" then add "version_value" as well in order to introduce normalized target version for the target
              EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
              push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
              push(@targetLines, "\t<Property NAME=\"version_value\" VALUE=\"$pValue\"/>\n");
            }
            elsif($pName eq "OracleHome")
            {
              EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
              push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
              push(@targetLines, "\t<Property NAME=\"OcmProxyOracleHome\" VALUE=\"$pValue\"/>\n");
            }
            elsif($pName eq "MachineName")
            {
              EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
              push(@targetLines, "\t<Property NAME=\"adminServerHost\" VALUE=\"$pValue\"/>\n");
            }
            else
            {
              EMD_PERL_DEBUG("PNAME = $pName, PVALUE =  $pValue");
              push(@targetLines, "\t<Property NAME=\"$pName\" VALUE=\"$pValue\"/>\n");
            }
          }
        }    
      }

      # set domainTarget property. Get from "farm" AssocTarget
       my @assocNodes = ias::simpleXPath::queryForNodes($configFile, 'Targets/Target[@NAME="'.$targetName.'"]/AssocTargetInstance');
      my $aHash = scalar(@assocNodes);

      for(my $cnt = 0; $cnt < $aHash; $cnt++)
      {
        my $assocName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOCIATION_NAME");
        my $assocTargetType = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_TYPE");
        my $assocTargetName = ias::simpleXPath::getAttribute($assocNodes[$cnt], "ASSOC_TARGET_NAME");
        if($assocTargetType eq "weblogic_domain")
        {
          my $domainTargetName = $assocTargetName;
          EMD_PERL_DEBUG("ANAME = $assocName, ATT = $assocTargetType, ATN = $assocTargetName");
          push(@targetLines, "\t<Property NAME=\"domainTarget\" VALUE=\"$domainTargetName\"/>\n");
        }
        elsif($assocTargetType eq "weblogic_j2eeserver")
        {
          my $adminServerTargetName = $assocTargetName;
          EMD_PERL_DEBUG("ANAME = $assocName, ATT = $assocTargetType, ATN = $assocTargetName");
          push(@targetLines, "\t<Property NAME=\"adminServerTargetName\" VALUE=\"$adminServerTargetName\"/>\n");
        }
      }
      
      push(@targetLines,"</Target>\n");
    }
    
    #Get host name
    if($type eq "host")
    {
      $host = ias::simpleXPath::getAttribute($nodes[$count], "NAME");
      EMD_PERL_DEBUG("Host is :--$host--");
    }
  }
}

# gets emagent dir from instanceHome
sub getEmAgentDir
{
  my $instanceHome = $_[0];
  my $agentRoot = File::Spec->catfile("$instanceHome", "EMAGENT");

  opendir(DIR, $agentRoot);

  my $fileName;
  while (my $file = readdir(DIR)) 
  {
      # Use a regular expression to ignore files beginning with a period
      next if ($file =~ m/^\./);
      
      # A file test to check that it is a directory
      $fileName = File::Spec->catfile("$agentRoot", "$file");
      next unless (-d $fileName);
      # only one emagent, so quit.
      last;
  }

  closedir(DIR);
  
  return $fileName;
}