# oracle_retail_AIPOnlineApp_discover.pl
#
# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_retail_AIPOnlineApp_discover.pl - get XML stream describing Oracle Retail
#      AIP Online application targets.
#

#use strict;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $targetType = "oracle_retail_AIPOnlineApp";

#my $oraHome = $ENV{ORACLE_HOME};
my $oraHome = $ENV{LL_ORACLE_HOME};
&debug("oraHome=${oraHome}");
#die "ORACLE_HOME must be set\n" unless $oraHome;
die "LL_ORACLE_HOME must be set\n" unless $oraHome;
my $aipOnlineEEInventoryFile = "${oraHome}/retail_inventory/${targetType}.properties";
&debug("aipOnlineEEInventoryFile=${aipOnlineEEInventoryFile}");

my @targetNames = &getTargetNames($aipOnlineEEInventoryFile);
my $numTargets = $#targetNames + 1;
&debug("numTargets=${numTargets}");
foreach my $tName (@targetNames) {
    my $version = &getTargetProperty($tName, "AIP_VERSION");
    &debug("version=${version}");    
    my $installDate = &getTargetProperty($tName, "AIP_INSTALL_DATE");
    &debug("installDate=${installDate}"); 
    my $appName = &getTargetProperty($tName, "AIP_APP_NAME");
    &debug("appName=${appName}"); 
    my $appserverInstance = &getTargetProperty($tName, "AIP_MANAGEDSERVER_INSTANCE");
    &debug("appserverInstance=${appserverInstanceProfile}");    
    my $installdir = "${oraHome}";
    &debug("installdir=${installdir}");

    print "  <Target TYPE=\"${targetType}\" NAME=\"${tName}\">\n";
    print "      <Property NAME=\"VERSION\" VALUE=\"${version}\" />\n";
    print "      <Property NAME=\"INSTALL_DATE\" VALUE=\"${installDate}\" />\n";
    print "      <Property NAME=\"APP_NAME\" VALUE=\"${appName}\" />\n";
    print "      <Property NAME=\"MANAGEDSERVER_INSTANCE\" VALUE=\"${appserverInstance}\" />\n";
    print "  </Target>\n";

}

# returns an array of target names that are found based on contents of the retail inventory
# properties file for the oracle_retail_AIPOnlineApp target type
sub getTargetNames {
  my ($propFile) = @_;
  my @targetNames;
  my $line;

  # open properties file and read in all target names from property names
  # format is targettype+targetname+propertyname=value, where targetname also contains
  # '+' characters
  open PROPFILE, "<${propFile}" || die "Unable to open file ${propFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line; 

    # skip comment lines
    next if $line =~ m/^\s*#.*$/;

    # remove property name so we just have the target name
    $line =~ s/^\s*(.*)\+.*$/$1/g; 

    # trim leading whitespace
    $line =~ s/^\s+//g; 

    # trim trailing whitespace
    $line =~ s/\s+$//g; 

    if ($line) {
      push @targetNames, $line;
    }
  }
  close PROPFILE;

  # remove duplicates
  my @targetNamesNoDups = ();
  my %seen = ();
  foreach my $elem (@targetNames) {
    next if $seen{$elem}++;
    push @targetNamesNoDups, $elem;
  }

  return @targetNamesNoDups;
}

# given a target name and property, obtain the property value from the inventory file
sub getTargetProperty {
  my ($targetName, $targetProp) = @_;
  my $line;
  open PROPFILE, "<$aipOnlineEEInventoryFile" || die "Unable to open file ${aipJavaEEInventoryFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line;
    next unless $line =~ m/^${targetName}\+${targetProp}=(.*)$/;
    close PROPFILE;
    return $1;    
  }
  close PROPFILE;
  return;
}

sub debug {
    return unless $DEBUG;
    my $message = shift;
    print $message . "\n";
}

