# oracle_retail_AllocApp_discover.pl
#
# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_retail_AllocApp_discover.pl - get XML stream describing Oracle Retail
#      Allocation application targets.
#

use strict;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $targetType = "oracle_retail_AllocApp";

#my $oraHome = $ENV{ORACLE_HOME};
my $oraHome = $ENV{LL_ORACLE_HOME};
&debug("oraHome=${oraHome}");
#die "ORACLE_HOME must be set\n" unless $oraHome;
die "LL_ORACLE_HOME must be set\n" unless $oraHome;
my $allocJavaEEInventoryFile = "${oraHome}/retail_inventory/${targetType}.properties";
&debug("allocJavaEEInventoryFile=${allocJavaEEInventoryFile}");

my @targetNames = &getTargetNames($allocJavaEEInventoryFile);
my $numTargets = $#targetNames + 1;
&debug("numTargets=${numTargets}");
foreach my $tName (@targetNames) {
    my $allocOc4jInstance = &getTargetProperty($tName, "ALLOC_OC4J_INSTANCE");
    my $allocManagedServerInstance = &getTargetProperty($tName, "ALLOC_MANAGEDSERVER_INSTANCE");
    my $allocAppName = &getTargetProperty($tName, "ALLOC_APP_NAME");
    my $allocVersion = &getTargetProperty($tName, "ALLOC_VERSION");
    my $allocInstallDate = &getTargetProperty($tName, "ALLOC_INSTALL_DATE");

    print "  <Target TYPE=\"${targetType}\" NAME=\"${tName}\">\n";
    print "      <Property NAME=\"ALLOC_OC4J_INSTANCE\" VALUE=\"${allocOc4jInstance}\" />\n";
    print "      <Property NAME=\"ALLOC_MANAGEDSERVER_INSTANCE\" VALUE=\"${allocManagedServerInstance}\" />\n";
    print "      <Property NAME=\"ALLOC_APP_NAME\" VALUE=\"${allocAppName}\" />\n";
    print "      <Property NAME=\"ALLOC_VERSION\" VALUE=\"${allocVersion}\" />\n";
    print "      <Property NAME=\"ALLOC_INSTALL_DATE\" VALUE=\"${allocInstallDate}\" />\n";
    print "  </Target>\n";
}

# returns an array of target names that are found based on contents of the retail inventory
# properties file for the oracle_retail_AllocApp target type
sub getTargetNames {
  my ($propFile) = @_;
  my @targetNames;
  my $line;

  # open properties file and read in all target names from property names
  # format is targettype+targetname+propertyname=value, where targetname also contains
  # '+' characters
  open PROPFILE, "<${propFile}" || die "Unable to open file ${propFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line; 

    # skip comment lines
    next if $line =~ m/^\s*#.*$/;

    # remove property name so we just have the target name
    $line =~ s/^\s*(.*)\+.*$/$1/g; 

    # trim leading whitespace
    $line =~ s/^\s+//g; 

    # trim trailing whitespace
    $line =~ s/\s+$//g; 

    if ($line) {
      push @targetNames, $line;
    }
  }
  close PROPFILE;

  # remove duplicates
  my @targetNamesNoDups = ();
  my %seen = ();
  foreach my $elem (@targetNames) {
    next if $seen{$elem}++;
    push @targetNamesNoDups, $elem;
  }

  return @targetNamesNoDups;
}

# given a target name and property, obtain the property value from the inventory file
sub getTargetProperty {
  my ($targetName, $targetProp) = @_;
  my $line;
  open PROPFILE, "<$allocJavaEEInventoryFile" || die "Unable to open file ${allocJavaEEInventoryFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line;
    next unless $line =~ m/^${targetName}\+${targetProp}=(.*)$/;
    close PROPFILE;
    return $1;    
  }
  close PROPFILE;
  return;
}

sub debug {
    return unless $DEBUG;
    my $message = shift;
    print $message . "\n";
}

