# oracle_retail_ORWApp_discover.pl
#
# Copyright (c) 2007, 2008, Oracle. All rights reserved.  
#
#    NAME
#      oracle_retail_ORWApp_discover.pl - get XML stream describing Oracle Retail
#      Invoice Matching application targets.
#

use strict;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $targetType = "oracle_retail_ORWApp";

#my $oraHome = $ENV{ORACLE_HOME};
my $oraHome = $ENV{LL_ORACLE_HOME};
&debug("oraHome=${oraHome}");
#die "ORACLE_HOME must be set\n" unless $oraHome;
die "LL_ORACLE_HOME must be set\n" unless $oraHome;
my $orwJavaEEInventoryFile = "${oraHome}/retail_inventory/${targetType}.properties";
&debug("orwJavaEEInventoryFile=${orwJavaEEInventoryFile}");

my @targetNames = &getTargetNames($orwJavaEEInventoryFile);
my $numTargets = $#targetNames + 1;
&debug("numTargets=${numTargets}");
foreach my $tName (@targetNames) {
    my $orwOc4jInstance = &getTargetProperty($tName, "ORW_OC4J_INSTANCE");
    my $orwAppName = &getTargetProperty($tName, "ORW_APP_NAME");
    my $orwVersion = &getTargetProperty($tName, "ORW_VERSION");
    my $orwInstallDate = &getTargetProperty($tName, "ORW_INSTALL_DATE");
    my $orwBuildNumber = &getTargetProperty($tName, "ORW_BUILD_NUMBER");
    my $installdir = "${oraHome}/j2ee/${orwOc4jInstance}/applications/${orwAppName}";

    if (-d $installdir) {
    print "  <Target TYPE=\"${targetType}\" NAME=\"${tName}\">\n";
    print "      <Property NAME=\"ORW_VERSION\" VALUE=\"${orwVersion}\" />\n";
    print "      <Property NAME=\"ORW_APP_NAME\" VALUE=\"${orwAppName}\" />\n";
    print "      <Property NAME=\"ORW_INSTALL_DATE\" VALUE=\"${orwInstallDate}\" />\n";
    print "      <Property NAME=\"ORW_OC4J_INSTANCE\" VALUE=\"${orwOc4jInstance}\" />\n";
    print "      <Property NAME=\"ORW_BUILD_NUMBER\" VALUE=\"${orwBuildNumber}\" />\n";
    print "  </Target>\n";
    }
}

# returns an array of target names that are found based on contents of the retail inventory
# properties file for the oracle_retail_ORWApp target type
sub getTargetNames {
  my ($propFile) = @_;
  my @targetNames;
  my $line;

  # open properties file and read in all target names from property names
  # format is targettype+targetname+propertyname=value, where targetname also contains
  # '+' characters
  open PROPFILE, "<${propFile}" || die "Unable to open file ${propFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line; 

    # skip comment lines
    next if $line =~ m/^\s*#.*$/;

    # remove property name so we just have the target name
    $line =~ s/^\s*(.*)\+.*$/$1/g; 

    # trim leading whitespace
    $line =~ s/^\s+//g; 

    # trim trailing whitespace
    $line =~ s/\s+$//g; 

    if ($line) {
      push @targetNames, $line;
    }
  }
  close PROPFILE;

  # remove duplicates
  my @targetNamesNoDups = ();
  my %seen = ();
  foreach my $elem (@targetNames) {
    next if $seen{$elem}++;
    push @targetNamesNoDups, $elem;
  }

  return @targetNamesNoDups;
}

# given a target name and property, obtain the property value from the inventory file
sub getTargetProperty {
  my ($targetName, $targetProp) = @_;
  my $line;
  open PROPFILE, "<$orwJavaEEInventoryFile" || die "Unable to open file ${orwJavaEEInventoryFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line;
    next unless $line =~ m/^${targetName}\+${targetProp}=(.*)$/;
    close PROPFILE;
    return $1;    
  }
  close PROPFILE;
  return;
}

sub debug {
    return unless $DEBUG;
    my $message = shift;
    print $message . "\n";
}

