# oracle_retail_RA_discover.pl
#
# Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_retail_RA_discover.pl - get XML stream describing Oracle Retail
#      Merchandising System application targets.
#

use strict;
my ($emdRoot,$hostName) = @ARGV;
require "$emdRoot/sysman/admin/scripts/emd_common.pl";

my $targetType = "oracle_retail_RA";

# Use LL_ORACLE_HOME provided by OCM to locate the ORACLE_HOME path.
# If LL_ORACLE_HOME is not defined for some reason then try ORACLE_HOME
my $oraHome;
if (defined $ENV{LL_ORACLE_HOME}) {
    $oraHome = $ENV{LL_ORACLE_HOME};
} elsif (defined $ENV{ORACLE_HOME}) {
    $oraHome = $ENV{ORACLE_HOME};
} else {
    die "Could not find config root directory."
        . " Neither LL_ORACLE_HOME nor ORACLE_HOME is set.\n";
}

my $raInventoryFile = "${oraHome}/retail_inventory/${targetType}.properties";
EMD_PERL_DEBUG('raInventoryFile=' . ${raInventoryFile});

my @targetNames = &getTargetNames($raInventoryFile);
my $numTargets = $#targetNames + 1;
EMD_PERL_DEBUG('numTargets=' . ${numTargets});
foreach my $tName (@targetNames) {
    my $raVersion = &getTargetProperty($tName, "RA_VERSION");
    #my $raInstallDate = &getTargetProperty($tName, "RA_INSTALL_DATE");

    print "  <Target TYPE=\"${targetType}\" NAME=\"${tName}\">\n";
    #print "      <Property NAME=\"RA_VERSION\" VALUE=\"${raVersion}\" />\n";
    #print "      <Property NAME=\"RA_INSTALL_DATE\" VALUE=\"${raInstallDate}\" />\n";
    print "      <Property NAME=\"version_value\" VALUE=\"${raVersion}\" />\n";
    print "  </Target>\n";
}

# returns an array of target names that are found based on contents of the retail inventory
# properties file for the oracle_retail_RA target type
sub getTargetNames {
  my ($propFile) = @_;
  my @targetNames;
  my $line;

  # open properties file and read in all target names from property names
  # format is targettype+targetname+propertyname=value, where targetname also contains
  # '+' characters
  open PROPFILE, "<${propFile}" || die "Unable to open file ${propFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line; 

    # skip comment lines
    next if $line =~ m/^\s*#.*$/;

    # remove property name so we just have the target name
    $line =~ s/^\s*(.*)\+.*$/$1/g; 

    # trim leading whitespace
    $line =~ s/^\s+//g; 

    # trim trailing whitespace
    $line =~ s/\s+$//g; 

    if ($line) {
      push @targetNames, $line;
    }
  }
  close PROPFILE;

  # remove duplicates
  my @targetNamesNoDups = ();
  my %seen = ();
  foreach my $elem (@targetNames) {
    next if $seen{$elem}++;
    push @targetNamesNoDups, $elem;
  }

  return @targetNamesNoDups;
}

# given a target name and property, obtain the property value from the inventory file
sub getTargetProperty {
  my ($targetName, $targetProp) = @_;
  my $line;
  open PROPFILE, "<$raInventoryFile" || exit 1;
  while($line = <PROPFILE>) {
    chomp $line;
    next unless $line =~ m/^${targetName}\+${targetProp}=(.*)$/;
    close PROPFILE;
    return $1;    
  }
  close PROPFILE;
  return;
}
