# oracle_retail_RPMApp_discover.pl
#
# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_retail_RPMApp_discover.pl - get XML stream describing Oracle Retail
#      Price Management application targets.
#

use strict;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $targetType = "oracle_retail_RPMApp";

#my $oraHome = $ENV{ORACLE_HOME};
my $oraHome = $ENV{LL_ORACLE_HOME};
&debug("oraHome=${oraHome}");
#die "ORACLE_HOME must be set\n" unless $oraHome;
die "LL_ORACLE_HOME must be set\n" unless $oraHome;
my $rpmJavaEEInventoryFile = "${oraHome}/retail_inventory/${targetType}.properties";
&debug("rpmJavaEEInventoryFile=${rpmJavaEEInventoryFile}");

my @targetNames = &getTargetNames($rpmJavaEEInventoryFile);
my $numTargets = $#targetNames + 1;
&debug("numTargets=${numTargets}");
foreach my $tName (@targetNames) {
    my $rpmOc4jInstance = &getTargetProperty($tName, "RPM_OC4J_INSTANCE");
    my $rpmManagedServerInstance = &getTargetProperty($tName, "RPM_MANAGEDSERVER_INSTANCE");
    my $rpmAppName = &getTargetProperty($tName, "RPM_APP_NAME");
    my $rpmVersion = &getTargetProperty($tName, "RPM_VERSION");
    my $rpmInstallDate = &getTargetProperty($tName, "RPM_INSTALL_DATE");

    print "  <Target TYPE=\"${targetType}\" NAME=\"${tName}\">\n";
    print "      <Property NAME=\"RPM_OC4J_INSTANCE\" VALUE=\"${rpmOc4jInstance}\" />\n";
    print "      <Property NAME=\"RPM_MANAGEDSERVER_INSTANCE\" VALUE=\"${rpmManagedServerInstance}\" />\n";
    print "      <Property NAME=\"RPM_APP_NAME\" VALUE=\"${rpmAppName}\" />\n";
    print "      <Property NAME=\"RPM_VERSION\" VALUE=\"${rpmVersion}\" />\n";
    print "      <Property NAME=\"RPM_INSTALL_DATE\" VALUE=\"${rpmInstallDate}\" />\n";
    print "  </Target>\n";
}

# returns an array of target names that are found based on contents of the retail inventory
# properties file for the oracle_retail_RPMApp target type
sub getTargetNames {
  my ($propFile) = @_;
  my @targetNames;
  my $line;

  # open properties file and read in all target names from property names
  # format is targettype+targetname+propertyname=value, where targetname also contains
  # '+' characters
  open PROPFILE, "<${propFile}" || die "Unable to open file ${propFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line; 

    # skip comment lines
    next if $line =~ m/^\s*#.*$/;

    # remove property name so we just have the target name
    $line =~ s/^\s*(.*)\+.*$/$1/g; 

    # trim leading whitespace
    $line =~ s/^\s+//g; 

    # trim trailing whitespace
    $line =~ s/\s+$//g; 

    if ($line) {
      push @targetNames, $line;
    }
  }
  close PROPFILE;

  # remove duplicates
  my @targetNamesNoDups = ();
  my %seen = ();
  foreach my $elem (@targetNames) {
    next if $seen{$elem}++;
    push @targetNamesNoDups, $elem;
  }

  return @targetNamesNoDups;
}

# given a target name and property, obtain the property value from the inventory file
sub getTargetProperty {
  my ($targetName, $targetProp) = @_;
  my $line;
  open PROPFILE, "<$rpmJavaEEInventoryFile" || die "Unable to open file ${rpmJavaEEInventoryFile}: $!\n";
  while($line = <PROPFILE>) {
    chomp $line;
    next unless $line =~ m/^${targetName}\+${targetProp}=(.*)$/;
    close PROPFILE;
    return $1;    
  }
  close PROPFILE;
  return;
}

sub debug {
    return unless $DEBUG;
    my $message = shift;
    print $message . "\n";
}

