# oracle_retail_RpasServerApp_discover.pl
#
# Copyright (c) 2007, 2008, Oracle. All rights reserved.  
#
#    NAME
#      oracle_retail_RpasServerApp_discover.pl - get XML stream describing Oracle Retail
#      Predictive Application Server.
#

use strict;
use warnings;

use lib '../scripts';
use RpasDomainInfo;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $targetType = "oracle_retail_RpasServerApp";

if (RpasDomainInfo::setupEnvironment() eq 1)
{
   exit 0;
}

my $dir_spec = $ENV{RPAS_HOME};

opendir (RPAS_DIR,$dir_spec) or die "Cant open RPAS_HOME directory";
my $found = 0;
my $file;
while (defined($file = readdir(RPAS_DIR)) && !$found)
{
   if ($file =~ /rpaslogin/)
   {
       $found = 1;
   }
}
closedir(RPAS_DIR);

if($found > 0)
{
   print "<Target TYPE=\"${targetType}\" NAME=\"$ENV{RPAS_HOME}\"/>\n";
}
