# oracle_retail_RpasSimpleDomain_discover.pl
#
# Copyright (c) 2007, 2008, Oracle. All rights reserved.  
#
#    NAME
#      oracle_retail_RpasSimpleDomain_discover.pl - get XML stream describing Oracle Retail
#      RPAS Simple Domain.
#

use strict;
use warnings;
use POSIX;
use lib '../scripts';
use RpasDomainInfo;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $targetType = "oracle_retail_RpasSimpleDomain";


if (RpasDomainInfo::setupEnvironment() eq 1)
{
   exit 0;
}

my @domains = RpasDomainInfo::getDomains($ENV{RPAS_HOME}, 'Simple');
foreach my $domain (@domains) {
   print "<Target TYPE=\"${targetType}\" NAME=\"${domain}\" />\n";
}
