#!/usr/local/bin/perl -w
# oracle_retail_RpasSubDomain_discover.pl
#
# Copyright (c) 2007, 2008, Oracle. All rights reserved.  
#
#    NAME
#      oracle_retail_RpasSubDomain_discover.pl - get XML stream describing Oracle Retail
#      RPAS Subdomain.
#

use strict;
use warnings;
use POSIX;
use lib '../scripts';
use RpasDomainInfo;

my $TRUE = 1;
my $FALSE = 0;

my $DEBUG = $FALSE;

my $targetType = "oracle_retail_RpasSubDomain";


if (RpasDomainInfo::setupEnvironment() eq 1)
{
   exit 0;
}

# Find the Global domains.
my @globals = RpasDomainInfo::getDomains($ENV{RPAS_HOME}, 'Global');
foreach my $global (@globals) {
   # For every global domain encountered, get a list of its subdomains.   
   my @subdomains = RpasDomainInfo::getSubdomainsShell($global);
   foreach my $subdomain (@subdomains) {
      print "<Target TYPE=\"${targetType}\" NAME=\"${subdomain}\">\n";
      print "  <Property NAME=\"MASTER\" VALUE=\"${global}\" />\n";
      print "</Target>\n";
   }
}
