#!/usr/local/bin/perl
## 
## $Header: emll/sysman/admin/discover/oracle_siebelDiscovery.pl /main/8 2012/08/13 12:36:44 suhkaul Exp $
##
## oracle_siebelDiscovery.pl
## 
## Copyright (c) 2002, 2007, Oracle. All rights reserved.  
##
##    NAME
##      discovers the siebel topology
##
##    DESCRIPTION
##      <short description of component this file declares/defines>
##
##    NOTES
##      <other useful comments, qualifications, etc.>
##
##    MODIFIED   (MM/DD/YY)
##       suhkaul  06/06/12 - Making it compatible to siebel 8.2.2 (Enh req : 13545203) and changes in search server,Fixing Bug  14460217 
##       rnag     01/21/10 - changing the install dir to siebel root
##       rnag     06/04/09 - changing the siebel jar name
##       rnag     05/15/09 - entering log directory
##       rnag     04/04/09 - do not check vpd for siebel server installs
##       hgiessel 10/03/07 - pass host as ON_HOST
##       hgiessel 10/01/07 - evaluate config_home environment variable
##       hgiessel 09/23/07 - improve discovery
##       hgiessel 09/23/07 - improve discovery
##       hgiessel 09/22/07 - fix siebsrvr handling
##       vesriniv 03/22/07 - 
##    vesriniv    15-mar-2007 - Creation
## 
#
# 1. Check whether siebns.dat is located -- Gateway server is installed and ccr collector is based on siebns.dat
#    Use the java wrapper to do the discovery
# 2. Check vpd.properties for siebel server install -- Siebel server is installed and ccr collector is based on vpd.properties
# 3 

use strict;
my ($emdRoot,$hostName) = @ARGV;
require "$emdRoot/sysman/admin/scripts/semd_common.pl";

my $oraHome = $ENV{'CCR_HOME'};
my $productHome = $ENV{'LL_ORACLE_HOME'};

my $jvm_found = -1;

##
# Main -  declare variables, do some OS specific setup, and then
# try to identify a Siebel installed JVM.
##
my $osRoot;                 # OS root directory
my $classpath;
my $osType;                 # OS type
my $vpdFile;                # location of vpd.properties
my $siebnstDatFile;          # location of siebns.dat
my $siebnstDatFile32x;          # location of siebns.dat pre 10.3.3
my $targetExe;              # name of target executable to look for
my $sepchar;                # OS dependent separator character
my $javaCmd;

my $pos;
my $installdir;


$osType = get_osType();     # get the OS type

##
# compute OS root directory and assemble path to vpd.properties (if
# existing).
##
if ($osType eq "WIN")
{
    $osRoot = $ENV{'SystemRoot'};
    $sepchar='\\';
    $vpdFile = "${osRoot}/vpd.properties";
    $siebnstDatFile = "$productHome${sepchar}gtwysrvr${sepchar}admin${sepchar}siebns.dat";
    $siebnstDatFile32x = "$productHome${sepchar}admin${sepchar}siebns.dat";
    $targetExe = "java.exe";
    $classpath="$oraHome/sysman/admin/lib/emocmsiebel.jar;$oraHome/lib/log4j-core.jar";
}
else
{
    $osRoot ="/";
    $sepchar="/";
    $vpdFile = "${osRoot}/var/adm/siebel/vpd.properties";
    $targetExe = "java";
    $siebnstDatFile = "$productHome${sepchar}gtwysrvr${sepchar}sys${sepchar}siebns.dat";
    $siebnstDatFile32x = "$productHome${sepchar}sys${sepchar}siebns.dat";
    $classpath="$oraHome/sysman/admin/lib/emocmsiebel.jar:$oraHome/lib/log4j-core.jar";
}
EMD_PERL_DEBUG("siebel installation to be  at : $productHome \n");
EMD_PERL_DEBUG("siebel configuration to be read from  : $siebnstDatFile \n");
EMD_PERL_DEBUG("pre-10.3.3 configuration to be read from  : $siebnstDatFile32x \n");
EMD_PERL_DEBUG("Siebel log level : $ENV{'EMAGENT_PERL_TRACE_LEVEL'} - log location : $ENV{'EMAGENT_PERL_TRACE_DIR'}\n");

if ( ! -e $vpdFile )
{
   # vpd.properties not found - Following cases can be there  :
   #1) There are no Siebel installations on this box.
   #2) Siebel installation version is greater than 8.2.1 and has no vpd.properties ;
    EMD_PERL_DEBUG("vpd.properties not present, Following cases can be there  :\n");
    EMD_PERL_DEBUG(" 1)Siebel installation  version is greater than 8.2.1 and has no vpd.properties \n ");
    EMD_PERL_DEBUG("2)No Siebel Installation found \n");
}

if((! -e $siebnstDatFile )&& (! -e $siebnstDatFile32x) && ( ! -e $vpdFile ))
{
 EMD_PERL_DEBUG("Siebel Gateway installation not found on this host \n");
}
else
{
	if(-e $vpdFile)
	{
  	EMD_PERL_DEBUG("Siebel installation found \n");
        # try to identify JVM - if a JVM is found, that implicitly indicates
        # that a valid gateway server installation seems to exist.
        # my $javaCmd = searchJVM($vpdFile, $sepchar, $targetExe)."\n";
	
        $javaCmd = searchJVM($vpdFile, $sepchar, $targetExe);
	 EMD_PERL_DEBUG(" Found JVM executable -it's location :$javaCmd \n");
	}
	else
	{
	 EMD_PERL_DEBUG("Siebel installation  version is greater than 8.2.1 and has no vpd.properties \n");
	}

   if($jvm_found == -1)
   {
	#the java environment variable needs to be set in ccr/config/emCCREnv
       my $java_home = $ENV{'CCR_JAVA_HOME'};
	EMD_PERL_DEBUG("java home : $java_home \n");
       if ( length($java_home) == 0)
       {
	     EMD_PERL_DEBUG("java home not found :Environment variable 'CCR_JAVA_HOME' not set.\n");
             EMD_PERL_DEBUG("Set 'CCR_JAVA_HOME' env variable in file ccr/config/emCCREnv \n");
 	     EMD_PERL_DEBUG("Run emSnapshotenv from /ccr/bin.\n");
		 exit 0;
       }
       else
       {
           my $result = checkVersion();
           if($result == 1)
           {
               $javaCmd ="$java_home${sepchar}bin${sepchar}$targetExe";
           }
           else
           {
               EMD_PERL_DEBUG("valid java 1.4.2 and above not found\n");
               exit 0;
           }
       }
   }
   # find gateway server is installed or not and the file should be readable as OCM em gateway agent does its operations after parsing siebns.dat

   if((-e $siebnstDatFile )||
	(-e $siebnstDatFile32x))
   {
      if (!(( -r $siebnstDatFile )||(-r $siebnstDatFile32x)))
	{ EMD_PERL_DEBUG("Gateway server is installed but  ..  \n");
          EMD_PERL_DEBUG("Enterprise Data won't be available as :  \n");
	  EMD_PERL_DEBUG("Read Permissions not available on ".$siebnstDatFile." or  ".$siebnstDatFile32x."   \n");
	exit 0; 
	}
     
        my $ccrConfigHome = $ENV{'CCR_CONFIG_HOME'};
        my $traceDir=$ENV{'EMAGENT_PERL_TRACE_DIR'};
	my $traceLevel=$ENV{'EMAGENT_PERL_TRACE_LEVEL'};
        my $command = "";
        $command="$javaCmd -Dwindir=".$osRoot." -DLOG_HOME=".$oraHome." -cp \"".$classpath."\" oracle.sysman.siebel.management.ocmconfigcollector.discovery.OCMEMGatewayAgent /o $oraHome /l $ccrConfigHome /s $hostName /td $traceDir  /tl $traceLevel @ARGV";
               EMD_PERL_DEBUG("executing command : $command \n");
        my $result=`$command`;
        print "$result\n";
        print "\n";
   }
	else
	{
#Now we go for searching the servers anyways.
		 EMD_PERL_DEBUG("Doing collection for only Servers as no siebns.dat found on thsi host.\n");
       		my $serverfound=searchServers($productHome,$osType);
		if(length($serverfound)==0)
		{

               EMD_PERL_DEBUG("collector could not resolve siebel server \n");
		exit 0;

		}
       print "\n" ;
	}
}

##
# Search for the JVM coming with a Siebel Gateway server installation
##
sub searchJVM
{
   my ($vpd, $separator, $target) = @_;
   open(VPDFILE, $vpd);          # Open the file
   my $result = "jvm not found"; # Initialize search

   # scan through vpd.properties file
   while (my $line = <VPDFILE>)
   {
      # Sample entry from sample vpd.properties:
      # 8eb8ead246b7230736ba8a7dcf6131ea|7|5|2|0|7.5.2.0|3=Gateway\COMMON\GTWY_COMMON\admin|GTWY_COMMON\admin| | | | |/vol1/unixuser/16187/ses/gtwysrvr|0|0|1|94d40ba8b445ef608077751c305bdf17|7|5|2|0|7.5.2.0|3|0|false| |true|3|8eb8ead246b7230736ba8a7dcf6131ea|7|5|2|0|7.5.2.0|3
      # split line - get fields that matter to us
      my @fields = split('\|', $line);
      my $installversion = $fields[5];
      my $installtype    = $fields[6];
      my $installdir     = $fields[12];

      # identify installation type
      my @type = split('=', $installtype);
      $installtype = $type[1];

      # search for gateway installations - that's all we are
      # interested in.
      if ($installtype =~ /^[Gg][Aa][Tt][Ee][Ww][Aa][Yy].*/ ||
          $installtype =~ /^[Ss][Ii][Ee][Bb][Ss][Rr][Vv][Rr].*/ )
      {
         # check if jvm can be identified based on gateway server
         # installation directory.
         my $dir = "$installdir${separator}..${separator}_uninst${separator}ses${separator}_jvm";
         my $exe = "$dir${separator}bin${separator}$target";
         if ( -x "$exe" ) 
         {
            # Found JVM executable - return it's location!
            $result = $exe;
            $jvm_found = 1;
            last;
         }
      }
   }

   close(VPDFILE);                    # Close the file
   return $result;
}

##
# retrieve enterprise and server name based on service entries
# under siebel server directory.
##
sub searchServers
{
   # construct 'sys' directory under siebel server installdir
	my ($rootdir, $osType) = @_;
	my $delimroot;
   	my $serverresult = "server found"; # Initialize search

	$rootdir =~ s/\s+$//g;
	$delimroot=$rootdir;

	if($rootdir !~ /"${sepchar}"$/)
	{
	$delimroot=$rootdir."${sepchar}";
	}
	
	#If collector is installed at root dir ,then we add 'siebsrvr' node,else proceed
	if(($pos = index($delimroot, "${sepchar}siebsrvr${sepchar}")) >= 0)
	{
		$installdir=$rootdir;
		EMD_PERL_DEBUG("$installdir INSTALL DIR inside siebsrvr, no need to add siebsrvr  \n");
	}
	else
	{
		$installdir=$rootdir."${sepchar}siebsrvr";
		EMD_PERL_DEBUG("$installdir ccr install outside siebsrvr ..have to add  \n");
	}


	if(! -d $installdir)
	{
		EMD_PERL_DEBUG("$installdir not a valid server install location - siebel collector exitting \n");
		return "";

	}




	if ($osType eq "WIN")
	{
	   my $command = "";
	   $command="$javaCmd -Dwindir=".$osRoot." -cp \"".$classpath."\" oracle.sysman.siebel.management.ocmconfigcollector.discovery.OCMEMGatewayAgent @ARGV /o $installdir /i $installdir /ss yes";
	   my $result=`$command`;
	   print "$result\n";
	   print "\n";
		return $serverresult;
	}
	else
	{
	   my $sys = "${installdir}/sys";
   	   my @servers = <${sys}/svc.siebsrvr.*>;
   	   my $entry;
   	   foreach $entry (@servers)
       {
        if ( $entry =~ /.*\.bak$/ )
        {
           # ignore 'bak' entries
        }
        else
        {
         	# Note: entries to process will have the following form:
         	# <install dir>/sys/svc.siebsrvr.<enterprise>:<server>
         	# Example:
         	# /scratch/siebel/siebsrvr/sys/svc.siebsrvr.sieb:stadn47
         	# Need to extract enterprise name and server name from the above.
	
         	# retrieve service definition from file name (strip base path)
         	# (in the example above, service would be 'svc.siebsrvr.sieb:stadn4'
         	my @base = split('/', $entry);
         	my $basesize = @base;
         	my $service = $base[$basesize - 1];
	
         	# split of server name
         	@base = split(':', $service);
         	my $server = $base[1]; # server name identified at this point

         	# need to split of enterprise name from the remaining string in base[0],
         	# e.g. base[0] = 'svc.siebsrvr.sieb' in the example, with 'sieb' being
         	# the enterprise name.

 		my @entarray = split('\.', $base[0]);
                my $enterprise = $entarray[2];
                my $proxyOracleHome = 'OcmProxyOracleHome';
                my $proxyOracleHomeValue = $installdir;
                my $proxyCollection = 'ProxyCollection';
                my $proxyCollectionValue = 'No' ;
	    #proxy collection values are set in order 
	    #to know if the assoc metric and the config
	    # metric are to be collected or not             
	    #local confic property is set in order 
	    #to know if the local config
	    # metric is to be collected or not 
            #two props are set coz in some cases 
            # all the three metrics may be collected
	    #ex:wre gateway and server on same m/c
	    #so we need individual checks for both metrics

		my $isLocalConfigPresent = 'IsLocalConfigPresent';
		my $isLocalConfigPresentVal = 'Yes';
                my @hostToken  = split('\.', $hostName);
                my $host = $hostToken[0];
 
		my $oldOracleHome = 'OLD_ORACLE_HOME';
		my $oldOracleHomeVal = $rootdir;
		my $oldHost = 'OLD_HOST';
		my $oldHostVal = $hostName ;
 	    #Old oracle home and old Host properties are 
	    #added to handle creation of duplicate targets.
                EMD_PERL_DEBUG("HOST NAME  : $hostName ");
                EMD_PERL_DEBUG("HOST  : $host  ");
                #print "$enterprise, $server";
            print "<Target NAME=\"".$server."\" TYPE=\"siebel_server\" ON_HOST=\"".$host."\"\>\n";
	    #print "<Target NAME=\"".$server."\" TYPE=\"siebel_server\">\n";
            print " <Property NAME=\"" . $proxyOracleHome . "\" VALUE=\"" .$proxyOracleHomeValue. "\" />\n";
	    print " <Property NAME=\"" . $proxyCollection . "\" VALUE=\"" .$proxyCollectionValue. "\" />\n";
	    print " <Property NAME=\"" . $isLocalConfigPresent . "\" VALUE=\"" .$isLocalConfigPresentVal. "\" />\n";
	    print " <Property NAME=\"" . $oldOracleHome . "\" VALUE=\"" .$oldOracleHomeVal. "\" />\n";
	    print " <Property NAME=\"" . $oldHost . "\" VALUE=\"" .$oldHostVal. "\" />\n";
            print "</Target>\n";

         	return ($enterprise, $server);
        }
       }
		return $serverresult; 
	}
}

sub checkVersion()
{
   my $jdk=$ENV{'CCR_JAVA_HOME'};
   if ( length($jdk) == 0) {
      return 0;
   }

   # retrieve output of version command.
   # Important note: java -version prints to stderr, therefore
   # redirection is required.
   my @jversion=`$jdk/bin/java -version 2>&1`;

   # sample output like this (3 lines):
   # java version "1.6.0_01"
   # Java(TM) SE Runtime Environment (build 1.6.0_01-b06)
   # Java HotSpot(TM) Client VM (build 1.6.0_01-b06, mixed mode, sharing)

   # consider first output line only and split around quotes
   my @version = split('"', $jversion[0]);

   # $version[1] should look like this at this point:
   # 1.6.0_01
   # split at '.' to retrieve major, maint, minor version parts
   @version = split('\.', $version[1]);

   # major and minor can be retrieved right away now
   my $major=$version[0];
   my $maintenance=$version[1];
   # minor version needs another split to separate the minor
   # version from fix pack number.
   my @min = split('_', $version[2]);

   # finally, get minor version, too (if required, version
   # could be checked based on fix level, too, which is in
   # $min[1])
   my $minor = $min[0];

   # debug output
   # print "major = $major, maint = $maintenance, minor = $minor\n";

   # below the settings for the minimally required JRE
   my $minMajor = 1;
   my $minMaint = 4;
   my $minMinor = 2;

   # finally, the comparison, by major, maintenance and minor
   # version:
   if ($major > $minMajor ||
       ($major == $minMajor && $maintenance > $minMaint) ||
       ($major == $minMajor && $maintenance == $minMaint && $minor >= $minMinor)) {
       return 1;
   }
   else {
       return 0;
   }
}

