#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracle_vm_server_discover.pl /st_emll_10.3.8/1 2012/12/25 20:23:03 alokak Exp $
#
# oracle_vm_server_discover.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracle_vm_server_discover.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    alokak      12/17/12 - change property name
#    alokak      10/09/12 - Add orcl_ccr_display_name to target properties
#    chkaushi    05/31/11 - Fixing Hostname
#    chkaushi    03/25/11 - Oracle Virtual Server Discovery
#    chkaushi    03/25/11 - Creation
#

use strict;
use warnings;
use XML::Parser;
use File::Spec;

my ($emdRoot,$hostName,$crsHome) = @ARGV;

my $beaHome = $ENV{BEA_HOME};
my $ovmcfgHome = $ENV{OVM_CFG_HOME};

my %servers = ();

my $serverTag = "F";
my $serversTag = "F";

my $serverFound = 0;

my $parseFailure = 0;
my $server;

my @encTable = (
  'US-ASCII',
  'iso-8859-1',        # [west european, a.k.a. Latin1]
  'windows-1252',      # [win Latin1 (8859-1 superset)]
  'iso-8859-2',        # [east european]
  'windows-1250',      # [win Latin2 (8859-2 superset)]
  'iso-8859-3',        # [south european]
  'iso-8859-4',        # [north european]
  'iso-8859-5',        # [cyrillic]
  'iso-8859-7',        # [greek]
  'iso-8859-8',        # [hebrew]
  'iso-8859-9',        # [turkish]
  'UTF-8',
  'UTF-16',
  'big5',              # [traditional chinese]
  'euc-kr',            # [extended unix code for korean]
  'x-euc-jp-jisx0221', # [extended unix code for japanese, JIS X0221]
  'x-euc-jp-unicode',  # [extended unix code for japanese, unicode]
  'x-sjis-cp932',      # [shift-jis win codepage 932]
  'x-sjis-jdk117',     # [shift-jis JDK117]
  'x-sjis-jisx0221',   # [shift-jis JIS X0221]
  'x-sjis-unicode',    # [shift-jis unicode]
);

my $fileToParse = filetoParse();

if (!($fileToParse eq ''))
{
   if(-r  $fileToParse)
  {
    my $p = new XML::Parser(ErrorContext => 2 ) ;

    $p->setHandlers(Start => \&parseStart,
                         End => \&parseEnd  );

    $p->parsefile($fileToParse) ;
    if($@)
    {
        foreach $_ (@encTable)
        {
            %servers = () ;
	    eval '$p->parsefile($fileToParse, ProtocolEncoding => $_)' ;
	    if(!$@)
            {
                last;
            }

        }
    }
    if($@)
    {
        print "$fileToParse failed Validation\n";
        $parseFailure = 1;
    }
  }
  else
  {
    print "em_warning=$fileToParse exists but does not have read permissions \n";
    exit 0;
  }

}


if($parseFailure == 1)
{
    print STDERR "em_error=$fileToParse parse failed.\n";
    exit 0;
}

foreach $server(sort keys %servers)
{
    my $ref = $servers{$server};

    print "<Target TYPE=\"oracle_vm_server\" NAME=\"$ref->{_NAME}\""
           ." VERSION=\"1.0\" ON_HOST=\"$hostName\" UNIQUE_ID=\"$ref->{_UUID}\" >\n";
    print "  <Property NAME=\"host\" VALUE=\"" . $hostName . "\" />\n";
    print "  <Property NAME=\"OVMTargetUuid\" VALUE=\"" . $ref->{_UUID} . "\" />\n";
    print "  <Property NAME=\"OcmProxyOracleHome\" VALUE=\"N/A\" />\n";
    print "  <Property NAME='OCM_CROSS_HOST' VALUE='TRUE'/>\n";
    if (exists $ref->{_OVM_DISPLAY_NAME})
    {
        print "  <Property NAME='orcl_ccr_display_name' VALUE=\"" . $ref->{_OVM_DISPLAY_NAME} . "\" />\n";
    }
    else
    {
        print "  <Property NAME='orcl_ccr_display_name' VALUE=\"" . $ref->{_UUID} . "\" />\n";
    }
    print "  <Property NAME=\"MULTIPLEXED\" VALUE=\"TRUE\" />\n";
    print "</Target>\n";

    ##print "<Target TYPE=\"host\" NAME=\"$hostName\""
    ##       ."  ON_HOST=\"$hostName\">\n";
    ##print "    <Property NAME=\"version_value\" VALUE=\"1.0\"/>\n";
    ##print "  <Property NAME=\"OcmProxyOracleHome\" VALUE=\"N/A\" />\n";
    ##print "</Target>\n";

}
 
## File Location can be any of $BEA_HOME/state/virtualdata.xml
## or $OVM_CFG_HOME/virtualdata.xml or /tmp/virtualdata.xml
## We look for these files in this order 
## $OVM_CFG_HOME dir , then $BEA_HOME and then /tmp
## This is being done to have flexibility of file location where OVM dumps the data and OCM finds it.

sub filetoParse
{
    my $fileName = File::Spec->catfile($beaHome , "state", "virtualdata.xml");
    my $fileNameOvm = File::Spec->catfile($ovmcfgHome, "virtualdata.xml");
    my $fileNameTmp = File::Spec->catfile("" , "tmp", "virtualdata.xml");

    if(-e $fileNameOvm)
    {
        return $fileNameOvm;
    }
    elsif(-e $fileName)
    {
        return  $fileName;
    }
    elsif(-e $fileNameTmp)
    {
        return  $fileNameTmp;
    }
    return '';
}

sub parseStart
{
    my $p = shift;
    my $el = shift;

    if($el eq "servers")
    {
        $serversTag = "T";
    }
    elsif($el eq "server")
    {
        $serverTag = "T";
        if($serversTag eq "T")
        {
            my $serv = $servers{$serverFound};
            if(not defined($serv))
            {
                $servers{$serverFound} = $serv = new Server;
                $serverFound++
            }
            my($att, $val);
            while(@_)
            {
                $att = shift;
                $val = shift;
		if($att eq "uuid")
                {
                    $serv->{_UUID} = $val;
                }
                if($att eq "name")
                {
                    $serv->{_NAME} = $val;
                }
		elsif($att eq "ovm-display-name")
                {
                    $serv->{_OVM_DISPLAY_NAME} = $val;
                }
	    }
	}
    }
}



sub parseEnd
{
    my $p = shift;
    my $el = shift ;

    if($el eq "servers")
    {
        $serversTag = "F";
    }
    elsif($el eq "server")
    {
        $serverTag ="F";

    }
}



package Server;
sub new
{
    my $class = shift;
    my $self = {};
    bless $self, $class;
}

 
