#!/usr/local/bin/perl
# 
# $Header: oracle_webcache.pl 30-may-2006.12:14:10 pparida Exp $
#
# oracle_webcache.pl
# 
# Copyright (c) 2006, Oracle. All rights reserved.  
#
#    NAME
#      oracle_webcache.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pparida     05/30/06 - Fix bug 5246279: Check in the script in EMLL and make 
#                           changes 
#    djoly       07/22/05 - Cut over to use agents oracle home discovery 
#    djoly       08/18/04 - Break up cemd 
#    djoly       05/14/04 - Update core reference 
#    jsutton     01/05/04 - Fix issues found during testing 
#    jsutton     10/17/03 - jsutton_standalone_webcache_discovery 
#    jsutton     10/09/03 - Creation
# 
use strict;
use emdiscoveryhelper;

my ($emdRoot,$hostName) = @ARGV;

# OS-specific path/classpath separators
my $pathSep = "/";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $pathSep = "\\";
}

# start the output array
my @processedLines;
if (!exists $ENV{LL_ORACLE_HOME}) { push (@processedLines, "\<Targets\>\n") };

# get list of homes 
my $homes;
if (defined($ENV{LL_ORACLE_HOME})) 
{ 
  my @temp; 
  push(@temp,$ENV{LL_ORACLE_HOME}); 
  $homes = \@temp; 
} 
else 
{ 
  $homes = emdiscoveryhelper::getOracleHomes();
}

# walk the list
my $homeLine;
foreach $homeLine (@$homes)
{
  $homeLine =~ s/^\s*//;
  chomp($homeLine);

  # check if iAS install, skip if so
  if (-e $homeLine . "/config/ias.properties")
  {
    next;
  }
  # look for signs of webcache
  if (-e $homeLine . "/webcache/webcachetargets.xml")
  {
    push (@processedLines, processWebcacheXML($homeLine, $hostName, "/webcache/webcachetargets.xml"));
  }
}
close HOMES_READER;

# finish up the stream and send it out
if (!exists $ENV{LL_ORACLE_HOME}) { push (@processedLines, "\<\/Targets\>\n") };
print @processedLines;
exit 0;

sub processWebcacheXML
{
  my ($wcOracleHome, $hostName, $targetsFileName) = @_;

  my ($httpMachine, $logFileDir);

  my $needVersionProperty = 1;
  my $needOracleHome = 1;
  my $needHTTPMachine = 1;

  my (@handledLines, $targetLine);

  my $targetsFile = $wcOracleHome . $targetsFileName;
  if (-e $targetsFile)
  {
    open (TARGETS_FILE_READER, "< $targetsFile");
    while($targetLine = <TARGETS_FILE_READER>)
    {
      $targetLine =~ s/^\s*//;

      if (($targetLine eq "\<Targets\>\n") || ($targetLine eq "\<\/Targets\>\n"))
      {
        next;
      }
      if (index($targetLine, "\<Target TYPE") >= 0)
      {
        # add the current line to the output
        # The "Version" tag in webcachetargets.xml should be changed to "VERSION"
        # since the DTD for targets.xml specifies it as "VERSION".
        $targetLine =~ s/Version/VERSION/g;
        push (@handledLines, $targetLine);
        next;
      }
      # end of target; add placeholders/values for any missing pieces
      if (index($targetLine, "\<\/Target") >= 0)
      {
        if ($needVersionProperty > 0)
        {
          push (@handledLines, "<Property NAME=\"version\" VALUE=\"9.0.3.0.0\"/>\n");
        }
        if ($needOracleHome > 0)
        {
          push (@handledLines, "<Property NAME=\"OracleHome\" VALUE=\"$wcOracleHome\"/>\n");
        }
        if ($needHTTPMachine > 0)
        {
          push (@handledLines, "<Property NAME=\"HTTPMachineForAdmin\" VALUE=\"$httpMachine\"/>\n");
        }

        # always output logFileDir, logFileName
        $logFileDir = $wcOracleHome . $pathSep . "webcache" . $pathSep . "logs";
        push (@handledLines, "<Property NAME=\"logFileDir\" VALUE=\"$logFileDir\"/>\n");
        push (@handledLines, "<Property NAME=\"logFileName\" VALUE=\"access_log\"/>\n");
        # always add the assoc target host
        push (@handledLines, "<AssocTargetInstance ASSOC_TARGET=\"host\" TYPE=\"host\" NAME=\"$hostName\"/>\n");

        # add the current line to the output
        push (@handledLines, $targetLine);
        # Add a newline for formatting if necessary
        if(index($targetLine, "\n") < 0)
        {
          push(@handledLines, "\n");
        }
        next;
      }

      # check for the version property
      if ($needVersionProperty > 0)
      {
        if ((index $targetLine, "Property NAME=\"version\"") >= 0 )
        {
          $needVersionProperty = 0;
          push (@handledLines, $targetLine);
          next; # get next input line
        }
      }

      # check for the OracleHome property
      if ($needOracleHome > 0)
      {
        if ((index $targetLine, "Property NAME=\"OracleHome\"") >= 0 )
        {
          $needOracleHome = 0;
          push (@handledLines, $targetLine);
          next; # get next input line
        }
      }

      # check for the HTTPMachine[ForAdmin] property
      if ($needHTTPMachine > 0)
      {
        if ((index $targetLine, "Property NAME=\"HTTPMachineForAdmin\"") >= 0 )
        {
          $needHTTPMachine = 0;
          push (@handledLines, $targetLine);
          next; # get next input line
        }
        if ((index $targetLine, "Property NAME=\"HTTPMachine\"") >= 0 )
        {
          $httpMachine = substr $targetLine, index($targetLine, "VALUE=\"")+length("VALUE=\"");
          $httpMachine = substr ($httpMachine, 0, index($httpMachine, "\""));
          push (@handledLines, $targetLine);
          next; # get next input line
        }
      }

      # check for the logFile[Dir|Name] property, skip - we force at end of target
      if ((index $targetLine, "Property NAME=\"logFile") >= 0 )
      {
        next; # get next input line
      }
      if ((index $targetLine, "Property NAME=") >= 0 )
      {
        push (@handledLines, $targetLine);
        next; # get next input line
      }
    }
    close TARGETS_FILE_READER;
  }
  return @handledLines;
}
