#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/oracledb.pl /main/60 2012/08/27 15:05:39 jsutton Exp $
#
# oracledb.pl
# 
# Copyright (c) 2002, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oracledb.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     08/27/12 - Fix pdb output in RAC
#    jsutton     08/22/12 - Fix discovery and collection issues
#    jsutton     06/15/12 - Fix PDB discovery
#    fmorshed    04/10/12 - Call getStateDirs instead of figuring it out.  In presence
#                           of designated collector the algorithm is more complicated.
#    jsutton     03/29/12 - CDB/PDB support
#    jsutton     03/02/12 - windows discovery issue
#    imunusam    10/27/11 - add rac group discovery
#    jsutton     08/01/11 - Ignore case of host found in .ccr file
#    davili      07/05/11 - Add oracle_dbmachine
#    nmittal     06/07/11 - removing oracle_cell target discovery
#    nmittal     05/07/11 - XbranchMerge prasawas_bug-12423349 from
#                           st_emll_10.3.5
#    prasawas    05/04/11 - Bug 12423349: Adding ON_HOST target property for
#                           'oracle_cell' targettype
#    davili      04/30/11 - XbranchMerge davili_bug-11939982 from main
#    davili      04/25/11 - Add exadata releaseVersion
#    jsutton     03/29/11 - case blind compare
#    jsutton     02/25/11 - Fixes related to issue with values from
#                           getConfigProperty
#    ysun        12/03/10 - add cell version
#    aghanti     10/14/10 - Bug 9033775 - Do not discover targets from
#                           .ll*/.ccr/.emrep file if it does not have end
#                           marker
#    ckalivar    07/01/10 - Fix bug 9868596: app db version is now collected
#                           properly
#    jsutton     06/11/10 - XbranchMerge jsutton_bug-9677140 from
#                           st_emll_10.3.3
#    ckalivar    06/04/10 - ER 8239565: populate version_value property for db,
#                           rac, listener, amd osm targets
#    jsutton     05/21/10 - Pass correct param to getConfigProperty
#    jsutton     05/18/10 - 11g srvctl output changes
#    jsutton     05/04/10 - sync with original txn
#    jsutton     04/30/10 - RAC instance discovery enhancements
#    jsutton     04/12/10 - ASM discovery on DB Machines
#    aghanti     03/25/10 - Bug 9499971 - Log stderr from getRunCommandOutput()
#                           in debug mode
#    aghanti     08/26/09 - Remove references to ADE and oracle hostnames
#    jsutton     08/19/09 - downcase host name for match
#    ysun        08/07/09 - remove ip address
#    jsutton     07/24/09 - fall through if expected pieces not in header
#    ndutko      06/15/09 - Add OracleHome target instance property to RAC
#                           databases
#    jsutton     06/10/09 - Check IP address vs. current host
#    aghanti     06/05/09 - Add CCR_DB_NLS_CHARACTERSET as property in
#                           targets.xml file
#    pparida     06/01/09 - impl_multiplex_clientside: Add MULTIPLEXED property
#                           conditionally to oracle_apps_db target.
#    pparida     05/05/09 - pparida_impl_unique_id: Add UNIQUE_ID attr.
#    ysun        04/22/09 - add exadata discovery for RAC
#    ysun        03/28/09 - add exadata support
#    jsutton     04/23/08 - 
#    ndutko      12/11/07 - don't call thru to isPasswordValid - obsolete
#    jsutton     10/01/07 - Use CCR_CONFIG_HOME for LL file location
#    jsutton     06/21/07 - Add OCM_CROSS_HOST property to RAC targets
#    dkapoor     05/29/07 - don't parse sid_list in OCM
#    kgupta      12/21/06 - Fixing bug 5631862
#    cvaishna    11/01/06 - Bug Fix : 5631862
#    ndutko      07/06/06 - Add the DBNAME to the target property list 
#    jsutton     06/28/06 - Discover ASM on Windows only if db is in OCM home 
#    dkapoor     06/06/06 - XbranchMerge dkapoor_bug-5284799 from main 
#    dkapoor     05/31/06 - XbranchMerge dkapoor_. from main 
#    jsutton     05/25/06 - XbranchMerge dkapoor_bug-5206572 from main 
#    dkapoor     06/06/06 - impl windows ASM OCM discovery 
#    dkapoor     05/31/06 - don't set current for LISTENER 
#    dkapoor     05/21/06 - don't call unix commands directly on windows 
#    dkapoor     12/09/05 - use db unique name for rac db 
#    dkapoor     12/07/05 - support platform dep defa tns_admin 
#    dkapoor     12/02/05 - use ccr/ccr_common 
#    dkapoor     11/30/05 - discover rac db even if srvctl is not working 
#    dkapoor     11/27/05 - discover default listener 
#    dkapoor     11/28/05 - Derive RAC target name from .ll file 
#    dkapoor     11/14/05 - use CCR_COLLECTION_TIMESTAMP_OVERRIDE 
#    dkapoor     10/11/05 - fix rac discovery 
#    dkapoor     10/06/05 - filter apps_cm targets 
#    dkapoor     10/05/05 - set collection time of db job from the .ll file 
#    dkapoor     09/29/05 - fix bug#4641966: use default Cluster Name for 9i 
#    dkapoor     09/26/05 - fix bug#4616792 
#    ndutko      08/03/05 - ndutko_code_checkin
#    dkapoor     04/04/05 - add db_name in the instance property for livelink 
#    dkapoor     03/09/05 - impl. discovery for the passed home only 
#    xuliu       03/22/05 - check instance_number for rac 
#    jstone      03/31/05 - fixes for MAC OS X 
#    xuliu       11/10/04 - don't print rac target if not in cluster
#    dkapoor     11/11/04 - 3772840:update correct listener home 
#    xuliu       11/10/04 - OMSENV_CLUSTER_NAME
#    xuliu       10/28/04 - 10gr2 misc 
#    xuliu       10/22/04 - new rac_database metadata 
#    dkapoor     10/15/04 - fix bug 3872639 
#    dkapoor     08/12/04 - touch for 10.2SA testing 
#    dkapoor     06/16/04 - no pass for ASM 
#    xuliu       06/04/04 - fix 3667625 for rac 
#    xuliu       05/13/04 - bug 3626488 
#    xuliu       05/12/04 - bug 3468650 
#    xuliu       03/18/04 - fix 3495276 
#    mbhoopat    03/10/04 - linux port 
#    xuliu       03/01/04 - workaround 3469118 
#    xuliu       02/18/04 - fix 3450484: disable err of spfile conversion
#    dkapoor     02/17/04 - fix dynamic sid on NT
#    xuliu       02/12/04 - fix 3434862 
#    dkapoor     01/19/04 - use containsFile 
#    dkapoor     01/23/04 - don't use TNS_ADMIN env in windows 
#    xuliu       01/26/04 - fix 3383117 for NT 
#    dkapoor     12/09/03 - unset ORA_NLS vars 
#    dkapoor     12/02/03 - check for soft link tnsadmin and ohome 
#    xuliu       11/24/03 - fix 3264493 
#    dkapoor     11/15/03 - fix 10g listener 
#    xuliu       11/11/03 - fix 3178713
#    dkapoor     11/05/03 - fix 3220691 
#    dkapoor     10/31/03 - add more logging 
#    dkapoor     10/27/03 - add logging 
#    dkapoor     10/24/03 - fix bug#3202471 
#    dkapoor     10/03/03 - use db_unique_name 
#    xuliu       08/19/03 - fix 3106024 
#    xuliu       08/05/03 - fix 3079354 
#    xuliu       07/23/03 - srvctl version chg
#    xuliu       07/18/03 - use DiscoveryWarning tag
#    dkapoor     05/28/03 - use initParam subs for local listener
#    dkapoor     05/15/03 - check pmon
#    dkapoor     05/08/03 - put host for rac db
#    dkapoor     05/07/03 - use address host,filter pre 8.1 dbs
#    dkapoor     04/17/03 - move parsing code to net area
#    xuliu       03/17/03 - fix service name
#    xuliu       01/06/03 - logging for RAC
#    xshen       12/22/02 - separate osm_instance targets from db
#    xuliu       12/13/02 - rac tgt naming
#    xuliu       12/12/02 - disable cluster tgt printing & more robust host equivalence test
#    dkapoor     11/14/02 - port to NT
#    dkapoor     11/12/02 - filter out PLSEXtPROC sid
#    dkapoor     11/02/02 - add 1521 port for first OHome for Port Table
#    dkapoor     10/30/02 - fix 2649537
#    dkapoor     10/10/02 - make a union of sids found dynamically
#    xuliu       10/07/02 - comment serviceName error for non-rac case
#    xuliu       10/01/02 - redirect err to pipe in executeCommand
#    xuliu       09/25/02 - refine rac discovery logic
#    xuliu       08/30/02 - serviceName logic
#    xuliu       08/22/02 - find cluster
#    xuliu       08/20/02 - rac & service_name discovery
#    dkapoor     07/31/02 - use dbsnmp as default user
#    dkapoor     07/31/02 - remove perltrace
#    dkapoor     07/22/02 - add listener disc. and port info
#    kduvvuri    04/04/02 - remove debug statement..
#    kduvvuri    04/04/02 - consider ORATAB environment variable, if it exists..
#    kduvvuri    03/07/02 - don't process sid's that have a '*' as the value..
#    kduvvuri    02/11/02 - kduvvuri_cemd_programmatic_discovery_v2
#    kduvvuri    02/05/02 - Creation
# 
use Config;
use Cwd;
use File::Basename;
use File::Copy;
use File::Spec;
use File::stat();
use Sys::Hostname;
use Net::Domain qw(hostname hostfqdn hostdomain domainname);

my ($emdRoot,$hostName,$crsHome) = @ARGV;
$ENV{EMDROOT} = $emdRoot;

require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/scripts/db/db_common.pl";
require "$emdRoot/sysman/admin/scripts/ccr/ccr_common.pl";
require "$emdRoot/sysman/admin/scripts/db/net/listenerUtil.pl";
require "$emdRoot/sysman/admin/discover/utl/oracledbUtl.pl";
require "$emdRoot/sysman/admin/discover/utl/initParameterFileUtl.pl";
require "$emdRoot/sysman/admin/scripts/emd_common.pl";

$OSNAME = get_osType();

#Discovery LOG CATEGORY
$LOG_CATEGORY = "DB_LISTENER_DISCOVERY: ";

#VIP name of the local machine if in 10g cluster
$LOCAL_HOST_VIP_NAME = "";

#Cluster Name if it's in cluster
$CLUSTER_NAME = "";

#SCAN Name if it's 11.2 or grater cluster version
my $CLUSTER_SCAN_NAME = "";

# Constant to hold database type supported (ADMIN or POLICY) on host cluster
# in case of 11.2 or greater cluster version, it's assumed that given cluster 
# will supoort either of above database type and not both, hence constant 
# initialized based on first database type.
my $DATABASE_TYPE_11_2;

#Default Cluster Name for 9i version in case of LiveLink.
#In 9i, if cluster name is not found but a RAC collection file is present,
#set this as the default Cluster Name.
my $LL_DEFAULT_CLUSTER_NAME= 'def_ll_cluster_name';
#Variable to check if there exists a RAC livelink collection
my $LL_RAC_COLLECTION_EXISTS = 0;

my $elapsedSec = time();
EMD_PERL_INFO("$LOG_CATEGORY ***** Start of Database and Listener Discovery***");
#The Live link agent home is defined only if 
#discovery is called by the live link agent
#During this, discover only targets for this agent home
my $llOracleHome;
my %racDBConfigFiles;
#A RAC DB Name to RAC DB Target Name mapping
my %llRACDBTargetNames;
my %llRACDBInstanceTargetNames;

my %myllCELLTargetNames;
my %dbmachineNamesMap;
my $g_cellHostName;

# host name and IP address retrieved from LL file and from perl environment
my ($dbHostName,$dbSHortHostName,$dbIpAddress);
my ($perlHostName,$perlShortHostName,$perlIpAddr);

$perlHostName = lc(hostname());
($perlShortHostName) = split /\./, $perlHostName;
$perlIpAddr = join(".",unpack("C4",(gethostbyname($perlHostName))[4]));

if (defined $ENV{LL_ORACLE_HOME} && -d  $ENV{LL_ORACLE_HOME})
{
  $llOracleHome = $ENV{LL_ORACLE_HOME};
  my %allLLFiles;
  my %allCCRFiles;
  my @configDirs = getStateDirs($emdRoot,$hostName);
  foreach $configDir (@configDirs)
  {
    EMD_PERL_DEBUG("Checking $configDir for ll/ccr files");
    opendir(DIR,$configDir);
    my @files = grep {/\.ll$|\.ccr$/ }  readdir(DIR);
    foreach my $file (@files)
    {
      my $fullFilePath = File::Spec->catdir($configDir,$file);
      EMD_PERL_INFO("$LOG_CATEGORY Days past since last modification on $fullFilePath=". (-M $fullFilePath));
      if( -M $fullFilePath >= 30)
      {
        unlink($fullFilePath);
        EMD_PERL_INFO("$LOG_CATEGORY Deleted 30 day old file=$fullFilePath");
        next;
      }
      #
      # Check if the file has been completely written out (has an end marker)
      # If it is incomplete, print a warning and ignore the file
      #
      next if (llFileIsComplete($fullFilePath) ne "true");

      #
      # split into LL and CCR files; where there are competing variants use the newer one.
      #
      if ($file =~ /(.*).ll$/)
      { $allLLFiles{uc($1)} = $fullFilePath; }
      if ($file =~ /(.*).ccr$/)
      {
        my $ccrFileHost = lc(getConfigProperty($fullFilePath,"HOST_NAME"));
        my ($ccrFileShortHost) = split /\./, $ccrFileHost;
        # verify the file was generated on this host
        EMD_PERL_INFO("$LOG_CATEGORY DB HostName: $ccrFileHost, $ccrFileShortHost; Perl HostName: $perlHostName, $perlShortHostName");
        if (($perlHostName ne $ccrFileHost) && 
            ($perlShortHostName ne $ccrFileShortHost))
        {
          # skip to the next file
          EMD_PERL_INFO("$LOG_CATEGORY Skipping $file, no match across host names");
          next;
        }
        $allCCRFiles{uc($1)} = $fullFilePath;
      }
    }
    closedir (DIR);
  }
  for my $llFile (keys %allLLFiles)
  {
    if (defined $allCCRFiles{$llFile})
    {
      # get full file paths and check mod dates; newer one wins
      my $stLL  = File::stat::stat($allLLFiles{$llFile});
      my $stCCR = File::stat::stat($allCCRFiles{$llFile});
      if ($stLL->mtime >= $stCCR->mtime) 
      { delete($allCCRFiles{$llFile}); }
      else
      { delete($allLLFiles{$llFile}); }
    }
  }
  # merge the hashes into one; clean out the 'CCR files' hash
  @allLLFiles{keys %allCCRFiles} = values %allCCRFiles;
  %allCCRFiles = ();

  # Now walk the list of all config files we found.
  foreach $fullFilePath (values %allLLFiles)
  {
    EMD_PERL_INFO("$LOG_CATEGORY Handle $fullFilePath");
    my ($volume,$directories,$file) = File::Spec->splitpath($fullFilePath);
    if ( $file =~ /(.*)(\.ll$|\.ccr$)/)
    {
      my $filename = $1;
      #dbname-apps_db --> apps_db target
      #dbname-RAC-apps_db --> apps_db target assoc with a RAC db
      #dbname-RAC  --> rac_database target
      #dbname --> oracle_database target
      if( $filename =~ /(.*)-apps_db$/)
      {
        my $dbname= $1; 
        my $isRAC = 0 ;
        if ($dbname =~ /(.*)-RAC$/)
        {
          $dbname= $1; #Associated with a RAC database
          $isRAC = 1;
          $LL_RAC_COLLECTION_EXISTS = 1;
        }
        print "<Target TYPE=\"oracle_apps_db\" NAME=\"$1_apps_db\" >\n";
        print "<Property NAME=\"DBOracleHome\" VALUE=\"$llOracleHome\" />\n";
        my $timestamp = getCollectionTimestamp($fullFilePath);
        if (defined $timestamp && $timestamp ne "")
        {
          print "<Property NAME=\"CCR_COLLECTION_TIMESTAMP_OVERRIDE\" VALUE=\"$timestamp\" />\n";
        }
        if($isRAC)
        {
          print "<Property NAME=\"ISRAC\" VALUE=\"TRUE\" />\n";
          print "<Property NAME=\"OCM_CROSS_HOST\" VALUE=\"TRUE\" />\n";
          print "<Property NAME=\"MULTIPLEXED\" VALUE=\"TRUE\" />\n";
        }
        #print app db version
        my $DBVersion = getAppDBVersionFromDBll($fullFilePath);
        if (defined $DBVersion && $DBVersion ne "")
        {
          print "<Property NAME=\"version_value\" VALUE=\"$DBVersion\"/>\n";
        }

        print "<Property NAME=\"DBName\" VALUE=\"$dbname\" />\n";
        print "<Property NAME=\"ConfigFile\" VALUE=\"". $fullFilePath. "\"/> \n";      
        my $dbcharset = getConfigProperty($fullFilePath, "NLS_CHARACTERSET");
        if (defined $dbcharset && $dbcharset ne "")
        {
            print "<Property NAME=\"CCR_DB_NLS_CHARACTERSET\" VALUE=\"".$dbcharset."\"/>\n";
        }
        print "</Target>\n";
        next;
      }  
      if( $filename =~ /(.*)-RAC$/)
      {
        $LL_RAC_COLLECTION_EXISTS = 1;
        #Update RAC DB names
        $racDBConfigFiles{uc($1)} = $fullFilePath ; 
        EMD_PERL_INFO("$LOG_CATEGORY Rac db file");
      }
      if( $filename !~ /-apps_.*$/ &&
          $filename !~ /-RAC.*$/)
      {
        #File name is neither apps_db nor RAC,
        #implies its single instance database
        my $gotMatch = 0;

        # check for a match on the IP address and/or host name
        $dbHostName = lc(getConfigProperty($fullFilePath,'HOSTNAME'));
        ($dbShortHostName) = split /\./, $dbHostName;
        $dbIpAddress = getConfigProperty($fullFilePath,'IP_ADDRESS');

        EMD_PERL_INFO("$LOG_CATEGORY DB IP: $dbIpAddress; DB HostName: $dbHostName, $dbShortHostName; Perl IP: $perlIpAddr; Perl HostName: $perlHostName, $perlShortHostName");
        if (($dbHostName ne "") || ($dbIpAddress ne ""))
        {
           if (($perlHostName ne $dbHostName) && 
              ($perlShortHostName ne $dbShortHostName) &&
              ($perlIpAddr ne $dbIpAddress))
          {
            # skip to the next file
            EMD_PERL_INFO("$LOG_CATEGORY Skipping $file, no match across host/IP address");
            next;
          }
          $gotMatch = 1;
        }

        if (!$gotMatch)
        {
          # get db_dbNInstanceInfo metric, pull out host name.
          # Make a call to handleConfigMetricResult but pass in the address of
          # the local routine "getDbHostName"
          handleConfigMetricResult($fullFilePath,"db_dbNInstanceInfo",17,'',\&getDbHostName);

          # $dbHostName is filled in via the getDbHostName callback
          ($dbShortHostName) = split /\./, $dbHostName;

          EMD_PERL_INFO("$LOG_CATEGORY DB HostName: $dbHostName, $dbShortHostName; Perl HostName: $perlHostName, $perlShortHostName");
          if (($perlHostName ne $dbHostName) && 
              ($perlShortHostName ne $dbShortHostName))
          {
            # skip to the next file
            EMD_PERL_INFO("$LOG_CATEGORY Skipping $file, no match across host names");
            next;
          }
        }

        ## If we fall through to here, we found a match (host name or IP address)
        my $dbname= $1; 

        ########################### call Cell discovery #########
        my @llCellTargetNames = discoverCellTargetsFromll($dbname, $fullFilePath);
        EMD_PERL_INFO(" target name is: $llCellTargetNames");
        ########################### end Cell discovery #########

        ########################### call PDB discovery #########
        my $llPDBTargets = discoverPDBTargetsFromll($dbname, $fullFilePath);
        if (@$llPDBTargets)
        {
         foreach my $pdb (@$llPDBTargets)
         {
           printOraclePDBDatabaseEntry($filename,'oracle_database', $pdb->{NAME}, $pdb->{SERVICE}, $pdb->{CON_UID}, $pdb->{IS_ROOT}, $fullFilePath);
         }
        } 
        ########################### end PDB discovery #########

        print "<Target TYPE=\"oracle_database\" NAME=\"$filename\" >\n";
        my $timestamp = getCollectionTimestamp($fullFilePath);
        if (defined $timestamp && $timestamp ne "")
        {
          print "<Property NAME=\"CCR_COLLECTION_TIMESTAMP_OVERRIDE\" VALUE=\"$timestamp\" />\n";
        }
        #print dbversion
        my $DBVersion = getDBVersionFromDBll($fullFilePath);
        if (defined $DBVersion && $DBVersion ne "")
        {
          print "<Property NAME=\"version_value\" VALUE=\"$DBVersion\"/>\n";
        }

        print "<Property NAME=\"DBName\" VALUE=\"" . uc($filename) . "\" />\n";
        print "<Property NAME=\"OracleHome\" VALUE=\"$llOracleHome\" />\n";
        print "<Property NAME=\"ConfigFile\" VALUE=\"". $fullFilePath . "\"/> \n";      
        my $dbcharset = getConfigProperty($fullFilePath, "NLS_CHARACTERSET");
        if (defined $dbcharset && $dbcharset ne "")
        {
            print "<Property NAME=\"CCR_DB_NLS_CHARACTERSET\" VALUE=\"".$dbcharset."\"/>\n";
        }
        ########################### add cell Association #########
        foreach my $llCellTarget (@llCellTargetNames)
        {
          if ( defined $llCellTarget && trim($llCellTarget) ne "")
          {
            my $cellInd = index($llCellTarget, "|");
            if ( $cellInd > 0 )
            {
              my $cellTargetName = substr($llCellTarget, 0, $cellInd);
              my $cellId = substr( $llCellTarget, $cellInd+1);
              print("<AssocTargetInstance ASSOCIATION_NAME=\"depends_on\" ASSOC_TARGET_TYPE=\"oracle_cell\" ASSOC_TARGET_NAME=\"$cellTargetName\" ASSOC_TARGET_PROPERTY=\"$cellId\"/> \n");
            }
          }
        }
        ########################### end cell Association #########
        ########################### add oracle_dbmachine Association #########
        my $llDbMachineTargetName = discoverDbMachineTargetsFromll($g_cellHostName, $fullFilePath);
        if ( defined $llDbMachineTargetName && trim($llDbMachineTargetName) ne "")
        {
          print("<AssocTargetInstance ASSOCIATION_NAME=\"member_of\" ASSOC_TARGET_TYPE=\"oracle_dbmachine\" ASSOC_TARGET_NAME=\"$llDbMachineTargetName\" ASSOC_TARGET_PROPERTY=\"$llDbMachineTargetName\"/> \n");
        }
        ########################### end oracle_dbmachine Association #########
        print "</Target>\n";
        next;
      }
    } #end of going through .ll file
  }
}
#CRS Home if 10g cluster
$CRS_HOME = "";

# Hashtable contains lsnrctl versions 
my %lsnrctlVersions;

if (!defined $llOracleHome)
{
  print "<Targets>\n";
}

#Unset ORA_NLS variables if in the environment
if(defined $ENV{ORA_NLS})
{
  delete ($ENV{ORA_NLS});
}
if(defined $ENV{ORA_NLS32})
{
  delete ($ENV{ORA_NLS32});
}
if(defined $ENV{ORA_NLS33})
{
  delete ($ENV{ORA_NLS33});
}

#if in Windows, remove TNS_ADMIN from the environment variable
#because there is no global TNS_ADMIN in windows, we should get
# from registry for each Oracle Home, that is, use getDefaultTNSAdmin
if(($OSNAME eq 'WIN') && defined $ENV{TNS_ADMIN})
{
  delete ($ENV{TNS_ADMIN});
}

printDatabaseAndListnerTargets();
if (!defined $llOracleHome)
{
  print "</Targets>\n";
}
$elapsedSec = time() - $elapsedSec;
#print "Total sec=$elapsedSec\n";
EMD_PERL_INFO("$LOG_CATEGORY ***** END of Database and Listener Discovery: Total sec=$elapsedSec***");


##print discovered Oracle Database and Listener targets
sub printDatabaseAndListnerTargets
{
  my ($emdRoot,$hostName) = @ARGV;

  my ($ohomesRef, $sidsRef, $initDir);
  if (defined $llOracleHome)
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY Add only the liveLink agent home");
    my %sidOhomes ;
    #Only keep the liveLink agent home
    my @homes = ($llOracleHome);
    $ohomesRef = \@homes;

    if( $OSNAME eq 'WIN' ) 
    {
      #Get Oracle Homes and Sids
      my ($myOhomesRef,$mySidsRef) = getOracleHomesAndSids();
      for $sid (keys %$mySidsRef) 
      {
        my $oHome = $mySidsRef->{$sid}; 
        next if (!isSameFileSystemEntity($oHome,$llOracleHome));
        EMD_PERL_DEBUG("$LOG_CATEGORY Processing SID=$sid from Home=$oHome");
        if($sid =~ /^\+.*/)
        { 
          $sidOhomes{$sid} = $oHome;
          EMD_PERL_DEBUG("$LOG_CATEGORY Add ASM instance $1");
        }
      }
    } 
    else
    {  
      $initDir = getDefaultInitFileLocation($llOracleHome);
      opendir(DIR,$initDir);
      #Check if there is any ASM instance by looking
      #at the init file for an ASM sids, starting with (+).
      my @files = grep {/^init\+.+\.ora$/ || /^spfile\+.+\.ora$/}  readdir(DIR);
      EMD_PERL_DEBUG("$LOG_CATEGORY Check for ASM init file at $initDir");
      foreach my $file (@files)
      {
        EMD_PERL_DEBUG("$LOG_CATEGORY Processing init file $file");
        if ( $file =~ /^init(.+?)\.ora$/ || $file =~ /^spfile(.+?)\.ora$/)
        {
          if ( asmProcExists('pmon', $1) )
          {
            $sidOhomes{$1} = $llOracleHome;
            EMD_PERL_DEBUG("$LOG_CATEGORY Add ASM instance $1");
          }
        }
      }
      closedir  (DIR);
      #
      # now look for any asm_pmon processes, check /proc/$pid/environ for ORACLE_HOME 
      # matching $llOracleHome and grab the SID from asm_pmon_<SID>
      #
      my $regexp = "[a]sm_pmon_\+[^\s]*[ ]*\$";
      my $procInfo = processExists($regexp);
      if ($procInfo =~ /[^\s]+\s+([^\s]*).*\+ASM.*/)
      {
        EMD_PERL_DEBUG("asm pmon process $1 exists");
        if (open(ENVFILE, "< /proc/$1/environ"))
        {
          my ($asmHome, $asmSid);
          my (@envSettings) = <ENVFILE>;
          close(ENVFILE);
          my @envInfo;
          foreach $_ (@envSettings)
          {
            push (@envInfo, split(/\x0/));
          }
          foreach (sort @envInfo)
          {
            if ($_ =~ /^ORACLE_HOME=(.*)/)
            {
              EMD_PERL_DEBUG("ORACLE_HOME: $1 ");
              $asmHome = $1 if ($1 eq $llOracleHome);
            }
            if ($_ =~ /^ORACLE_SID=(.*)/)
            {
              EMD_PERL_DEBUG("ORACLE_SID: $1 ");
              $asmSid = $1;
            }
          }
          $sidOhomes{$asmSid} = $asmHome if (defined($asmHome) && defined($asmSid));
        }
      }
    }    
    $sidsRef = \%sidOhomes;
  }
  else
  {
    #Get Oracle Homes and Sids
    ($ohomesRef,$sidsRef) = getOracleHomesAndSids();
  }

  my @oHomesWithLsnrctl;
  my $lsnrctl;
  foreach $oracleHome (@$ohomesRef)
  {
    $lsnrctl = getListenerControl($oracleHome);
    if(-e $lsnrctl)
    {
      push(@oHomesWithLsnrctl,$oracleHome);
    }
    else
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY $lsnrctl does not exist in $oracleHome; this home is excluded from discovery");
    }
  }

  #Sort the Oracle Homes in the descending order of
  #its listener control version.
  @oHomesWithLsnrctl = sort { compareVersions(getLsnrctlVersion($b) , getLsnrctlVersion($a)) } @oHomesWithLsnrctl;
  $ohomesRef = \@oHomesWithLsnrctl;

  #filterOutBadOracleHomes($ohomesRef, $sidsRef);

  filterOutNotSupportedOracleHomes($ohomesRef, $sidsRef);

  #filter out sids from oratab without initialization or lk file on Solaris
  my $uname = '';
  unless ( $OSNAME eq 'WIN' )
  {
    chomp($uname=`/bin/uname`) || chomp($uname=`/usr/bin/uname`);
  }
  if ($uname eq "HP-UX")
  {
    $ENV{UNIX95} = "XPG4";
  }

  if(!($OSNAME eq 'WIN')) 
  {
    for $sid (keys %$sidsRef) 
    {
      my $oHome = $sidsRef->{$sid}; 
      if (isValidSid($sid, $oHome))
      {
        next;
      }
      delete $sidsRef->{$sid};
      EMD_PERL_DEBUG("$LOG_CATEGORY SID=$sid excluded from discovery as it does not have ".
                     "a running pmon process, \"$initDir/lk". uc ($sid) . " file or initialization file.");
    }
  }

  my ($clusterRef, $racInstsRefs, $errRefs); 
  ($clusterRef, $racInstsRefs, $errRefs) = discoverRacTargets($ohomesRef, $hostName);
  
  my %racDBHome;
  my %racDBPort;
  my %racDBLsnrHost;
  my %racDBSID;
  my %racDBServiceName;
  my %racDBGlbName;
  
  # delete rac database entries 
  foreach $racDB (@{$clusterRef->{RACDATABASES}})
  {
    delete $sidsRef->{$racDB};
    EMD_PERL_DEBUG("$LOG_CATEGORY deleting RAC db $racDB"); 
  }

  # $racSidDB{$racSid} is the rac database name of the $racSid 
  my %racSidDB;
  
  # add rac instance entries to the $sidRef
  foreach $goodRacDB (keys %$racInstsRefs)
  {
    if (defined $llOracleHome &&
        !(defined $racDBConfigFiles{uc ($goodRacDB)}))
    {
      next; #SKIP as NO .ll file found for this DB
    }
    my $insts = $racInstsRefs->{$goodRacDB};
    for($i=0; $i<@$insts; $i++) 
    {
      my ($node, $sid, $oHome) = @{$insts->[$i]};
      if (&equalHosts($node, $hostName))
      {
        if (defined $llOracleHome &&
            !isSameFileSystemEntity($oHome,$llOracleHome))
        {
          EMD_PERL_DEBUG("$LOG_CATEGORY the rac instance SID=$sid is excluded from discovery as ".
                         "its home=$home does not match the liveLink agent home=$llOracleHome");
          next;
        }
        if (defined $llOracleHome || isValidSid($sid, $oHome))
        {
          $sidsRef->{$sid} = $oHome;
          if (!defined $llOracleHome)
          {
            #add to homes if not live link agent discovery
            addToArrayIfNotExisting($ohomesRef, $oHome);
          }
          $racSidDB{$sid} = $goodRacDB;
        }    
        else
        {
          EMD_PERL_DEBUG("$LOG_CATEGORY SID=$sid excluded from discovery as it does not have ".
                         "a running pmon process, \"$initDir/lk". uc ($sid) . " file or initialization file.");
        }    
      }
    }
  }

  #Discover listeners information and dynamic SIDS configured with 
  #listeners
  my ($dynamicSidsRef,$listenersRef) = discoverListenersSids($ohomesRef);

# $dynamicSidsRef is of the followig form:
# (
#   orcl92 =>    
#   {
#      SERVICE_NAME => host.domain.com,
#      ORACLE_HOME => d:\oracle92\ora92,
#      PORT => 1234 (obtained from the first address description)
#    },
#   orcloid =>    
#    {
#      SERVICE_NAME => orclServiceName,
#      ORACLE_HOME => d:\oracle92\test,
#      PORT => 1234
#    },
# )
  
  if (!defined $llOracleHome) 
  {
    #Add/(update for) dynamic sid in the sid list obtained 
    #from the standard location
    foreach $dynmamicSid(keys (%$dynamicSidsRef)) 
    {
      my $href = $dynamicSidsRef->{$dynmamicSid};
      my $oHome =  $href->{ORACLE_HOME};
      if(!isSupportedHome($oHome))
      {
        #dynamic db home is pre 8i, remove it from discovered db.
        delete $sidsRef->{$dynmamicSid};
        delete $dynamicSidsRef->{$dynmamicSid};
        EMD_PERL_DEBUG("$LOG_CATEGORY deleting dynamic \"$dynmamicSid\" as its Oracle Home \"$oHome\" is not supported."); 
        next;
      }
      #if home is defined and not empty string
      #update the sids list
      if(defined $oHome && trim($oHome) ne "")
      {
        $sidsRef->{$dynmamicSid} = $oHome;
        EMD_PERL_DEBUG("$LOG_CATEGORY adding dynamic sid \"$dynmamicSid\" with Oracle Home \"$oHome\"."); 
      }
      else
      {
        #Oracle home not found for the dynamic sid, may be on Windows
        if(defined $sidsRef->{$dynmamicSid})
        {
          # sid discovered statically, update the home in the dynamic list
          $href->{ORACLE_HOME} = $sidsRef->{$dynmamicSid};
          EMD_PERL_DEBUG("$LOG_CATEGORY sid discovered statically, update the home in the dynamic list");
          EMD_PERL_DEBUG("$LOG_CATEGORY \"$dynmamicSid\" with Oracle Home \"".$href->{ORACLE_HOME}."\"."); 
        }
        else
        {
          EMD_PERL_WARN("$LOG_CATEGORY discard dynamic \"$dynmamicSid\" : cannot determine its home"); 
        }
      }
    }
  }

  my @dbTargetNames;
  ##print database targets registered dynamically with listeners
  foreach $discoveredSid (keys (%$sidsRef)) 
  { 
    EMD_PERL_INFO("$LOG_CATEGORY processing sid=\"$discoveredSid\"");
    #check if this sid id dynamically registered with any listener
    my $href = $dynamicSidsRef->{$discoveredSid};
    if(defined $href)
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY sid=\"$discoveredSid\" is found dynamically registered with a listener.");
      my $serviceName = $href->{SERVICE_NAME};  
#      my $addr = $href->{ADDRESSES};

      #$discoveredSid is dynamically registered with a listener
      #Get the Best TCP port of the listener and use it for this sid.
#      my $port = getBestTCPPort($addr)->{PORT};
      my $port = $href->{PORT};
      my $lsnrHost = $href->{HOST};
      ##print this sid target
      my ($err, $targetName);
      my $dbn = checkNAddToRac($hostName, $sidsRef->{$discoveredSid}, $discoveredSid, $racInstsRefs);
      if ($dbn ne "")
      {
        # RAC: cluster_database = true
        if ($dbn eq "_INVALID_SID_DETECTED_")
        {
          #let's skip this instance since we don't know its real sid
          #otherwise, it can produce duplicate targets
          EMD_PERL_DEBUG("$LOG_CATEGORY invalid RAC target: $discoveredSid:$sidsRef->{$discoveredSid}, SKIPPED");
          # record the error
          $errRefs->{"$discoveredSid"} = 
            "Invalid cluster database instance - couldn't find the instance_name ".
            "'$discoveredSid' in oracle home '$sidsRef->{$discoveredSid}'\n";
          delete $sidsRef->{$discoveredSid};
          next;
        }    
        $racSidDB{$discoveredSid} = $dbn;
      }
       
      if (defined $racSidDB{$discoveredSid})
      {
        ($err, $targetName) = getTargetName($sidsRef->{$discoveredSid}, $discoveredSid, 1);
        $racDBPort{$racSidDB{$discoveredSid}} = $port;
        $racDBLsnrHost{$racSidDB{$discoveredSid}} = $lsnrHost;
        $racDBSID{$racSidDB{$discoveredSid}} = $discoveredSid;
        $racDBHome{$racSidDB{$discoveredSid}} = $sidsRef->{$discoveredSid};
        $racDBGlbName{$racSidDB{$discoveredSid}} = &getRacDBGlbName($targetName, uc $racSidDB{$discoveredSid});
                       
        if($serviceName eq "")
        {
          my ($err, $serviceName) = discoveryServiceName($sidsRef->{$discoveredSid}, $discoveredSid);
          # record the error for now
          if ($err ne "")
          {
            $errRefs->{"$discoveredSid.ServiceName"} = $err;
          }
        }
        $racDBServiceName{$racSidDB{$discoveredSid}} = $serviceName;
           
        if ($CLUSTER_NAME ne "")
        {
           printRACInstanceEntry($discoveredSid,$lsnrHost,$hostName,$sidsRef->{$discoveredSid},
                                 $port, $racDBGlbName{$racSidDB{$discoveredSid}}, $serviceName);
        }
        elsif (defined($ENV{OMSENV_WARN_CLUSTER_FOUND}) && ! defined($errRefs->{"WARN_CLUSTER_FOUND"}))
        {
          $errRefs->{"WARN_CLUSTER_FOUND"} = "Unknown";
        }
      }
      else
      {
        ($err, $targetName) = getTargetName($sidsRef->{$discoveredSid}, $discoveredSid);
        if($serviceName eq "")
        {
          my ($err, $serviceName) = discoveryServiceName($sidsRef->{$discoveredSid}, $discoveredSid);
          # record the error for now
          if ($err ne "")
          {
             #$errRefs->{"$discoveredSid.ServiceName"} = $err;
          }
        }
        printOracleDatabaseEntry($targetName,$discoveredSid,$lsnrHost,$hostName,$sidsRef->{$discoveredSid},
                                 $port, $serviceName,\@dbTargetNames);
      }      
      #Delete the printed database target
      delete $sidsRef->{$discoveredSid};
    }
  }

  #Now we have non-dynamic SIDs to associate with a listener
  
  ##print Listener targets and database targets statically register with a listener
  my @listenerTargetNames;
  foreach $listener (@$listenersRef) 
  {
    EMD_PERL_INFO("$LOG_CATEGORY processing listener \"$listener->{NAME}\" from \"$listener->{FILE}\"");
    #Get the best TCP address of the listener
    my $addr = getBestTCPPort($listener->{ADDRESSES});
    if(!defined $addr)
    {
      EMD_PERL_INFO("$LOG_CATEGORY listener does not have any TCP port, don't process further.");
      next;
    }
    #get the listener target name given its name
    my $targetName = getListenerTargetName($listener->{NAME},\@listenerTargetNames);
    
    ##print the listener target
    printListenerEntry($targetName, $listener->{FILE},$listener->{NAME},
                       $addr->{HOST}, $hostName, $listener->{ORACLE_HOME},$addr->{PORT});

    #Get static SID list of the listener
    my $sidsDescs = $listener->{SID_DESC};
    if(defined $sidsDescs)
    {
      #There is a static SID register with this listener
      foreach $sidDesc (@$sidsDescs)
      {
        my $registerSID = $sidDesc->{SID_NAME};
        #check if a static SID matches any remaining discovered
        #sids, so that we can match this listener with the SID
        foreach $discoveredSid (keys (%$sidsRef)) 
        { 
          if($registerSID eq $discoveredSid)
          {
            EMD_PERL_INFO("$LOG_CATEGORY SID=$discoveredSid  is statically registered with listener ".
                          "\"$listener->{NAME}\" from \"$listener->{FILE}\"");
            if(defined $addr)
            {
              EMD_PERL_DEBUG("$LOG_CATEGORY it has some address");
              #$discoveredSid matches $registerSID, associate the 
              #the best TCP address $addr with $discoveredSid.
              ##print the $discoveredSid database target
              my ($err_t, $targetName);
              my $dbn = checkNAddToRac($hostName, $sidsRef->{$discoveredSid}, 
                                       $discoveredSid, $racInstsRefs);
              if ($dbn ne "")
              {
                # RAC: cluster_database = true
                if ($dbn eq "_INVALID_SID_DETECTED_")
                {
                  #let's skip this instance since we don't know its real sid
                  #otherwise, it can produce duplicate targets
                  EMD_PERL_DEBUG("$LOG_CATEGORY invalid RAC target: $discoveredSid:$sidsRef->{$discoveredSid}, SKIPPED");
                  # record the error
                  $errRefs->{"$discoveredSid"} =
                     "Invalid cluster database instance - couldn't find the instance_name ".
                     "'$discoveredSid' in oracle home '$sidsRef->{$discoveredSid}'\n";
                  delete $sidsRef->{$discoveredSid};
                  next;
                }    
                $racSidDB{$discoveredSid} = $dbn;
              }
              if (defined $racSidDB{$discoveredSid})
              {
                ($err_t, $targetName) = getTargetName($sidsRef->{$discoveredSid}, $discoveredSid, 1);
                $racDBPort{$racSidDB{$discoveredSid}} = $addr->{PORT};
                $racDBLsnrHost{$racSidDB{$discoveredSid}} = $addr->{HOST};
                $racDBSID{$racSidDB{$discoveredSid}} = $discoveredSid;
                $racDBHome{$racSidDB{$discoveredSid}} = $sidsRef->{$discoveredSid};
                $racDBGlbName{$racSidDB{$discoveredSid}} = &getRacDBGlbName($targetName, uc $racSidDB{$discoveredSid});
                     
                my ($err, $serviceName) = discoveryServiceName($sidsRef->{$discoveredSid}, $discoveredSid);
                # record the error for now
                if ($err ne "")
                {
                  $errRefs->{"$discoveredSid.ServiceName"} = $err;
                }
                $racDBServiceName{$racSidDB{$discoveredSid}} = $serviceName;
                if ($CLUSTER_NAME ne "")
                {
                  printRACInstanceEntry($discoveredSid,$addr->{HOST}, $hostName,$sidsRef->{$discoveredSid},
                                        $addr->{PORT}, $racDBGlbName{$racSidDB{$discoveredSid}}, $serviceName);
                }
                elsif (defined($ENV{OMSENV_WARN_CLUSTER_FOUND}) && ! defined($errRefs->{"WARN_CLUSTER_FOUND"}))
                {
                  $errRefs->{"WARN_CLUSTER_FOUND"} = "Unknown";
                }
              }
              else
              {
                ($err_t, $targetName) = getTargetName($sidsRef->{$discoveredSid}, $discoveredSid);
                my ($err, $serviceName) = discoveryServiceName($sidsRef->{$discoveredSid}, $discoveredSid, $errRefs);
                # record the error for now
                if ($err ne "")
                {
                  #$errRefs->{"$discoveredSid.ServiceName"} = $err;
                }
                printOracleDatabaseEntry($targetName,$discoveredSid,$addr->{HOST},$hostName,
                                         $sidsRef->{$discoveredSid},$addr->{PORT},$serviceName,\@dbTargetNames);
              }
              # Delete the printed database target
              delete $sidsRef->{$discoveredSid};
            }
          }
        } # End of foreach $sid (keys (%sidOhomes))
      } # End of foreach $sidDesc (@$sidsDescs)
    } # End of if(defined $sidsDescs)
  } # End of foreach $listener (@$listenersRef)

  #Now we have SIDs which are neither dynamically registered 
  #nor statically registered with a discovered listener
  
  EMD_PERL_DEBUG("$LOG_CATEGORY Now we have SIDs which are neither dynamically registered nor statically registered with a discovered listener");

  foreach $discoveredSid (keys (%$sidsRef)) 
  { 
    EMD_PERL_DEBUG("$LOG_CATEGORY get local listener for $discoveredSid");
    my $addListHref = getLocalListenerAddresses($discoveredSid,$sidsRef->{$discoveredSid});
    #$discoveredSid is dynamically registered with a listener
    #Get the Best TCP port of the listener and use it for this sid.
    if(defined $addListHref)
    {
      my $addr = getBestTCPPort($addListHref);
      if(defined $addr)
      {
        my ($err_t, $targetName);
        my $dbn = checkNAddToRac($hostName, $sidsRef->{$discoveredSid}, 
                                 $discoveredSid, $racInstsRefs);
        if ($dbn ne "")
        {
          # RAC: cluster_database = true
          if ($dbn eq "_INVALID_SID_DETECTED_")
          {
            #let's skip this instance since we don't know its real sid
            #otherwise, it can produce duplicate targets
            EMD_PERL_DEBUG("$LOG_CATEGORY invalid RAC target: $discoveredSid:$sidsRef->{$discoveredSid}, SKIPPED");
            # record the error
            $errRefs->{"$discoveredSid"} =
              "Invalid cluster database instance - couldn't find the instance_name ".
              "'$discoveredSid' in oracle home '$sidsRef->{$discoveredSid}'\n";
            delete $sidsRef->{$discoveredSid};
            next;
          }    
          $racSidDB{$discoveredSid} = $dbn;
        }
        if (defined $racSidDB{$discoveredSid})
        {
          ($err_t, $targetName) = getTargetName($sidsRef->{$discoveredSid}, $discoveredSid, 1);
          $racDBPort{$racSidDB{$discoveredSid}} = $addr->{PORT};
          $racDBLsnrHost{$racSidDB{$discoveredSid}} = $addr->{HOST};
          $racDBSID{$racSidDB{$discoveredSid}} = $discoveredSid;
          $racDBHome{$racSidDB{$discoveredSid}} = $sidsRef->{$discoveredSid};
          $racDBGlbName{$racSidDB{$discoveredSid}} = &getRacDBGlbName($targetName,uc  $racSidDB{$discoveredSid});
                 
          # use rac database name as the default service name
          my ($err, $serviceName) = discoveryServiceName($sidsRef->{$discoveredSid},$discoveredSid);
          # record the error for now
          if ($err ne "")
          {
            $errRefs->{"$discoveredSid.ServiceName"} = $err;
          }
          $racDBServiceName{$racSidDB{$discoveredSid}} = $serviceName;

          if ($CLUSTER_NAME ne "")
          {
            printRACInstanceEntry($discoveredSid,$addr->{HOST},$hostName,$sidsRef->{$discoveredSid},
                                  $addr->{PORT}, $racDBGlbName{$racSidDB{$discoveredSid}}, $serviceName);
          }
          elsif (defined($ENV{OMSENV_WARN_CLUSTER_FOUND}) && ! defined($errRefs->{"WARN_CLUSTER_FOUND"}))
          {
            $errRefs->{"WARN_CLUSTER_FOUND"} = "Unknown";
          }
        }
        else
        {
          ($err_t, $targetName) = getTargetName($sidsRef->{$discoveredSid}, $discoveredSid);
          my ($err, $serviceName) = discoveryServiceName($sidsRef->{$discoveredSid},$discoveredSid);
          # record the error for now
          if ($err ne "")
          {
            #$errRefs->{"$discoveredSid.ServiceName"} = $err;
          }
          printOracleDatabaseEntry($targetName,$discoveredSid,$addr->{HOST},$hostName,
                                   $sidsRef->{$discoveredSid},$addr->{PORT},$serviceName,\@dbTargetNames);
        }      
        #Delete the printed database target
        delete $sidsRef->{$discoveredSid};
      }
    }
  }
  #
  # print rac databases
  #
  if ($CLUSTER_NAME ne "")
  {
    if (!defined $llOracleHome )
    {
      printRACDatabaseEntries($racInstsRefs, \%racDBHome, \%racDBLsnrHost, \%racDBPort, 
                             \%racDBSID, $hostName, \%racDBServiceName, \%racDBGlbName, $clusterRef);
    }
    #Now handle remaining rac .ll files, if any 
    my $racDBName;
    for $racDBName (keys %racDBConfigFiles)
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY $racDBName is remaing");
      discoveryRACTargetsFromll($racDBName,$racDBConfigFiles{$racDBName});
    }

    #### Adding RAC group target start ####
    foreach my $dbmachineName (keys%dbmachineNamesMap) 
    {
      if (defined $dbmachineName && trim($dbmachineName) ne "")
      {
        my $racTargetType = "oracle_exadata_clustergrp";
        my $racgroupname= "Exadata DatabaseSystem " . $dbmachineName;
        my $racgroupid= "exadata_databasesystem_" . $dbmachineName;

        my $configFileName = $dbmachineNamesMap {$dbmachineName};
        my $timestamp = getCollectionTimestamp($configFileName);

        print <<__END;  
<Target TYPE="$racTargetType" NAME="$racgroupname" UNIQUE_ID="$racgroupid" >
  <AssocTargetInstance ASSOCIATION_NAME="member_of"
                       ASSOC_TARGET_TYPE="oracle_dbmachine" 
                       ASSOC_TARGET_NAME=""
                       ASSOC_TARGET_PROPERTY="$dbmachineName" />
  <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>
__END

        if (defined $timestamp && $timestamp ne "")
        {
          print <<__END;
  <Property NAME="CCR_COLLECTION_TIMESTAMP_OVERRIDE" VALUE="$timestamp"/>
__END
        }
print <<__END;
</Target>
__END
      }
    }
     #### Adding RAC group target end ####
  }

  if (!defined $llOracleHome )
  {
    # print the error during the discovery  
    printDiscoveryErrors($errRefs, $hostName);
  }
}

#Gets a unique listener target name
sub getListenerTargetName
{
  my ($lsnrName,$listenerTargetNames) = @_;
  my $counter = 0;
  my $retTargetName = $lsnrName;
  my $uniqueNotFound = 1;
  while($uniqueNotFound)
  {
    $uniqueNotFound = 0;
    if(contains($retTargetName,@$listenerTargetNames))
    {
      $retTargetName = $lsnrName . $counter;      
      $counter++;
      $uniqueNotFound = 1;
    }
  }
  push(@$listenerTargetNames,$retTargetName);
  return $retTargetName;
}

# Get the TCP address
# prefer the one with 1521 port
sub getBestTCPPort
{
  my ($addrRef) = @_;
  my $tcpAddDetailRef;
  foreach $addDetailRef (@$addrRef)
  {  
    if(uc ($addDetailRef->{PROTOCOL}) eq "TCP" )
    {
      $tcpAddDetailRef = $addDetailRef if (!defined $tcpAddDetailRef || 
                                           trim($tcpAddDetailRef->{PORT}) eq "1521" ||
                                           equalHosts($addDetailRef->{HOST}, $LOCAL_HOST_VIP_NAME));
    }
    if((defined $tcpAddDetailRef) && trim($tcpAddDetailRef->{PORT}) eq "1521")
    {  
      last;  
    }
  }
  return $tcpAddDetailRef;  
}

#Gets the listener info
#Also gets a hashtable of port,protocol,ohome, passwords to discover dynamic sids
#with port as the key
sub discoverListenersSids
{
  my ($ohomesRef) = @_;  
  my @listeners;  
  my %dynamicSids;  
  my %portTable;
  my $parseGlobalFile = 0;  
  my $oHome;
  my $tnsAdminDir;
  my $globalTnsAdminDir = "";
  my $defTnsAdminDir = "";
  my %alreadyParsed = ();

  if ( defined $ENV{TNS_ADMIN} )
  {
    $globalTnsAdminDir = trim ( $ENV{TNS_ADMIN} );
    if (! -d $globalTnsAdminDir )
    {
      $globalTnsAdminDir = "";
    } 
    if($globalTnsAdminDir ne "")
    {
      $parseGlobalFile = 1;
    }
  }
  if($globalTnsAdminDir eq "")
  {
    #if global TNS_ADMIN is not set
    #check if there exists a platform dependent default
    if($OSNAME ne 'WIN')
    {
      my $defaultTNSLoc ;
      if($OSNAME eq 'LNX')
      {
        $defaultTNSLoc = "/etc";  
      }
      else
      {
        $defaultTNSLoc = "/var/opt/oracle";  
      }
      EMD_PERL_DEBUG("$LOG_CATEGORY check if default tns file exists:$defaultTNSLoc/listener.ora");
      if ( -d "$defaultTNSLoc/listener.ora" ) 
      {
        #warning "file not be a directory";
      }
      elsif ( -e "$defaultTNSLoc/listener.ora" )
      {
        EMD_PERL_DEBUG("$LOG_CATEGORY Using default TNS admin as $defaultTNSLoc");
        $defTnsAdminDir =  $defaultTNSLoc;
      }
    }
  }
  foreach $oHome (@$ohomesRef) 
  {
    if($parseGlobalFile )
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY Parsing listeners from TNS_ADMIN=$globalTnsAdminDir");
      parseListener($ohomesRef,$globalTnsAdminDir,$oHome,\@listeners,\%portTable,\%alreadyParsed,1);
      $parseGlobalFile = 0; 
    }
    $tnsAdminDir = ($defTnsAdminDir eq "") ? getDefaultTNSAdmin($oHome) : $defTnsAdminDir;
    parseListener($ohomesRef,$tnsAdminDir,$oHome,\@listeners,\%portTable,\%alreadyParsed,($defTnsAdminDir eq "") ? 0 : 1);
  }

  if(!defined $portTable{1521} && defined $ohomesRef->[0])
  {
    #Update Port Table with default TCP port 1521 
    #and for first Oracle home
    my @pswd = ();
    my $address = { PORT=> 1521 , HOST=>$hostName, PROTOCOL=>TCP};
    my @addresses;
    push(@addresses,$address);
    updateListenerData($ohomesRef->[0],\%portTable,\@addresses,@pswd);
  }
 
  if (!defined $llOracleHome)
  {
    updateDynamicSids(\%portTable,\%dynamicSids);
  }
  return (\%dynamicSids,\@listeners);
}

sub parseListener
{
  my ($ohomesRef,$tnsAdminDir,$oHome,$listeners,$portTable,$alreadyParsed,$isGlobalTns) = @_;
  my $listenerFile = File::Spec->catfile($tnsAdminDir, "listener.ora");
  EMD_PERL_DEBUG("$LOG_CATEGORY global=[$isGlobalTns] file $listenerFile"); 
  if(-e  $listenerFile)
  {
    #if we are not in Windows, check for file stat
    #else match the file names ignore case.
    if(!($OSNAME eq 'WIN')) 
    {
      my ($dev, $ino) = stat $listenerFile;
      if(defined $alreadyParsed->{$dev,$ino})
      {
        EMD_PERL_DEBUG("$LOG_CATEGORY $listenerFile already parsed, curr oh = $oHome");
        return;
      }
      $alreadyParsed->{$dev,$ino}  = $listenerFile;
    }
    else
    {
      if(containsFile($listenerFile,keys %$alreadyParsed))
      {
        EMD_PERL_DEBUG("$LOG_CATEGORY $listenerFile already parsed, curr oh = $oHome");
        return;
      }
      $alreadyParsed->{$listenerFile} = $listenerFile;
    }
    my $listenersInfo = parseOracleConfigFile($listenerFile);
    if(!(defined $listenersInfo))
    {
      next;
    }
    EMD_PERL_DEBUG("$LOG_CATEGORY Listeners from $listenerFile for OH=$oHome");
    my @listenerNames = getListenerNames($listenersInfo);
    foreach $lsnr (@listenerNames)
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY Name $lsnr");
      my $addresses = getListenerAddresses($lsnr,$listenersInfo);
      # Xun: fix for bug 3178713
      # We'll get rid of all remote addresses (defined as the address whose 
      # host ip as returned by gethostbyname() doesn't match that of the local host
      #
      getRidOfRemoteAddresses($addresses, $hostName);
      if (0 == @$addresses)
      {
        EMD_PERL_DEBUG("$LOG_CATEGORY Skip $lsnr: it has no local address on host $hostName");
        next;
      }
      my $sids = undef;
      if (!defined $llOracleHome )
      {
        $sids = getStaticSIDs($lsnr,$listenersInfo);
      }
      my @passwords = getPasswords($lsnr,$listenersInfo);
      #Get listener home
      my $lsnrOHome = getListenerHome($ohomesRef,$lsnr,$oHome,$tnsAdminDir,@passwords);
      if (!defined $lsnrOHome)
      {
        #Oracle home not found for the listener
        if ($isGlobalTns && defined $llOracleHome )
        {
          EMD_PERL_DEBUG("$LOG_CATEGORY home not found but is using global tns [$isGlobalTns] and in llOracleHome, ".
                         "check if $listenerFile is same file system as ".
                         File::Spec->catfile($oHome,"network","admin","listener.ora"));
          if (!isSameFileSystemEntity($listenerFile,File::Spec->catfile($oHome,"network","admin","listener.ora")))
          {
            #Bug#4616792:listener.ora at default location is
            #NOT a symlink to global TNS file.
            #skip this target,as this listener does not belong to the liveLink agent home
            EMD_PERL_DEBUG("$LOG_CATEGORY skip the target as it does not belong to the liveLink agent home: ".
                           "Listener [$lsnr] Ohome=$oHome tnsadmin=$tnsAdminDir");
            next;
          }
        }
        EMD_PERL_DEBUG("$LOG_CATEGORY Use default home");
        #default it to the current oracle home
        $lsnrOHome = $oHome;
      }
      addListener($lsnr,$tnsAdminDir,$lsnrOHome,$listeners,$portTable,$addresses,$sids,@passwords);
    }
  }
  elsif (!$isGlobalTns)
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY $listenerFile NOT FOUND for an Oracle Home");
    my $lsnr = 'LISTENER';
    #Get listener home
    EMD_PERL_DEBUG("$LOG_CATEGORY Find home for default Listener ");
    my $lsnrOHome = getListenerHome($ohomesRef,$lsnr,$oHome,$tnsAdminDir);
    if (defined $lsnrOHome)
    {
      my @defaultAddresses = (
                       {
                         PROTOCOL => "TCP",  
                         HOST => $hostName,  
                         PORT => "1521",  
                       });
      my @defaultSids  = ();
      addListener($lsnr,$tnsAdminDir,$lsnrOHome,$listeners,$portTable,\@defaultAddresses,\@defaultSids); 
    }  
  }
}

# Where $addresses is an array reference and each entry is a hashtable 
# containing address parameters like PROTOCOL, HOST , PORT etc.
# For example:
# (
#   {
#      PROTOCOL => TCP,
#      HOST => myhostname
#      PORT => 1234
#    },
#   {
#      PROTOCOL => IPC,
#      KEY => EXTPROC
#    },
# )
# Where $sids is an array reference and each entry is a hashtable 
# containing sid parameters like SID_NAME, GLOBAL_DBNAME , ORACLE_HOME 
# For example:
# (
#   {
#      SID_NAME => emdw1,
#      ORACLE_HOME => home2
#    },
#   {
#      GLOBAL_DBNAME => gdbname,
#      SID_NAME => orcl
#      ORACLE_HOME => home1
#    },
# )
sub addListener
{
  my ($lsnr,$tnsAdminDir,$lsnrOHome,$listeners,$portTable,$addresses,$sids,@passwords) = @_;
  updateListenerData($lsnrOHome,$portTable,$addresses,@passwords);
  EMD_PERL_DEBUG("$LOG_CATEGORY Listener [$lsnr] Ohome=$lsnrOHome");
  my $listener = 
    {
      NAME => $lsnr,
      ADDRESSES => $addresses,
      SID_DESC => $sids,
      FILE => $tnsAdminDir,
      ORACLE_HOME => $lsnrOHome,
    };
  push (@$listeners,$listener);
}

#run lsnrctl for each port in the $portTable
#and collect sid information in the dynamic sids
sub updateDynamicSids
{
  my ($portTable,$dynamicSids) = @_;
  #First update dynamic sids for 1521 if present
  #and do the same for rest later
  updateDynamicSidsForPort($portTable,$dynamicSids,1521);
  foreach $port (keys %$portTable)
  {
    if($port eq 1521)
    {
      next;
    }
    updateDynamicSidsForPort($portTable,$dynamicSids,$port);
  }
}

sub updateDynamicSidsForPort
{
  my ($portTable,$dynamicSids,$port) = @_;
  my $address;
  my $oracleHome;
  my $executable;
  my @discoveredSids;

  my $portInfo = $portTable->{$port};
  if(!defined $portInfo)
  {
    return;
  }
  $oracleHome = $portInfo->{ORACLE_HOME};
  $address = "(ADDRESS=";
  $address .= "(PROTOCOL=".$portInfo->{PROTOCOL}.")"; 
  $address .= "(HOST=".$portInfo->{HOST}.")"; 
  $address .= "(PORT=".$port.")"; 
  $address .=")"; 
  my $passwordList = $portInfo->{PASSWORDS};
  my @commands = ();
  push(@commands,"set displaymode raw");
  push(@commands,"services $address");
  push(@commands,"exit");

  my $result = getLsnrctlOutput($oracleHome,$passwordList,@commands);
  @discoveredSids = (keys %$dynamicSids);
  my $dbDetails = getDBDetailsDiscovery($result,$port,$portInfo->{HOST},@discoveredSids);
  my $sid ;
  EMD_PERL_DEBUG("$LOG_CATEGORY dynamically discovered sids for address \"$address\"");
  foreach $sid (keys %$dbDetails)
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY dynamic sid =\"$sid\"");
    if(! defined $dynamicSids->{$sid} || equalHosts($portInfo->{HOST}, $LOCAL_HOST_VIP_NAME))
    {
      $dynamicSids->{$sid} = $dbDetails->{$sid};
    }   
  }
}

#Get lsnrctl output for a command
sub getLsnrctlOutput
{
  my ($oracleHome,$passwordList,@cmds) = @_;
  my $executable;

  $executable = getListenerControl($oracleHome);
  my $result = "";
  my $error = "";
  if(-e $executable)
  {
    my @commands ;
    my $totalPswd = @$passwordList;
    my $currPswdInex = 0;
    do
    {
      @commands = ();
      my $pswd;
      #Add password if present
      if($currPswdInex < $totalPswd)
      {
        push(@commands,"set password ".$passwordList->[$currPswdInex++]);
      }
      foreach $cmdLine (@cmds)
      {
        push(@commands,$cmdLine);
      }
      eval
      {
        ($result,$error) = getRunCommandOutput($oracleHome,$executable,@commands);
      };

      # Swallow error and log it in debug mode
      if ($error ne "")
      {
        EMD_PERL_DEBUG("$LOG_CATEGORY In getLsnrctlOutput(): $error");
      }

      #if there is a password error try the next password, if there is 
      #password error
      #TNS-01169: The listener has not recognized the password
    }while($result =~ /TNS-01169/i && $currPswdInex < $totalPswd);
  }
  return $result;
}

#Gets the Oracle Home of the listener
#from log or trace directory.
#If the listener is not running from the passed tnsAdminDir, associate the
#passed Oracle Home to the listener.
#Otherwise, return undefined home.
sub getListenerHome
{
  my ($ohomesRef,$name,$oHome,$tnsAdminDir,@passwords) = @_;

  EMD_PERL_DEBUG("$LOG_CATEGORY In getListenerHome for $name,$oHome,$tnsAdminDir"); 
  my @commands = ();
  #No need to set the current listener 
  #if the listener is the default one
  #It was giving acces violation in Windows XP in an 8.1.7 home.
  #bug#5256982.
  push(@commands,"set current_listener $name") if ($name !~ /^listener$/i);
  push(@commands,"status");
  push(@commands,"show log_directory");
  push(@commands,"show trc_directory");
  push(@commands,"exit");

  #Set the TNS_ADMIN to the passed tnsAdminDir, backup the old one
  my $oldTNS_ADMIN = $ENV{TNS_ADMIN};
  $ENV{TNS_ADMIN} = $tnsAdminDir;

  my $result = getLsnrctlOutput($oHome,\@passwords,@commands);
  #Restore the old TNS_ADMIN 
  if(defined $oldTNS_ADMIN)
  {
    $ENV{TNS_ADMIN} = $oldTNS_ADMIN;
  }
  else
  {
    delete ($ENV{TNS_ADMIN});
  }
 
  my $lsnrHome ;
  #If there are no TNS errors and listener is running
  #using the passed tnsAdminDir, check the log and trace directory for OH
  if ($result !~ /^*TNS-[0-9]*/i && isThisListenerRunning($result,$tnsAdminDir,$name))
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY $name is running from $tnsAdminDir"); 
    my @resultArray = split /\n/, $result;

    foreach $ln (@resultArray)
    {
      if ( $ln !~ /log_directory/i && $ln !~ /trc_directory/i)
      {
        next;
      }
      if($ln =~ /^(.*)\"log_directory\"\s+\w+\s+\w+\s+(.*)/i)
      {
        return $lsnrHome if (defined ($lsnrHome= getHomeFromDir($ohomesRef,"log",$2,$oHome)));
      }
      if($ln =~ /^(.*)\"trc_directory\"\s+\w+\s+\w+\s+(.*)/i)
      {
        return $lsnrHome if (defined ($lsnrHome= getHomeFromDir($ohomesRef,"trace",$2,$oHome)));
      }
    }
  }
  else
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY $name is NOT running from $tnsAdminDir"); 
  }
  return $lsnrHome;
}

#Checks the log/trace directory for Oracle Home of the listener
#If the log directory matches OH/network/log for any valid OH, then that's
#the Oracle Home of the listener.
#If the trace directory matches OH/network/trace for any valid OH, then that's
#the Oracle Home of the listener.
#Otherwise, return undefined home.
sub getHomeFromDir
{
  my ($ohomesRef,$dirName,$dir,$oHome) = @_; 
  my $foundHome;
  my $endingSlash = "/" if ($dir =~ /\/$/ || $dir =~ /\\$/);
  EMD_PERL_DEBUG("$dirName directory = [$dir] compare against [$oHome/network/$dirName$endingSlash]");
  #Sometimes there is an ending slash in the directory
  #need to add that to the comparing directory.
  #Otherwise, comparison fails on Windows
  #  OK to use '/' because the check replaces file path separators internally
  if(isSameFileSystemEntity($dir,"$oHome/network/$dirName$endingSlash"))
  {
    $foundHome = $oHome;
    EMD_PERL_DEBUG("$LOG_CATEGORY Passed home is the home"); 
  }
  else
  {
    foreach $home (@$ohomesRef) 
    {
      if($home ne $oHome &&
         isSameFileSystemEntity($dir,"$home/network/$dirName$endingSlash"))
      {
        $foundHome = $home;
        EMD_PERL_DEBUG("$LOG_CATEGORY Non-Passed home is the home"); 
        last;
      }
    }
  }
  return $foundHome;
}

#Update $portTable with port, protocol,ohome, passwords to discover dynamic sids
#with port as the key
sub updateListenerData
{
  my ($oracleHome,$portTable,$addresses,@passwords) = @_;
  my ($port, $protocol, $host);
  foreach $addr (@$addresses)
  {
    $port = $addr->{PORT} if defined($addr->{PORT});          
    $protocol = $addr->{PROTOCOL} if defined($addr->{PROTOCOL});          
    $host = $addr->{HOST} if defined($addr->{HOST});
    # portTable hash uses listener port as key, which will not work as expected
    # where scan lister as well as local lister running on same port(11.2) (overrriding existing value)  
    # thus skipping scan listener entry in port table used to listener database assoc. 
    # Ideally port table should use combination of port and listerner insterface as key.  
    if (&equalHosts($host, $CLUSTER_SCAN_NAME))
    {
      next;
    }
    EMD_PERL_DEBUG("$LOG_CATEGORY Address = $host, $port, $protocol");

    if(defined $port && $port ne "" &&
       defined $protocol && $protocol ne "")
    {
      my $portInfo = $portTable->{$port};
      if (defined $portInfo)
      {
        #info already present, need to update info
        #password only
              
        #update passwords
        my $passwordList = $portInfo->{PASSWORDS};
        my $pswd;
        foreach $pswd (@passwords)
        {
           push(@$passwordList,$pswd);
        }
      }
      else
      {
        $portInfo->{ORACLE_HOME} = $oracleHome;
        $portInfo->{PROTOCOL} = $protocol;
        $portInfo->{HOST} = $host;
        my @passwordList = ();  
        foreach $pswd (@passwords)
        {
          push(@passwordList,$pswd);
        }
        $portInfo->{PASSWORDS} = \@passwordList;
        $portTable->{$port} = $portInfo;
      }
    }
  }
}

##print listener target entry
sub printListenerEntry
{
  my ($targetName,$oraDir,$name,$lsnrHost,$hostName,$oHome,$port) = @_;
  $lsnrHost = resolveLsnrHostName($lsnrHost,$hostName);
  my $lsnrVersion = getLsnrctlVersion($oHome);

  print "<Target TYPE=\"oracle_listener\" NAME=\"${targetName}_$hostName\" >\n";
  print "<Property NAME=\"ListenerOraDir\" VALUE=\"$oraDir\" />\n";
  print "<Property NAME=\"LsnrName\" VALUE=\"$name\" />\n";
  print "<Property NAME=\"Machine\" VALUE=\"$lsnrHost\" />\n";
  print "<Property NAME=\"OracleHome\" VALUE=\"$oHome\" />\n";
  print "<Property NAME=\"Port\" VALUE=\"$port\" />\n";
  if (defined $lsnrVersion && $lsnrVersion ne "")
  {
    print "<Property NAME=\"version_value\" VALUE=\"$lsnrVersion\"/>\n";
  }

  print "</Target>\n";

  EMD_PERL_INFO("$LOG_CATEGORY listener target \"${targetName}_$hostName\" discovered. ".
                "Details: [$oraDir,$name,$lsnrHost,$hostName,$oHome,$port]");
}

#Gets a unique Database target name
sub getDatabaseTargetName
{
  my ($targetName,$sid,$hostName,$dbTargetNames) = @_;
  my $useSidHostName = 0;
  if(trim($targetName) eq "")
  {
    $targetName = "${sid}_$hostName";
    $useSidHostName = 1;
  }
  my $counter = 0;
  my $retTargetName = $targetName;
  my $uniqueNotFound = 1;
  my $dbTargetName;
  while($uniqueNotFound)
  {
    $uniqueNotFound = 0;
    if(contains($retTargetName,@$dbTargetNames))
    {
      if($useSidHostName)
      {
        $retTargetName = $sid."_".$counter."_".$hostName;      
      }
      else
      {
        $retTargetName = $targetName . $counter;      
      }
      $counter++;
      $uniqueNotFound = 1;
    }
  }
  push(@$dbTargetNames,$retTargetName);
  return $retTargetName;
}

##print Oracle Database target entry
# if encounters '+' in SID, print to osm targets instead
sub printOracleDatabaseEntry
{
  my ($targetName,$sid,$lsnrHost,$hostName,$oHome,$port,$servName,$dbTargetNames) = @_;
  $lsnrHost = resolveLsnrHostName($lsnrHost,$hostName);
  $targetName = getDatabaseTargetName($targetName,$sid,$hostName,$dbTargetNames);
 
  # if discovered SID is preceded with '+', it belongs to osm target list
  if ( $discoveredSid =~ /^\+/ )
  {
    printOracleStorageManagerEntry($targetName,$sid,$hostName,$oHome,$port,$servName );
    return;
  }
 
  print "<Target TYPE=\"oracle_database\" NAME=\"$targetName\" >\n";
  print "<Property NAME=\"OracleHome\" VALUE=\"$oHome\" />\n";
  print "<Property NAME=\"UserName\" VALUE=\"dbsnmp\" ENCRYPTED=\"FALSE\"/>\n";
  #
  # The following code is commented out in the OCM code path. Passwords are
  # not required for configuration collections for OCM.
  #
  # if(isPasswordValid("dbsnmp",DUMMY_PASSWORD,$oHome, $sid))
  # {
  #  print "<Property NAME=\"password\" VALUE=\"". DUMMY_PASSWORD . "\" ENCRYPTED=\"FALSE\"/>\n";
  # }
  print "<Property NAME=\"MachineName\" VALUE=\"$lsnrHost\" />\n";
  print "<Property NAME=\"Port\" VALUE=\"$port\" />\n";
  print "<Property NAME=\"SID\" VALUE=\"$sid\"/> \n";
  print "<Property NAME=\"ServiceName\" VALUE=\"$servName\"/> \n";      
  # print "<Property NAME=\"emdPerlTraceLevel\" VALUE=\"\"/> \n";
  print "</Target>\n";
  EMD_PERL_INFO("$LOG_CATEGORY database target \"$targetName\" discovered. ".
                "Details: [$targetName,$sid,$lsnrHost,$hostName,$oHome,$port,$servName]");
}

# print Oracle Storage Manager target entries
# service name and emd perl trace currently not in use
sub printOracleStorageManagerEntry
{
  my ($targetName,$sid,$hostName,$oHome,$port,$servName) = @_;
  my $asmVersion = getASMVersion($oHome,$sid); 
  # target name already processed
  print "<Target TYPE=\"osm_instance\" NAME=\"$targetName\" >\n",
        "<Property NAME=\"OracleHome\" VALUE=\"$oHome\" />\n",
        "<Property NAME=\"UserName\" VALUE=\"sys\" ENCRYPTED=\"FALSE\"/>\n",
        "<Property NAME=\"Role\" VALUE=\"sysdba\" ENCRYPTED=\"FALSE\"/>\n",
        "<Property NAME=\"MachineName\" VALUE=\"$hostName\" />\n",
        "<Property NAME=\"Port\" VALUE=\"$port\" />\n",
        "<Property NAME=\"SID\" VALUE=\"$sid\"/> \n";
#       "<Property NAME=\"ServiceName\" VALUE=\"$servName\"/> \n",      
#       "<Property NAME=\"emdPerlTraceLevel\" VALUE=\"\"/> \n",
  if (defined $asmVersion && $asmVersion ne "")
  {
    print "<Property NAME=\"version_value\" VALUE=\"$asmVersion\"/>\n";
  }
  print    "</Target>\n";
  EMD_PERL_INFO("$LOG_CATEGORY osm_instance target \"$targetName\" discovered. ".
                "Details: [$targetName,$sid,$hostName,$oHome,$port,$servName]");
}

#Get the initialization file for the sid given SID and Ohome
sub getInitFile
{
  my ($SID,$OracleHome) = @_;

  my $initDir = getDefaultInitFileLocation($OracleHome);
  my $retInitFile;
  if (-e (File::Spec->catfile($initDir, "spfile$SID.ora")))
  {
    $retInitFile = File::Spec->catfile($initDir, "spfile$SID.ora");
  }
  elsif (-e (File::Spec->catfile($initDir, "spfile.ora")))
  {
    $retInitFile = File::Spec->catfile($initDir, "spfile.ora");
  }
  elsif (-e (File::Spec->catfile($initDir, "init$SID.ora")))
  {
    $retInitFile = File::Spec->catfile($initDir, "init$SID.ora");
  }
  return $retInitFile;
}

#Get the local listener address for the sid given SID and Ohome
#Return a reference for an array of addresses
# (
#    {
#         PROTOCOL = "TCP",  
#         HOST = "machine",  
#         PORT = "1234",  
#     },
#    {
#         PROTOCOL = "TCP",  
#         HOST = "machine",  
#         PORT = "1222",  
#     }
# )
#
sub getLocalListenerAddresses
{
  my ($SID,$OracleHome) = @_;

  my $initFile = getInitFile($SID,$OracleHome);

  #The default listener
  my @defaultAddresses = ( 
     {
       PROTOCOL => "TCP",  
       HOST => $hostName,  
       PORT => "1521",  
     } );

  my $retAddresses = \@defaultAddresses;
  
  if( defined $llOracleHome)
  {
    #In LiveLink, don't read the init file
    return  $retAddresses;
  }
  my @addresses;
  if (defined $initFile && (-e $initFile))
  {
    my ($localListenerValue ) = discoverParameterValue($OracleHome,$SID,LOCAL_LISTENER,$SID);
    if(defined $localListenerValue)
    {
      my $addresses = getAddresses($localListenerValue);
      if(@$addresses == 0)
      {
        my @namedAddresses = getCharsSeparatedWords($localListenerValue,",");
        #resolve named address to an address or address list from the 
        #tnsnames.ora
        my $addresses = getAddressesFromNames($OracleHome,@namedAddresses,);
        if(defined $addresses && @$addresses != 0)
        {
          $retAddresses = $addresses;
        }
      }
      else
      {
        $retAddresses = $addresses;
      }
    }
  }
  return $retAddresses;    
}

sub getAddressesFromNames
{
  my ($OracleHome,@namedAddresses) = @_;
  # Check if ORATAB env is specified
  my $tnsnamesFile ;
  my $addresses;
  if ( defined $ENV{TNS_ADMIN} )
  {
    my $tnsAdminDir = trim ( $ENV{TNS_ADMIN} );
    if (! -d $tnsAdminDir )
    {
      $tnsAdminDir = "";
    } 
    if($tnsAdminDir ne "")
    {
      $addresses = resolveAddressesFromNames($tnsAdminDir,\@namedAddresses)   
    }
  }
  if(! (defined $addresses))
  {
    $addresses = resolveAddressesFromNames(getDefaultTNSAdmin($OracleHome),\@namedAddresses) ;
  }
  return $addresses;
}

sub resolveAddressesFromNames
{
  my ($tnsAdminDir,$namedAddresses) = @_;
  my $addresses;
  my $tnsnamesFile;
  my $tnsnamesInfoRef ;

  my $sqlnetFile ;
  my $sqlnetInfoRef ;
  my $addrValue;
  my $defaultDomain = "";
    
  #print "TNSADMIN = [$tnsAdminDir]\n";
  if ( -d $tnsAdminDir )
  {
    $tnsnamesFile = File::Spec->catfile($tnsAdminDir,"tnsnames.ora");
    #print "tnsnames.ora file = [$tnsnamesFile]\n";
    if(-e $tnsnamesFile )
    {
      $sqlnetFile = File::Spec->catfile($tnsAdminDir,"sqlnet.ora");
      $sqlnetInfo = parseOracleConfigFile($sqlnetFile);
      if(defined $sqlnetInfo)
      {
        $defaultDomain = trim($sqlnetInfo->{"NAMES.DEFAULT_DOMAIN"});
        #print "setting default domain = [$defaultDomain]\n";
      }
    }
          
    $tnsnamesInfoRef = parseOracleConfigFile($tnsnamesFile);
    if(defined $tnsnamesInfoRef)
    {
      foreach $namedAddr (@$namedAddresses)
      {
        if($namedAddr !~ /\./)
        { 
          #Does not contain domain, add domain 
          if($defaultDomain ne "")
          {
            $namedAddr .=".".$defaultDomain;
            #print "Domain added [$defaultDomain]\n";
          }
        }
        #print "Check named address [$namedAddr]\n";
        $addrValue = $tnsnamesInfoRef->{uc ($namedAddr)};
#       #print "Value = [$addrValue]\n";
        if(defined $addrValue)
        {
          $addresses = getAddresses($addrValue);
        } # End of if(defined $addrValue)
      } # End of foreach $namedAddr (@$namedAddresses)
    } # End of if(defined $tnsnamesInfo)
  } # End of if ( -d $tnsAdminDir )
  return $addresses;
}

# Return: an array of words separated by zero or more given chars
sub getCharsSeparatedWords
{
  my ($paramValue,$charList) = @_;
  my $wd;
  my @words;
  #print "paramValue =[$paramValue],  charList =[$charList] \n";
  while ($paramValue =~ /(\s*\w+\s*)[$charList]*/g) 
  {
    $wd = $1;
    #print "wd =[$wd]\n";
    $wd =~ s/^\s*|\s*$//;
    push @words, $wd if ($wd ne "");
  }
  return @words;
}      

#strips leading and trailing spaces and returns the string
sub trim 
{
  my $origStr = $_[0];
  #Strip trailing and leading
  $origStr =~ s/^\s*|\s*$//g;
  return $origStr;
}

##############################################################################
# discover the PDBs from a config file
##############################################################################
sub discoverPDBTargetsFromll
{  
  my ($dbName,$configFile) = @_;
  EMD_PERL_DEBUG("PDB target from LL file, dbName is $dbName, configFile is $configFile");
  #may have multiple PDBs in one db
  my @pdbTargets = getPDBTargetsInfoFromDBll($configFile); 
  EMD_PERL_DEBUG("PDB target from LL file, printing oracle_pdb target");

  my @pdbTargetArray = ();
  foreach $pdbTarget (@pdbTargets)
  {
      $pdbTarget = trim($pdbTarget);
      EMD_PERL_DEBUG("PDB target info: ".$pdbTarget); 
      if ($pdbTarget =~ /^([^\|]+)\|([^\|]+)\|([^\|]+)\|([^\|]+)$/)
      {
        push @pdbTargetArray, { NAME=>$1, CON_UID=>$2, SERVICE=>$3, IS_ROOT=>$4 };
      	EMD_PERL_INFO("$LOG_CATEGORY discoverPDBTargetsFromll PDB info NAME=$1, CON_UID=$2, SERVICE=$3, IS_ROOT=$4");
      }
  }
  return \@pdbTargetArray;
}

##############################################################################
# print a pdb target block
##############################################################################
sub printOraclePDBDatabaseEntry
{
  my ($cdb_name, $cdb_type, $pdbName, $pdbServiceName, $pdbConUid, $is_root, $fullFilePath) = @_;
  my $tgt_suffix = $pdbName; 
  $tgt_suffix =~ s/\$//g;
  my $pdbTargetName = $cdb_name."_".$tgt_suffix;

  # ?? <Target TYPE="oracle_pdb" NAME="$pdbTargetName" UNIQUE_ID="$pdbGUID">
  print <<__END;
  <Target TYPE="oracle_pdb" NAME="$pdbTargetName">
    <Property NAME="PdbName" VALUE="$pdbName"/>
    <Property NAME="OracleHome" VALUE="$llOracleHome"/>
    <Property NAME="CON_UID" VALUE="$pdbConUid"/>
    <Property NAME="ServiceName" VALUE="$pdbServiceName"/>
    <Property NAME="IS_ROOT" VALUE="$is_root"/>
    <Property NAME="PLUGGED_IN" VALUE="YES"/>
    <Property NAME="ConfigFile" VALUE="$fullFilePath"/>
    <AssocTargetInstance ASSOCIATION_NAME="member_of" ASSOC_TARGET_TYPE="$cdb_type" ASSOC_TARGET_NAME="$cdb_name"/>
  </Target>
__END

  EMD_PERL_INFO("$LOG_CATEGORY pdb target \"$pdbTargetName\" discovered. Details: [$pdbTargetName,$pdbName,$pdbServiceName,$pdbConUid,$is_root]");
}

##############################################################################
##                 Start of Exadata Discovery Functions                      #
##############################################################################

#discover the cells from a config file
sub discoverCellTargetsFromll
{  
  my ($dbName,$configFile) = @_;
  EMD_PERL_DEBUG("CELL Exadata target from LL file, dbName is $dbName, configFile is $configFile");
  #may have multiple cells used by one db
  my @cellTargets = getCellTargetsInfoFromDBll($configFile); 
  EMD_PERL_DEBUG("CELL Exadata target from LL file, printing exadata target");

  my %llCellTargetNames;
  foreach $cellTarget (@cellTargets)
  {
      my $pos=0;
      my $cellIp = '';
      my $cellName = '';
      my $cellId = '';
      my $cellVersion = '';
      my $releaseVersion = '';
      my @tokens=split(/\|/, $cellTarget);
      foreach $token (@tokens)
      {
          if ($pos == 0)
          {
              $cellIp = $token;
          }
          if ($pos == 1 )
          {
              $cellName = $token;
          }
          if ($pos == 2)
          {
              $cellId = $token;
          }
          if ($pos == 3)
          {
              $cellVersion = $token;
          }
          if ($pos == 4)
          {
              $releaseVersion = $token;
          }
          $pos =$pos+1 ;
      }
      $releaseVersion = getReleaseVersion($cellVersion, $releaseVersion);
      my $myTargetName = $cellName.'|'.$cellId;
      $g_cellHostName = $cellName.".".hostdomain();
      $llCellTargetNames{$cellId} = $myTargetName;
      #check if the id existing
      if (!exists $myllCELLTargetNames{$cellId})
      {
          $myllCELLTargetNames{$cellId} = $myTargetName;
      }
  }
  return (values %llCellTargetNames);
}

## Discover the dbmachine
sub discoverDbMachineTargetsFromll
{
    my ($cellHostName,$configFile) = @_;
    my $cellHostName = lc($cellHostName);
    my ($shortCellHostName) = split /\./, $cellHostName;

    my $commonPrefix = &findCommonPrefix($shortCellHostName, $perlShortHostName);
    if(defined $commonPrefix && $commonPrefix ne "")
    {
      # return dbMachineName
      return $commonPrefix.".".hostdomain();
    }
    return "";
}

sub getReleaseVersion()
{
  my ($cellVersion, $releaseVersion) = @_;
  EMD_PERL_DEBUG("++Original release version is $releaseVersion");

####
#  Need to put the conversion logic here
####

  if (!defined $releaseVersion || $releaseVersion eq '')
  {
    if ($cellVersion =~ m/11.2.1.2.1/)
    { # ex. OSS_11.2.1.2.1_LINUX.X64_100131 -->  11.2.1.2.1 
      $releaseVersion = "11.2.1.2.1";
    }
    elsif ($cellVersion =~ m/11.2.1.2.4/)
    { 
      $releaseVersion = "11.2.1.2.4";
    }
    elsif ($cellVersion =~ m/11.2.1.2.6/)
    {
      $releaseVersion = "11.2.1.2.6";
    }
    elsif ($cellVersion =~ m/11.2.0.1.0/)
    { # exception case to regular matching rule
      $releaseVersion = "11.2.1.3.1";
    }
    elsif ($cellVersion =~ m/11.2.2.1.1/)
    {
      $releaseVersion = "11.2.2.1.1";
    }
    elsif ($cellVersion =~ m/11.2.0.3.0/)
    { # exception case to regular matching rule
      $releaseVersion = "11.2.2.2.0";
    }
    elsif ($cellVersion =~ m/11.2.2.2.2/)
    {
      $releaseVersion = "11.2.2.2.2";
    }
  }

  EMD_PERL_DEBUG("++Converted release version is $releaseVersion");

  $releaseVersion;
}

##############################################################################
##                 End of Exadata Discovery Functions                        #
##############################################################################


##############################################################################
##                 Start of RAC Discovery Functions                          #
##############################################################################

# Usage: printRACDatabaseEntries($racInstsRefs, \%racDBHome, \%racDBLsnrHost, \%racDBPort,\%racDBSID,
#                                $hostName, \%racDBServiceName, \%racDBGlbName, $clusterRef);
# $racInstsRefs is the one returned by discoverRacTargets()
# $hostName is the second command line argument    
# %racDBHome, %racDBPort, %racDBSID, %racDBServiceName, %cluster are as defined 
# in printDatabaseAndListnerTargets
sub printRACDatabaseEntries
{
  my ($racInstsRefs, $racDBHome, $racDBLsnrHost, $racDBPort, $racDBSID, $hostName, $servName, $racDBGlbName, $cluster) = @_;
  my $assocTargetName;   
  # good rac databases
  foreach $racDB (keys %$racInstsRefs)
  {
    if (defined $racDBSID->{$racDB})
    {
      EMD_PERL_DEBUG("LL_ORACLE_HOME NOT defined, printing RAC DB target");
      $assocTargetName = &getInstName($racDBGlbName->{$racDB}, $racDBSID->{$racDB});
print <<__END;
<Target TYPE="rac_database" NAME="$racDBGlbName->{$racDB}">
  <Property NAME="ServiceName" VALUE="$servName->{$racDB}"/>
  <Property NAME="ClusterName" VALUE="$cluster->{NAME}"/>
  <AssocTargetInstance ASSOCIATION_NAME="rac_instance" ASSOC_TARGET_TYPE="oracle_database" ASSOC_TARGET_NAME="$assocTargetName"/>
</Target>
__END
      EMD_PERL_INFO("$LOG_CATEGORY rac_database target \"$racDBGlbName->{$racDB}\" discovered. ".
                    "Details: [$racDBGlbName->{$racDB},$assocTargetName ( $racDBSID->{$racDB} ),$servName->{$racDB},$cluster->{NAME}]");
    } 
    else
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY SKIPPED Rac database '$racDB': no valid sid found on the host");
    }        
  }
}

#discover the RAC dbs from a config file
sub discoveryRACTargetsFromll
{
  my ($dbName,$configFile) = @_;
  ########################### call Cell discovery #########
  my @llCellTargetNames = discoverCellTargetsFromll($dbName, $configFile);
  EMD_PERL_INFO(" target name is: $llCellTargetNames");
  ########################### end Cell discovery #########

  ########################### call PDB discovery #########
  my $llPDBTargets = discoverPDBTargetsFromll($dbName, $configFile);
  if (@$llPDBTargets)
  {
    my $targetName = getLLRACTargetName($dbName);
    foreach my $pdb (@$llPDBTargets)
    {
      printOraclePDBDatabaseEntry($targetName,'rac_database', $pdb->{NAME}, $pdb->{SERVICE}, $pdb->{CON_UID}, $pdb->{IS_ROOT}, $configFile);
    }
  } 
  ########################### end PDB discovery #########

  my %sidTable = getSidsFromDBll($configFile);
  my $DBVersion = getDBVersionFromDBll($configFile);
  my $sid;
  for $sid (keys %sidTable)
  {
    # bug 13008805 - get host from hash first
    my $sidHost = $sidTable{$sid};
    # BUG 9950746: duplicate RAC instance targets on Windows
    $sid = convertSIDForOS($sid);
    EMD_PERL_DEBUG ("Discover sid=$sid host=$sidHost");
    printRACInstanceEntry ($sid, $hostName, $sidHost, $llOracleHome, "1521", ${dbName}, "");
  }
  my $targetName = getLLRACTargetName($dbName);
  EMD_PERL_DEBUG("RAC target from LL file, printing RAC DB target");

  #### Adding dbsys group target start ####
  if(scalar( @llCellTargetNames) > 0 ) 
  {
    my $dbsysTargetType = "oracle_exadata_dbsys";
    my $dbsysTargetName = $targetName ."_grid";
    my $dbsysTargetId = $targetName ."_grid";

    my $timestamp = getCollectionTimestamp($configFile);

  print <<__END;  
<Target TYPE="$dbsysTargetType" NAME="$dbsysTargetName" UNIQUE_ID="$dbsysTargetId" >
  <Property NAME="DB_NAME" VALUE="$dbName" />
  <Property NAME="OCM_CROSS_HOST" VALUE="TRUE"/>
__END

  ########################### add cell Association #########
  foreach my $llCellTarget (@llCellTargetNames)
  {
    if ( defined $llCellTarget && trim($llCellTarget) ne "")
    {
      my $cellInd = index($llCellTarget, "|");
      if ( $cellInd > 0 )
      {
        my $cellTargetName = substr($llCellTarget, 0, $cellInd);
        my $cellId = substr( $llCellTarget, $cellInd+1);
         print("<Member type=\"oracle_cell\" name=\"$cellTargetName\" id=\"$cellId\" parentTargetName=\"$dbsysTargetName\" />\n");
      }   
    }
  }
  ########################### end cell Association #########
  
  if (defined $timestamp && $timestamp ne "")
  {
print <<__END;
  <Property NAME="CCR_COLLECTION_TIMESTAMP_OVERRIDE" VALUE="$timestamp"/>
__END
  }
print <<__END;
</Target>
__END
}
#### Adding dbsys group target end ####

print <<__END;
<Target TYPE="rac_database" NAME="$targetName">
  <Property NAME="ClusterName" VALUE="${CLUSTER_NAME}"/>
  <Property NAME="ConfigFile" VALUE="$configFile"/>
__END
 
  if (defined $DBVersion && $DBVersion ne "")
  {
    print "<Property NAME=\"version_value\" VALUE=\"$DBVersion\"/>\n";
  }

  if (defined $llOracleHome)
  {
    print "<Property NAME=\"OracleHome\" VALUE=\"$llOracleHome\"/>\n";
  }
  my $timestamp = getCollectionTimestamp($configFile);
  if (defined $timestamp && $timestamp ne "")
  {
print <<__END;
  <Property NAME="CCR_COLLECTION_TIMESTAMP_OVERRIDE" VALUE="$timestamp"/>
__END
  }
  my $dbcharset = getConfigProperty($configFile, "NLS_CHARACTERSET");
  if (defined $dbcharset && $dbcharset ne "") {
      print <<__END;
   <Property NAME="CCR_DB_NLS_CHARACTERSET" VALUE="$dbcharset"/>
__END
  }
  for $sid (keys %sidTable)
  {
    my $node = $sidTable{$sid};
    my $assocTargetName = getLLRACDBInstanceTargetName($dbName, $sid);
    EMD_PERL_DEBUG("$LOG_CATEGORY the rac instance from ll SID=$sid node=$node home=$llOracleHome");
print <<__END;
  <AssocTargetInstance ASSOCIATION_NAME="rac_instance" ASSOC_TARGET_TYPE="oracle_database" ASSOC_TARGET_NAME="$assocTargetName"/>
__END
  }

  if(scalar( @llCellTargetNames) > 0 )
  {
    my $dbsysTargetType = "oracle_exadata_dbsys";
    my $dbsysTargetName =  $targetName . "_grid";
    my $dbsysTargetId =  $targetName . "_grid";

    print("<AssocTargetInstance ASSOCIATION_NAME=\"depends_on\" ASSOC_TARGET_TYPE=\"oracle_exadata_dbsys\" ASSOC_TARGET_NAME=\"$dbsysTargetName\" ASSOC_TARGET_PROPERTY=\"$dbsysTargetId\"/> \n");
  }

  ########################### add oracle_dbmachine Association #########
  my $llDbMachineTargetName = discoverDbMachineTargetsFromll($g_cellHostName, $configFile);
  if ( defined $llDbMachineTargetName && trim($llDbMachineTargetName) ne "")
  {
    if (not exists $dbmachineNamesMap {$llDbMachineTargetName}) 
    {
       $dbmachineNamesMap {$llDbMachineTargetName} = $configFile;
    }
    
    my $racTargetType = "oracle_exadata_clustergrp";
    my $racGroupName=  "Exadata DatabaseSystem " . $llDbMachineTargetName;
    my $racGroupId=  "exadata_databasesystem_" . $llDbMachineTargetName;
    print("<AssocTargetInstance ASSOCIATION_NAME=\"member_of\" ASSOC_TARGET_TYPE=\"$racTargetType\" ASSOC_TARGET_NAME=\"$racGroupName\" ASSOC_TARGET_PROPERTY=\"$racGroupId\"/>\n");
  }
  ########################### end oracle_dbmachine Association #########
  print <<__END;
</Target>
__END
}

# Usage: printDiscoveryErrors($errRefs, $hostName)
# $errRefs is the one returned by discoverRacTargets() and further filled by discoveryServiceName()
sub printDiscoveryErrors
{
  my ($errRefs, $hostName) = @_;
  foreach $err (keys %$errRefs)
  {
    my $escapedErrMsg = escapeXMLChar($errRefs->{$err});
    $escapedErrMsg = convertToUTF8($escapedErrMsg);
print <<__END;
<DiscoveryWarning DISCOVERY_SCRIPT="$hostName : $err">
$escapedErrMsg
</DiscoveryWarning>
__END
  }    

#<Target TYPE="rac_discovery_error" NAME="$err">
#  <Property NAME="MachineName" VALUE="$hostName"/>
#  <Property NAME="Message" VALUE="$escapedErrMsg"/>
#</Target>

}    

##print Oracle Database target entry
sub printRACInstanceEntry
{
  my ($sid,$lsnrHost, $hostName,$oHome,$port,$racDBName, $servName) = @_;
      
  $lsnrHost = resolveLsnrHostName($lsnrHost,$hostName);
  my $instName = &getInstName($racDBName, $sid);
      
  if (defined $llOracleHome )
  {
    my $racDBInstanceTargetName = getLLRACDBInstanceTargetName($racDBName, $sid);
    #
    # check if this instance is on a different host
    #
    my $onHostAttribute = "";
    if (($lsnrHost ne $hostName) && !equalHosts($lsnrHost, $hostName))
    {
      #
      # if the hostName has no domain info, see if it's available from the lsnrHost
      #
      if ((index($hostName,".") < 0) && (index($lsnrHost,".") > 0))
      {
        $hostName = $hostName . substr($lsnrHost,index($lsnrHost,"."));
      }
      $onHostAttribute = "ON_HOST=\"$hostName\"";
    }

    if (defined($llRACDBInstanceTargetNames{$racDBInstanceTargetName}))
    {
      return;
    }
    $llRACDBInstanceTargetNames{$racDBInstanceTargetName} = $racDBInstanceTargetName;
    print "<Target TYPE=\"oracle_database\" NAME=\"$racDBInstanceTargetName\" $onHostAttribute>\n";
    #
    # if this instance is from another host, we're proxying the collection
    #
    if (length($onHostAttribute) > 0)
    {
      print "  <Property NAME=\"OcmProxyOracleHome\" VALUE=\"$oHome\" />\n";
    }
  }
  else
  {
    print "<Target TYPE=\"oracle_database\" NAME=\"$instName\" >\n";
  }
  my $configFile = $racDBConfigFiles{uc($racDBName)};

  # print version_value
  my $DBVersion = getDBVersionFromDBll($configFile);
  if (defined $DBVersion && $DBVersion ne "")
  {
    print "  <Property NAME=\"version_value\" VALUE=\"$DBVersion\"/>\n";
  }

  my $timestamp = getCollectionTimestamp($configFile);
  if (defined $timestamp && $timestamp ne "")
  {
    print "  <Property NAME=\"CCR_COLLECTION_TIMESTAMP_OVERRIDE\" VALUE=\"$timestamp\" />\n";
  }
  my $dbcharset = getConfigProperty($configFile, "NLS_CHARACTERSET");
  if (defined $dbcharset && $dbcharset ne "") {
      print "<Property NAME=\"CCR_DB_NLS_CHARACTERSET\" VALUE=\"$dbcharset\"/>\n";
  }
  print "  <Property NAME=\"OracleHome\" VALUE=\"$oHome\" />\n";
  if (!defined $llOracleHome )
  {
    print "  <Property NAME=\"UserName\" VALUE=\"dbsnmp\" ENCRYPTED=\"FALSE\"/>\n";
    #
    # The following code is commented out in the OCM case. Passwords are not
    # required for configuration collections due to OCM instrumentation.
    #
    # if(isPasswordValid("dbsnmp",DUMMY_PASSWORD,$oHome, $sid))
    # {
    #  print "<Property NAME=\"password\" VALUE=\"" . DUMMY_PASSWORD . "\" ENCRYPTED=\"FALSE\"/>\n";
    # }
  }
  print "  <Property NAME=\"MachineName\" VALUE=\"$hostName\" />\n";
  print "  <Property NAME=\"Port\" VALUE=\"$port\" />\n";
      
  my $osid = (defined $RacSidConversionMap{$sid})? $RacSidConversionMap{$sid} : $sid;
  print "  <Property NAME=\"SID\" VALUE=\"$osid\"/> \n";
  print "  <Property NAME=\"ServiceName\" VALUE=\"$servName\"/> \n";
  if (defined $llOracleHome )
  {
    my @llSuffixes = (".ll",".ccr");
    my $DBName = basename($configFile, @llSuffixes);
    $DBName =~ s/-RAC$//;
    print "  <Property NAME=\"ConfigFile\" VALUE=\"" . $configFile. "\"/> \n";      
    print "  <Property NAME=\"DBName\" VALUE=\"" . uc($DBName) . "\"/> \n";
  }
  print "  <CompositeMembership> \n";
  if (defined $llOracleHome )
  {
    my $targetName = getLLRACTargetName($racDBName);
    print "    <MemberOf TYPE=\"rac_database\" NAME=\"$targetName\" ASSOCIATION=\"cluster_member\"/>\n";
  }
  else
  {
    print "    <MemberOf TYPE=\"rac_database\" NAME=\"$racDBName\" ASSOCIATION=\"cluster_member\"/>\n";
  }
  print "  </CompositeMembership> \n";
  print "</Target>\n";
}

# Usage: ($clusterRef, $racInstsRefs, $errRefs) = discoverRacTargets($ohomesRef, $hostName);
# $ohomesRef is the reference of an array of Oracle Homes
# return reference of three hashtables. See findRacTargetsFromOracleHome() for 
# more details
#     
sub discoverRacTargets
{
  my (@oracleHomes) = @{$_[0]};
  my $hostName = $_[1];
  addToArrayIfNotExisting(\@oracleHomes, $ENV{ORACLE_HOME}) if (defined $ENV{ORACLE_HOME});
    
  my ($clusterRef, $racInstsRefs, $errRefs);
  my $oracleHome;
  my ($racOracleHome, $srvctlVersion) = ("", "0.0.0.0.0");
  my %errs;
  my ($clusterName, $crsOh);
  my $warn_cluster_found = 0;

  if (defined $ENV{OMSENV_CLUSTER_NAME})
  {
    # UI can mandidate a clusterwide discovery
    ($clusterName, $crsOh) = $ENV{OMSENV_CLUSTER_NAME};
    EMD_PERL_DEBUG("$LOG_CATEGORY OMSENV_CLUSTER_NAME=$clusterName");
  }

  if (!defined $clusterName || $clusterName eq "")
  {
    ($clusterName, $crsOh) = getClusterName($emdRoot, $crsHome);
    if ($clusterName ne "" && defined $ENV{OMSENV_WARN_CLUSTER_FOUND})
    {
      $warn_cluster_found = 1;
    }
  }
    
  if ($clusterName eq "")
  {
    if(defined $llOracleHome &&  $LL_RAC_COLLECTION_EXISTS)
    {
      EMD_PERL_DEBUG("$LOG_CATEGORY could not find cluster name but there exists RAC livelink collection, use a default clustername");
      $clusterName = $LL_DEFAULT_CLUSTER_NAME;
    }
    else
    {
      # if clusterName is empty, then we are not in a cluster. Stop here
      EMD_PERL_DEBUG("$LOG_CATEGORY discoverRacTargets: not in a cluster");    
      return ((), (), ());
    }
  }    

  # remember it's in a cluster
  $CLUSTER_NAME = $clusterName;
  $CRS_HOME = $crsOh if (defined($crsOh));
    
  EMD_PERL_DEBUG("discoverRacTargets: cluster is '$clusterName'");    
    
  # get newest srvctl
  foreach $oracleHome (@oracleHomes)
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY discoverRacTargets: looking in $oracleHome...");
    my $srvctlFile = File::Spec->catfile($oracleHome,"bin","srvctl");
    if (-e $srvctlFile || -e $srvctlFile.".bat")
    {
      my ($err, $version) =  getSrvCtlVersion($oracleHome);
      if ($err eq "")
      {
        EMD_PERL_DEBUG("$LOG_CATEGORY discoverRacTargets: srvctl found, version $version");
        $err = srvctl_sanity_check($oracleHome, $version);
        if ($err eq "")
        {
          if (compareVersions($version, $srvctlVersion) == 1)
          {
            $srvctlVersion = $version;
            $racOracleHome = $oracleHome;
          }    
        }
        else
        {
          $errs{$oracleHome} = $err;
        }    
      }
      else
      {
        $errs{$oracleHome} = $err;
      }
    }    
  }
    
  if ($racOracleHome ne "")
  {
    ($clusterRef, $racInstsRefs, $errRefs) = 
            findRacTargetsFromOracleHome($racOracleHome, $hostName, $srvctlVersion);
  }
    
  $clusterRef->{NAME} = $clusterName;
    
  # we need to put the errors returned by getSrvCtlVersion() in the $errRefs
  foreach $k (keys %errs)
  {
    $errRefs->{$k} = $errs{$k};
  }
    
  if ($warn_cluster_found)
  {
    $errRefs->{"WARN_CLUSTER_FOUND"} = $clusterName;
  }    
       
  ($clusterRef, $racInstsRefs, $errRefs);
}        

# Usage: ($clusterRef, $racInstsRefs, $errRefs) = 
#           findRacTargetsFromOracleHome($oracleHome, $hostName, $srvctlVersion)
# $srvctlVersion is optional. If not specified, the program will try to find out
#
# Logic:
#   if ("$oracleHome/bin/lsnodes" exists)
#   {
#        1. run "$OracleHome/bin/lsnodes" to get the cluster nodes
#        2. run "$OracleHome/bin/srvctl config" to get all rac databases in the cluster
#        3. foreach $racDatabase discovered in 2
#           {
#               run "$OracleHome/bin/srvctl config database -d $racDatabase" (for version >= 9.2)
#                  or "$OracleHome/bin/srvctl config database -p $racDatabase -n $hostName" (9.0.1)
#                  to get the ($racInstanceName, $racInstanceOracleHome) on the host being discovered.
#           }     
#  }
#
# return references of three hashtables ($clusterRef, $racInstsRefs, $errRefs), in the following format
#
# $clusterRef = {
#        #NAME => "cluster1",
#        #NODES => [ "sun1.domain.com", "sun2.domain.com", "sun3.domain.com" ],
#        RACDATABASES => [ "racDB1", "racDB2", "racDB3", "racDB4" ]
# }
# 
# For now, $racInstsRefs only contains rac instances on $hostName. But the data structure is extensible
# for instances not on the $hostName
# $racInstsRefs = {
#           
#     "racDB1" => [ 
#                     [ "sun1.domain.com", "racDB11", "/oracle/9.2.0" ],
#                     #[ "sun2.domain.com", "racDB12", "/oracle/9.2.0" ]
#                 ],
#
#     
#     "racDB3" => [ 
#                     [ "sun1.domain.com", "racDB31", "/oracle/9.3.0" ],
#                     #[ "sun2.domain.com", "racDB32", "/oracle/9.3.0" ],
#                     #[ "sun3.domain.com", "racDB32", "/oracle/9.3.0" ]  
#                 ]
# }   
# 
# $errRefs = {
#     "racDB3" => "cannot execute "srvctl ..."",
#     "racDB4" => "PRKR-1007 : ...",
#     "/oracle/home" =>  "bad '/oracle/home/bin/srvctl config database'..",
# }
#   
#
# 
sub findRacTargetsFromOracleHome
{
  my ($oracleHome, $hostName, $srvctlVersion) = @_;
  my ($clusterRef, $racInstsRefs, $errRefs) = ((), (), ());
  my ($cmd, $err, $output);
  my %racdbOHMap = (); 

  # bug 3469118 workaround
  my $orgDIR = changeCWDForSrvctlIfNecessary($oracleHome, $srvctlVersion);

  EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: discovering RAC targets in $oracleHome");

  #get the rac databases in the cluster
  my $srvctlFile = File::Spec->catfile($oracleHome,"bin","srvctl");
  if (-e $srvctlFile || -e $srvctlFile.".bat")
  {
    if ($srvctlVersion eq "")
    {
      ($err, $srvctlVersion) = getSrvCtlVersion($oracleHome);
      if ($err ne "")
      {
        $errRefs->{$oracleHome} = $err;
      }
    }
    if ($srvctlVersion ne "")
    {
      my $before92 = (compareVersions($srvctlVersion, "9.2.0.0.0") == -1);
      my $after100 = (compareVersions($srvctlVersion, "10.0.0.0.0") >= 0);
      my $before112 = (compareVersions($srvctlVersion, "11.2.0.0.0") == -1);

      $cmd = "$srvctlFile config";
      if ($after100)
      {
        #Get the VIP of the machine
        $LOCAL_HOST_VIP_NAME = getVIPName($oracleHome, $hostName);
        EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: VIP Name on $hostName is $LOCAL_HOST_VIP_NAME");
      }
      if (!$before112)
      {
        $CLUSTER_SCAN_NAME = getScanName($CRS_HOME) if (defined $CRS_HOME && $CRS_HOME ne "");
        EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: SCAN name  is $CLUSTER_SCAN_NAME");
        $cmd = "$srvctlFile config database -S 1"; 
      }
      EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: executing '$cmd'");

      my $lib_path = unset_lib_path_env();
      ($err, $output) = executeCommand($cmd, $oracleHome);
      set_lib_path_env($lib_path);

      if ($err ne "")
      {
        $errRefs->{$oracleHome} = $err;
      }
      else
      {
        #rac database found
        EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: returned \n$output");
        my @racDBList = ();
        if ($before112)
        {
          @racDBList = split /\n/, $output;
        }
        else
        {
          my @lns = split /\n/, $output;
          for my $ln (@lns)
          {
            # expected output format
            # #@=result[0]: res_name={ora.dbm.db} dbunique_name={dbm} db_domain={} oh={/u01/app/oracle/product/11.2.0/dbhome_1} cluster_database={true} srvpool={dbm} db_type={ADMIN_MANAGED} enabled={true} disabled_nodes={} enabled_nodes={node01,node02}
            if ($ln =~ /res_name\s*=\s*\{.*?\}.*?dbunique_name\s*=\s*\{(.*?)\}.*?oh\s*=\s*\{(.*?)\}.*?cluster_database\s*=\s*\{true\}.*?db_type\s*=\s*\{(.*?)\}/i)
            {
              my $dbName = $1;
              $racdbOHMap{$dbName} = $2;
              $DATABASE_TYPE_11_2 = $3 if (!defined $DATABASE_TYPE_11_2 && $3);
              EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: database found $dbName");    
              push(@racDBList,$dbName);
            }
          }
        }
        $clusterRef->{RACDATABASES} = \@racDBList;

        foreach $racDB (@racDBList)
        {
          if ($before92)
          {
            # 9.0.1 database
            $cmd = "$srvctlFile config database -p $racDB -n $hostName"
          }
          elsif ($before112)
          {
            $cmd = "$srvctlFile config database -d $racDB";
          }
          else
          {
            $cmd = "$srvctlFile status database -d $racDB -S 1"; 
          }
          EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: executing $cmd");

          my $lib_path = unset_lib_path_env();
          ($err, $output) = executeCommand($cmd, $oracleHome);
          set_lib_path_env($lib_path);

          # on NT, CAPITAL case is used for simplicity
          $racDB = convertSIDForOS($racDB);
          if ($err ne "")
          {
            $errRefs->{$racDB} = $err;
          }
          else
          {
            EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: returned \n$output");
            my @instRefAry = ();
            my @instInfs = split /\n/, $output;
            #
            # before 11.2, output is of the form
            # <hostName> <instanceName> <oracleHome>[EOL]
            #
            # 11.2 and later, output is of the form
            # #@=result[0]: dbunique_name={<dbUniqueName>} inst_name={<dbInstName>} node_name={<hostName>} up={true}
            #
            my $exprMatch = ($before112 ? '^([^\\s]+)\\s([^\\s]+)\\s(.+)$' : 
                                          "dbunique_name\\s*=\\s*\\{\\s*$racDB\\s*\\}.*?inst_name\\s*=\\s*\\{(.*?)\\}.*?node_name\\s*=\\s*\\{(.*?)\\}");

            foreach $instInf (@instInfs)
            {
              if ($instInf =~ /$exprMatch/i)
              {
                my $runningNode = ($before112 ? $1 : $2);
                my $runningSID = ($before112 ? $2 : $1);
                if (defined $llOracleHome || &equalHosts($runningNode, $hostName))
                {
                  # on NT, CAPITAL case is used for simplicity
                  my $racsid = convertSIDForOS($runningSID);
                  # 3667625 workaround for rac sid mismatch problem 
                  $RacSidConversionMap{$racsid} = $runningSID;
                  my $runningHome = ($before112 ? $3 : $racdbOHMap{$racDB});
                  push @instRefAry, [$runningNode, $racsid, $runningHome];
                  EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: Instance [$runningNode, $runningSID, $runningHome] is on the host");
                  # Bug 3468650 - contine to find all other instances on the host
                  # last;
                }
              }
              else
              {
                $errRefs->{$racDB} = "Unknown format from output of " . "\"$cmd\": " . $output;
                EMD_PERL_ERROR("findRacTargetsFromOracleHome: $errRefs->{$racDB}");
                last;
              }
            }
            if (!defined $errRefs->{$racDB} && @instRefAry)
            {
              $racInstsRefs->{$racDB} = \@instRefAry;
            }
          }
        }
      }
    }
  }
  else
  {
    $errRefs->{$oracleHome} = "$srvctlFile doesn't exist";
    EMD_PERL_ERROR("findRacTargetsFromOracleHome: $errRefs->{$oracleHome}");
  }

  # bug 3469118 workaround: we'll revert the cwd 
  if($orgDIR ne "__CURRENT_DIR_UNCHANGED__")
  {
    chdir($orgDIR);
  }

  ($clusterRef, $racInstsRefs, $errRefs);
}

# getSrvCtlVersion($OracleHome)
# return ($err, $version)
# when $err is empty, the $version contains the version $OracleHome/bin/srvctl
sub getSrvCtlVersion
{
  my $oracleHome = $_[0];
  my ($err, $output, $version);

  my $srvctlFile = File::Spec->catfile($oracleHome,"bin","srvctl");
  if (-e $srvctlFile || -e $srvctlFile.".bat")
  {
    my $lib_path = unset_lib_path_env();    
    ($err, $output) = executeCommand("$srvctlFile -V", $oracleHome);
    set_lib_path_env($lib_path);

    if ($err eq "")
    {
      if ($output =~ /\d+\.\d+\.\d+\.\d+/)
      {
        $version = $&;
      }    
      else
      {
        $err = "Wrong version format: $output";
        EMD_PERL_ERROR("getSrvCtlVersion: $err");
      }    
    }
  }
  else
  {
    $err = "$srvctlFile doesn't exist";
    EMD_PERL_ERROR("getSrvCtlVersion: $err");
  }
  ($err, $version);
}

# Usage: ($err, $output) = executeCommand($cmd, $envOracleHome, $envJavaHome)
#  
# Run the $cmd and 
# if success, return the empty to $err and output string to $output
# else, return the error msg to $err and empty to $output

sub executeCommand
{
  my ($cmd, $envOracleHome, $envJavaHome) = @_;
  my ($oldOH, $oldJH);
    
  $oldOH = $ENV{ORACLE_HOME};
  if (defined $envOracleHome && $envOracleHome ne "")
  {
    $ENV{ORACLE_HOME} = $envOracleHome;
  }
  else
  {
    delete $ENV{ORACLE_HOME};
  }

  $oldJH = $ENV{JAVA_HOME};
  if (defined $envJavaHome && $envJavaHome ne "")
  {
    $ENV{JAVA_HOME} = $envJavaHome;
  }
  else
  {
    delete $ENV{JAVA_HOME};
  }

  my $err = "";
  my $output = "";

  if (open(CMDOUTPUT, "$cmd 2>&1 |"))
  {
    my @outputs = <CMDOUTPUT>;
    $output = join "", @outputs;

    if (!close(CMDOUTPUT))
    {
      # close error
      if ($output ne "")
      {
        $err = "\"${cmd}\" returned: \"" . $output . "\"";
        $output = "";
      }
      else
      {
        $err = "bad \"$cmd\": $! $?";
      }   
      }   
  }
  else
  {
    # open error
    $err = "cannot execute \"$cmd\": $!";
  }    

  if (defined $oldOH && $oldOH ne "")
  {
    $ENV{ORACLE_HOME} = $oldOH;
  }
  else
  {
    delete $ENV{ORACLE_HOME};
  }
    
  if (defined $oldJH && $oldJH ne "")
  {
    $ENV{JAVA_HOME} = $oldJH;
  }
  else
  {
    delete $ENV{JAVA_HOME};
  }
    
  EMD_PERL_ERROR("executeCommand: $cmd: $err") if ($err ne "");
    
  ($err, $output);
}    

sub escapeXMLChar
{
  my $newStr = $_[0];
  $newStr =~ s/&/&amp;/g;
  $newStr =~ s/</&lt;/g;
  $newStr =~ s/>/&gt;/g;
  $newStr =~ s/\"/&quot;/g;
  $newStr =~ s/'/&apos;/g;
  $newStr;
}

# compareVersions($v1, $v2)
# return 1 if $v1 > $v2
#        0 if $v1 = $v2
#        -1 if $v1 < $v2
sub compareVersions
{
  my ($v1, $v2) = @_;
  my @subv1;
  my @subv2;

  while ($v1 =~ /\d+/g)
  {
    push @subv1, $&;
  }    

  while ($v2 =~ /\d+/g)
  {
    push @subv2, $&;
  }    

  my $size = (@subv1 > @subv2)? @subv1 : @subv2;

  my $i;
  for($i=0; $i<$size; $i++)
  {
    if ($subv1[$i] > $subv2[$i])
    {
      return 1;
    }

    if ($subv1[$i] < $subv2[$i])
    {
      return -1;
    }
  }

  return 0;
}

# addToArrayIfNotExisting ($aryRef, $string)
# if there is no element, $s, in @$aryRef such that ($s eq $string), then
# push @$aryRef, $string
sub addToArrayIfNotExisting 
{
  my ($aryRef, $string) = @_;
  foreach $s (@$aryRef)
  {
    if ($s eq $string)
    {
      return 0;
    }
  }
  push @$aryRef, $string;
  1;
}

# Usage: ($err, $targetName) = getTargetName($oracleHome, $sid, $isRac)
# return the database target name if found. If any error occured, it'll be returned in $err
# 
# Logic:
# find value of db_unique_name
# if not found and db_domain exists return db_name.db_domain
# else return db_name
#
sub getTargetName 
{
  my ($oracleHome, $sid, $isRac) = @_;
  my $err = "";
  my $isStandby = 0;

  if( defined $llOracleHome)
  {
    #In LiveLink, don't use target name from the init file
    return ("", "");
  }
  #get param with quotes preserved
  my ($dbUniqueName) = discoverParameterValue($oracleHome, $sid, "db_unique_name", $sid,1);
  if ($dbUniqueName eq "" || $dbUniqueName eq "''" || $dbUniqueName eq '""')
  {
    # bug fix 2755537
    #$err = checkErrorMessageInParameterDiscovery();
    # 
    # if ($err ne "")
    # {
    #     # error 
    #     $err = "Failed to retrieve value for parameter \"$sid.db_unique_name\": " . $err; 
    #     
    #     return ($err, ""); 
    # }
    # 
    #Check if the database is a standby
    if (isStandby($oracleHome, $sid))
    {
      EMD_PERL_INFO("$LOG_CATEGORY $sid is a standby db");
      #the target name would be sid_hostname
      $isStandby = 1;
      if (!$isRac)
      {
        $dbUniqueName = "${sid}_$hostName";
      }    
    }

    if (!$isStandby || $isRac)
    {
      # db_unique_name not specified, try db_name.db_domain 
      #get param with quotes preserved
      my ($dbName) = discoverParameterValue($oracleHome, $sid, "db_name", $sid,1);

      $err = checkErrorMessageInParameterDiscovery();
      if ($err ne "")
      {
        #error
        $err = "Failed to retrieve value for parameter \"$sid.db_name\": " . $err; 
        return ($err, "");
      }     

      # db_name retrieve succeeded, try db_domain     
      #get param with quotes preserved
      my ($db_domain) = discoverParameterValue($oracleHome, $sid, "db_domain", $sid,1);

      $err = checkErrorMessageInParameterDiscovery();
      if ($err ne "")
      {
        #error
        $err = "Failed to retrieve value for parameter \"$sid.db_domain\": " . $err; 
        return ($err, "");
      }     
      if( defined $llOracleHome)
      {
        #don't use DB domain
        #set it empty
        $db_domain = "";
        #Also, use upper cased DB Name, db_name is case insensitive
        $dbName = uc($dbName);
      }
      $dbName = convertToUcIfNotQuoted($dbName);
      $dbName = trimQuote($dbName);
      $db_domain = convertToUcIfNotQuoted($db_domain);
      $db_domain = trimQuote($db_domain);
      # db_name and db_domain are retrieved
      if($db_domain ne "")
      {
        $dbUniqueName = $dbName . "." . $db_domain;
      }
      else
      {
        $dbUniqueName = $dbName;
      }
    }
  }         
  else
  {
    # db_name retrieve succeeded, try db_domain     
    #get param with quotes preserved
    my ($db_domain) = discoverParameterValue($oracleHome, $sid, "db_domain", $sid,1);

    $err = checkErrorMessageInParameterDiscovery();
    if ($err ne "")
    {
      #error
      $err = "Failed to retrieve value for parameter \"$sid.db_domain\": " . $err; 
      return ($err, "");
    }     

    # db_name and db_domain are retrieved
    $dbUniqueName = convertToUcIfNotQuoted($dbUniqueName);
    $dbUniqueName = trimQuote($dbUniqueName);
    $db_domain = convertToUcIfNotQuoted($db_domain);
    $db_domain = trimQuote($db_domain);
    if($db_domain ne "")
    {
      $dbUniqueName = $dbUniqueName . "." . $db_domain;
    }
  }

  if ($isRac && $isStandby)
  {
    $dbUniqueName .= "_$CLUSTER_NAME"; 
  }     

  ("", $dbUniqueName);
}        

#Check if the database is a standby
#The database is standby if one of the following is true:
# - ora_mrp<0-9>*_sid process is running
# - fal_client is present in the init.ora
# - fal_server is present in the init.ora
#
sub isStandby
{
  my ($oracleHome, $sid) = @_;
  if(($OSNAME ne 'WIN') )
  {
    if ( oraProcExists('mrp[0-9]*', $sid) ) 
    {
      #MRP standby process process exists
      #This is standby database
      EMD_PERL_DEBUG("$LOG_CATEGORY mrp process found for, its a standby db");
      return 1;
    }
  }
  my $standbyParam = discoverParameterValue($oracleHome, $sid, "fal_client", $sid,1);

  $err = checkErrorMessageInParameterDiscovery();
  if ($err ne "")
  {
    #error
    EMD_PERL_DEBUG("$LOG_CATEGORY Failed to retrieve value for parameter \"$sid.fal_client\": ");
  }     
  if($standbyParam ne "")
  {
    return 1;
  }
  $standbyParam = discoverParameterValue($oracleHome, $sid, "fal_server", $sid,1);

  $err = checkErrorMessageInParameterDiscovery();
  if ($err ne "")
  {
    #error
    EMD_PERL_DEBUG("$LOG_CATEGORY Failed to retrieve value for parameter \"$sid.fal_server\": ");
  }     
  if($standbyParam ne "")
  {
    return 1;
  }
  return 0; 
}

# Usage: ($err, $serviceName) = discoveryServiceName($oracleHome, $sid)
# return the service name if found. If any error occured, it'll be returned in $err
# 
# Logic:
# find value of service_names
# if not found and db_domain exists return db_name.db_domain
# else return db_name
#
sub discoveryServiceName 
{
  my ($oracleHome, $sid) = @_;

  my $err = "";
  if( defined $llOracleHome)
  {
    #In LiveLink, don't get service name from the init file
    return ("", "");
  }

  EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: discovering value of parameter service_names");
  my ($serviceName) = discoverParameterValue($oracleHome, $sid, "service_names", $sid);

  $err = checkErrorMessageInParameterDiscovery();

  if ($err ne "")
  {
    # error 
    $err = "Failed to retrieve value for parameter \"$sid.service_names\": " . $err; 
    return ($err, ""); 
  }

  EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: service_names = $serviceName");
  if ($serviceName eq "")
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: discovering value of parameter db_unique_name");
    ($serviceName) = discoverParameterValue($oracleHome, $sid, "db_unique_name", $sid);

    EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: db_unique_name = $serviceName");

    if ($serviceName eq "")
    {      
      # service_names not specified, try db_name
      EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: discovering value of parameter db_name");
      ($serviceName) = discoverParameterValue($oracleHome, $sid, "db_name", $sid);

      $err = checkErrorMessageInParameterDiscovery();
      if ($err ne "")
      {
        #error
        $err = "Failed to retrieve value for parameter \"$sid.db_name\": " . $err; 
        return ($err, "");
      }
    }    
    EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: db_name = $serviceName");
  }

  # get db_domain     
  EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: discovering value of parameter db_domain");
  my ($db_domain) = discoverParameterValue($oracleHome, $sid, "db_domain", $sid);

  $err = checkErrorMessageInParameterDiscovery();
  if ($err ne "")
  {
    #error
    $err = "Failed to retrieve value for parameter \"$sid.db_domain\": " . $err; 
    return ($err, "");
  }     

  EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: db_domain = $db_domain");

  # put them together
  if ($db_domain ne "" && $serviceName !~ /$db_domain$/)
  {
    $serviceName = $serviceName . "." . $db_domain;
  }     

  EMD_PERL_DEBUG("$LOG_CATEGORY discoveryServiceName: serviceName = $serviceName");

  ("", $serviceName);
}        

# Usage: filterOutNotSupportedOracleHomes($ohomesRef,$sidsRef)
# ($ohomesRef,$sidsRef) are those returned by getOracleHomesAndSids(); 
# The method will delete the entries with not supported oracle home. 
sub filterOutNotSupportedOracleHomes
{
  my ($ohomesRef, $sidsRef) = @_;
  my $sid;
  for $sid (keys %$sidsRef) 
  {
    if (!isSupportedHome($sidsRef->{$sid}))
    {
      EMD_PERL("$LOG_CATEGORY Oracle Home $sidsRef->{$sid} for sid=$sid is not supported. It is excluded from discovery.");
      delete $sidsRef->{$sid};
    }
  }

  my $i;
  my @ohs = @{$ohomesRef};

  splice @$ohomesRef, 0;

  for($i=0; $i<@ohs; $i++)
  {
    if (isSupportedHome($ohs[$i]))
    {
      push @{$ohomesRef}, $ohs[$i];
    }
    else
    {
      EMD_PERL_INFO("$LOG_CATEGORY Oracle Home $ohs[$i] is not supported. It is excluded from discovery.");
    }
  }
}

# Usage: filterOutBadOracleHomes($ohomesRef,$sidsRef)
# ($ohomesRef,$sidsRef) are those returned by getOracleHomesAndSids(); 
# The method will delete the entries with an oracle home that doesn't exist
sub filterOutBadOracleHomes
{
  my ($ohomesRef, $sidsRef) = @_;
  my $sid;
  for $sid (keys %$sidsRef) 
  {
    if (! -e $sidsRef->{$sid})
    {
      delete $sidsRef->{$sid};
    }
  }

  my $i;
  my @ohs = @{$ohomesRef};

  splice @$ohomesRef, 0;

  for($i=0; $i<@ohs; $i++)
  {
    if (-e $ohs[$i])
    {
      push @{$ohomesRef}, $ohs[$i];
    }
  }
}

# Usage: removeElementFromArray($arrayRef, $element)
# if (existing $e in @$arrayRef such that $e eq $element)
#   remove it from the array
sub removeElementFromArray
{
  my ($arrayRef, $element) = @_;
  my $i;
  for($i=0; $i<@$arrayRef; $i++)
  {
    if ($arrayRef->[$i] eq $element)
    {
      last;
    }
  }

  if ($i < @$arrayRef)
  {
    splice @$arrayRef, $i, 1;
  }
}

#Usage: getRacDBGlbName($targetName, $dbName)
sub getRacDBGlbName
{
  my $targetName = $_[0];

  if ($targetName eq "")
  {
    $targetName = $_[1];
  }
  $targetName;
}

#Usage: getInstName($racDBName, $sid)    
sub getInstName
{
  $_[0] . "_" . $_[1];
}    

#Check if Oracle Home is supported like pre 8.1
sub isSupportedHome
{
  my ($home) = @_;
#  if (! -e ($home . "/javavm"))
#  {
#    return 1;    
#  }
#  return 0;
#return all the homes supported till we get a good logic to filter out
#an Old Oracle home
    return 1;    
}

# Usage: getRidOfRemoteAddresses($addresses, $localHost)
# $addresses is the one returned by getListenerAddresses()
#
# Remove from $addresses any entry whose ip address doesn't match that of $localHost
#
sub getRidOfRemoteAddresses
{
  my ($addresses, $localHost) = @_;

  my @addrList = @{$addresses};

  splice @$addresses, 0;

  for($i=0; $i<@addrList; $i++)
  {
    my $host = $addrList[$i]->{HOST};

    if(defined $host && $host ne "" && 
       !&equalHosts($host, $localHost)  &&
       !&equalHosts($host, $LOCAL_HOST_VIP_NAME) )
    {
      next; 
    }
    push @{$addresses}, $addrList[$i];
  }
}

#
# The agent's lib_path doesn't work with 92 srvctl even after calling set_lib_path()
# Unsetting the lib_path works fine with srvctl
#  
# Return the old lib_path before unset
#
# This method is adapted from set_lib_path_env() in semd_common.pl
sub unset_lib_path_env
{
  my ($oh) = @_;
  my $rst;

  if ( $OSNAME eq "SOL" || $OSNAME eq "LNX" || $OSNAME eq "OSF1" ) 
  {
    $rst = $ENV{LD_LIBRARY_PATH};
    delete $ENV{LD_LIBRARY_PATH};
  } 
  elsif ( $OSNAME eq "HP" ) 
  {
    $rst = $ENV{SHLIB_PATH};
    delete $ENV{SHLIB_PATH};
  }
  elsif ( $OSNAME eq "AIX" ) 
  {
    $rst = $ENV{LIBPATH};
    delete $ENV{LIBPATH};
  }
  elsif ( $OSNAME eq "MAC OS X" ) 
  {
    $rst = $ENV{DYLD_LIBRARY_PATH};
    delete $ENV{DYLD_LIBRARY_PATH};
  }
  else 
  {
    # Unsupported Operating System
    # Do nothing
  }
  $rst;
}

#
# Take the lib_path and set it to the env variable 
# Return the old lib_path
#
# This method is adapted from set_lib_path_env() in semd_common.pl
sub set_lib_path_env
{
  my $libpath = $_[0];
  my $rst;

  if ( $OSNAME eq "SOL" || $OSNAME eq "LNX" || $OSNAME eq "OSF1" ) 
  {
    $rst = $ENV{LD_LIBRARY_PATH};
    $ENV{LD_LIBRARY_PATH} = $libpath if defined $libpath;
  }
  elsif ( $OSNAME eq "HP" )
  {
    $rst = $ENV{SHLIB_PATH};
    $ENV{SHLIB_PATH} = $libpath if defined $libpath;
  }
  elsif ( $OSNAME eq "AIX" )
  {
    $rst = $ENV{LIBPATH};
    $ENV{LIBPATH} = $libpath if defined $libpath;
  }
  elsif ( $OSNAME eq "MAC OS X" )
  {
    $rst = $ENV{DYLD_LIBRARY_PATH};
    $ENV{DYLD_LIBRARY_PATH} = $libpath if defined $libpath;
  }
  else
  {
    # Unsupported Operating System
    # Do nothing
  }
  $rst;
}    

#
# Run "$oracleHome/bin/srvctl config", if failed return the error
# else return empty
#
sub srvctl_sanity_check
{
  my ($oracleHome, $srvctlVersion) = @_;
   
  # bug 3469118 workaround:
  my $orgDIR = changeCWDForSrvctlIfNecessary($oracleHome, $srvctlVersion);

  my $cmd = File::Spec->catfile($oracleHome,"bin","srvctl")." config"; 
  EMD_PERL_DEBUG("srvctl_sanity_check: $cmd");    
        
  my $lib_path = unset_lib_path_env();
  my ($err, $output) = executeCommand($cmd, $oracleHome);
  set_lib_path_env($lib_path);
        
  if ($err ne "")
  {
    EMD_PERL_DEBUG("srvctl_sanity_check failed: $err");
  }
   
  EMD_PERL_DEBUG("srvctl_sanity_check passed");

  # bug 3469118 workaround: we'll revert the cwd
  if($orgDIR ne "__CURRENT_DIR_UNCHANGED__")
  {
    chdir($orgDIR);
  }
  $err; 
}

sub convertToUTF8
{
  my $value = $_[0];
  my $num = 0;
  my $utf8 = '';

  for (my $i = 0; $i < length($value); $i++)
  {
    $num = ord(substr($value,$i,1));
    if ($num < 0x80)
    {
      $utf8 .= chr($num);
    }
    else
    {
      $utf8 .= chr(0xC0 | (($num >> 6) & 0x03));
      $utf8 .= chr(0x80 | ($num & 0x3F));
    }
  }
  return $utf8;
}

## 
## The following method is written to workaround bug 3469118.
## For pre-10g NT rac, if PATH env doesn't include $oracleHome/bin, 
## the srvctl will return error when invoked not within $oracleHome/bin. 
## The workaround for this bug is to change the current dir to $oracleHome/bin 
## before calling srvctl and set it back when finished
##

# Take in $oracleHome and $srvctlVersion
#
# Return the original current dir if it's changed
# Otherwise return "__CURRENT_DIR_UNCHANGED__"
sub changeCWDForSrvctlIfNecessary
{
  my ($oracleHome, $srvctlVersion) = @_;
  my $orgDIR = "__CURRENT_DIR_UNCHANGED__";
    
  if ($OSNAME eq 'WIN' && compareVersions($srvctlVersion, "10.0.0.0.0") == -1)
  {    
    # This is a NT pre-10g srvctl
    $orgDIR = getcwd;
    chdir File::Spec->catdir($oracleHome,"bin");
  }
  $orgDIR;
}

#
# Use the srvctl to retrieve the vip name of the machine specified
#
sub getVIPName
{
  my ($oh, $host) = @_;
  my $vipn = "";
  my $localnode = "";
  my $cmd;
  my $lib_path = unset_lib_path_env();  
  my ($err, $output) = ("", "");

  if ($CRS_HOME ne "")
  {
    $cmd = File::Spec->catfile($CRS_HOME,"bin","olsnodes");
    ($err, $output) = executeCommand($cmd, $oh);

    EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: getVIPName: $cmd returned (err=$err, output=$output)");

    if ($err eq "")
    {
      my @nodes = split /\n/, $output;
      foreach $node (@nodes)
      {
        if (&equalHosts($node, $host))
        {
          $localnode = $node;
          last;
        }
      }   
    }    
  } #END of if ($CRS_HOME ne "")

  if ($localnode eq "")
  {
    ($localnode) = split /\./, $host;
  }        

  if ($localnode ne "")
  {
    $cmd = File::Spec->catfile($oh,"bin","srvctl")." config nodeapps -n $localnode -a";
    ($err, $output) = executeCommand($cmd, $oh);

    EMD_PERL_DEBUG("$LOG_CATEGORY findRacTargetsFromOracleHome: getVIPName: $cmd returned (err=$err, output=$output)");

    if ($err eq "")
    {
      my @lns = split /\n/, $output;
      for $ln (@lns)
      {
        if ($ln =~ /VIP exists.*?\/(.*?)\/(.*?)\//)
        {
          $vipn = ($1 eq "")? $2 : $1;
          last;
        }
      }
    }    
  }   
  set_lib_path_env($lib_path);
  $vipn;
}    

# Check whether the sid is a rac sid
#
# If it's a rac AND $addToRac is 1, make it a rac target and add it to $racInstsRefs
#
# Return dbname if it's RAC. 
# Return "_INVALID_SID_DETECTED_" if it's rac, but instance_name is not same as sid
# Return "" otherwise
sub checkNAddToRac
{
  my ($hostName, $oracleHome, $sid, $racInstsRefs) = @_;
  if( defined $llOracleHome)
  {
    #In LiveLink, don't read the init file
    return "";
  }
  my ($israc) = discoverParameterValue($oracleHome, $sid, "cluster_database", $sid);
    
  $err = checkErrorMessageInParameterDiscovery();
  if ($err ne "")
  {
    return "";
  }     
    
  if (uc($israc) eq "TRUE")
  {
    #rac instance
        
    my ($dbName) = discoverParameterValue($oracleHome, $sid, "db_unique_name", $sid);
        
    if ($dbName eq "")
    {
      ($dbName) = discoverParameterValue($oracleHome, $sid, "db_name", $sid);
    }
        
    if ($dbName eq "")
    {
      return "";
    }

    my ($insno) = discoverParameterValue($oracleHome, $sid, "instance_number", $sid);

    if ($insno eq "")
    {
      # BAD!! It means $sid is not really a valid instance name
      EMD_PERL_DEBUG("$LOG_CATEGORY checkNAddToRac: RAC, but sid($sid) does't have instance_number specified");
      return "_INVALID_SID_DETECTED_";
    }
    if (!defined $racInstsRefs->{$dbName})
    {
      my @instRefAry = ();
      push @instRefAry, [$hostName, $sid, $oracleHome];
      $racInstsRefs->{$dbName} = \@instRefAry;
    }
    else
    {
      # already defined. do nothing for now
    }

    # we need to the retrieve the sid with original case
    my ($osid) = discoverParameterValue($oracleHome, $sid, "instance_name", $sid);
        
    if ($osid ne "")
    {
      $RacSidConversionMap{$sid} = $osid;
    }    
    return $dbName;
  }    
  return "";
}            

#
# Retrive scan name
#
sub getScanName
{
  my ($crsoh) = @_;
  my $scan_name = "";
  my ($err, $output) = ("", "");

  my $lib_path = unset_lib_path_env();  
  my $cmd = File::Spec->catfile($crsoh,"bin","srvctl")." config scan -S 1";
  ($err, $output) = executeCommand($cmd, $crsoh);
  EMD_PERL_DEBUG("$LOG_CATEGORY getScanName: $cmd returned (err=$err, output=$output)");

  if ($err eq "")
  {
    my $scan_res_name=""; 
    my @lns = split /\n/, $output;
    for my $ln (@lns)
    {
      if ($ln =~ /res_name\s*=\s*\{(.*?)\}.*?enable\s*=\s*\{true\}/i)
      {
        $scan_res_name = $1;
        my $cmd = File::Spec->catfile($crsoh,"bin","crsctl")." status resource $scan_res_name -p";
        ($err, $output) = executeCommand($cmd, $crsoh);
        EMD_PERL_DEBUG("$LOG_CATEGORY getScanName: $cmd returned (err=$err, output=$output)");

        if ($err eq "")
        {
          my @lns = split /\n/, $output;
          for my $ln (@lns)
          {
            if ($ln =~ /SCAN_NAME\s*=\s*/i)
            {
              $scan_name = trim($'); # $' represents what is after the match
              EMD_PERL_DEBUG("$LOG_CATEGORY getScanName: Scan name found : $scan_name");
              last;
            }
          }
        }
        last;
      }
    }
  }
  if(!defined($scan_name) ||  $scan_name eq "")
  {
    my $cmd = File::Spec->catfile($crsoh,"bin","srvctl")." config scan";
    ($err, $output) = executeCommand($cmd, $crsoh);
    EMD_PERL_DEBUG("$LOG_CATEGORY getScanName: $cmd returned (err=$err, output=$output)");

    if ($err eq "")
    {
      my @lns = split /\n/, $output;
      for my $ln (@lns)
      {
        if ($ln =~ /SCAN name:\s*(.*?)\,/i)
        {
          $scan_name = $1;
          last;
        }
      }
    }
  }    
  set_lib_path_env($lib_path);
  EMD_PERL_DEBUG("$LOG_CATEGORY getScanName: scan name : $scan_name");
  $scan_name;
}      

# Check if 
#  - there is a running process
#  - there is a lock file for the sid
#  - there is a default initialization file
# return if the given $sid, $oh is valid or not
sub isValidSid
{
  my ($sid, $oHome) = @_;

  if ( oraProcExists('pmon', $sid) )
  {
    #PMON process exists
    return 1;
  }
  # ASM handling
  if ($sid =~ /\+.*/)
  {
    if ( asmProcExists('pmon', $sid) )
    {
      #PMON process exists
      return 1;
    }
  }

  my $initDir = getDefaultInitFileLocation($oHome);
  if (-e (File::Spec->catfile($initDir,"lk".uc($sid))))
  {
    #lk file exists
    return 1;
  }
  my $initFile = getInitFile($sid,$oHome);
  if (defined $initFile && (-e $initFile))
  {
    #initalization file exists
    return 1;
  }

  return 0;
}

#Gets listener control version.
#if not found returns 0.
sub getLsnrctlVersion
{
  my ($oracleHome) = @_;
  my $lsnrctl = getListenerControl($oracleHome);

  # if version already present, return it
  return $lsnrctlVersions{$lsnrctl} if (defined $lsnrctlVersions{$lsnrctl});

  if(-e $lsnrctl)
  {
    my @commands =("version","exit");
    my $result = "";
    my $error = "";
    ($result, $error) = getRunCommandOutput($oracleHome,$lsnrctl,@commands);

    # Swallow error and log it in debug mode
    if ($error ne "")
    {
        EMD_PERL_DEBUG("$LOG_CATEGORY In getLsnrctlVersion(): $error");
    }

    my @resultArray = split /\n/, $result;

    foreach $ln (@resultArray)
    {
      if($ln =~ /\s*LSNRCTL (.+) Version ([0-9.a-zA-Z]+?) (.+)/i)
      {
        EMD_PERL_INFO("$LOG_CATEGORY The version of the $lsnrctl=[$2]");
        $lsnrctlVersions{$lsnrctl} = $2;
        return $2;
      }
    }
  }
  EMD_PERL_ERROR("$LOG_CATEGORY Could not get version of $lsnrctl");
  $lsnrctlVersions{$lsnrctl} = 0;
  return 0;
}

sub getkfod
{
    my ($oracleHome) = @_;
    if(get_osType() eq 'WIN')
    {
      return $oracleHome . "\\bin\\kfod.exe";
    }
    return $oracleHome . "/bin/kfod";
}

#Gets ASM instance version using kfod version.
#if not found returns nothing
sub getASMVersion
{
  my ($oracleHome,$sid) = @_;
  my $kfod = getkfod($oracleHome);
  if(-e $kfod)
  {
    my $commands =" -op=version";
    my $result = "";
    #sample `$kfod -op=version` ouput
    #
    #--------------------------------------------------------------------------------
    #ORACLE_SID RAC VERSION   
    #================================================================================
    #     +ASM  NO 10.2.0.1.0                                                 

    $result = `$kfod $commands`;
    # In windows kfod might give sids of asm in small case
    # So, convert kfod result to uppercase. and $sid would have
    # already be in UpperCase if the script running in windows
    if(get_osType() eq 'WIN')
    {
          $result = uc ($result);
    }
    my @resultArray = split /\n/, $result;
    # remove + sign from sid fro regular expression
    my $sidcomp =(split('\+', $sid))[1];
    foreach $ln (@resultArray)
    {
      if($ln =~ /\s*\+$sidcomp\s+.+\s+([0-9.a-zA-Z]+?)\s*$/)
      {
        EMD_PERL_INFO("$LOG_CATEGORY The version of the $sid=[$1]");
        return $1;
      }
    }
  }
  EMD_PERL_ERROR("$LOG_CATEGORY Could not get version of $sid");
  return;
}

# Test for the presence of an ora_ process
sub oraProcExists 
{
  my $retval = 0;
  my ($proc, $sid) = @_;
  if ( !defined($proc) || !defined($sid) )
  {
    return($retval);
  }
  my $regexp = "[o]ra_".$proc."_".$sid."[ ]*\$" ;
  return length(processExists($regexp))>0;
}

# Test for the presence of an asm_ process
sub asmProcExists 
{
  my $retval = 0;
  my ($proc, $sid) = @_;
  EMD_PERL_DEBUG("$LOG_CATEGORY $proc, $sid");
  if ( !defined($proc) || !defined($sid) ) 
  {
    return($retval);
  }
  my $regexp = "[a]sm_".$proc."_".$sid."[ ]*\$" ;
  return length(processExists($regexp))>0;
}

sub processExists
{
  my ($regexp) = @_;
  my $retval = "";
  my $uname ;

  my $ps_opts = "-ef";
  chomp($uname=`/bin/uname`) || chomp($uname=`/usr/bin/uname`);
  if ( $uname eq "Darwin" ) 
  { 
    # MAC OS
    $ps_opts = "-x";
  }
  $retval = `/bin/ps $ps_opts | /bin/grep "$regexp"`;
  return( $retval );
}

#Returns the timestamp from the config file
#if there is no error and the value is not empty, return the value  
#otherwise, return empty string
sub getCollectionTimestamp
{
  my ($configFile) = @_;
  my ($err,$value) = getConfigProperty($configFile,"TIMESTAMP");
  
  EMD_PERL_DEBUG("$LOG_CATEGORY in getCollectionTimestamp for $configFile=$err,$value");
  #if there is no error and the value is not empty, return the value  
  if ($err eq "" && trim($value) ne "")
  {
    return trim($value);
  }

  return "";
}

#Gets the RAC target Name LL environment given the db name
# For CCR, use the following target name for the RAC database: 
#     1. db_unique_name.db_domain_<CLUSTER_NAME>, if db_unique_name is found 
# (that would be in 10g) 
#     2. if db_unique_name is not found, use db_name.db_domain_<CLUSTER_NAME>. 
#     Note: In both the above cases, if db_domain is empty don't append 
# [.db_domain] to the target name 
#     RAC instance target name would be <RAC target name>_<SID>". So, the 
# instance name in a RAC case would be 
# <db_unique_name.db_domain>_<CLUSTER_NAME>_<sid>. 
sub getLLRACTargetName
{
  my ($dbname) = @_;

  EMD_PERL_DEBUG("$LOG_CATEGORY in getLLRACTargetName for db_name=[$dbname]");
  my $targetName = $llRACDBTargetNames{uc $dbname} ;

  #Returned the stored target name, if its not empty
  if(defined $targetName  && $targetName ne "")
  {
    EMD_PERL_DEBUG("$LOG_CATEGORY returned stored targetname=[$targetName]");
    return $targetName;
  }
  #Otherwise, compute one.

  my $configFile = $racDBConfigFiles{uc $dbname};
  my ($db_unique_name, $db_domain);
  if ($configFile =~ /^(.*)\.ccr$/)
  {
    $db_unique_name = getConfigProperty($configFile,"DB_UNIQUE_NAME");
    $db_domain = getConfigProperty($configFile,"DB_DOMAIN");
  }
  else
  {
    my @params = ( "DB_UNIQUE_NAME", "DB_DOMAIN" );
    my %paramValues = getInitParams ($configFile,@params);
    $db_unique_name = $paramValues{"DB_UNIQUE_NAME"};
    $db_domain = $paramValues{"DB_DOMAIN"};
  }
  EMD_PERL_DEBUG("$LOG_CATEGORY DB_UNIQUE_NAME=[$db_unique_name]");
  if ($db_unique_name ne "-" && $db_unique_name ne "" )
  {
    $targetName = $db_unique_name;
  }
  else
  {
    $targetName = uc $dbname ;
  }
  #Append db_domain, if not empty
  EMD_PERL_DEBUG("$LOG_CATEGORY db_domain=[$db_domain]");
  if ($db_domain ne "-" && $db_domain ne "" )
  {
    $targetName = $targetName . "." . $db_domain;
  }
  
  #Append cluster_name
  $targetName = $targetName . "_" .  $CLUSTER_NAME;

  #Store the name
  $llRACDBTargetNames{uc $dbname} = $targetName;

  EMD_PERL_DEBUG("$LOG_CATEGORY returned targetname=[$targetName]");
  return $targetName;
}

sub getLLRACDBInstanceTargetName
{
  my ($dbname,$sid) = @_;
  return getLLRACTargetName($dbname) . "_" . $sid;
}

# This assumes that only one row is returned, it will get the last 
# row if multiple rows are returned
sub getDbHostName
{
  my ($result) = @_;
  EMD_PERL_DEBUG("In getDbHostName: [$result]");

  # metric is structured as dbName|dbGlobalName|banner|hostName|<rest>
  if ($result =~ /em_result=([^\|]*)\|([^\|]*)\|([^\|]*)\|([^\|]*)\|(.*)/)
  {
    # downcase the hostName to be consistent with perlHostName
    $dbHostName = lc($4);
    EMD_PERL_DEBUG("Found host_name=$dbHostName");
  }
}
# ------------------------------  End of File  ---------------------------------
