#!/usr/local/bin/perl
# 
# e1_util.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#      Utility module for common EnterpriseOne operations.
#
#    NOTES
#      This script relies on a xml dump file produced by the standalone agent.
#
#    MODIFIED   (MM/DD/YY)
#    kclearwater 11/29/06 - Creation

use strict;

use File::Copy;
use File::Spec;

sub getE1CCRDumpFiles
{
    EMD_PERL_DEBUG("getE1CCRDumpFiles START");
    
    #CCR Root Directory
    my $e1DumpFileDirectory = $_[0];
    
    #e1 dump file type config, scf
    my $dumpFileType = $_[1];
       
    #array of dump files found
    my @file = ();
       

        if ($e1DumpFileDirectory ne "")
        {
            if (opendir DIR, $e1DumpFileDirectory)
            {
                      
                EMD_PERL_DEBUG("Opening $e1DumpFileDirectory directory to find dump files");
                #e.g. oracle_e1_scf_sa_1.xml
                @file = grep {/^oracle_e1_$dumpFileType.*\.xml/} readdir(DIR);
                EMD_PERL_DEBUG("getE1CCRDumpFiles END");
                closedir (DIR);
                return @file;
            
            }
        }
        EMD_PERL_DEBUG("CSIDL_SYSTEM - System Directory not found.");

    
    EMD_PERL_DEBUG("getE1CCRDumpFiles END");
    return @file;
}

1;


