#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/discover/utl/thirdPartyCommon.pl /main/4 2008/08/28 23:13:16 aghanti Exp $
#
# ibm.pl
# 
# Copyright (c) 2002, 2008, Oracle. All rights reserved.
#
#    NAME
#      discovers the livelink target
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       aghanti  07/23/08 - Merging changes from stpl_emll_main_gen branch
#       kgupta   04/10/07 - -ww option for command is not supported on porting
#                           platforms (bug#5894615)
#       dkapoor  05/21/06 - windows discovery implmtd 
#       ndutko   08/03/05 - ndutko_code_checkin
#    dkapoor      30-jun-2005 - Creation


strict;
($emdRoot,$hostName,$crsHome) = @ARGV;
require "$emdRoot/sysman/admin/scripts/semd_common.pl";
require "$emdRoot/sysman/admin/scripts/emd_common.pl";

use hostOSD;
use File::Spec;
use File::Basename;
use Digest::MD5 qw(md5 md5_hex md5_base64);

sub getThirdPartyJarList 
{
   my ($className,$jarName) = @_;

   my @thirdPartyJarList; 

   chomp($uname=`/bin/uname`) || chomp($uname=`/usr/bin/uname`);

   my $ps_opts = "-efww";
   if ( $uname eq "Darwin" ) {
       # MAC OS
       $ps_opts = "-x";
   }
   elsif ( ( $uname eq "SunOS" ) || ( $uname eq "AIX" ) || ( $uname eq "HP-UX" ) )
   { 
       $ps_opts = "-ef"; 
   } 

   my @results = split '\n',`/bin/ps $ps_opts | /bin/grep $className`;
   if ($? == 0) 
   {
        for my $res (@results)
        {
            my $path;
	    EMD_PERL_DEBUG("Path from the running process");
            if($res =~ /.*-classpath\s+(.*)($jarName.jar).*/)
            {
              #got the classpath till the jarName.jar
              $path = $1;
	      EMD_PERL_DEBUG("got the classpath till the $jarName.jar-->$path");
              if( $path =~ /.*[:](.*)/)
              {
                #get directory of the $jarName.jar
                $path = $1;
              }
              #Found the directory for the $jarName.jar
	      EMD_PERL_DEBUG("got the directory $jarName.jar-->$path");
              push(@thirdPartyJarList,$path);
            }
        }
   }

   return @thirdPartyJarList; 
}

sub getTargetName
{
 my ($home,$prefix) = @_;
 
 my $targetName = $prefix. "_". $home;
 
 if( length($targetName) > 256)
 {
	$targetName = "$prefix_".uc md5_base64($HOME);
 }
 return $targetName;
}


#
# Get the installation locations for the Windows
# OS registered software
#
sub getWindowsInstalledLocations
{
  my ($product) = @_;

  EMD_PERL_DEBUG("In getWindowsInstalledLocations for product=$product");
  my @installLocations = ();
	
  #Get the products only on Windows
  if(get_osType() eq 'WIN')
  {
    #Set the ORACLE_HOME as needed by the host OSD call
    $ENV{ORACLE_HOME} = $ENV{LL_ORACLE_HOME};
    my @results =  hostOSD::getCcrOsRegisteredSwMetric();
    my ($row, $ref);

    #The data from the earlier call is now in hostOSD::ccrData hashmap
    foreach $row(keys %hostOSD::ccrData)
    {
      $ref = $hostOSD::ccrData{$row};

      EMD_PERL_DEBUG("Checking product= $ref->{NAME} ");
      if( $ref->{NAME} =~ /^$product/i)
      {
        push(@installLocations ,$ref->{INSTALLED_LOCATION});
      }
    }
  }
  return @installLocations ;
}

