#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/CRSCTLActiveSoftVersion.pl /main/2 2010/03/11 05:21:09 nmittal Exp $
#
# CRSCTLActiveSoftVersion.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      CRSCTLActiveSoftVersion.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED       (MM/DD/YY)
#    raankire        02/11/10 - Creation
# 
#
#
#
#
###############################################################################
#This perl gives the Active version and Software version of CRCTL on Rac machine
#For Getting Active version, We are executing the command:::crsctl query crs activeversion
#
#For getting Software Version ,We are executing the command:::crsctl query crs softwareversion
#
#And the passing the output to get the exact version field from the command output
#
##############################################################################
use strict;
use File::Spec;
require "semd_common.pl";
require "emd_common.pl";

##Getting the CRSHome
my @crsHomes = getCRSHomes();

my $CRSHome=$crsHomes[$#crsHomes];

my $oracle_home=$ENV{ORACLE_HOME};
##If the CRShome is null then set Oracle Home as CRSHome
if (!defined $CRSHome) {
        $CRSHome=$oracle_home;
}

my $crs_activeversion;
my $crs_softwareversion;

my $crsctl_file=File::Spec->catfile( $CRSHome, "bin", "crsctl" );

if ((-f $crsctl_file) || (-f $crsctl_file.".exe")) {
                EMD_PERL_DEBUG("crsctl File found:$crsctl_file");
                my $i;
                my @cmd_output_act=`$crsctl_file query crs activeversion 2>&1` or EMD_PERL_DEBUG("Unable to execute CRSCTL for activeversion");
                my $status_exit_act=$?;
                EMD_PERL_DEBUG("crsctl activeversion command output status:$status_exit_act, Please see the following output");
##Now logging the output of the crsctl command for easy debugging
                foreach my $output_debug (@cmd_output_act) {
                EMD_PERL_DEBUG("$output_debug \n");
                }
                if ($status_exit_act == 0){ 
			my @res_1=split(/\[/,$cmd_output_act[0],2);
			my $res_str1=$res_1[1];
			my @res_2=split(/\]/,$res_str1);
			my $res_str2=$res_2[0];
			$crs_activeversion=$res_str2;
			# print "em_result=$crs_activeversion\n";
			
                }

                my @cmd_output_soft=`$crsctl_file query crs softwareversion 2>&1` or EMD_PERL_DEBUG("Unable to execute CRSCTL for softwareversion");
                my $status_exit_soft=$?;
                EMD_PERL_DEBUG("crsctl softwareversion command output status:$status_exit_soft, Please see the following output");
##Now logging the output of the crsctl command for easy debugging
                foreach my $output_debug (@cmd_output_soft) {
                EMD_PERL_DEBUG("$output_debug \n");
                }
                if ($status_exit_soft == 0){
                        my @res_1=split(/\[/,$cmd_output_soft[0]);
                        my $res_str1=$res_1[2];
                        my @res_2=split(/\]/,$res_str1);
                        my $res_str2=$res_2[0];
                        $crs_softwareversion=$res_str2;
                 }
	        if ($status_exit_act == 0 or $status_exit_soft == 0) {	
		print "em_result=$crs_activeversion|$crs_softwareversion\n";
  		}
                
}
else {
        EMD_PERL_DEBUG("crsctl File NOT found");
}

