#############################################################################
# $Header: ChronosDbmTypes.pm 15-sep-2004.03:29:03 snakhoda Exp $
# Copyright (c) 2001, 2004, Oracle. All rights reserved.  
#
# Author      : Shehzaad Nakhoda
# Description : This module consists of a hash containing meta-information 
#               about various dbm implementations
#
#  MODIFIED    (MM/DD/YY)
#     snakhoda  09/15/04 - move deleteHash to ChronosHash.pm 
#     snakhoda  04/22/04 - move deleteHash from chronos_mining.pl 
#     snakhoda  11/10/03 - improve 3217842 - remove defaultDbm
#     snakhoda  10/29/03 - bug 3217842: osd changes for non-Solaris 
#     snakhoda  09/24/03 - snakhoda_bug-3103887 
#     snakhoda  09/15/03 - Created
#
#############################################################################

package ChronosDbmTypes;
use Exporter;
use vars qw(@ISA @EXPORT);

@ISA = qw(Exporter);
@EXPORT_OK = qw(@dbmTypes deleteHash);

## Note: make sure that the leading period (if applicable) is present
## in all entries in exts.
@dbmTypes = (
             {
		 implname =>  "ndbm",  
		 maxdatasize => 
		 {
                     "solaris" => 1018,
                     "*" => 1008
		 },
		 module =>  "NDBM_File.pm", 
		 exts   =>  [".dir",".pag"] 
	     },
	     {
		 implname => "sdbm", 
		 maxdatasize => 
		 {
		     "*" => 1008
	         },
		 module =>  "SDBM_File.pm", 
		 exts   =>  [".dir",".pag"] 
	     },
	     {
		 implname => "*",
		 exts => [""]		 
	     }
	   );


