#
#  $Header: ChronosFilter.pm 26-jun-01.14:34:41 asawant Exp $
#
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      ChronosFilter.pm - Chronos Filter
#
#    DESCRIPTION
#      This class provies the chronos mining engine (CME for short) an
#     interface to access filter information.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#     asawant    06/18/01 - Creation (modified from ver. provided by jmarfati).
#
#

package ChronosFilter;
use strict;
use IO::File;

sub trace
{
  print("@_\n");
}

# Usage new(class name, err message ref, filter file name)
# Returns a valid filter object in case of success or undef in case of failure
sub new
{
  my ($class, $err_ref, $file_name) = @_;

  my $self =
  {
    file_name => $file_name,
    file_object => new IO::File,
    filter_array => []
  };

  bless $self, $class;

  #trace("Open file Read Only.");
  unless($self->{file_object}->open("<".$self->{file_name}))
  {
    $$err_ref = "$!Failed opening file.\n";
    return undef;
  }

  #trace("Parse file");
  unless($self->parse())
  {
    $$err_ref = "Failed parsing file, or parse file empty.\n";
    $self->{file_object}->close();
    return undef;
  }

  unless($self->{file_object}->close())
  {
    $$err_ref = "$!\nFailed closing file.\n";
    return undef;
  }

  return $self;
}

# Usage parse(self)
# Parses a log file and populates the filter array
sub parse
{
  my ($self) = @_;

  my $line;
  my $tmp_file_object = $self->{file_object};
  while ($line = <$tmp_file_object>)
  {
    chomp($line);
    # Ignore comment lines. See that full space lines, WILL go through!
    unless($line =~ /^#/)
    {
      # add it to the filter array
      #trace("Filter: $line");
      push @{$self->{filter_array}}, $line;
    }
  }
  # verify that at least one filter line exists
  unless(@{$self->{filter_array}})
  {
    return 0;
  }
  return 1;
}

# Usage is_uri_valid(self, uri)
# Returns 1 if the URI belongs to ANY of the filter regular expressions and
# returns 0 otherwise.
sub is_uri_valid
{
  my ($self, $uri) = @_;

  # check for all filters
  my $filter_exp;
  foreach $filter_exp (@{$self->{filter_array}})
  {
    if($uri =~ /$filter_exp/)
    {
      #trace("Page $uri matches.");
      return 1;
    }
  }
  #trace("Page $uri doesn't match.");
  return 0;
}

# Make use return 1
1;
