#
#  $Header: ChronosIncompleteLoadHash.pm 19-aug-2005.18:26:30 adosani Exp $
#
#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      ChronosIncompleteLoadHash.pm
#
#    DESCRIPTION
#      Perl module for organizing request-level data produced by Chronos Mining Engine.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#     adosani     08/19/05 - fix bug 4564334 - change strftime format string
#                            to make it more standard (work on NT).
#     adosani     03/02/05 - convert server time to milliseconds
#     snakhoda    12/17/04 - snakhoda_chronos_gu2
#     snakhoda    10/12/04 - Creation
#
#
package ChronosIncompleteLoadHash;
use strict;
use POSIX qw(strftime);
sub new
{
    my ($class, $outFileObject) = @_;
    my %hashByHourStamp = ();
    my $self = 
    {
	hashByHourStamp => \%hashByHourStamp,
	outFileObject => $outFileObject,
    };
    bless($self, $class);
}


sub add_entry
{
    my ($self, $page, $serverTime, $timeStampUSecs) = @_;
    my $hourStamp = '';
    $serverTime = $serverTime/1000; # convert to milliseconds (from microseconds)

    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
	localtime($timeStampUSecs/1000000);
    $sec = 0;
    $min = 0;
    my $hourStamp = strftime("%Y-%m-%d %H:%M:%S",$sec, $min, $hour, $mday, $mon, $year);


    # first level key is timeStamp since a given run should rarely
    # have multiple hours, so this will avoid repetition in the value.
    my $hourEntry = $self->{hashByHourStamp}->{$hourStamp};
    if(!$hourEntry)
    {
	$self->{hashByHourStamp}->{$hourStamp} = {};
	$hourEntry = $self->{hashByHourStamp}->{$hourStamp};
    }
    my $pageEntry = $hourEntry->{$page};    
    if(!$pageEntry)
    {
	$hourEntry->{$page} = {
	    numIncompleteLoads => 1,
	    averageServerTime => $serverTime
	    };
    } else {
	my $numIncompleteLoads = $pageEntry->{numIncompleteLoads};
	$pageEntry->{averageServerTime} = ($pageEntry->{averageServerTime} * $numIncompleteLoads + $serverTime) / ($numIncompleteLoads + 1);
	$pageEntry->{numIncompleteLoads} ++;
	}
}

sub createOutput
{

    my ($self, $target_guid, $error) = @_;

    foreach my $hour (keys %{$self->{hashByHourStamp}})
    {
	foreach my $page (keys %{$self->{hashByHourStamp}->{$hour}})
	{	   
	    my $pageData = $self->{hashByHourStamp}->{$hour}->{$page};
		$self->{"outFileObject"}->add_incomplete_loads_line(\$error,
		    [ $target_guid, $page, $pageData->{numIncompleteLoads}, 
		      $pageData->{averageServerTime}, $hour
		      ]);
	}
    }
}
1;
