#
#  $Header: ChronosPageParams.pm 16-mar-2005.17:15:17 adosani Exp $
#
#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      ChronosPageParams.pm
#
#    DESCRIPTION
#      This class provies the chronos mining engine (CME for short) an
#     interface to page parameter support
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#     adosani     03/16/05 - pass string for post params instead of hash
#     adosani     02/16/05 - fix MatchUrlParams
#     snakhoda    12/17/04 - snakhoda_chronos_gu2
#     snakhoda    10/12/04 - Creation (functionality moved out from chronos_mining.pl)
#
#

package ChronosPageParams;
use strict;

# Usage new(class name, err message ref, filter file name)
# Returns a valid page params object in case of success or undef in case of failure
sub new
{
    my ($class, $debug, $err_ref, $pageidparams, $queryDelimiterRegexp, $qParamDelimiterRegexp) = @_;

    my @urlParams={};
    my $param="";
    my $paramlist="";
    my $url="";
    my $uparams="";
    my %URLParams;
    my @URLParamsKeys={};
    my $allURLS;
    my $parameterizedURL;
    my $parameters;

    if ($pageidparams =~ m/.*\:.*/o) 
    {
	$allURLS = 0;
	@urlParams=split /\;/,$pageidparams;
	foreach $uparams (@urlParams)
	{
	    my @params={};

	    if(($url,$paramlist) = $uparams =~ m/(.*)\:(.*)/o)
	    {
		@params=split /\,/,$paramlist;
		$URLParams{$url}=\@params;
	    }
	}
	# sort urls bases on their depth in path using
	# sort routine below
	# sort using routine based on depth
	@URLParamsKeys = sort UrlSort keys %URLParams;
	if (@URLParamsKeys=={})
	{
	    return undef;
	}
    }  else {
	# these params apply to all urls
	$allURLS = 1;
	my @params=split /\,/,$pageidparams;
	$parameters = \@params; 
	if ($parameters == {}) 
	{
	    return undef;
	}
    }

    my $self =
    {
	debug => $debug,
	paramsUrlHash => \%URLParams,
	urlkeys => \@URLParamsKeys,
	parameters => $parameters,
	allURLS => $allURLS,
	queryDelimiterRegexp => $queryDelimiterRegexp,
	qParamDelimiterRegexp => $qParamDelimiterRegexp
	    
	};

    bless $self, $class;

    return $self;
}

##########################################################################
# Returs a regular expression that matches one of the characters in the 
# argument.
# Used to create a regular expression to match one of a number of possible
# delimiting characters in query strings
#
# IN: string containing delimiter characters
# RETURN: reg exp string of the form: [a|b|c]
##########################################################################
sub getDelimiterRegexp
{
    my ($delimiterChars) = @_;
    my $perlMetaChars = '{}[]()^$.|*+?\\';
    my $delimiterRegexp = ']';
    my $appendBar = 0;
    while(my $thisChar = chop($delimiterChars))
    {
	if($appendBar) {
	    $delimiterRegexp = $thisChar. '|'. $delimiterRegexp;
	} else {
	    $delimiterRegexp = $thisChar.$delimiterRegexp;
	    $appendBar = 1;
	}
	if(index($perlMetaChars, $thisChar) != -1) 
	{
	    $delimiterRegexp = '\\'.$delimiterRegexp;
	}
    }
    $delimiterRegexp = '['.$delimiterRegexp;
    return $delimiterRegexp;
}    

###################################################################### 
#     MatchUrlParam : Match params from url param list to user 
#                     provided param list
#     Context in:
#                     @urlparamlist
#                     @userparamlist
#     Context out:
#                     $page
###################################################################### 

sub MatchUrlParams
{
    my ($urlParamsRef,$configParamsRef, $page, $postParamsRef)=@_;

    my $matchedparam=0;
    my $parameter="";
    my $urlparam="";
    my @urlParams=@$urlParamsRef;
    my @parameters=@$configParamsRef;
    my @postParameters =@$postParamsRef;
    my $j=1;

    foreach $parameter (@parameters)
    {
	$matchedparam=0;
	my $parameterHasValue = (index($parameter, "=") != -1);
	my $parameterPlusEquals = "";
	if(!$parameterHasValue)
	{
	    $parameterPlusEquals = $parameter."=";
	}
	foreach $urlparam (@urlParams)
	{
	    if ($matchedparam) {
		last;
	    }
	    if (($parameterHasValue && ($urlparam eq $parameter)) ||
		((!$parameterHasValue) && (index($urlparam,$parameterPlusEquals) == 0)))
	    {
		if ($j==1) {
		    $page=$page.'?'.$urlparam;
		} else { 
		    $page=$page.'&'.$urlparam;
		}
		$j++;
		$matchedparam=1;
	    } 
	}
	foreach my $postParam (@postParameters)
	{
	    #my $postParamPlusValue = $postParam . "=" . $postParameters{$postParam};
	    if ($matchedparam) {
		last;
	    }
	    if (($parameterHasValue && ($postParam eq $parameter)) ||
		((!$parameterHasValue) && (index($postParam,$parameterPlusEquals) == 0)))
	    {
		if ($j==1) {
		    $page=$page.'?'.$postParam;
		} else { 
		    $page=$page.'&'.$postParam;
		}
		$j++;
		$matchedparam=1;
	    } 
	}
    }
    return ($page);
}

sub getOutputPage
{
    my ($self, $queryStr, $page, $postParamString) = @_;
    my $outputPage = $page;
    my $qParamDelimiterRegexp = $self->{"qParamDelimiterRegexp"};
    if ($self->{allURLS})
    {
	my $parametersRef=$self->{"parameters"};
	my @urlParams = split /$qParamDelimiterRegexp/, $queryStr;
        my @postParams = split /$qParamDelimiterRegexp/, $postParamString;
	$outputPage = MatchUrlParams(\@urlParams,$parametersRef,$page,\@postParams);
	$self->{debug}->PrintTrace("Matched URL param $page");
    } else {
	# 
	# should now be able to match parameters with respective url against parameters provided  
	# by user
	#         
	$self->{debug}->PrintTrace("Matching URLS");
	my $urlkeysRef = $self->{urlkeys};
	my $matchedurl = 0;
	foreach my $urlVal (@$urlkeysRef)
	{
            if ($matchedurl)
            {
		last;
            }
	    my $lastUrlValChar = substr($urlVal, -1, 1);
            if($lastUrlValChar eq "/") 
	    {
		# if the last character in the specification is a / 
		# (e.g. "/" or "/a/") then do a  substring match
		# this means /abc/def will match spec /def
		if(index($page, $urlVal)<0) 
		{
		    next;
		}
	    } else # the last character is not a slash
	    {
		if(!($page eq $urlVal))
		{
		    if(index($page, $urlVal."/") < 0)
		    {
			next;
		    }
		}	
	    }
	    # url matched
	    $matchedurl=1;
	    my $parametersRef = $self->{'paramsUrlHash'}->{$urlVal};
	    my @urlParams = split /$qParamDelimiterRegexp/, $queryStr;
            my @postParams = split /$qParamDelimiterRegexp/, $postParamString;
	    $outputPage = MatchUrlParams(\@urlParams,$parametersRef,$page,\@postParams);
	}
    }
    return $outputPage;
}

##########################################################################
# UrlSort: Sort routine that returns order in which elements need to 
# be sorted for url, params input parameters
#
##########################################################################
sub UrlSort
{
   my @numpaths_a;
   my @numpaths_b;

   @numpaths_a=split /\//,$a;
   @numpaths_b=split /\//,$b;

   #descending order of depth

   $#numpaths_b <=> $#numpaths_a;

}

# Make use return 1
1;
