#
#  $Header: ChronosRequestsHash.pm 29-aug-2005.11:30:31 adosani Exp $
#
#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      ChronosRequestsHash.pm
#
#    DESCRIPTION
#      Perl module for organizing request-level data produced by Chronos Mining Engine.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#     adosani     08/29/05 - fix bug 4571442 - request url should not be empty
#     adosani     08/19/05 - fix bug 4564334 - change strftime format string
#                            to make it more standard (work on NT).
#     snakhoda    12/17/04 - snakhoda_chronos_gu2
#     snakhoda    10/12/04 - Creation
#
#
package ChronosRequestsHash;
use strict;
use POSIX qw(strftime);

sub new
{
    my ($class, $outFileObject) = @_;
    my %hashByHourStamp = ();
    my $self = 
    {
	hashByHourStamp => \%hashByHourStamp,
	outFileObject => $outFileObject
	};
    bless($self, $class);
}


sub add_elements
{
    my ($self, $refPage, $pageElemArrayRef, $timeStampUSecs) = @_;
    my $hourStamp = '';

    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = 
	localtime($timeStampUSecs/1000000);
    $sec = 0;
    $min = 0;
    my $hourStamp = strftime("%Y-%m-%d %H:%M:%S",$sec, $min, $hour, $mday, $mon, $year);
    
    # first level key is timeStamp since a given run should rarely
    # have multiple hours, so this will avoid repetition in the value.    
    my $hourEntry = $self->{hashByHourStamp}->{$hourStamp};
    if(!$hourEntry)
    {
	$self->{hashByHourStamp}->{$hourStamp} = {};
	$hourEntry = $self->{hashByHourStamp}->{$hourStamp};
    }
    my $refPageEntry = $hourEntry->{$refPage};    
    if(!$refPageEntry)
    {
	$hourEntry->{$refPage} = {};
	$refPageEntry = $hourEntry->{$refPage};
    }
    foreach my $pageElem (@{$pageElemArrayRef})
    {
	my $requestUrl = $pageElem->{elem};
	my $pageRequestMap = $refPageEntry->{$requestUrl};
	if (!$pageRequestMap)
	{
	    $refPageEntry->{$requestUrl} = {
		numCached => 0,
		numNonCached => 0,
		cachedSvrTime => 0,
		nonCachedSvrTime => 0		    
		};
	    $pageRequestMap = $refPageEntry->{$requestUrl};
	}
	if($pageElem->{x_cache} eq 'H')
	{
 	    my $numCached = $pageRequestMap->{numCached};
	    $pageRequestMap->{cachedSvrTime} = ($pageRequestMap->{cachedSvrTime} * $numCached + (($pageElem->{xte}- $pageElem->{xts})/1000))/($numCached + 1);
	    $pageRequestMap->{numCached}++;
	} else { ## non-cached
	    my $numNonCached =$pageRequestMap->{numNonCached};
	    $pageRequestMap->{nonCachedSvrTime} = ($pageRequestMap->{nonCachedSvrTime} * $numNonCached + (($pageElem->{xte}-$pageElem->{xts})/1000))/($numNonCached + 1);
	    $refPageEntry->{$requestUrl}->{numNonCached}++;		    
	}	
    }	    
}


sub createOutput
{

  my ($self, $target_guid, $errorRef) = @_;

  foreach my $hour (keys %{$self->{hashByHourStamp}})
  {
    foreach my $page (keys %{$self->{hashByHourStamp}->{$hour}})
	  {	   
	    foreach my $request (keys %{$self->{hashByHourStamp}->{$hour}->{$page}})
	    {
        if ($request) {
		      my $requestData = $self->{hashByHourStamp}->{$hour}->{$page}->{$request};
		      $self->{"outFileObject"}->add_pr_mapping_line($errorRef,
		        [ $target_guid, $page, $request, $requestData->{numCached},
		          $requestData->{cachedSvrTime}, $requestData->{numNonCached},
		          $requestData->{nonCachedSvrTime}, $hour
		        ])
	      } 
      }
	  }
  }
}
1;
