#!usr/bin/perl
#
# Copyright (c) 1998, 2004, Oracle. All rights reserved.  
#
# NAME:
#
#  FormsProcessInfo.pl -- Forms runtime Processes Information
#                         determines the oc4j process id and child forms
#                         processes returned in the format:
#                         <oc4j_pid>|<forms_pid>,<forms_pid>,...
#
#                         This perl is intended to be generic. The file 
#                         formsinit.pl can be modified or ported to specific 
#                         environments by writing the routines get_oc4j_pid() 
#                         and get_forms_pids(). The former returns an array of 
#                         oc4j OC4J_BI_Forms process ids, the latter an array 
#                         of matching forms processes.
#
# ARGUMENTS:
#
#  argv(0) - scriptsDir
#  argv(1) - oracle_home string
#
#
# MODIFIED     (MM/DD/YY)
#  sbalacha     12/13/04  - #(4017604)
#  clowes       04/01/04  - 3133205 for Linux, taking newline out of em_result
#  dklein       02/25/04 -  Included dejvm90 processes
#  clowes       09/09/03 -  #(3133205) and #(3122105) Changes to formsinit
#                           to accomodate Linux allowed simplification of 
#                           this file
#  clowes       05/22/03 -  Creation
#
$scriptsDir = $ARGV[0];
$oraHome = $ARGV[1];
$frm_orahome = $oraHome;
$em_result  = "";
$OC4J_BI_FORMS = "OC4J_BI_Forms";
$OC4J_JAR = "oc4j.jar";
$foundFormsProcesses = "no";

require ("$scriptsDir/formsinit.pl");

#
# run "ps" command to find the oc4j process
# 
# the subroutine get_oc4j_pid needs to return the pid of the 
# oc4j processes in the array oc4j_processes declared in 
# formsinit.pl
#
&get_oc4j_pid("$OC4J_JAR", "$OC4J_BI_FORMS", "$oraHome");
for ($oc4j_index=0; $oc4j_index <= $#oc4j_processes ; $oc4j_index++)
{
    $oc4j_pid = @oc4j_processes->[$oc4j_index];

    #
    # run ps command to get runtime instances who have a parent 
    # process matching OC4J_BI_Forms, and with executable name we are
    # expecting. If we have any, append them to the em_result delimited
    # with a ",".
    # We only want to do this if we've found an oc4j_pid
    #
    if ( ($oc4j_pid) && ($foundFormsProcesses eq "no") )
    {
        $em_result = "$oc4j_pid|";
        &get_forms_pids("$oc4j_pid", "$oraHome", "$frmexename");

        for ($pid_index=0; $pid_index <= $#forms_processes ; $pid_index++)
        {
            @forms_process = split(" ", @forms_processes->[$pid_index]);
            $rti90file  = 
                    "$oraHome$emhome/em_$forms_process[$PID_COL].rti";
            if (-r $rti90file) 
            {

                if ( $foundFormsProcesses eq "no" )
                {
                    $pid_sep = "";
                }
                else
                {
                    $pid_sep = ",";
                }
   
                $foundFormsProcesses = "yes";

                $em_result = "$em_result$pid_sep$forms_process[$PID_COL]";

            } # if -- we have a forms process with matching rti file

        } # for -- on matching forms processes for this oc4j process

    } # if we've not found matching forms processes 


} # for -- loop on candidate oc4j processes

#
# JVM processes
foreach $_ (`$PS`)
{
    if (/$_[0]/)
    {
        if (/$dejvmexename/)
        {
            @dejvm_process = split(" ",$_);
            $em_result = "$em_result$pid_sep$dejvm_process[$PID_COL]";
        }
    }
}
#
# if we failed to find the oc4j process then we 
# need to return "|"
#
if ( !($em_result) )
{
    $em_result="|";
}
print "$em_result";

