# $Header: JServProcessInfo.pl 05-sep-2003.10:42:02 klmichae Exp $
#
# JServProcessInfo.pl
# 
# Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      JServProcessInfo.pl - gets the pids for all JServ processes
#
#    DESCRIPTION
#      JServProcessInfo.pl <script_dir> <oracle_home> 
#
#      where:
#         <script_dir> is filepath of the scripts directory
#         <oracle_home> is the oracle home in which the iAS is installed
#
#    returns: 
#      [start-pid]|[comma-separated-pid-list]
#
#      where:
#         <start-pid> the pid that represents that start time of JServ.  We will
#          specify the apache pid here
#         <comma-separated-pid-list> a comma separated list of pids for the 
#          JServ processes
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    klmichae   09/05/03 - remove leading and trailing spaces from pid 
#    echolank   08/07/03 - echolank_more-ias-central-changes 
#    klmichae   06/04/03 - klmichae_jserv_metrics
#    klmichae   06/04/03 - Initial revision

use strict;
require "iasresourceusage.pl";

  # Find all the jserv processes
  my $start_pid = "";
  my $pid_list = "";
  my $ps_command = getPsCommand();
  my $ps_output = `$ps_command | grep java | grep $ARGV[1] | grep org.apache.jserv.JServ`;
  my @lines = split( "\n", $ps_output );
  foreach my $line (@lines)
  {
    # The output will be in the form: 
    # {USER} {PID} {%CPU} {%MEM} {SZ} {RSS} {TT} {S} {START TIME} {COMMAND}
    my @tokens = split( " ", $line );
    # see if this is the first pid
    if( $start_pid eq "" ) 
    {
      # Get the start pid.  It will be the top apache process, which is the 
      # this process.  Then remove leading and trailing spaces.
      $start_pid = `/bin/ps -p $tokens[1] -o \"ppid\" | tail -1`;
      ($start_pid) = split( " ", $start_pid );

      # put this pid onto the list
      $pid_list = $tokens[1];
    } else {
      # add the pid to the list
      $pid_list = "$pid_list,$tokens[1]";
    }
  } # end foreach $line 

  # print the pids
  print "$start_pid|$pid_list";
