#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/LLInventoryParser.pl /main/7 2010/08/17 03:19:37 asunar Exp $
#
# LLInventoryParser.pl
# 
# Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      LLInventoryParser.pl - contains the implementation as a routine
#
#    DESCRIPTION
#      parses OUI inventory from given path
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    asunar      08/11/10 - Avoiding the unnecessary warning messages being
#                           displayed during the execution of
#                           ias/IASgetGeneral.pl
#    hmodawel    07/15/10 - fusionAppsPatchHistory.xml is now in
#                           APPL_TOP/faPatchInventory
#    irraju      06/30/10 - adding support for PSUs
#    irraju      06/17/10 - Support for Fusion App Patches
#    irraju      06/17/10 - handle same components with different versions
#    jsutton     03/31/10 - Get version along with component name for TOPLEVEL
#    hmodawel    08/01/09 - parse OPatchs inventory.xml
#    irraju      04/27/09 - ER 8339765 ER 8206032
#    jsutton     06/25/08 - Creation
# 
use File::Spec;
use ias::simpleXPath;
use XML::Parser;
use List::Util qw(max);
use strict;
use warnings;
package LLParseInventory;


our $invParseFailure = 0;

our %homes;
our %comps;
our %deps;
our %patches;
our %patchsets;
our %oneoffs;
our %psuComps;#We need a separate hash for psu affected components because we need to process them in the ascending order of from_versions

our $Hfound   = 0;
our $Cfound   = 0;
our $Dfound   = 0;
our $DLfound  = 0;
our $Pfound   = 0;
our $PSfound  = 0;
our $PSPfound = 0;
our $OOfound  = 0;
our $BugsFound= 0;
our $refCount = 0; # to count affected components
our $inTopLevel = "FALSE";

our $inComp     = "FALSE";
our $inPatch    = "FALSE";
our $inPatchSet = "FALSE";
our $inOneOff   = "FALSE";

our $inExtName  = "FALSE";
our $inDesc     = "FALSE";
our $inDepList  = "FALSE";
our $skipGroup  = "FALSE";
our $inBugList  = "FALSE";
our $inBug      = "FALSE";
our $inRefList  = "FALSE";

our @bugList; # array to hold all the bugs in the current patch(one off)
our @refList; #arry of hashes to hold all the components in the current one off. Each hash  contains only one entry. Component name as key and its version as value.
  
our %months = ( Jan => '01',
               Feb => '02',
               Mar => '03',
               Apr => '04',
               May => '05',
               Jun => '06',
               Jul => '07',
               Aug => '08',
               Sep => '09',
               Oct => '10',
               Nov => '11',
               Dec => '12',
             );

# Expat built-in encodings are UTF-8, iso-8859-1 [west european], UTF-16, and US-ASCII
# the remainder are from the various .enc files included with our perl distribution
my @encTable = (
  'US-ASCII',
  'iso-8859-1',        # [west european, a.k.a. Latin1]
  'windows-1252',      # [win Latin1 (8859-1 superset)]
  'iso-8859-2',        # [east european]
  'windows-1250',      # [win Latin2 (8859-2 superset)]
  'iso-8859-3',        # [south european]
  'iso-8859-4',        # [north european]
  'iso-8859-5',        # [cyrillic]
  'iso-8859-7',        # [greek]
  'iso-8859-8',        # [hebrew]
  'iso-8859-9',        # [turkish]
  'UTF-8',
  'UTF-16',
  'big5',              # [traditional chinese]
  'euc-kr',            # [extended unix code for korean]
  'x-euc-jp-jisx0221', # [extended unix code for japanese, JIS X0221]
  'x-euc-jp-unicode',  # [extended unix code for japanese, unicode]
  'x-sjis-cp932',      # [shift-jis win codepage 932]
  'x-sjis-jdk117',     # [shift-jis JDK117]
  'x-sjis-jisx0221',   # [shift-jis JIS X0221]
  'x-sjis-unicode',    # [shift-jis unicode]
);


sub getInfo {
  # Get the components in this home
  my ($oracleHome, $elType, $compName) = @_;
  my ($compsFile) = File::Spec->catfile("$oracleHome","inventory","ContentsXML","comps.xml");

  if (-e $compsFile)
  {
    my $p2 = new XML::Parser(ErrorContext => 2);
  
    $p2->setHandlers(Start => \&handle_comps_start, 
                     End => \&handle_comps_end,
                     Char => \&handle_comps_char);
  
    eval '$p2->parsefile($compsFile)';
  
    if ($@)
    {
      foreach $_ (@encTable)
      {
        %homes = ();
        %comps = ();
        %deps = ();
        %patches = ();
        %patchsets = ();
        %oneoffs = ();
        %psuComps= ();
  
        eval '$p2->parsefile($compsFile, ProtocolEncoding => $_)';
  
        if (!$@)
        {
          last;
        }
      }
    }
    if ($@)
    {
      print "$compsFile failed validation. Giving up\n";
      $invParseFailure = 1;
    }
  }
  
  if ($invParseFailure == 1)
  {
    print STDERR "em_error=$compsFile parse failed.\n";
    exit 0;
  }
  
  
  # Also parse OPatch's patch specific inventory.xml for each 
  # patch collected
  foreach my $ooInf(sort keys %oneoffs)
  {
    # Construct Opatch's metadata file location  
    my ($patchFile) = $oracleHome."/inventory/oneoffs/".$oneoffs{$ooInf}->{_REF_ID}."/etc/config/inventory.xml";
    my ($patchFileOldVer) = $oracleHome."/inventory/oneoffs/" .$oneoffs{$ooInf}->{_REF_ID}."/etc/config/inventory";
    my $fileOpened=0;
    # if inventory.xml exists in the oneoff dir
    if ( (-e $patchFile) || (-e $patchFileOldVer) )
    {
      #the file exists
      if(-e $patchFile)
      {
        if(open(ONE_OFF_INV_FILE,"<$patchFile"))
        {
          $fileOpened = 1;
        }
      }
      else
      {
        if(open(ONE_OFF_INV_FILE,"<$patchFileOldVer"))
        {
          $fileOpened = 1;
        }
      }
      if($fileOpened)
      {
       #read lines and grep for the string
       my(@lines) = <ONE_OFF_INV_FILE>;
       my $all_lines = join ' ', @lines;
       if($all_lines =~ m|<unique_patch_id>(.*)<\/unique_patch_id>|s)
       {
         my $linesBtTags = $1;
         $linesBtTags =~s|\r?\n| |gs;
         $oneoffs{$ooInf}->{_UPI} = $linesBtTags;                
       }
       #close the file 
       close(ONE_OFF_INV_FILE);
      }
    }
  } 
  
  # UPDATE the latest component considering PSUs
  foreach my $compDep (sort keys %psuComps)
  {
   #gives the component dependencies in the ascending order of fromversion
   my($comp,$fromVer) = split('\|',$compDep);
   unless(my $baseVer = getCompBaseVer($comp,$fromVer))
   {
    #component doesn't exist
    #
    print "em_warning=".
          "PSU has been applied on $comp $fromVer which doesn't exist\n";
     
   }
   else
   {
    #update the latest version
    updateCompLatestVer($comp,$baseVer,$psuComps{$compDep});
   }
  }
  # FUSION APP PATCHES
  # Fusion app patches will the collected by CCR kit installed inside the fusion app home.
  # fusionAppsPatchHistory.xml will be right inside it. If this xml contains fully qualified
  # component's name, we do not require pfOUIMapping.xml
  getFusionAppPatches($oracleHome);
   
  # at this point we've parsed the inventory (comps.xml)	
  # now, based on the type of info we want, spit it out	
  # in em_result format
  
  my ($comp,$depInfo,$patch);
  if ($elType eq "COMPONENTS")
  {  
    foreach $comp(sort keys %comps)
    {
      my $ref = $comps{$comp};
      print "em_result=".
          (defined($ref->{_NAME}) ? $ref->{_NAME} : "") . "|".
          (defined($ref->{_VER}) ? $ref->{_VER} : "") . "|".
          (defined($ref->{_DESC}) ? $ref->{_DESC} : "") . "|".
          (defined($ref->{_EXT_NAME}) ? $ref->{_EXT_NAME} : "") . "|".
          (defined($ref->{_LANGS}) ? $ref->{_LANGS} : "") . "|".
          (defined($ref->{_INST_LOC}) ? $ref->{_INST_LOC} : "") . "|".
          (defined($ref->{_ACT_INST_VER}) ? $ref->{_ACT_INST_VER} : "") . "|".
          (defined($ref->{_DEINST_VER}) ? $ref->{_DEINST_VER} : "") . "|".
          (defined($ref->{_IS_TOP_LEVEL}) ? $ref->{_IS_TOP_LEVEL} : "") . "|".
          (defined($ref->{_TIMESTAMP}) ? $ref->{_TIMESTAMP} : "") . "\n";
    }
  }   
  elsif ($elType eq "TOPLEVEL")
  {
    my $retInfo="";
    foreach $comp(sort keys %comps)
    {
      my $ref = $comps{$comp};
      if (defined($ref->{_IS_TOP_LEVEL}) && $ref->{_IS_TOP_LEVEL} eq "Y")
      {
        $retInfo .= $ref->{_NAME} . " " . $ref->{_VER} . "\n";
      }
    }
    return $retInfo;
  }
  elsif ($elType eq "COMP_DEPS")
  {
    foreach my $comp(sort keys %comps)
    {
      my $ref = $comps{$comp};
      my $dependee = (defined($ref->{_NAME}) ? $ref->{_NAME} : "");
      my $dependVer = (defined($ref->{_VER}) ? $ref->{_VER} : "");
  
      foreach $depInfo (keys %{$comps{$comp}->{_DEP_LIST}})
      {
        $ref = $comps{$comp}->{_DEP_LIST}->{$depInfo};
        print "em_result=".$dependee."|".$dependVer."|".
            (defined($ref->{_NAME}) ? $ref->{_NAME} : "") . "|".
            (defined($ref->{_VER}) ? $ref->{_VER} : "") . "\n";
      }
    }
  }
  elsif ($elType eq "PATCHSETS")
  {
    foreach my $pSet(sort keys %patchsets)
    {
      my $ref = $patchsets{$pSet};
      print "em_result=".
          (defined($ref->{_NAME}) ? $ref->{_NAME} : "") . "|".
          (defined($ref->{_VER}) ? $ref->{_VER} : "") . "|".
          (defined($ref->{_DESC}) ? $ref->{_DESC} : "") . "|".
          (defined($ref->{_EXT_NAME}) ? $ref->{_EXT_NAME} : "") . "|".
          (defined($ref->{_ACT_INST_VER}) ? $ref->{_ACT_INST_VER} : "") . "|".
          (defined($ref->{_DEINST_VER}) ? $ref->{_DEINST_VER} : "") . "|".
          (defined($ref->{_TIMESTAMP}) ? $ref->{_TIMESTAMP} : "") . "\n";
    }
  }
  elsif ($elType eq "VERSIONED_PATCHES")
  {
    foreach my $patch(sort keys %patches)
    {
      my $patchSetName = undef;
      my $patchSetVer = undef;
      my $ref = $patches{$patch};
      # can we assume a patch is in at most one patchset?
      PATCHSET: foreach my $pSet(sort keys %patchsets)
      {
        foreach my $pspInfo (keys %{$patchsets{$pSet}->{_DEP_LIST}})
        {
          my $pspRef = $patchsets{$pSet}->{_DEP_LIST}->{$pspInfo};
          if ( (defined($pspRef->{_NAME})) && 
               (defined($pspRef->{_VER})) &&
               (defined($ref->{_NAME})) && 
               (defined($ref->{_VER})) )
          {
            if ( ($pspRef->{_NAME} eq $ref->{_NAME}) &&
                 ($pspRef->{_VER} eq $ref->{_VER}) )
            {
              $patchSetName = $patchsets{$pSet}->{_NAME};
              $patchSetVer = $patchsets{$pSet}->{_VER};
              last PATCHSET;
            }
          }
        }
      }
      print "em_result=".
          (defined($ref->{_NAME})         ? $ref->{_NAME} : "") . "|".
          (defined($ref->{_VER})          ? $ref->{_VER} : "") . "|".
          (defined($patchSetName)         ? $patchSetName : "") . "|".
          (defined($patchSetVer)          ? $patchSetVer : "") . "|".
          (defined($ref->{_DESC})         ? $ref->{_DESC} : "") . "|".
          (defined($ref->{_EXT_NAME})     ? $ref->{_EXT_NAME} : "") . "|".
          (defined($ref->{_LANGS})        ? $ref->{_LANGS} : "") . "|".
          (defined($ref->{_INST_LOC})     ? $ref->{_INST_LOC} : "") . "|".
          (defined($ref->{_DEINST_VER})   ? $ref->{_DEINST_VER} : "") . "|".
          (defined($ref->{_TIMESTAMP})    ? $ref->{_TIMESTAMP} : "") . "\n";
    }
  }
  elsif ($elType eq "ONEOFFS")
  {
    foreach my $ooInf(sort keys %oneoffs)
    {
      my $ref = $oneoffs{$ooInf};
      print "em_result=".
          (defined($ref->{_REF_ID}) ? $ref->{_REF_ID} : "") . "|".
          (defined($ref->{_ROLLBACK}) ? $ref->{_ROLLBACK} : "") . "|".
          (defined($ref->{_XML_INV_LOC}) ? $ref->{_XML_INV_LOC} : "") . "|".
          (defined($ref->{_ACT_INST_VER}) ? $ref->{_ACT_INST_VER} : "") . "|".
          (defined($ref->{_TIMESTAMP}) ? $ref->{_TIMESTAMP} : "") . "|".
          (defined($ref->{_UPI}) ? $ref->{_UPI} : "") . "|".
          (defined($ref->{_IS_PSU}) ? $ref->{_IS_PSU} : "N") . "|".
          (defined($ref->{_PATCH_TYPE}) ? $ref->{_PATCH_TYPE} : "") . "|".
          (defined($ref->{_LANG}) ? $ref->{_LANG} : "") . "\n"; 
    }
  }
  elsif($elType eq "PATCH_BUGFIX")
  {
        foreach my $ooInf(sort keys %oneoffs)
        {
              my $ref = $oneoffs{$ooInf};
              if(defined($ref->{_BUG_LIST}))
              {
                        for my $i( 0 .. $#{$ref->{_BUG_LIST} } )
                        {
                                print "em_result=".
                                (defined($ref->{_REF_ID}) ? $ref->{_REF_ID} : "") . "|".
                                (defined($ref->{_BUG_LIST}[$i]) ? $ref->{_BUG_LIST}[$i]:"") . "\n";
                         }
                }
        }
  }
  elsif($elType eq "PATCH_COMP")
  {
        foreach my $ooInf(sort keys %oneoffs)
        {
              my $ref = $oneoffs{$ooInf};
              if(defined ($ref->{_REF_LIST}))
              {
                    for my $i (sort keys (%{$ref->{_REF_LIST}}))
                    {
                        my $comp = $ref->{_REF_LIST}->{$i}->{_NAME};
                        my $ver = $ref->{_REF_LIST}->{$i}->{_VER};
                        my $fromVer = $ref->{_REF_LIST}->{$i}->{_FROM_VER};
                        my $toVer = $ref->{_REF_LIST}->{$i}->{_TO_VER};
                        unless($ver)
                        {
                         #PSU thats the reason _VER is not set
                         my $baseVer= getCompBaseVer($comp,$toVer);
                         $ver= $ref->{_REF_LIST}->{$i}->{_VER}= $baseVer;
                        }
                        print "em_result=".
                        (defined($ref->{_REF_ID}) ? $ref->{_REF_ID} : "") . "|".
                        (defined($comp) ? $comp : "") . "|".
                        (defined($ver) ? $ver : "") . "|".
                        (defined($fromVer) ? $fromVer : "") . "|".
                        (defined ($toVer) ? $toVer:"") . "\n";
                     }
               } 
        }
  }
  elsif($elType eq "GET_COMP_VER")
  {
   # Unlike other $elType this is not a metric. This part returns the latest 
   # version of the given component. If the component doesn't exist  we return
   # undef
   #
   return getCompLatestVer($compName); 
  }
}  
  
sub handle_comps_start
{
  my $p = shift;
  my $el = shift;

  if ($el eq "TL_LIST")
  {
    $inTopLevel = "TRUE";
  }
  elsif ($el eq "COMP")
  {
    $inComp = "TRUE";
    my $compInf = $comps{$Cfound};
    if (not defined($compInf))
    {
      $comps{$Cfound} = $compInf = new CompInfo;
      $Cfound++;
    }
    $compInf->{_IS_TOP_LEVEL} = (($inTopLevel eq "TRUE") ? "Y" : "N");
    $compInf->{_HOME_IDX} = $Hfound-1;
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "NAME")
      {
        $compInf->{_NAME} = $val;
      }
      elsif ($att eq "VER")
      {
        $compInf->{_VER} = $val;
        $compInf->{_CURR_VER} = $val; #current version of this component
      }
      elsif ($att eq "LANGS")
      {
        $compInf->{_LANGS} = $val;
      }
      elsif ($att eq "INST_LOC")
      {
        $val =~ s?\x{C2}\x{A5}?\\?g;
        $compInf->{_INST_LOC} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $compInf->{_ACT_INST_VER} = $val;
      }
      elsif ($att eq "DEINST_VER")
      {
        $compInf->{_DEINST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        # times are in format yyyy.MMM.dd HH:mm:ss z
        # we want timestamp as yyyy-mm-dd HH:mm:ss (z)
        my ($date,$time,$zone) = split(' ',$val);
        my ($year,$month,$day) = split('\.',$date);
        $compInf->{_TIMESTAMP} = $year."-".$months{$month}."-".$day." ".$time; # ." (".$zone.")";
      }
      elsif (($att eq "CLONABLE") && ($val eq "F"))
      {
        $homes{$Hfound-1}->{_CLONABLE} = "N";
      }
    }
  }
  elsif ($el eq "PATCH")
  {
    $inPatch = "TRUE";
    my $patchInf = $patches{$Pfound};
    if (not defined($patchInf))
    {
      $patches{$Pfound} = $patchInf = new PatchInfo;
      $Pfound++;
    }
    $patchInf->{_HOME_IDX} = $Hfound-1;
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "NAME")
      {
        $patchInf->{_NAME} = $val;
      }
      elsif ($att eq "VER")
      {
        $patchInf->{_VER} = $val;
      }
      elsif($att eq "BASE_VER")
      {
        $patchInf->{_BASE_VER} = $val;
      }
      elsif ($att eq "LANGS")
      {
        $patchInf->{_LANGS} = $val;
      }
      elsif ($att eq "INST_LOC")
      {
        $val =~ s?\x{C2}\x{A5}?\\?g;
        $patchInf->{_INST_LOC} = $val;
      }
      elsif ($att eq "DEINST_VER")
      {
        $patchInf->{_DEINST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        # times are in format yyyy.MMM.dd HH:mm:ss z
        # we want timestamp as yyyy-mm-dd HH:mm:ss (z)
        my ($date,$time,$zone) = split(' ',$val);
        my ($year,$month,$day) = split('\.',$date);
        $patchInf->{_TIMESTAMP} = $year."-".$months{$month}."-".$day." ".$time; #." (".$zone.")";
      }
    }
    #by now component name and version are already fetched
    updateCompLatestVer($patchInf->{_NAME}, $patchInf->{_BASE_VER}, $patchInf->{_VER});
    
  }
  elsif ($el eq "PATCHSET")
  {
    $inPatchSet = "TRUE";
    my $pSetInf = $patchsets{$PSfound};
    if (not defined($pSetInf))
    {
      $patchsets{$PSfound} = $pSetInf = new PatchsetInfo;
      $PSfound++;
    }
    $pSetInf->{_HOME_IDX} = $Hfound-1;
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "NAME")
      {
        $pSetInf->{_NAME} = $val;
      }
      elsif ($att eq "VER")
      {
        $pSetInf->{_VER} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $pSetInf->{_ACT_INST_VER} = $val;
      }
      elsif ($att eq "DEINST_VER")
      {
        $pSetInf->{_DEINST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        # times are in format yyyy.MMM.dd HH:mm:ss z
        # we want timestamp as yyyy-mm-dd HH:mm:ss (z)
        my ($date,$time,$zone) = split(' ',$val);
        my ($year,$month,$day) = split('\.',$date);
        $pSetInf->{_TIMESTAMP} = $year."-".$months{$month}."-".$day." ".$time; #." (".$zone.")";
      }
    }
  }
  elsif ($el eq "PS_PATCH")
  {
    if ($inPatchSet eq "TRUE")
    {
      my $pspInfo = new PatchsetPatch;
      $pspInfo->{_HOME_IDX} = $Hfound-1;
      my ($att, $val);
      while (@_)
      {
        $att = shift;
        $val = shift;
        if ($att eq "NAME")
        {
          $pspInfo->{_NAME} = $val;
        }
        elsif ($att eq "VER")
        {
          $pspInfo->{_VER} = $val;
        }
        elsif ($att eq "BASE_VER")
        {
          $pspInfo->{_BASE_VER} = $val;
        }
      }
      $patchsets{$PSfound-1}->{_DEP_LIST}->{$PSPfound} = $pspInfo;
      $PSPfound++;
    }
  }
  elsif ($el eq "ONEOFF")
  {
    $inOneOff = "TRUE";
    my $ooInfo = $oneoffs{$OOfound};
    if (not defined($ooInfo))
    {
      $oneoffs{$OOfound} = $ooInfo = new Oneoff;
      $OOfound++;
    }
    $ooInfo->{_HOME_IDX} = $Hfound-1;
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "REF_ID")
      {
        $ooInfo->{_REF_ID} = $val;
      }
      elsif($att eq "UNIQ_ID")
      {
        $ooInfo->{_UPI} = $val;
      }
      elsif($att eq "LANG")
      {
        $ooInfo->{_LANG} = $val;
      }
      elsif ($att eq "ROLLBACK")
      {
        $ooInfo->{_ROLLBACK} = $val;
      }
      elsif ($att eq "XML_INV_LOC")
      {
        $ooInfo->{_XML_INV_LOC} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $ooInfo->{_ACT_INST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        # times are in format yyyy.MMM.dd HH:mm:ss z
        # we want timestamp as yyyy-mm-dd HH:mm:ss (z)
        my ($date,$time,$zone) = split(' ',$val);
        my ($year,$month,$day) = split('\.',$date);
        $ooInfo->{_TIMESTAMP} = $year."-".$months{$month}."-".$day." ".$time; # ." (".$zone.")";
      }
    }
  }
  elsif ($el eq "PATCHSET_UPDATE")
  {
    $inOneOff = "TRUE";#treating patchset-update and oneoff as same
    my $ooInfo = $oneoffs{$OOfound};
    if (not defined($ooInfo))
    {
      $oneoffs{$OOfound} = $ooInfo = new Oneoff;
      $OOfound++;
    }
    $ooInfo->{_HOME_IDX} = $Hfound-1;
    my ($att, $val);
    while (@_)
    {
      $att = shift;
      $val = shift;
      if ($att eq "REF_ID")
      {
        $ooInfo->{_REF_ID} = $val;
      }
      elsif ($att eq "UNIQ_ID")
      {
        $ooInfo->{_UPI} = $val;
      }
      elsif ($att eq "LANG")
      {
        $ooInfo->{_LANG} = $val;
      }
      elsif ($att eq "ROLLBACK")
      {
        $ooInfo->{_ROLLBACK} = $val;
      }
      elsif ($att eq "XML_INV_LOC")
      {
        $ooInfo->{_XML_INV_LOC} = $val;
      }
      elsif ($att eq "ACT_INST_VER")
      {
        $ooInfo->{_ACT_INST_VER} = $val;
      }
      elsif ($att eq "INSTALL_TIME")
      {
        # times are in format yyyy.MMM.dd HH:mm:ss z
        # we want timestamp as yyyy-mm-dd HH:mm:ss (z)
        my ($date,$time,$zone) = split(' ',$val);
        my ($year,$month,$day) = split('\.',$date);
        $ooInfo->{_TIMESTAMP} = $year."-".$months{$month}."-".$day." ".$time; # ." (".$zone.")";
      }
    }
    $ooInfo->{_IS_PSU}="Y";
  } 
  elsif($el eq "BUG_LIST")
  {
        if($inOneOff)
        {
             $inBugList="TRUE";
             @bugList=();
             $BugsFound=0;
        }
  }
  elsif($el eq "BUG")
  {
        $inBug="TRUE";
  }
  elsif($el eq "REF_LIST")
  {
    if($inOneOff eq "TRUE")
    {
      $inRefList="TRUE";
      #$ooInfo->{_REF_LIST} = {};
      $refCount = 0; 
    }
  }
  elsif($el eq "REFCOMP_LIST")
  {
    if($inOneOff eq "TRUE")
    {
      $inRefList="TRUE";
      #$ooInfo->{_REF_LIST} = {};
      $refCount = 0;
    }
  }
  elsif($el eq "REF")
  {
   if(($inRefList eq "TRUE")&&($inOneOff eq "TRUE"))
   {
     my($name,$version);
     my $ooInfo = $oneoffs{$OOfound-1};
     $ooInfo->{_REF_LIST}->{$refCount} = my $refComp = {};
     while(@_)
     {
       my $atr =shift;
       my $val =shift;
       if($atr eq "NAME")
       {
         $refComp->{_NAME} = $val;
       }
       elsif($atr eq "VER")
       {
         $refComp->{_VER} = $val;
       }
     }
   }
    $refCount++;
  }
  elsif($el eq "REFCOMP")
  {
   if(($inRefList eq "TRUE") && ($inOneOff eq "TRUE"))
   {
     my($name,$version);
     my $ooInfo = $oneoffs{$OOfound-1};
     $ooInfo->{_REF_LIST}->{$refCount} = my $refComp = {};
     while(@_)
     {
       my $atr =shift;
       my $val =shift;
       if($atr eq "NAME")
       {
        $refComp->{_NAME} = $val;
       }
       elsif($atr eq "FROM_VER")
       {
        $refComp->{_FROM_VER} = $val;
       }
       elsif($atr eq "TO_VER")
       {
        $refComp->{_TO_VER} = $val;
       }
     }
     $psuComps{$refComp->{_NAME}."|".$refComp->{_FROM_VER}} = $refComp->{_TO_VER};
   }
   $refCount++;
  }
  elsif ($el eq "EXT_NAME")
  {
    $inExtName = "TRUE";
  }
  elsif ($el eq "DESC")
  {
    $inDesc = "TRUE";
  }
  elsif ($el eq "DEP_LIST")
  {
    if ($skipGroup eq "FALSE")
    {
      $inDepList = "TRUE";
      $comps{$Cfound-1}->{_DEP_LIST} = new DepList;
    }
  }
  elsif ($el eq "DEP")
  {
    if ($skipGroup eq "FALSE")
    {
      # need to nest the dependencies
      if ($inDepList)
      {
        my $depInfo = new DepInfo;
        $depInfo->{_HOME_IDX} = $Hfound-1;
        my ($att, $val);
        while (@_)
        {
          $att = shift;
          $val = shift;
          if ($att eq "NAME")
          {
            $depInfo->{_NAME} = $val;
          }
          elsif ($att eq "VER")
          {
            $depInfo->{_VER} = $val;
          }
        }
        $comps{$Cfound-1}->{_DEP_LIST}->{$Dfound} = $depInfo;
        $Dfound++;
      }
    }
  }
  elsif (($el eq "DEP_GRP_LIST") || ($el eq "DEP_GRP"))
  {
    $skipGroup = "TRUE";
  }
}

sub handle_comps_end
{
  my $p = shift;
  my $el = shift;
  
  if ($el eq "TL_LIST")
  {
    $inTopLevel = "FALSE";
  }
  elsif ($el eq "COMP")
  {
    $inComp = "FALSE"
  }
  elsif ($el eq "PATCH")
  {
    $inPatch = "FALSE"
  }
  elsif ($el eq "PATCHSET")
  {
    $inPatchSet = "FALSE"
  }
  elsif ($el eq "ONEOFF")
  {
    $inOneOff = "FALSE"
  }
  elsif($el eq "BUG_LIST")
  {
        if($inOneOff)
        {
          $inBugList="FALSE";
          my $ooInfo = $oneoffs{$OOfound-1};
          $ooInfo->{_BUG_LIST}=[@bugList];
        }
  }
  elsif($el eq "BUG")
  {
    $inBug="FALSE";
  }
  elsif($el eq "REF_LIST")
  {
    if($inOneOff eq "TRUE")
    {
      $inRefList="FALSE";
    }
  }
  elsif($el eq "REFCOMP_LIST")
  {
    if($inOneOff eq "TRUE")
    {
      $inRefList="FALSE";
    }
  }
  elsif ($el eq "EXT_NAME")
  {
    $inExtName = "FALSE"
  }
  elsif ($el eq "DESC")
  {
    $inDesc = "FALSE"
  }
  elsif ($el eq "DEP_LIST")
  {
    $inDepList = "FALSE";
    $Dfound = 0;
  }
  elsif (($el eq "DEP_GRP_LIST") || ($el eq "DEP_GRP"))
  {
    $skipGroup = "FALSE";
  }
}

sub handle_comps_char
{
 if( ($inOneOff eq "TRUE") && ($inBugList eq "TRUE") && ($inBug eq "TRUE"))
  {
        my ($p, $bug) = @_;
        if(defined $bug)
        {
           $bugList[$BugsFound]=$bug;
           $BugsFound++;

        }

  }
 if (($inExtName eq "TRUE") || ($inDesc eq "TRUE"))
  {
    my $p = shift;
    my $info = shift;
    $info =~ s/\n/ /g;
    if ($inExtName eq "TRUE")
    {
      if ($inComp eq "TRUE")
      {
        $comps{$Cfound-1}->{_EXT_NAME} = defined($comps{$Cfound-1}->{_EXT_NAME}) ?
                                          $comps{$Cfound-1}->{_EXT_NAME}.$info : $info;
      }
      elsif ($inPatch eq "TRUE")
      {
        $patches{$Pfound-1}->{_EXT_NAME} = defined($patches{$Pfound-1}->{_EXT_NAME}) ?
                                           $patches{$Pfound-1}->{_EXT_NAME}.$info : $info;
      }
      elsif ($inPatchSet eq "TRUE")
      {
        $patchsets{$PSfound-1}->{_EXT_NAME} = defined($patchsets{$PSfound-1}->{_EXT_NAME}) ?
                                              $patchsets{$PSfound-1}->{_EXT_NAME}.$info : $info;
      }
    }
    elsif ($inDesc eq "TRUE")
    {
      if ($inComp eq "TRUE")
      {
        $comps{$Cfound-1}->{_DESC} = defined($comps{$Cfound-1}->{_DESC}) ? 
                                     $comps{$Cfound-1}->{_DESC}.$info : $info;
      }
      elsif ($inPatch eq "TRUE")
      {
        $patches{$Pfound-1}->{_DESC} = defined($patches{$Pfound-1}->{_DESC}) ?
                                       $patches{$Pfound-1}->{_DESC}.$info : $info;
      }
      elsif ($inPatchSet eq "TRUE")
      {
        $patchsets{$PSfound-1}->{_DESC} = defined($patchsets{$PSfound-1}->{_DESC}) ?
                                          $patchsets{$PSfound-1}->{_DESC}.$info : $info;
      }
    }
  }
}

sub get_oui_plat
{
  # perhaps we can read the install.platform in the current
  # oracle_home; the ID=<nn> nv pair holds what we want!
  # or, in ContentsXML/oraclehomeproperties.xml, the ARU_ID
  # information holds this same value...
  use Config;
  my $osName = $Config{'osname'};
  my $osArch = $Config{'archname'};
  my $osVers = $Config{'osvers'};

  if ($osName eq "MSWin32")
  {
    return 912;
  }
  elsif ($osName eq "linux")
  {
    return 46;
  }
  elsif ($osName eq "solaris")
  {
    return 453;
  }
}


sub getFusionAppPatches
{
  # Get the patches from the patch history files
  # for each patch
  # Is it already in the oneoffs hash?
    # NO  -put it as a new oneoff
    # YES - update the lang/patch type info to the patch object

  my $appl_top = shift;
  # patch history xml will be inside faPatchInventory directory
  # There is no way to determine that this is APPL_TOP Oracle Home
  # if fusionAppsPatchHistory.xml exists in OH/faPatchInventory dir, assume OH=APPL_TOP
  # and parse the xml file
  my $appsPatchHistoryFileName = File::Spec->catfile("$appl_top","faPatchInventory","fusionAppsPatchHistory.xml");
  #Check if file exists and we have permissions to read it
  if ((-e $appsPatchHistoryFileName)&&(-r $appsPatchHistoryFileName))
  {
   my $appsPatchHistoryFile = ias::simpleXPath::parseFile($appsPatchHistoryFileName);
   # Get a list of patches
   my @patches = ias::simpleXPath::queryForNodes($appsPatchHistoryFile, 'FAPatchInventory/PatchList/Patch');

   #Iterate through each patch and get the desired information
   foreach my $patch (@patches)
   {
    my @node_ouis = (ias::simpleXPath::queryForNodes($patch, 'Patch/CompList/Comp'));
    my $attributes = (ias::simpleXPath::queryForAttributes($patch, 'Patch'))[0];
    
    if (scalar(@node_ouis) > 0)
    { 
      # Get the attributes 
      my $patch_id = $attributes->{'ID'};
      my $patchRef = undef;
      unless($patchRef = doesThisPatchExist($patch_id))
      {
       #create a new patch object
       my $patchCount = List::Util::max(keys %oneoffs);
       $patchCount += 1;
       $oneoffs{$patchCount} = $patchRef = new Oneoff; 
       $patchRef->{_REF_ID} = $patch_id;       
      }
      $patchRef->{_ROLLBACK} = $attributes->{'IsRollbackable'} eq "Yes"?"T":"F";
      $patchRef->{_LANG} = $attributes->{'Languages'};
      $patchRef->{_TIMESTAMP} = $attributes->{'Date'};
      $patchRef->{_PATCH_TYPE} = $attributes->{'Type'};

      # Get the Bugs Fixed      
      my @bugs_fixed = ias::simpleXPath::queryForAttributes($patch, 'Patch[@ID="' . $patch_id . '"]/BugfixList/Bugfix');
      my @bugList = ();
      my $bugCount = 0;
      # Iterate through the list of bugs fixed and add it to the bugs string
      foreach my $bug_fixed (@bugs_fixed)
      {
        my $bug = $bug_fixed->{'Number'};
        $bugList[$bugCount++] = $bug;
      }
      $patchRef->{_BUG_LIST} = [@bugList];
      #Get the components affected
      # Component names will be fully qualified, 
      my @comps_affected = ias::simpleXPath::queryForAttributes($patch, 'Patch[@ID="' . $patch_id . '"]/CompList/Comp');
      my $compCount = 0;
      foreach my $comp_affected(@comps_affected)
      {
        my $comp = $comp_affected->{'Name'};
        my $ver  = getCompBaseVer($comp); 
        $patchRef->{_REF_LIST}->{$compCount++} = my $refComp = {};
        $refComp->{_NAME} = $comp;
        $refComp->{_VER}  = $ver;
      }

   }
  }
 }#DO NOTHING IF THAT FILE DEOSN'T EXIST
}


sub doesThisPatchExist
{
 my $patchId = shift;
 foreach my $idx (keys %oneoffs)
 {
  if($oneoffs{$idx}->{_REF_ID} eq $patchId)
  {
    return $oneoffs{$idx};
  }
 }
 return 0; #patch does not exist
}

sub getCompBaseVer
{
 # given the component name, returns its base version.
 # 
 my ($name, $currVer) = @_ ;
 
 foreach my $idx (sort keys(%comps))
 {
   if($comps{$idx}->{_NAME} eq $name)#component found
   {
     if(defined($currVer)) # is current version specified
     {
      if($comps{$idx}->{_CURR_VER} eq $currVer)
      {
        return $comps{$idx}->{_VER};
      }
      else
      {
        return 0; # there is no component with the given component name and current version
      }
     }
     return $comps{$idx}->{_VER};# This is the special case for fusion app patches where
                                 # we just know the component name but not it's version
                                 # Its guaranteed that there will be only one entry for 
                                 # any component.
   } 
 }
 return 0; #Component doesn't exist
}


sub updateCompLatestVer
{
  my ($name, $baseVer, $latVer) = @_;
  foreach my $idx (sort keys(%comps))
 {
   if(($comps{$idx}->{_NAME} eq $name) &&($comps{$idx}->{_VER} eq $baseVer))#component found
   {
     $comps{$idx}->{_CURR_VER} = $latVer;
   }
 }
}

sub getCompLatestVer
{
 # call this method only after all the files are parsed
 # if base version is specified - returns the current version of the component with the base version. If base version is not specified it returns based on the components name. No component will have two entries in the same oracle home
 my ($name, $baseVer) = @_;
 foreach my $idx (sort keys(%comps))
  {
   if($comps{$idx}->{_NAME} eq $name)
   {
     if((defined($baseVer) && ($comps{$idx}->{_VER} eq $baseVer))||(!defined($baseVer)))#component found
     {
      return $comps{$idx}->{_CURR_VER};
     }
   }
 }
 return undef ;#could not find the component
}


package HomeInfo;
sub new
{
  my $class = shift;
  my $self = {};
  bless $self, $class;
}

package CompInfo;
sub new
{
  my $class = shift;
  my $self = {};
  bless $self, $class;
}

package DepList;
sub new
{
  my $class = shift;
  my $self = {};
  bless $self, $class;
}

package DepInfo;
sub new
{
  my $class = shift;
  my $self = {};
  bless $self, $class;
}

package PatchInfo;
sub new
{
  my $class = shift;
  my $self = {};
  bless $self, $class;
}

package Oneoff;
sub new
{
  my $class = shift;
  my $self = {};
  #setting the defaults
  $self->{_IS_PSU} = "N";
  bless $self, $class;
}

package PatchsetInfo;
sub new
{
  my $class = shift;
  my $self = {};
  bless $self, $class;
}

package PatchsetPatch;
sub new
{
  my $class = shift;
  my $self = {};
  bless $self, $class;
}

1;
