# $Header: Ptdpm11.pm 13-may-2005.00:36:32 mgoodric Exp $
#
# Package : Ptdpm11.pm
#
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#   NAME
#       Ptdpm11.pm
#
#   DESCRIPTION
#       Common date conversion utilities
#
#   NOTES
#
#   MODIFIED     (MM/DD/YY)
#      mgoodric   05/13/05 - fix warning with bitwise operator on 5.8.3 
#      mgoodric   05/02/05 - convert to UTC times for INSTALLATION_DATE
#      mgoodric   09/27/04 - code cleanup 
#      mgoodric   03/21/04 - Linux cleanup
#      mgoodric   01/30/04 - fixed missing America/Nome
#      mgoodric   11/18/03 - added latest 10g timezone offsets
#      mgoodric   11/17/03 - fix GMT offsets for parsing by Java
#      mgoodric   06/16/03 - fix converting Solaris timezone to JAVA timezones
#      mgoodric   05/11/03 - added -debug tracing
#      mgoodric   04/24/03 - fix parsing dates with full month names
#      mgoodric   04/15/03 - fix using uname for arch
#      mgoodric   04/08/03 - fix finding MAC address
#      rlal       02/25/03 - EM 4.0 changed for Linux
#      xxu        06/25/02 - remove /usr/local/bin/perl
#      vkhizder   06/20/02 - vkhizder_compare_fix_2420795_collection_script_changes
#      goramamo   06/02/02 - GIT5: Include zone in the outputs
#      mgoodric   02/14/02 - Make scripts more portable
#      goramamo   12/15/01 - Creation
#
##*************************************************************

use strict;

package Ptdpm11;

use Carp;
require 5.005;

#require 5.6.1;
require Exporter;

#use POSIX;
use Ptdpm3;

#******************************************
#   Export Subroutines
#******************************************

@Ptdpm11::ISA    = ('Exporter');
@Ptdpm11::EXPORT = qw(
  &convRpmTimeToYYYYMMDD_hhmmss_Zone
  );

#******************************************
#     Global Variables
#******************************************

use constant NIL => '';

%Ptdpm11::Months = (

    # en (English) "Thu Jun 19 18:11:11 EDT 2003"
    "January"   => '01',
    "February"  => '02',
    "March"     => '03',
    "April"     => '04',
    "May"       => '05',
    "June"      => '06',
    "July"      => '07',
    "August"    => '08',
    "September" => '09',
    "October"   => '10',
    "November"  => '11',
    "December"  => '12',
    "Jan"       => '01',
    "Feb"       => '02',
    "Mar"       => '03',
    "Apr"       => '04',
    "May"       => '05',
    "Jun"       => '06',
    "Jul"       => '07',
    "Aug"       => '08',
    "Sep"       => '09',
    "Oct"       => '10',
    "Nov"       => '11',
    "Dec"       => '12',

    # de (German) "Donnerstag, 19. Juni 2003, 15:21:01 Uhr EDT"
    "Januar"    => '01',
    "Februar"   => '02',
    "M\344rz"   => '03',
    "April"     => '04',
    "Mai"       => '05',
    "Juni"      => '06',
    "Juli"      => '07',
    "August"    => '08',
    "September" => '09',
    "Oktober"   => '10',
    "November"  => '11',
    "Dezember"  => '12',
    "Jan"       => '01',
    "Feb"       => '02',
    "M\344r"    => '03',
    "Apr"       => '04',
    "Mai"       => '05',
    "Jun"       => '06',
    "Jul"       => '07',
    "Aug"       => '08',
    "Sep"       => '09',
    "Okt"       => '10',
    "Nov"       => '11',
    "Dez"       => '12',

    # es (Spanish) "jueves, 19 de junio de 2003, 15:21:05 EDT"
    "enero"      => '01',
    "febrero"    => '02',
    "marzo"      => '03',
    "abril"      => '04',
    "mayo"       => '05',
    "junio"      => '06',
    "julio"      => '07',
    "agosto"     => '08',
    "septiembre" => '09',
    "octubre"    => '10',
    "noviembre"  => '11',
    "diciembre"  => '12',
    "ene"        => '01',
    "feb"        => '02',
    "mar"        => '03',
    "abr"        => '04',
    "may"        => '05',
    "jun"        => '06',
    "jul"        => '07',
    "ago"        => '08',
    "sep"        => '09',
    "oct"        => '10',
    "nov"        => '11',
    "dic"        => '12',

    # fr (French) "jeudi, 19 juin 2003, 15:21:08 EDT"
    "janvier"     => '01',
    "f\351vrier"  => '02',
    "mars"        => '03',
    "avril"       => '04',
    "mai"         => '05',
    "juin"        => '06',
    "juillet"     => '07',
    "ao\373t"     => '08',
    "septembre"   => '09',
    "octobre"     => '10',
    "novembre"    => '11',
    "d\351cembre" => '12',
    "jan"         => '01',
    "f\351v"      => '02',
    "mar"         => '03',
    "avr"         => '04',
    "mai"         => '05',
    "jun"         => '06',
    "jul"         => '07',
    "ao\373"      => '08',
    "sep"         => '09',
    "oct"         => '10',
    "nov"         => '11',
    "d\351c"      => '12',

    # it (Italian) "gioved, 19 giugno 2003, 15:21:11 EDT"
    "gennaio"   => '01',
    "febbraio"  => '02',
    "marzo"     => '03',
    "aprile"    => '04',
    "maggio"    => '05',
    "giugno"    => '06',
    "luglio"    => '07',
    "agosto"    => '08',
    "settembre" => '09',
    "ottobre"   => '10',
    "novembre"  => '11',
    "dicembre"  => '12',
    "gen"       => '01',
    "feb"       => '02',
    "mar"       => '03',
    "apr"       => '04',
    "mag"       => '05',
    "giu"       => '06',
    "lug"       => '07',
    "ago"       => '08',
    "set"       => '09',
    "ott"       => '10',
    "nov"       => '11',
    "dic"       => '12',

    # pt_BR (Portuguese) "quinta-feira 19 junho 2003, 15:21:16 EDT"
    "janeiro"   => '01',
    "fevereiro" => '02',
    "mar\347o"  => '03',
    "abril"     => '04',
    "maio"      => '05',
    "junho"     => '06',
    "julho"     => '07',
    "agosto"    => '08',
    "setembro"  => '09',
    "outubro"   => '10',
    "novembro"  => '11',
    "dezembro"  => '12',
    "jan"       => '01',
    "fev"       => '02',
    "mar"       => '03',
    "abr"       => '04',
    "mai"       => '05',
    "jun"       => '06',
    "jul"       => '07',
    "ago"       => '08',
    "set"       => '09',
    "out"       => '10',
    "nov"       => '11',
    "dez"       => '12'
    );

%Ptdpm11::Timezones = (

    # Timezone regions with +00:00 standard offset from GMT
    "Africa/Casablanca"  => 'GMT',
    "Africa/Freetown"    => 'GMT',
    "Africa/Nouakchott"  => 'GMT',
    "Atlantic/Canary"    => 'GMT',
    "Atlantic/Faeroe"    => 'GMT',
    "Atlantic/Madeira"   => 'GMT',
    "Atlantic/Reykjavik" => 'GMT',
    "Atlantic/St_Helena" => 'GMT',
    "Eire"               => 'GMT',
    "Etc/GMT"            => 'GMT',
    "Etc/GMT+0"          => 'GMT',
    "Etc/GMT-0"          => 'GMT',
    "Etc/GMT0"           => 'GMT',
    "Etc/Greenwich"      => 'GMT',
    "Europe/Belfast"     => 'GMT',
    "Europe/Dublin"      => 'GMT',
    "Europe/Lisbon"      => 'GMT',
    "Europe/London"      => 'GMT',
    "GB"                 => 'GMT',
    "GB-Eire"            => 'GMT',
    "GMT"                => 'GMT',
    "GMT+0"              => 'GMT',
    "GMT-0"              => 'GMT',
    "GMT0"               => 'GMT',
    "Greenwich"          => 'GMT',
    "Iceland"            => 'GMT',
    "Portugal"           => 'GMT',
    "UTC"                => 'GMT',
    "WET"                => 'GMT',

    # Timezone regions with +01:00 standard offset from GMT
    "Africa/Algiers"      => 'GMT+01:00',
    "Africa/Ceuta"        => 'GMT+01:00',
    "Africa/Tunis"        => 'GMT+01:00',
    "Arctic/Longyearbyen" => 'GMT+01:00',
    "CET"                 => 'GMT+01:00',
    "Etc/GMT-1"           => 'GMT+01:00',
    "Europe/Amsterdam"    => 'GMT+01:00',
    "Europe/Belgrade"     => 'GMT+01:00',
    "Europe/Berlin"       => 'GMT+01:00',
    "Europe/Bratislava"   => 'GMT+01:00',
    "Europe/Brussels"     => 'GMT+01:00',
    "Europe/Budapest"     => 'GMT+01:00',
    "Europe/Copenhagen"   => 'GMT+01:00',
    "Europe/Gibraltar"    => 'GMT+01:00',
    "Europe/Ljubljana"    => 'GMT+01:00',
    "Europe/Luxembourg"   => 'GMT+01:00',
    "Europe/Madrid"       => 'GMT+01:00',
    "Europe/Monaco"       => 'GMT+01:00',
    "Europe/Oslo"         => 'GMT+01:00',
    "Europe/Paris"        => 'GMT+01:00',
    "Europe/Prague"       => 'GMT+01:00',
    "Europe/Rome"         => 'GMT+01:00',
    "Europe/San_Marino"   => 'GMT+01:00',
    "Europe/Sarajevo"     => 'GMT+01:00',
    "Europe/Skopje"       => 'GMT+01:00',
    "Europe/Stockholm"    => 'GMT+01:00',
    "Europe/Tirane"       => 'GMT+01:00',
    "Europe/Vatican"      => 'GMT+01:00',
    "Europe/Vienna"       => 'GMT+01:00',
    "Europe/Warsaw"       => 'GMT+01:00',
    "Europe/Zagreb"       => 'GMT+01:00',
    "Europe/Zurich"       => 'GMT+01:00',
    "MET"                 => 'GMT+01:00',
    "Poland"              => 'GMT+01:00',

    # Timezone regions with +02:00 standard offset from GMT
    "Africa/Cairo"        => 'GMT+02:00',
    "Africa/Johannesburg" => 'GMT+02:00',
    "Africa/Khartoum"     => 'GMT+02:00',
    "Africa/Tripoli"      => 'GMT+02:00',
    "Africa/Windhoek"     => 'GMT+02:00',
    "Asia/Beirut"         => 'GMT+02:00',
    "Asia/Damascus"       => 'GMT+02:00',
    "Asia/Gaza"           => 'GMT+02:00',
    "Asia/Istanbul"       => 'GMT+02:00',
    "Asia/Jerusalem"      => 'GMT+02:00',
    "Asia/Nicosia"        => 'GMT+02:00',
    "Asia/Tel_Aviv"       => 'GMT+02:00',
    "EET"                 => 'GMT+02:00',
    "Egypt"               => 'GMT+02:00',
    "Etc/GMT-2"           => 'GMT+02:00',
    "Europe/Athens"       => 'GMT+02:00',
    "Europe/Bucharest"    => 'GMT+02:00',
    "Europe/Helsinki"     => 'GMT+02:00',
    "Europe/Istanbul"     => 'GMT+02:00',
    "Europe/Kaliningrad"  => 'GMT+02:00',
    "Europe/Kiev"         => 'GMT+02:00',
    "Europe/Minsk"        => 'GMT+02:00',
    "Europe/Riga"         => 'GMT+02:00',
    "Europe/Simferopol"   => 'GMT+02:00',
    "Europe/Sofia"        => 'GMT+02:00',
    "Europe/Tallinn"      => 'GMT+02:00',
    "Europe/Vilnius"      => 'GMT+02:00',
    "Israel"              => 'GMT+02:00',
    "Libya"               => 'GMT+02:00',
    "Turkey"              => 'GMT+02:00',

    # Timezone regions with +03:00 standard offset from GMT
    "Africa/Djibouti"  => 'GMT+03:00',
    "Africa/Mogadishu" => 'GMT+03:00',
    "Africa/Nairobi"   => 'GMT+03:00',
    "Asia/Aden"        => 'GMT+03:00',
    "Asia/Amman"       => 'GMT+03:00',
    "Asia/Baghdad"     => 'GMT+03:00',
    "Asia/Bahrain"     => 'GMT+03:00',
    "Asia/Kuwait"      => 'GMT+03:00',
    "Asia/Qatar"       => 'GMT+03:00',
    "Asia/Riyadh"      => 'GMT+03:00',
    "Etc/GMT-3"        => 'GMT+03:00',
    "Europe/Moscow"    => 'GMT+03:00',
    "Indian/Mayotte"   => 'GMT+03:00',
    "W-SU"             => 'GMT+03:00',

    # Timezone regions with +03:30 standard offset from GMT
    "Asia/Tehran" => 'GMT+03:30',
    "Iran"        => 'GMT+03:30',

    # Timezone regions with +04:00 standard offset from GMT
    "Asia/Aqtau"     => 'GMT+04:00',
    "Asia/Baku"      => 'GMT+04:00',
    "Asia/Dubai"     => 'GMT+04:00',
    "Asia/Muscat"    => 'GMT+04:00',
    "Asia/Tbilisi"   => 'GMT+04:00',
    "Asia/Yerevan"   => 'GMT+04:00',
    "Etc/GMT-4"      => 'GMT+04:00',
    "Europe/Samara"  => 'GMT+04:00',
    "Indian/Reunion" => 'GMT+04:00',

    # Timezone regions with +04:30 standard offset from GMT
    "Asia/Kabul" => 'GMT+04:30',

    # Timezone regions with +05:00 standard offset from GMT
    "Asia/Aqtobe"        => 'GMT+05:00',
    "Asia/Bishkek"       => 'GMT+05:00',
    "Asia/Karachi"       => 'GMT+05:00',
    "Asia/Tashkent"      => 'GMT+05:00',
    "Asia/Yekaterinburg" => 'GMT+05:00',
    "Etc/GMT-5"          => 'GMT+05:00',
    "Indian/Chagos"      => 'GMT+05:00',

    # Timezone regions with +05:30 standard offset from GMT
    "Asia/Calcutta" => 'GMT+05:30',

    # Timezone regions with +06:00 standard offset from GMT
    "Asia/Almaty"      => 'GMT+06:00',
    "Asia/Dacca"       => 'GMT+06:00',
    "Asia/Novosibirsk" => 'GMT+06:00',
    "Asia/Omsk"        => 'GMT+06:00',
    "Etc/GMT-6"        => 'GMT+06:00',

    # Timezone regions with +06:30 standard offset from GMT
    "Asia/Rangoon" => 'GMT+06:30',
    "Indian/Cocos" => 'GMT+06:30',

    # Timezone regions with +07:00 standard offset from GMT
    "Asia/Bangkok"     => 'GMT+07:00',
    "Asia/Jakarta"     => 'GMT+07:00',
    "Asia/Krasnoyarsk" => 'GMT+07:00',
    "Asia/Saigon"      => 'GMT+07:00',
    "Etc/GMT-7"        => 'GMT+07:00',
    "Indian/Christmas" => 'GMT+07:00',

    # Timezone regions with +08:00 standard offset from GMT
    "Asia/Chungking"     => 'GMT+08:00',
    "Asia/Harbin"        => 'GMT+08:00',
    "Asia/Hong_Kong"     => 'GMT+08:00',
    "Asia/Irkutsk"       => 'GMT+08:00',
    "Asia/Kashgar"       => 'GMT+08:00',
    "Asia/Kuala_Lumpur"  => 'GMT+08:00',
    "Asia/Kuching"       => 'GMT+08:00',
    "Asia/Macao"         => 'GMT+08:00',
    "Asia/Manila"        => 'GMT+08:00',
    "Asia/Shanghai"      => 'GMT+08:00',
    "Asia/Singapore"     => 'GMT+08:00',
    "Asia/Taipei"        => 'GMT+08:00',
    "Asia/Ujung_Pandang" => 'GMT+08:00',
    "Asia/Urumqi"        => 'GMT+08:00',
    "Australia/Perth"    => 'GMT+08:00',
    "Australia/West"     => 'GMT+08:00',
    "Etc/GMT-8"          => 'GMT+08:00',
    "Hongkong"           => 'GMT+08:00',
    "PRC"                => 'GMT+08:00',
    "ROC"                => 'GMT+08:00',
    "Singapore"          => 'GMT+08:00',

    # Timezone regions with +09:00 standard offset from GMT
    "Asia/Jayapura" => 'GMT+09:00',
    "Asia/Seoul"    => 'GMT+09:00',
    "Asia/Tokyo"    => 'GMT+09:00',
    "Asia/Yakutsk"  => 'GMT+09:00',
    "Etc/GMT-9"     => 'GMT+09:00',
    "Japan"         => 'GMT+09:00',
    "ROK"           => 'GMT+09:00',

    # Timezone regions with +09:30 standard offset from GMT
    "Australia/Darwin" => 'GMT+09:30',
    "Australia/North"  => 'GMT+09:30',

    # Timezone regions with +10:00 standard offset from GMT
    "Asia/Vladivostok"     => 'GMT+10:00',
    "Australia/Brisbane"   => 'GMT+10:00',
    "Australia/Lindeman"   => 'GMT+10:00',
    "Australia/Queensland" => 'GMT+10:00',
    "Etc/GMT-10"           => 'GMT+10:00',
    "Pacific/Guam"         => 'GMT+10:00',
    "Pacific/Saipan"       => 'GMT+10:00',

    # Timezone regions with +10:30 standard offset from GMT
    "Australia/Adelaide"    => 'GMT+10:30',
    "Australia/Broken_Hill" => 'GMT+10:30',
    "Australia/South"       => 'GMT+10:30',
    "Australia/Yancowinna"  => 'GMT+10:30',

    # Timezone regions with +11:00 standard offset from GMT
    "Asia/Magadan"        => 'GMT+11:00',
    "Australia/ACT"       => 'GMT+11:00',
    "Australia/Canberra"  => 'GMT+11:00',
    "Australia/Hobart"    => 'GMT+11:00',
    "Australia/LHI"       => 'GMT+11:00',
    "Australia/Lord_Howe" => 'GMT+11:00',
    "Australia/Melbourne" => 'GMT+11:00',
    "Australia/NSW"       => 'GMT+11:00',
    "Australia/Sydney"    => 'GMT+11:00',
    "Australia/Tasmania"  => 'GMT+11:00',
    "Australia/Victoria"  => 'GMT+11:00',
    "Etc/GMT-11"          => 'GMT+11:00',
    "Pacific/Noumea"      => 'GMT+11:00',

    # Timezone regions with +11:30 standard offset from GMT
    "Pacific/Norfolk" => 'GMT+11:30',

    # Timezone regions with +12:00 standard offset from GMT
    "Asia/Kamchatka"    => 'GMT+12:00',
    "Etc/GMT-12"        => 'GMT+12:00',
    "Kwajalein"         => 'GMT+12:00',
    "Pacific/Kwajalein" => 'GMT+12:00',
    "Pacific/Wake"      => 'GMT+12:00',
    "Pacific/Wallis"    => 'GMT+12:00',

    # Timezone regions with +13:00 standard offset from GMT
    "Asia/Anadyr"      => 'GMT+13:00',
    "Etc/GMT-13"       => 'GMT+13:00',
    "NZ"               => 'GMT+13:00',
    "Pacific/Auckland" => 'GMT+13:00',
    "Pacific/Fiji"     => 'GMT+13:00',

    # Timezone regions with +13:45 standard offset from GMT
    "NZ-CHAT"         => 'GMT+13:45',
    "Pacific/Chatham" => 'GMT+13:45',

    # Timezone regions with -01:00 standard offset from GMT
    "America/Scoresbysund" => 'GMT-01:00',
    "Atlantic/Azores"      => 'GMT-01:00',
    "Etc/GMT+1"            => 'GMT-01:00',

    # Timezone regions with -02:00 standard offset from GMT
    "America/Araguaina" => 'GMT-02:00',
    "America/Fortaleza" => 'GMT-02:00',
    "America/Maceio"    => 'GMT-02:00',
    "America/Noronha"   => 'GMT-02:00',
    "America/Sao_Paulo" => 'GMT-02:00',
    "Brazil/DeNoronha"  => 'GMT-02:00',
    "Brazil/East"       => 'GMT-02:00',
    "Etc/GMT+2"         => 'GMT-02:00',

    # Timezone regions with -03:00 standard offset from GMT
    "America/Asuncion"     => 'GMT-03:00',
    "America/Belem"        => 'GMT-03:00',
    "America/Boa_Vista"    => 'GMT-03:00',
    "America/Buenos_Aires" => 'GMT-03:00',
    "America/Cayenne"      => 'GMT-03:00',
    "America/Cuiaba"       => 'GMT-03:00',
    "America/Godthab"      => 'GMT-03:00',
    "America/Miquelon"     => 'GMT-03:00',
    "America/Montevideo"   => 'GMT-03:00',
    "America/Santiago"     => 'GMT-03:00',
    "Atlantic/Stanley"     => 'GMT-03:00',
    "Chile/Continental"    => 'GMT-03:00',
    "Etc/GMT+3"            => 'GMT-03:00',

    # Timezone regions with -03:30 standard offset from GMT
    "America/St_Johns"    => 'GMT-03:30',
    "Canada/Newfoundland" => 'GMT-03:30',

    # Timezone regions with -04:00 standard offset from GMT
    "America/Anguilla"    => 'GMT-04:00',
    "America/Caracas"     => 'GMT-04:00',
    "America/Curacao"     => 'GMT-04:00',
    "America/Goose_Bay"   => 'GMT-04:00',
    "America/Guadeloupe"  => 'GMT-04:00',
    "America/Halifax"     => 'GMT-04:00',
    "America/La_Paz"      => 'GMT-04:00',
    "America/Manaus"      => 'GMT-04:00',
    "America/Martinique"  => 'GMT-04:00',
    "America/Montserrat"  => 'GMT-04:00',
    "America/Porto_Velho" => 'GMT-04:00',
    "America/Puerto_Rico" => 'GMT-04:00',
    "America/St_Thomas"   => 'GMT-04:00',
    "America/Thule"       => 'GMT-04:00',
    "America/Tortola"     => 'GMT-04:00',
    "America/Virgin"      => 'GMT-04:00',
    "Atlantic/Bermuda"    => 'GMT-04:00',
    "Brazil/West"         => 'GMT-04:00',
    "Canada/Atlantic"     => 'GMT-04:00',
    "Etc/GMT+4"           => 'GMT-04:00',

    # Timezone regions with -05:00 standard offset from GMT
    "America/Bogota"               => 'GMT-05:00',
    "America/Cayman"               => 'GMT-05:00',
    "America/Detroit"              => 'GMT-05:00',
    "America/Fort_Wayne"           => 'GMT-05:00',
    "America/Grand_Turk"           => 'GMT-05:00',
    "America/Guayaquil"            => 'GMT-05:00',
    "America/Havana"               => 'GMT-05:00',
    "America/Indianapolis"         => 'GMT-05:00',
    "America/Indiana/Indianapolis" => 'GMT-05:00',
    "America/Indiana/Knox"         => 'GMT-05:00',
    "America/Indiana/Marengo"      => 'GMT-05:00',
    "America/Indiana/Vevay"        => 'GMT-05:00',
    "America/Jamaica"              => 'GMT-05:00',
    "America/Knox_IN"              => 'GMT-05:00',
    "America/Lima"                 => 'GMT-05:00',
    "America/Louisville"           => 'GMT-05:00',
    "America/Montreal"             => 'GMT-05:00',
    "America/New_York"             => 'GMT-05:00',
    "America/Panama"               => 'GMT-05:00',
    "America/Thunder_Bay"          => 'GMT-05:00',
    "America/Porto_Acre"           => 'GMT-05:00',
    "Brazil/Acre"                  => 'GMT-05:00',
    "Canada/Eastern"               => 'GMT-05:00',
    "Chile/EasterIsland"           => 'GMT-05:00',
    "Cuba"                         => 'GMT-05:00',
    "EST"                          => 'GMT-05:00',
    "EST5EDT"                      => 'GMT-05:00',
    "Etc/GMT+5"                    => 'GMT-05:00',
    "Jamaica"                      => 'GMT-05:00',
    "Pacific/Easter"               => 'GMT-05:00',
    "US/East-Indiana"              => 'GMT-05:00',
    "US/Eastern"                   => 'GMT-05:00',
    "US/Indiana-Starke"            => 'GMT-05:00',
    "US/Michigan"                  => 'GMT-05:00',

    # Timezone regions with -06:00 standard offset from GMT
    "America/Cambridge_Bay"    => 'GMT-06:00',
    "America/Cancun"           => 'GMT-06:00',
    "America/Chicago"          => 'GMT-06:00',
    "America/Costa_Rica"       => 'GMT-06:00',
    "America/El_Salvador"      => 'GMT-06:00',
    "America/Guatemala"        => 'GMT-06:00',
    "America/Iqaluit"          => 'GMT-06:00',
    "America/Managua"          => 'GMT-06:00',
    "America/Mexico_City"      => 'GMT-06:00',
    "America/Rankin_Inlet"     => 'GMT-06:00',
    "America/Regina"           => 'GMT-06:00',
    "America/Swift_Current"    => 'GMT-06:00',
    "America/Tegucigalpa"      => 'GMT-06:00',
    "America/Winnipeg"         => 'GMT-06:00',
    "CST"                      => 'GMT-06:00',
    "CST6CDT"                  => 'GMT-06:00',
    "Canada/Central"           => 'GMT-06:00',
    "Canada/East-Saskatchewan" => 'GMT-06:00',
    "Canada/Saskatchewan"      => 'GMT-06:00',
    "Etc/GMT+6"                => 'GMT-06:00',
    "Mexico/General"           => 'GMT-06:00',
    "US/Central"               => 'GMT-06:00',

    # Timezone regions with -07:00 standard offset from GMT
    "America/Boise"        => 'GMT-07:00',
    "America/Chihuahua"    => 'GMT-07:00',
    "America/Dawson_Creek" => 'GMT-07:00',
    "America/Denver"       => 'GMT-07:00',
    "America/Edmonton"     => 'GMT-07:00',
    "America/Inuvik"       => 'GMT-07:00',
    "America/Mazatlan"     => 'GMT-07:00',
    "America/Phoenix"      => 'GMT-07:00',
    "America/Shiprock"     => 'GMT-07:00',
    "America/Yellowknife"  => 'GMT-07:00',
    "Canada/Mountain"      => 'GMT-07:00',
    "Etc/GMT+7"            => 'GMT-07:00',
    "MST"                  => 'GMT-07:00',
    "MST7MDT"              => 'GMT-07:00',
    "Mexico/BajaSur"       => 'GMT-07:00',
    "Navajo"               => 'GMT-07:00',
    "US/Arizona"           => 'GMT-07:00',
    "US/Mountain"          => 'GMT-07:00',

    # Timezone regions with -08:00 standard offset from GMT
    "America/Dawson"      => 'GMT-08:00',
    "America/Ensenada"    => 'GMT-08:00',
    "America/Los_Angeles" => 'GMT-08:00',
    "America/Tijuana"     => 'GMT-08:00',
    "America/Vancouver"   => 'GMT-08:00',
    "America/Whitehorse"  => 'GMT-08:00',
    "Canada/Pacific"      => 'GMT-08:00',
    "Canada/Yukon"        => 'GMT-08:00',
    "Etc/GMT+8"           => 'GMT-08:00',
    "Mexico/BajaNorte"    => 'GMT-08:00',
    "PST"                 => 'GMT-08:00',
    "PST8PDT"             => 'GMT-08:00',
    "US/Pacific"          => 'GMT-08:00',
    "US/Pacific-New"      => 'GMT-08:00',

    # Timezone regions with -08:30 standard offset from GMT
    "Pacific/Pitcairn" => 'GMT-08:30',

    # Timezone regions with -09:00 standard offset from GMT
    "America/Anchorage" => 'GMT-09:00',
    "America/Juneau"    => 'GMT-09:00',
    "America/Nome"      => 'GMT-09:00',
    "Etc/GMT+9"         => 'GMT-09:00',
    "Pacific/Gambier"   => 'GMT-09:00',
    "US/Alaska"         => 'GMT-09:00',

    # Timezone regions with -09:30 standard offset from GMT
    "Pacific/Marquesas" => 'GMT-09:30',

    # Timezone regions with -10:00 standard offset from GMT
    "America/Adak"      => 'GMT-10:00',
    "America/Atka"      => 'GMT-10:00',
    "Etc/GMT+10"        => 'GMT-10:00',
    "HST"               => 'GMT-10:00',
    "Pacific/Fakaofo"   => 'GMT-10:00',
    "Pacific/Honolulu"  => 'GMT-10:00',
    "Pacific/Johnston"  => 'GMT-10:00',
    "Pacific/Rarotonga" => 'GMT-10:00',
    "Pacific/Tahiti"    => 'GMT-10:00',
    "US/Aleutian"       => 'GMT-10:00',
    "US/Hawaii"         => 'GMT-10:00',

    # Timezone regions with -11:00 standard offset from GMT
    "Etc/GMT+11"        => 'GMT-11:00',
    "Pacific/Midway"    => 'GMT-11:00',
    "Pacific/Niue"      => 'GMT-11:00',
    "Pacific/Pago_Pago" => 'GMT-11:00',
    "Pacific/Samoa"     => 'GMT-11:00',
    "US/Samoa"          => 'GMT-11:00',

    # Timezone regions with -12:00 standard offset from GMT
    "Etc/GMT+12" => 'GMT-12:00',

    # Timezone regions with mappings
    "Pacific/Apia"              => 'GMT-11:00',
    "America/Yakutat"           => 'GMT-09:00',
    "America/Menominee"         => 'GMT-06:00',
    "America/Rainy_River"       => 'GMT-06:00',
    "Pacific/Galapagos"         => 'GMT-06:00',
    "America/Nipigon"           => 'GMT-05:00',
    "America/Pangnirtung"       => 'GMT-06:00',
    "America/Antigua"           => 'GMT-04:00',
    "America/Aruba"             => 'GMT-04:00',
    "America/Dominica"          => 'GMT-04:00',
    "America/Glace_Bay"         => 'GMT-04:00',
    "America/Grenada"           => 'GMT-04:00',
    "America/Guyana"            => 'GMT-04:00',
    "America/Port_of_Spain"     => 'GMT-04:00',
    "America/Santo_Domingo"     => 'GMT-04:00',
    "America/St_Kitts"          => 'GMT-04:00',
    "America/St_Lucia"          => 'GMT-04:00',
    "America/St_Vincent"        => 'GMT-04:00',
    "America/Catamarca"         => 'GMT-03:00',
    "America/Cordoba"           => 'GMT-03:00',
    "America/Jujuy"             => 'GMT-03:00',
    "America/Mendoza"           => 'GMT-03:00',
    "America/Paramaribo"        => 'GMT-03:00',
    "America/Rosario"           => 'GMT-03:00',
    "Atlantic/South_Georgia"    => 'GMT-02:00',
    "Africa/Abidjan"            => 'GMT',
    "Africa/Bamako"             => 'GMT',
    "Africa/Banjul"             => 'GMT',
    "Africa/Bissau"             => 'GMT',
    "Africa/Conakry"            => 'GMT',
    "Africa/Dakar"              => 'GMT',
    "Africa/El_Aaiun"           => 'GMT',
    "Africa/Lome"               => 'GMT',
    "Africa/Monrovia"           => 'GMT',
    "Africa/Ouagadougou"        => 'GMT',
    "Africa/Sao_Tome"           => 'GMT',
    "Africa/Timbuktu"           => 'GMT',
    "Africa/Bangui"             => 'GMT+01:00',
    "Africa/Brazzaville"        => 'GMT+01:00',
    "Africa/Douala"             => 'GMT+01:00',
    "Africa/Kinshasa"           => 'GMT+01:00',
    "Africa/Lagos"              => 'GMT+01:00',
    "Africa/Libreville"         => 'GMT+01:00',
    "Africa/Luanda"             => 'GMT+01:00',
    "Africa/Malabo"             => 'GMT+01:00',
    "Africa/Ndjamena"           => 'GMT+01:00',
    "Africa/Niamey"             => 'GMT+01:00',
    "Africa/Porto-Novo"         => 'GMT+01:00',
    "Europe/Andorra"            => 'GMT+01:00',
    "Europe/Malta"              => 'GMT+01:00',
    "Europe/Vaduz"              => 'GMT+01:00',
    "Africa/Blantyre"           => 'GMT+02:00',
    "Africa/Bujumbura"          => 'GMT+02:00',
    "Africa/Gaborone"           => 'GMT+02:00',
    "Africa/Harare"             => 'GMT+02:00',
    "Africa/Kigali"             => 'GMT+02:00',
    "Africa/Lubumbashi"         => 'GMT+02:00',
    "Africa/Lusaka"             => 'GMT+02:00',
    "Africa/Maputo"             => 'GMT+02:00',
    "Africa/Maseru"             => 'GMT+02:00',
    "Africa/Mbabane"            => 'GMT+02:00',
    "Europe/Chisinau"           => 'GMT+02:00',
    "Africa/Addis_Ababa"        => 'GMT+03:00',
    "Africa/Asmera"             => 'GMT+03:00',
    "Africa/Dar_es_Salaam"      => 'GMT+03:00',
    "Africa/Kampala"            => 'GMT+03:00',
    "Antarctica/Syowa"          => 'GMT+03:00',
    "Indian/Antananarivo"       => 'GMT+03:00',
    "Indian/Comoro"             => 'GMT+03:00',
    "Indian/Mahe"               => 'GMT+04:00',
    "Indian/Mauritius"          => 'GMT+04:00',
    "Asia/Ashkhabad"            => 'GMT+05:00',
    "Asia/Dushanbe"             => 'GMT+05:00',
    "Asia/Samarkand"            => 'GMT+05:00',
    "Indian/Kerguelen"          => 'GMT+05:00',
    "Indian/Maldives"           => 'GMT+05:00',
    "Antarctica/Mawson"         => 'GMT+06:00',
    "Asia/Colombo"              => 'GMT+06:00',
    "Asia/Thimbu"               => 'GMT+06:00',
    "Antarctica/Davis"          => 'GMT+07:00',
    "Asia/Phnom_Penh"           => 'GMT+07:00',
    "Asia/Vientiane"            => 'GMT+07:00',
    "Antarctica/Casey"          => 'GMT+08:00',
    "Asia/Brunei"               => 'GMT+08:00',
    "Asia/Dili"                 => 'GMT+08:00',
    "Asia/Pyongyang"            => 'GMT+09:00',
    "Pacific/Palau"             => 'GMT+09:00',
    "Antarctica/DumontDUrville" => 'GMT+10:00',
    "Pacific/Port_Moresby"      => 'GMT+10:00',
    "Pacific/Truk"              => 'GMT+10:00',
    "Pacific/Yap"               => 'GMT+10:00',
    "Pacific/Funafuti"          => 'GMT+12:00',
    "Pacific/Majuro"            => 'GMT+12:00',
    "Pacific/Nauru"             => 'GMT+12:00',
    "Pacific/Tarawa"            => 'GMT+12:00',

    # Atlantic
    "ADT" => 'GMT-03:00',

    # Eastern
    "EDT" => 'GMT-04:00',

    # Central
    "CDT" => 'GMT-05:00',

    # Mountain
    "MDT" => 'GMT-06:00',

    # Pacific
    "PDT" => 'GMT-07:00',

    # Hawaii
    "HDT" => 'GMT-09:30',

    # Mideast/Riyadh
    "Mideast/Riyadh87" => 'GMT+03:07',
    "Mideast/Riyadh88" => 'GMT+03:07',
    "Mideast/Riyadh89" => 'GMT+03:07',

    # GMT
    "GMT+0"     => 'GMT',
    "GMT+1"     => 'GMT+01:00',
    "GMT+2"     => 'GMT+02:00',
    "GMT+3"     => 'GMT+03:00',
    "GMT+4"     => 'GMT+04:00',
    "GMT+5"     => 'GMT+05:00',
    "GMT+6"     => 'GMT+06:00',
    "GMT+7"     => 'GMT+07:00',
    "GMT+8"     => 'GMT+08:00',
    "GMT+9"     => 'GMT+09:00',
    "GMT+10"    => 'GMT+10:00',
    "GMT+11"    => 'GMT+11:00',
    "GMT+12"    => 'GMT+12:00',
    "GMT+13"    => 'GMT+13:00',
    "GMT-0"     => 'GMT',
    "GMT-1"     => 'GMT-01:00',
    "GMT-2"     => 'GMT-02:00',
    "GMT-3"     => 'GMT-03:00',
    "GMT-4"     => 'GMT-04:00',
    "GMT-5"     => 'GMT-05:00',
    "GMT-6"     => 'GMT-06:00',
    "GMT-7"     => 'GMT-07:00',
    "GMT-8"     => 'GMT-08:00',
    "GMT-9"     => 'GMT-09:00',
    "GMT-10"    => 'GMT-10:00',
    "GMT-11"    => 'GMT-11:00',
    "GMT-12"    => 'GMT-12:00',
    "UCT"       => 'GMT',
    "Universal" => 'GMT',
    "UTC"       => 'GMT',
    "Zulu"      => 'GMT'

    );

$Ptdpm11::Timezone = NIL;

use constant DASH_CHR   => '-';
use constant SLASH_CHR  => '/';
use constant OPAREN_CHR => '(';
use constant CPAREN_CHR => ')';
use constant TW_YEAR    => 1911;
use constant PM_OFFSET  => 12;

#******************************************
#     Exported Subroutines
#******************************************

sub convRpmTimeToYYYYMMDD_hhmmss_Zone($)
{

    # Function: Patch date conversion

    my ($indt) = @_;       # Sample input:  Fri Apr 24 20:50:37 1998
    my $instdt = NIL;      # Sample output: 1998-04-24 20:50:37 (GMT)
    my $mon    = NIL;
    my $day    = NIL;
    my $year   = NIL;
    my $hr     = NIL;
    my $min    = NIL;
    my $sec    = NIL;
    my $hhmmss = NIL;
    my $tz     = $ENV{'TZ'};
    my $tzID   = NIL;
    my @in     = ();

    if ((defined $indt) && (length($indt) > 0))
    {
        @in     = split (' ', $indt);
        $mon    = $Ptdpm11::Months{$in[1]};
        $day    = $in[2];
        $hhmmss = $in[3];
        $year   = $in[4];
        $day    =~ s/[. ,]//g;
        $year   =~ s/[. ,]//g;

        if (isMonth($mon) && isDay($day) && isYear($year) && isTime($hhmmss))
        {

            $tz = getTimeZone() if ((!defined $tz) || (length($tz) == 0));
            $tzID = $Ptdpm11::Timezones{$tz}
              if ((defined $tz) && (length($tz) > 0));
            if ((!defined $tzID) || (length($tzID) == 0))
            {
                $tzID = $tz;
            }

            # YYYY-MM-DD HH:MM:SS (z) Format
            $instdt =
              $year . DASH_CHR
              . zeroPad($mon) . DASH_CHR
              . zeroPad($day) . ' ' . $hhmmss . ' '
              . OPAREN_CHR . $tzID
              . CPAREN_CHR;
        }
    }

    return $instdt;
}

#******************************************
#     Non-Exported Subroutines
#******************************************

sub getTimeZone
{

    # Method 1 to get time zone
    use POSIX;
    chomp(my $tz = strftime "%Z\n", localtime);

    return $tz;
}

1;

# End of the Program
