
# +===========================================================================+
# |   Copyright (c) 2003 Oracle Corporation, Redwood Shores, California, USA
# |                         All Rights Reserved
# |                        Applications Division
# +===========================================================================+
# |
# | FILENAME
# |   RunScript.pm
# |
# | DESCRIPTION
# |      TXK RunScript package
# |
# | USAGE
# |       See RunScript.html
# |
# | PLATFORM
# |
# | NOTES
# |
# +===========================================================================+

# $Header: RunScript.pm 03-aug-2005.08:54:54 ndutko Exp $

package TXK::RunScript;

######################################
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#
# This package is a pseudo-main for
# pl scripts. Therefore it does not
# include TXK::COMMON or objects.
#
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#
######################################

######################################
# Standard Modules
######################################

use strict;
use English;
use Carp;

require 5.005;

######################################
# Package Specific Modules
######################################

use TXK::Util();

######################################
# Public Constants
######################################

######################################
# Global Variables
######################################

######################################
# Package Variables 
######################################

my $PACKAGE_ID = "TXK::RunScript";

######################################
# Object Keys
######################################

sub new;
sub DESTROY;
sub require;

######################################
# Constructor
######################################

sub new {
  my $self = bless {} ;

  return $self;
}

######################################
# Destructor
######################################

sub DESTROY
{
}

######################################
# require
######################################

sub require
{
  my $self  = $ARG[0];
  my $args  = $ARG[1];

  TXK::Util->isValidObj({obj=>$self,mode=>"class",package=>$PACKAGE_ID});

  require $args;
}

1;

