# $Header: alertlogViewer.pl 20-jan-2005.11:01:53 ychan Exp $
#
# alertlogViewer.pl
# 
# Copyright (c) 2002, 2005, Oracle. All rights reserved.  
#
#    NAME
#      alertlogViewer.pl - show the last n bytes of an alert log file
#
#    DESCRIPTION
#      Given oracle home, directory containing Oracle alert log file, SID,
#      alertlogViewer dumps the last given size of the content of the alert log file
#
#    NOTES
#      (none)
#
#    MODIFIED   (MM/DD/YY)
#      ychan   01/20/05 - Fix filter 
#      ychan   01/18/05 - Add filter support 
#      jsoule  11/06/02 - don't assume '?' in background_dump_dest
#      xxu     06/24/02 - remove /usr/local/bin/perl
#      hjchu   01/30/02 - Creation
#

use strict;
use Time::Local;
use HTTP::Date;

require "alertlog_util.pl";

# Command Line Arguments
my $argnum = @ARGV;

my $OracleHome = shift(@ARGV);
my $dest = shift(@ARGV);       # Absolute directory containing (log) file (oracle home prepended)
my $SID = shift(@ARGV);        # Database SID 
my $sizeToView = shift(@ARGV); # The last <sizeToView> bytes to view

my $stime;      # start time filter
my $etime;      # end time filter

if ($argnum > 4)
{
    $stime=shift(@ARGV);
    $etime=shift(@ARGV);
}
# End Arguments

my $logFile = get_absolute_alert_log_filename($dest, $OracleHome, $SID);

if(!open(FH, "$logFile"))  
{
    print "em_alertLogViewerError01:\n$logFile\n";
    exit 0;
}


seek(FH,0,2);  # go directly to EOF

my $fileSize = tell(FH);
my $startPoint = $fileSize - $sizeToView;

if($startPoint < 0)
{
    $startPoint = 0; 
}

if(!seek(FH, $startPoint, 0))  
{
    print "em_alertLogViewerError02:\n$logFile\n";
    exit 0;
}

my $bufferSize = 1000; # size of read buffer in bytes
my $record;

if ( (!defined($stime) &&  !defined($etime)) || ($stime eq '0' && $etime eq '0'))
{
    while(<FH>)
    {
        #read(FH, $record, $bufferSize) || die "can't read $logFile: $!";
        if(!read(FH, $record, $bufferSize))  
        {
            print "em_alertLogViewerError03:\n$logFile\n";
            exit 0;
        }    
        print $record;
    }
}
else
{
    my $secs;
    my $found=0;

    # start time
    my $stimesec;
    if ($stime eq '0')
    {
        $stimesec = 0;
    }
    else
    {
        my @startlist=split(':', $stime);
        $stimesec = timelocal(@startlist);
    }        
    
    # end time
    my $etimesec;
    if ($etime eq '0')
    {
        $etimesec = 0;
    }
    else
    {
        my @endlist=split(':', $etime);
        $etimesec = timelocal(@endlist);
    }    

    while(<FH>)
    {
        $record = $_;    
        
        if ($found == 0 ||  $etimesec != 0)
        {
            $secs = str2time($record);   
    
            if (defined $secs)
            {
                if ($secs >= $stimesec && ($secs <= $etimesec || $etimesec == 0))
                {        
                    $found = 1;
                }
                elsif ($secs > $etimesec && $etimesec != 0)
                {
                    last;
                }        
            }                  
        }           
    
        if ($found == 1)
        {         
            print "$record";
        }  
    }     
}

close FH;  
