#!/usr/local/bin/perl
# 
# $Header: apacheresponse.pl 30-nov-2005.20:47:36 ssuggala Exp $
#
# apacheresponse.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      apacheresponse.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ssuggala    11/30/05 - Backport ssuggala_bug-4748931 from main 
#    ssuggala    11/21/05 - for bug 4748931 
#    ssuggala    04/20/05 - 
#    ssuggala    04/14/05 - Add version property 
#    ssuggala    01/26/05 - ssuggala_standalone_apache_metadata
#    ssuggala    01/25/05 - Creation
# 
use strict;
#use Config;

#require "iasresourceusage.pl";

my $LONG_PS_CMD_PID_COL = 1;
my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";
my $osType = $^O;

# See we if find any apache server pids
# Get the pidd for the http server and see if we find some pids.
my $httpPids = getApachePids( $ARGV[0] );
my $version = getApacheVersion( $ARGV[0] );

my $status;
# If we found a pid, the http server is up
if( $httpPids eq "" )
{
    $status = "0";
} else {
    $status = "1";
}

print "em_result=$status|$version\n";
#print "em_result=1\n";

# Get the pid list for the Apache Server 
# parameters:
#   install_home - the install home in which the Apache instance is running
sub getApachePids 
{
  my $install_home = shift(@_);

  if( !(-e $install_home) )
  {
      exit 1;
  }
  my $pidList = "";
  my $httpd_pid_file = $install_home.$sep."logs".$sep."httpd.pid";


  # on Win32, get the pids from DMS
  if ($osType eq "MSWin32")
  {
    # Get the apache child process pid and the parent pid
#    $pidList = getApacheChildPidFromDMS( $install_home );
#    my $parentPid =  getPidForComponentFromDMS( $install_home, "HTTP_Server" );
#    if( $pidList eq "" ) 
#    {
#      $pidList = $parentPid;
#    } else {
#      $pidList = "$pidList,$parentPid";
#    }
    
    my $key = "Apache2";
    my $ps_output = `net start | find "$key"`;
    #print "net start | find \"$key\"\n";

    # Get the ps output lines and walk through them Looking for the pids
    my $line;
    my @lines = split( "\n", $ps_output );
    foreach $line (@lines)
    {
        $line =~ s/\s*//g;
        if($line eq "$key" )
        {
            $pidList = $line;
        }
    }
  } else {
    # The process id of apache server
    my $pid;
    open(process_id_file, $httpd_pid_file);
    while( $pid = <process_id_file> )
    {
        chomp( $pid );
        if($pid =~ m/[0-9]+/)
        {
            last;
        }
    }
    #print $pid."\n";
    close process_id_file;
    
    # The ps command is platform specific
    my $ps_command = getPsCommand();

    # Get the apache pids from ps
    # The output will be in the following form:
    # USER       PID %CPU %MEM   SZ  RSS TT       S    START  TIME COMMAND
    # my $key = getHttpServerKey( $install_home );
    # For standalone apache key will be install homw
    my $key = $install_home.$sep."bin".$sep."httpd";
    my $ps_output = `$ps_command | egrep "$key"`;
    #print "$ps_command | egrep $key\n";

    # Get the ps output lines and walk through them Looking for the pids
    my $line;
    my @lines = split( "\n", $ps_output );
    my @tokens;
    foreach $line (@lines)
    {
        #print $line . "\n";
      @tokens = split( " ", $line );
      #print "$tokens[10]\n";
      if($tokens[$LONG_PS_CMD_PID_COL] eq "$pid")
      {
        # Get the pid; it is the second token
        if( $pidList eq "" )
        {
          $pidList = "$tokens[$LONG_PS_CMD_PID_COL]";
        } 
        else
        {
          $pidList = "$pidList,$tokens[$LONG_PS_CMD_PID_COL]";
        }
      }
    } # end foreach line
  } # end if MSWin32

  #print $pidList . "\n";
  return $pidList;
}

# Get the version for the Apache Server 
# parameters:
#   install_home - the install home in which the Apache instance is running
sub getApacheVersion 
{
  my $install_home = shift(@_);
  my $command = $install_home.$sep;

  # on Win32, get the pids from DMS
  if ($osType eq "MSWin32")
  {
      if( !(-e $command."bin".$sep."Apache.exe") )
      {
          $command = $command."Apache.exe"
      }
      else
      {
          $command = $command."bin".$sep."Apache.exe";
      }
  } else {
      if( !(-e $command."bin".$sep."apachectl") )
      {
          $command = $command."apachectl"
      }
      else
      {
          $command = $command."bin".$sep."apachectl";
      }
  } # end if MSWin32
  
  my $output = `"$command" -v`;
  #print $output."\n";
  #print "$ps_command | egrep $key\n";

  # Get the ps output lines and walk through them Looking for the pids
  my @lines = split( "\n", $output );

  chomp($lines[0]);
  #print "$lines[0]\n";
  if($lines[0] =~ m/Apache\//)
  {
      my @tokens = split("Apache\/", $lines[0]);
      #print $tokens[1];
      chomp($tokens[1]);
      return $tokens[1];
  }
  
  return "";
}

# Get a ps command that returns the the username followed by the pid
# plus the full command line.  Note that this command is plateform
# specific.
sub getPsCommand
{
  $ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/lib";

  my $osType = `uname -s`;
  chomp($osType);

  SWITCH:
  {
    $osType eq "SunOS" && do
    {
      return "/usr/ucb/ps auxww";
    };
    $osType eq "HP-UX" && do
    {
      $ENV{UNIX95} = "XPG4";
      return "/bin/ps -efxo user,pid,pcpu,comm";
    };
    $osType eq "Linux" && do
    {
      return "/bin/ps auxww";
    };
    die "Unsupported Operating System\n";
  }
}

