#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/beehive/bhv_assoc.pl /main/5 2012/06/14 11:40:59 fmorshed Exp $
#
# bhv_assoc.pl
# 
# Copyright (c) 2006, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      bhv_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    01/19/12 - With advent of central collector, change query of
#                targets.xml to account for the new hierarchy of tags.
#    vikas       11/11/10 - changing oc4j association to wls
#    rgorle      03/08/09 - Creation 
# 
# Include Libraries
use Getopt::Std;
use XML::Parser;
use IPC::Open2;
use File::Spec;
use ecmAssoc;
use ias::simpleXPath;
use strict;
#------------------------------------------------------------------------
# Global variables
#------------------------------------------------------------------------
my $emdRoot                 = $ENV{CCR_HOME};
my $ccrConfigHome           = $ENV{CCR_CONFIG_HOME};
my $oraHome                 = "";
my $targetsFileLoc          = "";
my $exit_status             = 0;
my $em_result               = "em_result=";
my $em_error                = "em_error=";
my $result_sep              = "|";
my $version                 = "";
my $isWlsStack          = 0; # 0 indicates oc4j and 1 indicates WLS
my $exit_status             = 0;

#input variables
my $input_file              = "";
my $input_obj_id            = "";
my $target_type             = "";

#------------------------------------------------------------------------
# Main Logic
#------------------------------------------------------------------------
parseCommandLine();
my $ohQueryPrefix = '/TargetHomes/TargetHome[@LOCATION="' . $oraHome . '"]';
createAssocs();
#Exit program with the appropriate return status
exit($exit_status);

#------------------------------------------------------------------------
# Parses the command line parameters  and updates the global variables
#------------------------------------------------------------------------
sub parseCommandLine
{
    my %args_hash;
    getopts('i:m:t:o:', \%args_hash);
    $input_file = (exists $args_hash{i} ) ? trim($args_hash{i}) : "";
    $input_obj_id = (exists $args_hash{m} ) ? trim($args_hash{m}) : "";
    $target_type = (exists $args_hash{t} ) ? trim($args_hash{t}) : "";
    $oraHome = (exists $args_hash{o} ) ? trim($args_hash{o}) : "";
    
    if($oraHome eq "") {
        die("$em_error\"ORACLE_HOME not provided.\"\n");
    }

    $emdRoot = (defined $emdRoot) ? trim($emdRoot) : "";
    if($emdRoot eq "") {
        die("$em_error\"CCR_HOME not set.\"\n");
    }

    $ccrConfigHome = (defined $ccrConfigHome) ? trim($ccrConfigHome) : "";
    if($ccrConfigHome eq "") {
        die("$em_error\"CCR__CONFIG_HOME not set.\"\n");
    }

    if($target_type eq "") {
        die("$em_error\"target type not provided.\"\n");
    }
    
    $targetsFileLoc = $ccrConfigHome . "/config/default/targets.xml";
    my $script_file = $emdRoot."/sysman/admin/scripts/beehive/bhv_config.pl";
    #replace \ with / in the input file
    $script_file =~ s/\\/\//g;
    $targetsFileLoc =~ s/\\/\//g;
    #replace /+ with / 
    $script_file=~ s/\/+/\//g;
    $targetsFileLoc =~ s/\/+/\//g;

    if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
    {
        # For Windows change the path  from / to \
        $script_file=~ s/\//\\\\/g;
        $targetsFileLoc=~ s/\//\\\\/g;
    } 
    require "$script_file";
}
#--------------------------------------------------------------------------------------------
# This function fetchs the beehive version 
sub getBeehiveVersion
{

    my $bhvtargets = $_[0];
    my $domain = "";
    my @bhvVersion = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@TYPE="'.$ecmAssoc::BEEHIVE_SITE_TYPE.'"]/Property[@NAME="version"]');
                      
    foreach my $property (@bhvVersion) {
        $version = $$property{'VALUE'};
    }
    
     
    $version =~ m/^((\d)*\.(\d)*)/;  
    $version = $&;
    
    my @domainNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$bhvtargets.'"]/Property[@NAME="domainName"]');
    foreach my $property (@domainNameProps) {
        $domain = $$property{'VALUE'};
    }
    
    if($domain ne ""){
      $isWlsStack =1;
    }
        
    if(($version eq "") && ($domain eq "")) {
            die("$em_error\"beehive version not provided.\"\n");
        }
    

}
#---------------------------------------------------------------------------------------------
sub createAssocs
{
    if(($target_type eq $ecmAssoc::BEEHIVE_SITE_TYPE) && ($input_file ne "")) {
        addSiteDBLdapIASAssocs();
    }
    
    if(-e $targetsFileLoc) {
        my %siteIdHash = ();
        
        my @bhvSiteTargets = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@TYPE="'.$ecmAssoc::BEEHIVE_SITE_TYPE.'"]');
        foreach my $target (@bhvSiteTargets) {
            my $bhvSiteTargetName = $$target{'NAME'};
            my $bhvSiteTargetUniqueId = $$target{'UNIQUE_ID'};

            $siteIdHash{$bhvSiteTargetName} = $bhvSiteTargetUniqueId;
        }

        my @bhvTargets = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@TYPE="'.$target_type.'"]');
        foreach my $target (@bhvTargets) {
            my $bhvTargetName = $$target{'NAME'};
            
            if(($target_type eq $ecmAssoc::BEEHIVE_SITE_TYPE) || ($target_type =~ /inst$/)) {
                my $siteNameValue = "";
                my @siteNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$bhvTargetName.'"]/Property[@NAME="siteName"]');
                foreach my $property (@siteNameProps) {
                    $siteNameValue = $$property{'VALUE'};
                }

                my $unique_id = $siteIdHash{$siteNameValue};

                if($target_type eq $ecmAssoc::BEEHIVE_SITE_TYPE) {                
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_CALDAVAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_CONFERENCEAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_DEVICEMGMTAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_DISCUSSIONSAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_EMAILAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_FTPAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_IMAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_PRESENCEAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_PUSHMAILAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_SEARCHAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_TIMEMGMTAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_USERDIRECTORYAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_VOICEMESSAGEAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_WEBDAVAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_WORKSPACESAPP_TYPE."|".$unique_id."\n";
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::BEEHIVE_XMPPAPP_TYPE."|".$unique_id."\n";
                } else {
                    my @instNameArray = $target_type =~ m/beehive_(.*)inst/g;
                    my $appType = "beehive_".$instNameArray[0]."app";
                    print "em_result=".$ecmAssoc::MEMBER_OF."||".$appType."|".$unique_id."\n";
                
                    #Get Beehive Version to decide whether Beehive is OC4J(2.0 or earlier) based or WLS based 
                    getBeehiveVersion($bhvTargetName);
                    if( $version ne ""){
                        if($version <= 2.0){
                            $isWlsStack = 0;
                        }else{
                            $isWlsStack = 1;
                                
                        }
                    }
                        
                    
                    if (!$isWlsStack){
                     
                        # generate the oc4j target name
                        my $iasName = "";
                        my $oc4jName = "";
                        my @iasNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$bhvTargetName.'"]/Property[@NAME="asName"]');
                        foreach my $property (@iasNameProps) {
                            $iasName = $$property{'VALUE'};
                        }
                        my @oc4jNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$bhvTargetName.'"]/Property[@NAME="oc4jName"]');
                        foreach my $property (@oc4jNameProps) {
                            $oc4jName = $$property{'VALUE'};
                        }
                        my $genOc4jTargetName = $iasName."_".$oc4jName;
                
                        my @oc4jTargets = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@TYPE="oc4j"]');
                        foreach my $target (@oc4jTargets) {
                            my $oc4jTargetName = $$target{'NAME'};

                            if($oc4jTargetName eq $genOc4jTargetName) {
                                my $ohName = "";
                                my $hostName = "";

                                my @ohNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$oc4jTargetName.'"]/Property[@NAME="OracleHome"]');
                                foreach my $property (@ohNameProps) {
                                    $ohName = $$property{'VALUE'};
                                }
                                my @hostNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$oc4jTargetName.'"]/Property[@NAME="HTTPMachine"]');
                                foreach my $property (@hostNameProps) {
                                    $hostName = $$property{'VALUE'};
                                }
                                print "em_result=".$ecmAssoc::RELATES_TO."||".$ecmAssoc::OC4J_TYPE."|".$hostName.":".$ohName.":".$oc4jTargetName."\n";
                            }
                        }
                    }else{
                        #generate the  wls target name
                        
                        my $domainName  = "";
                        my $wlsName     = "";
                    
                            
                        
                        my @domainNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$bhvTargetName.'"]/Property[@NAME="domainName"]');
                        foreach my $property (@domainNameProps) {
                            $domainName = $$property{'VALUE'};
                        }
                    
                        my @wlsNameProps = simpleXPathQuery($targetsFileLoc, $ohQueryPrefix.'Targets/Target[@NAME="'.$bhvTargetName.'"]/Property[@NAME="oc4jName"]');
                        foreach my $property (@wlsNameProps) {
                            $wlsName = $$property{'VALUE'};
                        }
                                
                        # The Wls Target Name would be like /Farm_beehive_domain/beehive_domain/BEEAPP

                        my $wlsTargetName = "/Farm_".$domainName."/".$domainName."/".$wlsName;
                        
                        my $wlsDomainHome = "";
                        my $volume = "";
                        my $directories ="";
                        my $endfile = "" ;
                        my $line = "";
                        ($volume,$directories,$endfile) = File::Spec->splitpath( $oraHome );
                    
                            
                        my $file = $volume.$directories."wlserver_10.3/common/nodemanager/nodemanager.domains";
                         
                        if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
                        {
                            # For Windows change the path  from / to \
                            $file =~ s/\//\\/g;
                            
                            # replace \: with \
                            $file =~ s/\\:/:/; 
                            $file=~ s/\//\\\\/g;
       
                        }else{
                            #replace \ with /
                            $file =~ s/\\/\//g;
                            #replace /+ with / 
                            $file=~ s/\/+/\//g;
                        }
                        my $file_exists = open(HANDLE, $file ); 

                        if($file_exists){
        
                            while( $line = <HANDLE> ){
                                chomp($line); 
                                my @values = split('=', $line);
                                if($values[0] eq $domainName){
                                    $wlsDomainHome = $values[1];
                                    last;
                                }
                            }
                        }

                        if($wlsDomainHome ne ""){
                            if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
                            {
                                # For Windows change the path  from / to \
                                $wlsDomainHome =~ s/\//\\/g;
                                # replace \: with \
                                $wlsDomainHome =~ s/\\:/:/;
                                # replace \+ with \
                                $wlsDomainHome =~ s/\\+/\\/g;
                            
       
                            }else{
                                #replace \ with /
                                $wlsDomainHome =~ s/\\/\//g;
                                #replace /+ with / 
                                $wlsDomainHome =~ s/\/+/\//g;
                            }
                        }       

                        
                        print "em_result=".$ecmAssoc::RELATES_TO."|".$wlsTargetName."|".$ecmAssoc::ORACLE_WEBLOGIC_SERVER."|".$wlsDomainHome."\n";
                            
                    }
                    
                }
                
            }
        }
    }
}
#---------------------------------------------------------------------------------------------
sub addSiteDBLdapIASAssocs 
{
    my $full_output = getOutputTargets($input_file, $input_obj_id, "", $oraHome);
    $full_output =~ m/<DiscoveryResult>([\S*\s*]*)<\/DiscoveryResult>/g;
    
    my $command_output = (defined $1) ? trim($1) : "";
    if($command_output ne "")
    {
        $command_output = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DiscoveryResult>\n".$command_output."\n<\/DiscoveryResult>\n";
    }
    
    my $parser = new XML::Parser(Handlers => {Init => \&handle_Init, Start => \&handle_Start,End => \&handle_End, Final => \&handle_Final});
    my $targetsNode;
    if($command_output ne ""){
        my $rootNode = $parser->parsestring($command_output);
        if (($rootNode ne "") && (ref($rootNode) eq 'HASH')) {
            #create the db association
            my $connDescriptor = $rootNode->{"DbConnectDescriptor"};
            
            my $rac_result = "";
            my $db_result = "";
            
            if (((my $dbHost, my $dbPort, my $dbService) = ($connDescriptor =~ /\s*.*?HOST=(.*?)\)\(PORT=(.*?)\).*?SERVICE_NAME=(.*?)\).*?/)) != 0) {
                $rac_result = $dbHost.":".$dbPort.":".$dbService;
                $db_result = $dbHost.":".$dbService;
            }

            #first we need to determine if it it a DB instance or RAC
            #check if it is a DB instance
            if ((my $db_index = index ($connDescriptor, "LOAD_BALANCE=")) == -1) {
                #it is is RAC, 
                print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::ORACLE_DATABASE_TYPE."|".$db_result."\n";
            }
            else {
                # we can return any DB instance for this RAC and LL can find out the actual host
                print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ecmAssoc::RAC_DATABASE_TYPE."|".$rac_result."\n";    
            }

            #create the ldap association
            my $ldapDirType = $rootNode->{"DirectoryType"};
            my $ldapHost = $rootNode->{"LdapServerHostName"};
            my $ldapPort = $rootNode->{"LdapServerPort"};
            my $ldapSSLPort = $rootNode->{"LdapServerSslPort"};
            
            my $ldapTargetType = "";
            if($ldapDirType eq "ORACLE_INTERNET_DIRECTORY") {
                $ldapTargetType = $ecmAssoc::ORACLE_LDAP_TYPE;
            }elsif($ldapDirType eq "MICROSOFT_ACTIVE_DIRECTORY") {
                $ldapTargetType = "active_directory";
            }elsif($ldapDirType eq "IBM_TIVOLI_DIRECTORY") {
                $ldapTargetType = "ibm_tivoli_directory";
            }elsif($ldapDirType eq "SUN_ONE_DIRECTORY") {
                $ldapTargetType = "sun_one_directory";
            }
            if((length($ldapTargetType) > 0) && (length($ldapHost) > 0) && (length($ldapPort) > 0) && (length($ldapSSLPort) > 0)) {
                print "em_result=".$ecmAssoc::CONNECTS_TO."||".$ldapTargetType."|".$ldapHost.":".$ldapPort.":".$ldapSSLPort."\n";
            }

            # create the ias association
            my $iasHomes = $rootNode->{"IASProperties"};
            for (my $i = 0; $i <= $#$iasHomes; $i++) {
                my $iasHome = $iasHomes->[$i];
                if((length($iasHome->{"PrimaryHostName"}) > 0) && (length($iasHome->{"OracleHome"}) > 0)) {
                    print "em_result=".$ecmAssoc::CONTAINS."||".$ecmAssoc::ORACLE_IAS_TYPE."|".$iasHome->{"PrimaryHostName"}.":".$iasHome->{"OracleHome"}."\n";
                }
            }
        }
    }
}
#---------------------------------------------------------------------------------------------
sub handle_Init {
    my $expat = shift;
    $expat->{DBLdapIASProperties} = ();
    $expat->{DBLdapIASProperties}->{"DbConnectDescriptor"} = "";
    $expat->{DBLdapIASProperties}->{"DirectoryType"} = "";
    $expat->{DBLdapIASProperties}->{"LdapServerHostName"} = "";
    $expat->{DBLdapIASProperties}->{"LdapServerPort"} = "";
    $expat->{DBLdapIASProperties}->{"LdapServerSslPort"} = "";
    $expat->{DBLdapIASProperties}->{"IASProperties"} = [];
}
#---------------------------------------------------------------------------------------------
sub handle_Start {
    (my $expat, my $tag, my %atts) = @_;
    if($tag eq "Property") {
        if(exists %atts->{"DbConnectDescriptor"}) {
            $expat->{DBLdapIASProperties}->{"DbConnectDescriptor"} = trim(%atts->{"DbConnectDescriptor"});    
        }elsif((exists %atts->{"DirectoryType"}) && (exists %atts->{"LdapServerHostName"}) && (exists %atts->{"LdapServerPort"}) && (exists %atts->{"LdapServerSslPort"})) {
            $expat->{DBLdapIASProperties}->{"DirectoryType"} = trim(%atts->{"DirectoryType"});    
            $expat->{DBLdapIASProperties}->{"LdapServerHostName"} = trim(%atts->{"LdapServerHostName"});    
            $expat->{DBLdapIASProperties}->{"LdapServerPort"} = trim(%atts->{"LdapServerPort"});    
            $expat->{DBLdapIASProperties}->{"LdapServerSslPort"} = trim(%atts->{"LdapServerSslPort"});    
        }elsif((exists %atts->{"PrimaryHostName"}) && (exists %atts->{"OracleHome"})) {
            $expat->{IASProperty} = ();
            $expat->{IASProperty}->{"PrimaryHostName"} = trim(%atts->{"PrimaryHostName"});    
            $expat->{IASProperty}->{"OracleHome"} = trim(%atts->{"OracleHome"});    
            push @{$expat->{DBLdapIASProperties}->{"IASProperties"}}, $expat->{IASProperty};
        }
    }
}
#---------------------------------------------------------------------------------------------
sub handle_End {
    (my $expat,my $tag) = @_;
}
#---------------------------------------------------------------------------------------------
sub handle_Final {
    my $expat = shift;
    delete $expat->{IASProperty};
    $expat->{DBLdapIASProperties};
}
#---------------------------------------------------------------------------------------------
sub trim 
{
    my @out = @_;
    for(@out) 
    {
        s/^\s+//;
        s/\s+$//;
    }
    return wantarray ? @out : $out[0];
}
