#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/beehive/bhv_ecm.pl /main/1 2009/06/27 00:41:48 rgorle Exp $
#
# bhv_ecm.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      bhv_ecm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rgorle      03/08/09 - Creation
# 
# Include Libraries
use Getopt::Std;
use XML::Parser;
use Text::ParseWords;
use IPC::Open2;
use strict;

#------------------------------------------------------------------------
# Global variables
#------------------------------------------------------------------------
my $emdRoot                 = $ENV{CCR_HOME};
my $oraHome                 = "";
my $bean_name               = "beanName";
my $exit_status             = 0;
my $em_result               = "em_result=";
my $em_error                = "em_error=";
my $em_format               = "em_format";
my $is_table                = "is_table";
my $result_sep              = "|";
my $result_sep1              = '\|';

#input variables
my $input_file              = "";
my $input_obj_id            = "";
my $input_obj_type         = "";

# Error codes
my $parse_error_code        = "";
my $parse_error_msg        = "";

#------------------------------------------------------------------------
# Main Logic
#------------------------------------------------------------------------
parseCommandLine();
printResult();
#Exit program with the appropriate return status
exit($exit_status);

#------------------------------------------------------------------------
# Parses the command line parameters  and updates the global variables
#------------------------------------------------------------------------
sub parseCommandLine
{
    my %args_hash;
    getopts('i:m:t:o:', \%args_hash);
    $input_file = (exists $args_hash{i} ) ? trim($args_hash{i}) : "";
    $input_obj_id = (exists $args_hash{m} ) ? trim($args_hash{m}) : "";
    $input_obj_type = (exists $args_hash{t} ) ? trim($args_hash{t}) : "";
    $oraHome = (exists $args_hash{o} ) ? trim($args_hash{o}) : "";

    if($oraHome eq "")
    {
        die("$em_error\"ORACLE_HOME not provided.\"\n");
    }

    $emdRoot = (defined $emdRoot) ? trim($emdRoot) : "";
    if($emdRoot eq "")
    {
        die("$em_error\"CCR_HOME not set.\"\n");
    }

    my $script_file = $emdRoot."/sysman/admin/scripts/beehive/bhv_config.pl";
    #replace \ with / in the input file
    $script_file =~ s/\\/\//g;
    #replace /+ with / 
    $script_file=~ s/\/+/\//g;

    if (($^O =~ "Windows") || ($^O =~ "MSWin32"))  # windows platforms
    {
        # For Windows change the path  from / to \
        $script_file=~ s/\//\\\\/g;
    }
    require "$script_file";
}
#---------------------------------------------------------------------------------------------
sub printResult 
{
    my $full_output = getOutputTargets($input_file, $input_obj_id, $input_obj_type, $oraHome);
    $full_output =~ m/<DiscoveryResult>([\S*\s*]*)<\/DiscoveryResult>/g;
    
    my $command_output = (defined $1) ? trim($1) : "";
    if($command_output ne "")
    {
        $command_output = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DiscoveryResult>\n".$command_output."\n<\/DiscoveryResult>\n";
    }

    my $parser = new XML::Parser(Handlers => {Init => \&handle_Init, Start => \&handle_Start,End => \&handle_End, Final => \&handle_Final});
    if($command_output ne ""){
        $parser->parsestring($command_output);
    }else{
#        EMD_PERL_ERROR("bhv_ecm.pl: Error: Input file:$input_file , msg:No Data.");
        die("$em_error\"No Data.\"\n");
    }

    if($parse_error_code ne "") {
#        EMD_PERL_ERROR("bhv_ecm.pl: Error: Input file:$input_file , msg:$parse_error_msg.");
        print "$em_error\"$parse_error_msg\"\n";
    }
}
#---------------------------------------------------------------------------------------------
sub handle_Init {
    my $expat = shift;
}
#---------------------------------------------------------------------------------------------
sub handle_Start {
    (my $expat, my $tag, my %atts) = @_;
    if($tag eq "Target") {
        $expat->{Properties} = [];
        $expat->{Emformat} = "";
        $expat->{IsTable} = "";
    }elsif($tag eq "Property") {
        if(defined %atts->{$em_format}) {
            $expat->{Emformat} = trim(%atts->{$em_format});
        }elsif(defined %atts->{$is_table}) {
            $expat->{IsTable} =  trim(%atts->{$is_table});
        }elsif(not defined %atts->{$bean_name}) {
            $expat->{Property} = ();
            my @keys = keys %atts;
            foreach my $key (@keys) {
                $expat->{Property}->{$key} = (defined %atts->{$key} ) ? trim(%atts->{$key}) : "";
            }
            push @{$expat->{Properties}},$expat->{Property};
        }
    }elsif($tag eq "Error") {
        $parse_error_code = (defined %atts->{"code"}) ? trim(%atts->{"code"}) : "";
        $parse_error_msg = (defined %atts->{"message"}) ? trim(%atts->{"message"}) : "";
    }
}
#---------------------------------------------------------------------------------------------
sub handle_End {
    (my $expat,my $tag) = @_;
    if($tag eq "Target") {
        my $is_table_flag = "false";
        if($expat->{IsTable} eq "true") {
            $is_table_flag = "true";
        }
        
        if($expat->{Emformat} ne "") {
            my @tokens = &quotewords($result_sep1, 0, $expat->{Emformat});
            my $props = $expat->{Properties};
            for (my $i = 0; $i <= $#$props; $i++) {
                my $is_one_prop_avail = "false";
                my $em_output = "";
                foreach my $token (@tokens) {
                    my $value = (defined $props->[$i]->{$token} ) ? trim($props->[$i]->{$token}) : "";
                    if($value ne "") {
                        $is_one_prop_avail = "true";
                    }
                    if($em_output eq "") {
                        $em_output = $em_result.$value;
                    }else {
                        $em_output = $em_output.$result_sep.$value;
                    }
                }
                if(($is_table_flag eq "false") || ($is_one_prop_avail eq "true")) {
                    print "$em_output\n";
		        }
            }
        }

        delete $expat->{Properties};
        delete $expat->{Property};
        delete $expat->{Emformat};
        delete $expat->{IsTable};
    }
}
#---------------------------------------------------------------------------------------------
sub handle_Final {
    my $expat = shift;
}
#---------------------------------------------------------------------------------------------
sub trim 
{
    my @out = @_;
    for(@out) 
    {
        s/^\s+//;
        s/\s+$//;
    }
    return wantarray ? @out : $out[0];
}
