#!/usr/local/bin/perl
# 
# $Header: cluster_controller_assoc.pl 18-apr-2007.21:39:41 ckannusa Exp $
#
# cluster_controller_assoc.pl
# 
# Copyright (c) 2007, Oracle. All rights reserved.  
#
#    NAME
#      cluster_controller_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ckannusa    04/18/07 - biutil Package Removed
#    aime        03/21/07 - 
#    ckannusa    02/04/07 - Cluster Controller Association.
#    ckannusa    02/04/07 - Creation
#
use hostOSD;
use iniparser;
use ecmAssoc;
use biutil;
my $SAROOTDIR=$ARGV[0];
my $host=$ARGV[2];
my $configFile=$ARGV[3];
my $oracleHome =$ARGV[4];
if (-f $configFile)
{
    #$lines = `cat $configFile`; #read the file
    my $lines = &getContent($configFile);
    $lines =~s/\/\/(.*)//g;
    $lines =~s/\s/ /g; #replace all newline chars etc by spaces
    my $server=iniparser::getAttribValue($lines,"CLUSTER","SERVERS");
    $server=~s/\"//g;
    my $serverPort=iniparser::getAttribValue($lines,"CLUSTER","CLIENT_SERVER_PORT");
    if (index($server,",") == -1 )
    {
        #one server only
        $server=&hostOSD::getHostNameForIP($server);
        if (($server eq "local") or ($server eq "localhost") )
        {
            $server=$host;
        }
        if( (length($server)!=0) and (length($serverPort)!=0) and !(($server=~/^</) and ($server=~/>$/)) )
        {
            $targetProp=sprintf("%s:%s",$server,$serverPort);
            print "em_result=$ecmAssoc::CONTAINS||$ecmAssoc::ORACLE_BI_ANS|$targetProp|\n";
        }
    
    }
    else
    {
        my @serverArray=split(/\,/, $server);   
        foreach(@serverArray)
        {
            my $serverName=trim($_);
            $serverName=&hostOSD::getHostNameForIP($serverName);
            if (($serverName eq "local") or ($serverName eq "localhost") )
            {
                $serverName=$host;
            }
            if( (length($serverName)!=0) and (length($serverPort)!=0) and !(($server=~/^</) and ($server=~/>$/)) )
            {
                $targetProp=sprintf("%s:%s",$serverName,$serverPort);       
                print "em_result=$ecmAssoc::CONTAINS||$ecmAssoc::ORACLE_BI_ANS|$targetProp|\n";
            }
        }
    
    }
    #Scheduler Association
    my $schServer=iniparser::getAttribValue($lines,"CLUSTER","SCHEDULERS"); 
    $schServer=~s/\"//g;
    if (index($schServer,",") == -1 )
    {
            #print "one server only";
    
            my @schServerArray=split(/:/, $schServer);
            my $schServerName=&hostOSD::getHostNameForIP(trim($schServerArray[0]));
            my $schServerPort=trim($schServerArray[1]);
            if (($schServerName eq "local") or ($schServerName eq "localhost") )
            {
                $schServerName=$host;
            }
            if ( (length($schServerName)!=0) and !(($schServerName=~/^</) and ($schServerName=~/>$/)) )
            {
                #$targetProp=sprintf("%s:",$schServerName);
                $targetProp=sprintf("%s:%s",$schServerName,$schServerPort);
                print "em_result=$ecmAssoc::CONTAINS||$ecmAssoc::ORACLE_BI_SCH|$targetProp|\n";
            }

    }
    else
    {
            my @schServerArray=split(/\,/, $schServer);
            foreach(@schServerArray)
            {
                my @schServerArraySingle=split(/\:/, $_);
                my $schServerName=trim($schServerArraySingle[0]);
                my $schServerPort=trim($schServerArraySingle[1]);
                $schServerName=&hostOSD::getHostNameForIP($schServerName);
                if (($schServerName eq "local") or ($schServerName eq "localhost") )
                {
                    $schServerName=$host;
                }
                if( (length($schServerName)!=0)  and !(($schServerName=~/^</) and ($schServerName=~/>$/)))
                {
                    #$targetProp=sprintf("%s:",$schServerName);
                    $targetProp=sprintf("%s:%s",$schServerName,$schServerPort);
                    print "em_result=$ecmAssoc::CONTAINS||$ecmAssoc::ORACLE_BI_SCH|$targetProp|\n";
                }
            }

    }
}
else
{
    print "em_error=Cannot perform ECM Associations.config File not Found ..$configFile";
}
