#!/usr/local/bin/perl
# 
# $Header: present_server_assoc.pl 18-apr-2007.21:50:11 ckannusa Exp $
#
# present_server_assoc.pl
# 
# Copyright (c) 2007, Oracle. All rights reserved.  
#
#    NAME
#      present_server_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ckannusa    04/18/07 - biutil package removed
#    ckannusa    04/04/07 - add association for cc
#    aime        03/21/07 - 
#    ckannusa    01/31/07 - Creation
#
use ias::simpleXPath;
use hostOSD;
use iniparser;
use ecmAssoc;
use biutil;
my $SAROOTDIR=$ARGV[0]; 
my $host=$ARGV[2];
my $instanceConfigFile=$ARGV[3];
my $oracleHome =$ARGV[4];
my $odbcfilename=sprintf("%s%s",$oracleHome,"/setup/odbc.ini");
my $configQuery="WebConfig/ServerInstance/DSN";
if (-f $instanceConfigFile)
{
	my $portNumber,$servermachine,$isClustered,$ecmTarget;
	my @startParams = simpleXPathQueryForText($instanceConfigFile,$configQuery);
	my $conVal =$startParams[0]; 
	#print $conVal;
	my $os=get_osType();
	if ($os ne 'WIN')
	{
		if (-f $odbcfilename)
		{
			my $lines = &getContent($odbcfilename);
			$lines =~s/\/\/(.*)//g;
			$lines =~s/#(.*)//g;
			$lines =~s/\]\s+/\] /g; 
			$lines =~s/^\s*\[/\[/g; 
			$_ = $lines;
			if (m/;/)
			{
					$lines =~s/[\n\r]+/ /g; 
			}
			else
			{
					$lines =~s/[\n\r]+/;/g; 
			}
			#if clustered associate to CC else to ANS
			$isClustered=iniparser::getAttribValue($lines,$conVal,"IsClusteredDSN");
			if (lc($isClustered) eq "yes")
			{
				$portNumber=iniparser::getAttribValue($lines,$conVal,"PrimaryCCSPort");
				$servermachine=iniparser::getAttribValue($lines,$conVal,"PrimaryCCS");
				$ecmTarget=$ecmAssoc::ORACLE_BI_CC;

			}
			else
			{
				$portNumber=iniparser::getAttribValue($lines,$conVal,"Port");
				$servermachine=iniparser::getAttribValue($lines,$conVal,"ServerMachine");
				$ecmTarget=$ecmAssoc::ORACLE_BI_ANS;
			}
		}
	}
	else
	{
		($ecmTarget,$servermachine,$portNumber)=&getDSNHostPortForPS($conVal);
	}
	if ((lc($servermachine) eq "local") or (lc($servermachine) eq "localhost") )
	{
		$servermachine=$host;
	}
	if ( (length($servermachine)!=0) and (length($portNumber)!=0) )
	{
		$servermachine=&hostOSD::getHostNameForIP($servermachine);
		my $targetprop=sprintf("%s:%s",$servermachine,$portNumber);
		print "em_result=$ecmAssoc::MEMBER_OF||$ecmTarget|$targetprop|\n";
	}

	#Association for Scheduler
	my $schConfigQuery="WebConfig/ServerInstance/Alerts/ScheduleServer";
	my @schParams = simpleXPathQueryForText($instanceConfigFile,$schConfigQuery);
	#my $schServer =$schParams[0];
	my($schServer,$schPort) = parseHostPortSchedulerAssoc($schParams[0]);
	$schServer=trim($schServer);
	if ((lc($schServer) eq "local") or (lc($schServer) eq "localhost") )
	{
		$schServer=$host;
	}
	if (length($schServer)!=0)
    	{
		$schServer=&hostOSD::getHostNameForIP($schServer);
		#my $schTargetProp=sprintf("%s:",$schServer);#as of now
		my $schTargetProp = sprintf("%s:%s",$schServer,$schPort);
		print "em_result=$ecmAssoc::DEPENDS_ON||$ecmAssoc::ORACLE_BI_SCH|$schTargetProp|\n";
	}

}
else
{
	print "em_error=Unable to perform ECM Association.Config File Not Found..$instanceConfigFile";
}
