#!/usr/local/bin/perl
# 
# $Header: web_plugin_assoc.pl 19-feb-2008.21:47:03 ckannusa Exp $
#
# web_plugin_assoc.pl
# 
# Copyright (c) 2007, 2008, Oracle. All rights reserved.  
#
#    NAME
#      web_plugin_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ckannusa    02/19/08 - Fix Association bug 6759506
#    ckannusa    04/18/07 - biutil package removed
#    ckannusa    04/10/07 - Add Saw Servers Association CLuster
#    ckannusa    04/04/07 - add localhost conversion
#    ckannusa    03/29/07 - 
#    aime        03/28/07 - web plugin association
#    aime        03/28/07 - Creation
# 
use hostOSD;
use iniparser;
use ecmAssoc;
use biutil;
my $SAROOTDIR=$ARGV[0]; 
my $host=$ARGV[2];
my $instanceConfigFile=$ARGV[3];
my $oracleHome =$ARGV[4];
my $pluginType =$ARGV[5];
#if config file exists take it or get it from 
#registry(applicable only for windows IIS Plugin in 7.8 series)
my $os=get_osType();
my $version=getVersion($oracleHome);
my @addrArray;
if ($pluginType eq "OC4J")
{
	if (-f $instanceConfigFile)
	{
		my (%defaulthash)=getOC4JConfigs($instanceConfigFile);
		@addrArray=getOC4JSAWServers(\%defaulthash,$version);
	}
	else
	{
		print "em_error=Unable to perform ECM Association.Config File Not Found..$instanceConfigFile";
	}
}
elsif ($pluginType eq "IIS")
{
	if (-f $instanceConfigFile)
	{
		@addrArray=getIISSAWServers($instanceConfigFile);
	}
	elsif (($os eq "WIN") and ($version=~/^7.8/))
	{
		($server,$port) = getIISConnectStrFor7Dot8();
		push(@addrArray,$server.":".$port);
	}
	else
	{
		print "em_error=Unable to perform ECM Association.Config File Not Found..$instanceConfigFile";
	}
}
my $count = scalar(@addrArray);
if( $count!=0 )
{
	foreach(@addrArray)
	{
		my ($server,$port) = parseHostPort($_);
		$server=&hostOSD::getHostNameForIP($server);
                if ((lc($server) eq "local") or (lc($server) =~/^localhost/) )
                {
                        $server=$host;
                }

		my $targetProp=$server.":".$port;
		print "em_result=$ecmAssoc::RELATES_TO||$ecmAssoc::ORACLE_BI_PS|$targetProp|\n";
	}

}
