#package biutil;

use Exporter;
use ias::simpleXPath;
use ecmAssoc;
use hostOSD;
@ISA         = ('Exporter');
@EXPORT_OK      = ('getDefaultAttribs','getPropValues','isMemoryUnit','convert2KB','get_osType','getContent','getWinEnvVariables','getOC4JConfigs','getIISConnectStrFor7Dot8','getSchConfigFromRegistry','parseHostPortSchedulerAssoc','getOC4JSSLConfig','getConfigFilePath','getDSNHostPortForPS','getIISSAWServers','getOC4JSAWServers','parseHostPort','getVersion');

sub isMemoryUnit
{
        my $config = shift(@_);
        my $value  = shift(@_);
        if ( ($config =~ /SIZE$/) and ( ( $value=~/KB/i ) or ( $value=~/MB/i ) or ( $value=~/GB/i ) ) )
        {
                return "TRUE";
        }
        else 
        {       
                return "FALSE";
        }

}
sub convert2KB
{
        my $sizeKB=0;
        my $value  = shift(@_);
        if  ( $value=~/KB/i )
        {
                $sizeKB = substr($value,0,-2);
        }
        elsif  ( $value=~/MB/i )
        {
                $sizeKB = substr($value,0,-2);
                $sizeKB=$sizeKB*1024;
        }
        elsif  ( $value=~/GB/i )
        {
                $sizeKB = substr($value,0,-2);
                $sizeKB=$sizeKB*1024*1024;
        }
        return trim($sizeKB);
}
sub getConfigFilePath
{
	my $oracleHome = shift(@_);
	my $targetType = shift(@_);
	my $configPath;
	my $version =getVersion($oracleHome);
	if ($version=~/^7.8/)
	{
		$path="/Config/";
	}
	else 
	{
		$path="/server/Config/";
	} 

	if ($targetType eq $ecmAssoc::ORACLE_BI_ANS)
	{
		$configPath=sprintf("%s%s", $path, "NQSConfig.INI");
	}
	elsif ($targetType eq $ecmAssoc::ORACLE_BI_CC)
	{
		$configPath=sprintf("%s%s", $path, "NQClusterConfig.INI");
	}
	return $configPath;

}
sub getVersion
{
	my $version;
	my $oracleHome= shift(@_);
	my $versionFile="version.txt";
	my $versionPath=sprintf("%s/%s",$oracleHome,$versionFile);
	if(-f $versionPath)
	{
		open FILE,$versionPath;
		while( $line = <FILE>)
		{
				my $index=index($line,"Oracle Business Intelligence");
				if ($index ne -1 )
				{
						$version=substr($line,($index+length("Oracle Business Intelligence")+1));
				}
		}
		close FILE;
	}
	else
	{
		$versionPath=sprintf("%s%s%s",$oracleHome,"/Document/",$versionFile);
		if(-f $versionPath)
		{
			open FILE,$versionPath;

			while( $line = <FILE>)
			{
					my $index=index($line,"Siebel Analytics");
					if ($index ne -1 )
					{
							$version=substr($line,($index+length("Siebel Analytics")+1));
					}
			}
			close FILE;
		}


	}
	$version=~s/\s//;
	return $version;
}
sub getDefaultAttribs
{
        my $file=shift(@_);
        my $path=shift(@_);
        my @startParams = simpleXPathQueryForNodes($file,$path);
        my %allAttribs;
        for my $resultRef (@startParams)
        {
                my %somemap = %$resultRef;
                my @attribs=split('\n',ias::simpleXPath::getStringValue($resultRef));
                my $name=trim($attribs[1]);
                my $value=trim($attribs[6]);
                $allAttribs{$name}=$value;
        }
#       while(($key,$value)=each %AllAttribs)
#        {
#               print "$key is $AllAttribs{$key}  \n";
#        }
 return %allAttribs;
}
sub getOC4JConfigs
{
        my $filename=shift(@_);
        my %allAttribs;
		my $configQry="web-app/servlet/init-param";
		my @confRoot = simpleXPathQueryForNodes($filename,$configQry);
		for my $resultRef (@confRoot)
		{
			#print ias::simpleXPath::getStringValue($resultRef);
		        my @childRef=ias::simpleXPath::getChildren($resultRef,"param-name");
			my $name = trim(ias::simpleXPath::getStringValue(@childRef));
	       		my @childRefVal=ias::simpleXPath::getChildren($resultRef,"param-value");
		    	my $value = trim(ias::simpleXPath::getStringValue(@childRefVal));
			$allAttribs{$name}=$value;
		}
		 return %allAttribs;

}
sub getPropValues
{
	my %props;
        my $commonFile = shift(@_);
        open (COMMONFILE, $commonFile);
        my $SAROOTDIR;
        my $SADATADIR;
        $count = 0;
        while ($record = <COMMONFILE>)
        {
		$record=trim($record);
		if(index($record,"#") == 0) 
		{
			next;
		}
                my $eqIndex=index($record,"=");
                my $name = substr($record,0,$eqIndex);
                my $value = substr($record,$eqIndex+1);
		$name=trim($name);
		$value=trim($value);
                $props{$name}=$value;
		

		$count++;
              #print $record;
           }
        close(COMMONFILE);
        return %props;
	
}
sub getContent()
{
	my $content = shift(@_);
	open FILE, $content or die "Couldn't open file: $!";
	$string = join("", <FILE>); 
	close (FILE);
	return $string;
}
sub getWinEnvVariables
{
	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $saroot = $Registry->{"HKEY_LOCAL_MACHINE/SYSTEM/CurrentControlSet/Control/Session Manager/Environment/SAROOTDIR"};
	my $sadata = $Registry->{"HKEY_LOCAL_MACHINE/SYSTEM/CurrentControlSet/Control/Session Manager/Environment/SADATADIR"};
	$saroot=trim($saroot);
	$sadata=trim($sadata);
	if(length($saroot)==0)
	{
		$saroot = $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Common/7.8/ProgramDir"};
		$saroot=trim($saroot);
	}
	if(length($sadata)==0)
	{
		$sadata = $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Common/7.8/DataDir"};
		$sadata=trim($sadata);
	}
	
	return $saroot,$sadata;
}
sub getDSNHostPortForPS
{
	my $dsn = shift(@_);
	my $hostQry,$portQry,$ecmTarget;
	$portQry=sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/Port");
	my $isClusteredQry =sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/IsClusteredDSN"); 

	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $isClustered = $Registry->{$isClusteredQry};
	if (lc($isClustered) eq "yes")
	{
		$hostQry=sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/PrimaryCCS");  
		$ecmTarget=$ecmAssoc::ORACLE_BI_CC;
	}
	else
	{
		$hostQry=sprintf("%s%s%s", "HKEY_LOCAL_MACHINE/SOFTWARE/ODBC/ODBC.INI/",$dsn,"/ServerMachine"); 
		$ecmTarget=$ecmAssoc::ORACLE_BI_ANS;
	}

	my $server = $Registry->{$hostQry};
	my $port = $Registry->{$portQry};
	$server=trim($server);
	$port=trim($port);
	return $ecmTarget,$server,$port;
}

sub parseHostPortSchedulerAssoc
{
	#format host:port
	my $url = shift(@_);
	my $index = rindex($url,":");
	my $host,$port;
	if ($index == -1 )
	{
		$host=$url;
		$port="9705";
	}
	else
	{
		$port=substr($url,$index+1);
		$host=substr($url,0,$index);
	}
	$host=trim($host);
	$port=trim($port);
	return $host,$port;
}
sub parseHostPort
{
        #format host:port
        my $url = shift(@_);
        my $index = rindex($url,":");
        my $host,$port;
	$port=substr($url,$index+1);
	$host=substr($url,0,$index);
        $host=trim($host);
        $port=trim($port);
        return $host,$port;
}
sub getIISConnectStrFor7Dot8
{
	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $connectStr = $Registry->{"HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Web/7.8/ISAPI/ServerConnectString"};
	my $indexColon = rindex($connectStr,":");
	my $indexPtcl = rindex($connectStr,"/");
	my $port=substr($connectStr,$indexColon+1);
	my $host=substr($connectStr,0,$indexColon);
	$host=substr($host,$indexPtcl+1);
	$host=trim($host);
	$port=trim($port);
	return $host,$port;

}
sub getOC4JSAWServers
{
	my (%oc4jConfig) = %{shift(@_)};
	my $version = shift(@_);
	my $val=$oc4jConfig{"com.siebel.analytics.web.sawservers"};
	my @sawServer=split(";",$val);
	my $count=scalar(@sawServer);
	if ($count==0)
	{
		my $hostQry,$portQry;
		if ($version=~/^7.8/)
		{
			$hostQry="com.siebel.analytics.web.SAWServer.Host";
			$portQry="com.siebel.analytics.web.SAWServer.Port";
		}
		else
		{
			$hostQry="oracle.bi.presentation.sawserver.Host";
			$portQry="oracle.bi.presentation.sawserver.Port";
		}	
		my $add=$oc4jConfig{$hostQry};
		my $port=$oc4jConfig{$portQry};
		my $serveradd=$add.":".$port;
		$serveradd=trim($serveradd);
		push(@sawServer,$serveradd);	
	}
	return @sawServer;	
}
#Returns the list of SAW Server for Load Balancing or else 
#from ServerConnectInfo 
sub getIISSAWServers
{
	my $filename = shift(@_);
	my $configQry = "WebConfig/ServerInstance/ServerConnectInfo/Hosts/Host";
	my @confRoot = simpleXPathQueryForNodes($filename,$configQry);
	my @serverArray,$serveradd;
	foreach ( @confRoot)
	{
		my $add=ias::simpleXPath::getAttribute($_,"address");
		my $port=ias::simpleXPath::getAttribute($_,"port");
		$serveradd=$add.":".$port;
		push(@serverArray,$serveradd);
	}
	my $count=scalar(@serverArray);
	if ($count == 0)
	{
		$configQry = "WebConfig/ServerInstance/ServerConnectInfo";
		@confRoot = simpleXPathQueryForNodes($filename,$configQry);
		my $add=ias::simpleXPath::getAttribute(@confRoot,"address");
		my $port=ias::simpleXPath::getAttribute(@confRoot,"port");
		$serveradd=$add.":".$port;
		push(@serverArray,$serveradd);
	}
	return @serverArray;
}
sub getOC4JSSLConfig
{
	#hard coded values for oc4j ssl config
	my $version = shift(@_);
	my $config = shift(@_);
	my $conVal;
	if ($config eq "ssl")
	{
		$conVal="com.siebel.analytics.Secure";
	}
	elsif ($config eq "path")
	{
		$conVal="com.siebel.analytics.SSL.CertStoreFile";
	}
	elsif ($config eq "credentialAlias")
	{
		$conVal="com.siebel.analytics.SSL.CertAlias";
	}
	return $conVal;
}
sub getSchConfigFromRegistry
{
	my $configQry = shift(@_);
	my $config = shift(@_);
	if ($configQry eq "ServerInstance")
	{
		$configQry="";
	}
	elsif ($configQry eq "ServerInstance/Mail")
	{
		$configQry="Mail";
	}
	elsif ($configQry eq "ServerInstance/iBots")
	{
		$configQry="IBots";
	}
	if ($config eq "SMTP_Port")
	{
		$config="SMTP Port";
	}
	elsif ($config eq "SMTP_Server")
	{
		$config="SMTP Server";
	}
	elsif ($config eq "Log_Dir")
	{
		$config="Log Dir";
	}

	elsif ($config eq "Web_Server")
	{
		$config="Web Server";
	}

	my $qry=sprintf("%s/%s/%s", "HKEY_LOCAL_MACHINE/SOFTWARE/Siebel Systems, Inc./Siebel Analytics/Scheduler/7.8",$configQry,$config); 
	eval 'use Win32::TieRegistry;';
	$Registry->Delimiter("/");
	my $value = $Registry->{$qry};
	$value=trim($value);
	return $value;
}
sub get_osType
{
    if (( $^O eq "Windows_NT") ||
        ( $^O eq "MSWin32")) {
        return "WIN";
    }

    my $os = `uname -s`;
    my $ver = `uname -r`;
    chomp ($os);

    if ( $os eq "SunOS" ) {
        if ( chomp($ver) !~ /^4./ ) {
            return "SOL";
        }
    } elsif ( $os eq "HP-UX" ) {
        return "HP";
    } elsif ( $os eq "Linux" ) {
        return "LNX";
    } elsif ( $os eq "AIX" ) {
        return "AIX";
    } elsif ( $os eq "OSF1" ) {
        return "OSF1";
    } elsif ( $os eq "Darwin" ) {
        return "MAC OS X";
    } else {
        # Unsupported Operating System
        return -1;
    }
}
return 1;

