#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/ccr/adrInfoCollector.pl /main/1 2010/07/27 10:09:24 jsutton Exp $
#
# adrInfoCollector.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      adrInfoCollector.pl - use adrci to retrieve problem information for a target
#
#    DESCRIPTION
#      We use the adrci tool to retrieve the summary information from 
#      vproblem_bucket_count for a given target.
#
#    NOTES
#      This script is *strictly* for use on Exadata machines, hence no support
#      logic is in place for Windows constructs.
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     03/24/10 - Creation
# 
use strict;
use encoding 'utf8';
use Config;
use Cwd 'abs_path';

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my ($type, $configFile) = @ARGV;

$| = 1;

my $sid = $ENV{SID};

my @adrciOutput;
my ($adrBase, $adrHome, $adrInit, $dbName, $instanceName);

# locate DB Machine marker file
my $dbmMarker = "/opt/oracle.cellos";
exit if (! -e $dbmMarker);

my $ccrParent = abs_path(File::Spec->catdir($ENV{CCR_HOME}, File::Spec->updir()));

if (($type =~ /oracle_database/ || $type =~ /rac_database/) && (-e $configFile))
{
    # only gather for 11.2+
    my $dbVersion = getDBVersionFromDBll($configFile);
    exit if (compare_versions($dbVersion,"11.2.0.0.0") < 0);
    if ($configFile =~ /^.*\.ll$/)
    {
      # adrBase, dbName, instanceName are set in handleDiagDestInfo
      # using values found in the db_init_params metric from the LL file
      handleConfigMetricResult($configFile, "db_init_params", 3, $sid, \&handleDiagDestInfo);
    }
    else
    {
      # if we're not using an .LL file, we use config properties set in the .CCR file 
      $adrBase = getConfigProperty($configFile,"DIAG_DEST");
      $dbName = getConfigProperty($configFile,"DB_NAME");
      $instanceName = getConfigProperty($configFile,"INSTANCE_NAME");
    }
    exit if ($sid ne $instanceName);
    # construct adrHome from dbName, dbInstanceName
    $adrHome = "diag/rdbms/".lc($dbName)."/$instanceName";
    # this is the init string we feed to adrci
    $adrInit = "set base $adrBase; set home $adrHome; "
}
elsif ($type =~/osm_instance/)
{
    # use asmcmd to get version string for verification
    my $asmcmd = File::Spec->catfile($ccrParent, "bin", "asmcmd");
    # no asmcmd?
    exit if (!-f $asmcmd);
    # asmcmd requires ORACLE_SID set to ASM instance SID
    $ENV{ORACLE_SID} = $sid;
    my @asmcmdV = `$asmcmd -V`;
    foreach my $asmLine (@asmcmdV)
    {
        # output should be "asmcmd version <version>"
        if ($asmLine =~ /asmcmd version ([0-9\.]+)/)
        { 
            exit if (compare_versions($1,"11.2.0.0.0") < 0);
        }
    }
    # version check OK, continue (not sure how we would get $adrBase)
    $adrBase = "";
    $adrHome = "diag/asm/+asm/$sid";
    $adrInit = "set home $adrHome; ";
}

# locate adrci utility
my $adrci_file = File::Spec->catfile($ccrParent, "bin", "adrci");
EMD_PERL_DEBUG("Running $adrci_file exec=$adrInit...");
if (-f $adrci_file)
{
    @adrciOutput = `$adrci_file exec="$adrInit select start_time,end_time,count,problem_key from vproblem_bucket_count"`;
}

my ($matchThis, $gotHome, $pKey, $startTime,$endTime,$pCount);
$gotHome = 0;
$matchThis = $adrBase."/".$adrHome;

foreach my $adrLine (@adrciOutput)
{
    # debug log the ADR home we're dealing with
    if ($adrLine =~ /^ADR Home = (.*):$/) 
    {
        my $currHome = $1;
        $gotHome = ($currHome =~ /\Q$matchThis\E$/ ? 1 : 0);
    }
    # ----------------------------- --------------- -----------
    if ($gotHome && $adrLine =~ /^(.{33})\s+(.{33})\s+([0-9]+)\s+(.*)$/)
    {
        $startTime = $1;
        $endTime = $2;
        $pCount = $3;
        $pKey = trim($4);
        # timestamp format is 'yyyy-mm-dd hh:mi:ss.ffffff tzh:tzm'
        # discard fractional seconds but keep time zone offset
        $startTime =~ m/([^\.]+)([^\s]*)(.*)/;
        $startTime = $1.$3;
        $endTime =~ m/([^\.]+)([^s].*)(.*)/;
        $endTime = $1.$3;
        # discard problem_id and print out key, timestamps, count
        EMD_PERL_DEBUG("em_result=$pKey|$startTime|$endTime|$pCount\n");
        print ("em_result=$pKey|$startTime|$endTime|$pCount\n");
    }
}
1;

sub handleDiagDestInfo
{
    my ($result) = @_;
    if ($result ne "")
    {
        if ($result =~ /^em_result=diagnostic_dest\|(.*)\|.*/)
        {
            $adrBase = $1;
            EMD_PERL_INFO("adr base: $adrBase");
        }
        elsif ($result =~ /^em_result=db_name\|(.*)\|.*/)
        {
            $dbName = $1;
            EMD_PERL_INFO("db name: $dbName");
        }
        elsif ($result =~ /^em_result=instance_name\|(.*)\|.*/)
        {
            $instanceName = $1;
            EMD_PERL_INFO("instance name: $instanceName");
        }
    }
}
