#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/cell_assoc.pl /main/3 2012/10/03 15:57:41 fmorshed Exp $
#
# cell_assoc.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      cell_assoc.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    fmorshed    10/02/12 - Remove / as first character to query targets.xml
#    fmorshed    01/19/12 - In advent of central collector, change query of
#                targets.xml to account for the new hierarchy of tags.
#    imunusam    10/27/11 - Creation
# 
use strict;
use ias::simpleXPath;

require "emd_common.pl";
require "semd_common.pl";

my ($targetName) = @ARGV;
my $discoveredTargetsFile = $ENV{CCR_CONFIG_HOME} . "/config/default/targets.xml";
my $ohQueryPrefix = 'TargetHomes/TargetHome[@LOCATION="' . $ENV{ORACLE_HOME} . '"]';
if (-e $discoveredTargetsFile)
{
 my @assocTargets = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix.'/Targets/Target[@NAME="'.$targetName.'"]/AssocTargetInstance');
 for my $assocTarget (@assocTargets)
 {
print ("em_result=".$$assocTarget{'ASSOCIATION_NAME'}."|".$$assocTarget{'ASSOC_TARGET_NAME'}."|".$$assocTarget{'ASSOC_TARGET_TYPE'}."|".$$assocTarget{'ASSOC_TARGET_PROPERTY'}."|\n");
 }

 my @assocTargets = simpleXPathQuery($discoveredTargetsFile, $ohQueryPrefix.'/Targets/Target/Member[@name="'.$targetName.'"]');
 for my $assocTarget (@assocTargets)
 {
print ("em_result=member_of||oracle_exadata_dbsys|".$$assocTarget{'parentTargetName'}."|\n");
 }

}
