#!/usr/bin/perl
#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#    post_crs_extend.pl
#
#    SYNOPSIS
#    <perlbin>/perl post_crs_extend.pl ORACLE_HOME=<ORACLE_HOME>
#
#    DESCRIPTION
#    This script needs to be run as post-script while running extend cluster operation
#
#    MODIFIED   (MM/DD/YY)
#       audupi     09/16/05 - audupi_bug-4579173
#       makarapu   08/25/05 - Intial creation
#
############################################################################

#############################################################################
#              POST SCRIPT FOR EXTEND CRS CASE CLONING                      #
#############################################################################


# Check that the version of perl used is 5.6.1 or above
require v5.6.1;

use English qw(-no_match_vars);
use File::Basename;
use File::Spec();
use File::Spec::Functions;
use File::Path;

#Initialize global Variables
$ORACLE_HOME = "Not yet set!!";
$REMOTE_PORT = "Not yet set!!";
$BIN_DIR = "Not yet set!!"; 

parse_arguments(@ARGV);
set_remote_port();
set_node_list();
run_racgons();
########## END ##########



#############################################################################
# NAME   : parse_arguments
# PURPOSE: Checks the command line arguments.
# INPUTS : The command line arguments
# OUTPUTS: NONE
# NOTES  : Updates global variables with command line arguments.
#
#############################################################################
sub parse_arguments 
{
	(@ARGV)=@_;
	my %ARGS;
	$no_arguments = scalar ( @ARGV );
	for ( my $i = 0; $i < $no_arguments; $i++ )
	{
		if ($ARGV[$i] =~ /=/)
		{
			($name, $value) = split (/=/, $ARGV[$i]);
			$ARGS{$name} = $value;
		}
	}

	if (exists $ARGS{"ORACLE_HOME"})
	{
		$ORACLE_HOME = $ARGS{"ORACLE_HOME"};
	}
	else
	{
		stop_on_err("Mandatory parameter ORACLE_HOME has not been passed.", "true");
	}

	if (!-e File::Spec->catfile($ORACLE_HOME, "opmn", "conf", "ons.config"))
	{
		stop_on_err("Invalid Oracle Home specified.", "true");
		exit -1;	
	}

	$BIN_DIR = File::Spec->catdir($ORACLE_HOME, "bin");
}


#############################################################################
# NAME   : set_remote_port
# PURPOSE: Sets the global variable REMOTE_PORT
# INPUTS : NONE
# OUTPUTS: NONE
# NOTES  : This value is retrieved from the $ORACLE_HOME/opmn/conf/ons.config file
#############################################################################
sub set_remote_port
{
	$ons_config_file=File::Spec->catfile($ORACLE_HOME, "opmn", "conf", "ons.config");
	open (ONS_FILE, $ons_config_file);
	@ons_config=<ONS_FILE>;
	close (ONS_FILE);
	foreach $line (@ons_config)
	{
		if ($line =~ /remoteport/)
		{
			($tmp, $REMOTE_PORT) = split("=", $line);
			chomp($REMOTE_PORT);
			return;
		}
	}
}

#############################################################################
# NAME   : set_node_list
# PURPOSE: Sets the global variable LOCAL_NODE
# INPUTS : NONE
# OUTPUTS: NONE
# NOTES  :  This value is retrieved from the 
#              $ORACLE_HOME/inventory/ContentsXML/oraclehomeproperties.xml file
#              in the <LOCAL_NODE> tag
###############################################################################
sub set_node_list
{
	my $ohprops_file=File::Spec->catfile($ORACLE_HOME, "inventory", "ContentsXML", "oraclehomeproperties.xml");
	open (OHPROPS_FILE, $ohprops_file);
	my @array=<OHPROPS_FILE>;
	close (OHPROPS_FILE);

	foreach $line (@array)
	{
		if ( $line =~ /<(.*)LOCAL_NODE(.*)>/ ) 
        {
			($tmp, $LOCAL_NODE, $tmp2)=split("\"",$line);
		}
	}
}


#############################################################################
# NAME   : run_racgons
# PURPOSE: run the command
#              ./racgons add_config $LOCAL_NODE:$REMOTE_PORT
# INPUTS : NONE
# OUTPUTS: NONE
# NOTES  : 
#############################################################################
sub run_racgons
{
	my $RACGONS_CMD = File::Spec->catfile($ORACLE_HOME, "bin", "racgons");
	$cmd = "$RACGONS_CMD add_config  $LOCAL_NODE:$REMOTE_PORT";
	print "\nExecuting -- $cmd";
	system("$cmd");
	print "\nExit Status: $? \n";
}


#############################################################################
# NAME   : stop_on_err
# PURPOSE: Exit the program
# INPUTS : Message, true/false
# OUTPUTS: NONE
# NOTES  : 
#############################################################################
sub stop_on_err
{
	($msg, $exit)=@_;
	print "$msg\n";
	if ($exit eq "true") 
	{
		print "Aborting the post script operation.";
		exit -1;
	}
}

