#!/usr/local/bin/perl
# 
# $Header: emll/sysman/admin/scripts/coherence/printCoherenceAssociations.pl /main/3 2012/01/17 14:41:08 prbhoj Exp $
#
# printCoherenceAssociations.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      printCoherenceAssociations.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    prbhoj      01/13/12 - Fix bug 13587135. Change creation of Exalogic assoc
#                           to use mwm::exalogicUtil:getExalogicAssoc() method
#    prbhoj      01/09/12 - Change Exalogic rack type from exalogic_rack to
#                           exa_rack
#    prbhoj      01/09/12 - Fix bug 13572101 - change oracleHome to be WL_HOME
#                           instead of BEA_HOME
#    prbhoj      11/01/11 - Print Coherence cluster target association to
#                           either Weblogic domain in case of CoherenceWeb OR
#                           to Exalogic Rack in case of non-CoherenceWeb
#                           Exalogic deployment
#    prbhoj      11/01/11 - Creation
# 

BEGIN
{
    require "emd_common.pl";
}

use strict;
use mwm::exalogicUtil;

my $hostName = shift(@ARGV);
my $oracleHome = $ENV{'WL_HOME'};

# Find the last association with a unique type, that has a target name
my %assocs = ();
for my $assoc (@ARGV)
{
    my @params = split('\|', $assoc);
    my $assocType = $params[0];
    my $targetName = $params[1];
    if ($targetName eq '' || $targetName =~ /^%.*%$/)
    {
        # Target name is missing
        next;
    }
    $assocs{$assocType} = $assoc;
}

# Print associations including the target property <host name>:<oracle home> 
# in case of association to Weblogic domain
for my $assocType (keys %assocs)
{
    my $assoc = $assocs{$assocType};
    my @params = split('\|', $assoc);
    my $targetType = $params[2];

    EMD_PERL_DEBUG("COH: In print associations Association is $assoc\n");
    EMD_PERL_DEBUG("COH: In print associations associated target type is $targetType\n");

    if ($targetType eq "weblogic_domain")
    {
       EMD_PERL_DEBUG("COH: In print associations DomainAssociation em_result is $assoc|$hostName:$oracleHome\n");
       print "em_result=$assoc|$hostName:$oracleHome\n";
    }
    if ($targetType eq "exa_rack")
    {
       my $elAssoc = getExalogicAssoc();
       if(defined($elAssoc))
       {
         EMD_PERL_DEBUG("COH: In print associations ExalogicAssociation em_result is $elAssoc\n");
         print $elAssoc;
       }
    }
}

