# $Header: contentComputeRtc.pl 07-jun-2005.18:37:37 aknatara Exp $
#
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      contentComputeRtc.pl - compute ResponseTimeCategory
#
#    DESCRIPTION
#      This script returns an integer between 0 and 15 for
#      ResponseTimeCategory.
#
#      ARGV[0] is RunWebAppResponseTimeMetric
#      ARGV[1] is RunLoadBalancedWebAppResponseTimeMetric
#      ARGV[2] is RunRMAppResponseTimeMetric
#      ARGV[3] is RunLoadBalancedRMAppResponseTimeMetric
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    aknatara    06/07/05 - aknatara_shared_changed_product_name
#    mhong       04/27/05 - rename from filesComputeRtc.pl to
#                           contentComputeRtc.pl
#    kchellap    04/22/05 - 
#    kchellap    03/13/05 - kchellap_bug-4190287
#    mhong       03/01/05 - mhong_em_ha_support_and_other_metadata_changes
#    mhong       02/24/05 - Creation
#

use strict;
require "emd_common.pl";

my $rtcategory;
my ($webapp, $lbwebapp, $rmapp, $lbrmapp) =
  ($ARGV[0], $ARGV[1], $ARGV[2], $ARGV[3]);

# transform TRUE to 1 and FALSE to 0

$webapp =~ tr/a-z/A-Z/;  # to uppercase
if ($webapp eq "TRUE")
{
  $webapp = 1;
}
else
{
  $webapp = 0;
}

$lbwebapp =~ tr/a-z/A-Z/;
if ($lbwebapp eq "TRUE")
{
  $lbwebapp = 1;
}
else
{
  $lbwebapp = 0;
}

$rmapp =~ tr/a-z/A-Z/;
if ($rmapp eq "TRUE")
{
  $rmapp = 1;
}
else
{
  $rmapp = 0;
}

$lbrmapp =~ tr/a-z/A-Z/;
if ($lbrmapp eq "TRUE")
{
  $lbrmapp = 1;
}
else
{
  $lbrmapp = 0;
}

$rtcategory = 1 * $webapp + 2 * $lbwebapp + 4 * $rmapp + 8 * $lbrmapp;

# debug
EMD_PERL_DEBUG("ResponseTimeCategory = $rtcategory\n");

print "em_result=$rtcategory\n";

# EOF
